/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.watch;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.watch.DebuggerWatchesProvider;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.services.DataTypeManagerService;
import ghidra.docking.settings.SettingsImpl;
import ghidra.pcode.exec.AddressOfPcodeArithmetic;
import ghidra.pcode.exec.AddressOfPcodeExecutorState;
import ghidra.pcode.exec.AsyncPcodeExecutor;
import ghidra.pcode.exec.BytesPcodeArithmetic;
import ghidra.pcode.exec.PairedPcodeArithmetic;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeFrame;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.SleighExpression;
import ghidra.pcode.exec.SleighProgramCompiler;
import ghidra.pcode.exec.SleighUseropLibrary;
import ghidra.pcode.exec.TracePcodeUtils;
import ghidra.pcode.exec.trace.TraceBytesPcodeExecutorState;
import ghidra.pcode.exec.trace.TraceSleighUtils;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.ByteMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.Swing;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.tuple.Pair;

public class WatchRow {
    public static final int TRUNCATE_BYTES_LENGTH = 64;
    private final DebuggerWatchesProvider provider;
    private Trace trace;
    private DebuggerCoordinates coordinates;
    private SleighLanguage language;
    private PcodeExecutor<Pair<byte[], TraceMemoryState>> executorWithState;
    private ReadDepsPcodeExecutor executorWithAddress;
    private AsyncPcodeExecutor<byte[]> asyncExecutor;
    private String expression;
    private String typePath;
    private DataType dataType;
    private SleighExpression compiled;
    private TraceMemoryState state;
    private Address address;
    private AddressSet reads;
    private byte[] value;
    private byte[] prevValue;
    private String valueString;
    private Object valueObj;
    private Throwable error = null;

    public WatchRow(DebuggerWatchesProvider provider, String expression) {
        this.provider = provider;
        this.expression = expression;
    }

    protected void blank() {
        this.state = null;
        this.address = null;
        this.reads = null;
        this.value = null;
        this.valueString = null;
        this.valueObj = null;
    }

    protected void recompile() {
        this.compiled = null;
        this.error = null;
        if (this.expression == null || this.expression.length() == 0) {
            return;
        }
        if (this.language == null) {
            return;
        }
        try {
            this.compiled = SleighProgramCompiler.compileExpression((SleighLanguage)this.language, (String)this.expression);
        }
        catch (Exception e) {
            this.error = e;
            return;
        }
    }

    protected void doTargetReads() {
        if (this.compiled != null && this.asyncExecutor != null) {
            ((CompletableFuture)this.compiled.evaluate(this.asyncExecutor)).exceptionally(ex -> {
                this.error = ex;
                Swing.runIfSwingOrRunLater(() -> this.provider.watchTableModel.notifyUpdated(this));
                return null;
            });
        }
    }

    protected void reevaluate() {
        this.blank();
        if (this.trace == null || this.compiled == null) {
            return;
        }
        try {
            Pair valueWithState = (Pair)this.compiled.evaluate(this.executorWithState);
            Pair valueWithAddress = (Pair)this.compiled.evaluate((PcodeExecutor)this.executorWithAddress);
            this.value = (byte[])valueWithState.getLeft();
            this.error = null;
            this.state = (TraceMemoryState)valueWithState.getRight();
            this.address = (Address)valueWithAddress.getRight();
            this.reads = this.executorWithAddress.getReads();
            this.valueObj = this.parseAsDataTypeObj();
            this.valueString = this.parseAsDataTypeStr();
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    protected String parseAsDataTypeStr() {
        if (this.dataType == null || this.value == null) {
            return "";
        }
        ByteMemBufferImpl buffer = new ByteMemBufferImpl(this.address, this.value, this.language.isBigEndian());
        return this.dataType.getRepresentation((MemBuffer)buffer, SettingsImpl.NO_SETTINGS, this.value.length);
    }

    protected Object parseAsDataTypeObj() {
        if (this.dataType == null || this.value == null) {
            return null;
        }
        ByteMemBufferImpl buffer = new ByteMemBufferImpl(this.address, this.value, this.language.isBigEndian());
        return this.dataType.getValue((MemBuffer)buffer, SettingsImpl.NO_SETTINGS, this.value.length);
    }

    protected static ReadDepsPcodeExecutor buildAddressDepsExecutor(DebuggerCoordinates coordinates) {
        Trace trace = coordinates.getTrace();
        ReadDepsTraceBytesPcodeExecutorState state = new ReadDepsTraceBytesPcodeExecutorState(trace, coordinates.getViewSnap(), coordinates.getThread(), coordinates.getFrame());
        Language language = trace.getBaseLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Watch expressions require a SLEIGH language");
        }
        PcodeExecutorState paired = state.paired((PcodeExecutorStatePiece)new AddressOfPcodeExecutorState(language.isBigEndian()));
        PairedPcodeArithmetic arithmetic = new PairedPcodeArithmetic((PcodeArithmetic)BytesPcodeArithmetic.forLanguage((Language)language), (PcodeArithmetic)AddressOfPcodeArithmetic.INSTANCE);
        return new ReadDepsPcodeExecutor(state, (SleighLanguage)language, (PairedPcodeArithmetic<byte[], Address>)arithmetic, (PcodeExecutorState<Pair<byte[], Address>>)paired);
    }

    public void setCoordinates(DebuggerCoordinates coordinates) {
        this.prevValue = this.value;
        this.trace = coordinates.getTrace();
        this.coordinates = coordinates;
        this.updateType();
        if (this.trace == null) {
            this.blank();
            return;
        }
        Language newLanguage = this.trace.getBaseLanguage();
        if (this.language != newLanguage) {
            if (!(newLanguage instanceof SleighLanguage)) {
                this.error = new RuntimeException("Not a sleigh-based langauge");
                return;
            }
            this.language = (SleighLanguage)newLanguage;
            this.recompile();
        }
        if (coordinates.isAliveAndReadsPresent()) {
            this.asyncExecutor = TracePcodeUtils.executorForCoordinates(coordinates);
        }
        this.executorWithState = TraceSleighUtils.buildByteWithStateExecutor((Trace)this.trace, (long)coordinates.getViewSnap(), (TraceThread)coordinates.getThread(), (int)coordinates.getFrame());
        this.executorWithAddress = WatchRow.buildAddressDepsExecutor(coordinates);
    }

    public void setExpression(String expression) {
        if (!Objects.equals(this.expression, expression)) {
            this.prevValue = null;
        }
        this.expression = expression;
        this.blank();
        this.recompile();
        if (this.error != null) {
            this.provider.contextChanged();
            return;
        }
        if (this.asyncExecutor != null) {
            this.doTargetReads();
        }
        this.reevaluate();
        this.provider.contextChanged();
    }

    public String getExpression() {
        return this.expression;
    }

    protected void updateType() {
        this.dataType = null;
        if (this.trace == null || this.typePath == null) {
            return;
        }
        this.dataType = this.trace.getDataTypeManager().getDataType(this.typePath);
        if (this.dataType != null) {
            return;
        }
        DataTypeManagerService dtms = (DataTypeManagerService)this.provider.getTool().getService(DataTypeManagerService.class);
        if (dtms == null) {
            return;
        }
        this.dataType = dtms.getBuiltInDataTypesManager().getDataType(this.typePath);
    }

    public void setTypePath(String typePath) {
        this.typePath = typePath;
        this.updateType();
    }

    public String getTypePath() {
        return this.typePath;
    }

    public void setDataType(DataType dataType) {
        this.typePath = dataType == null ? null : dataType.getPathName();
        this.dataType = dataType;
        this.valueString = this.parseAsDataTypeStr();
        this.valueObj = this.parseAsDataTypeObj();
        this.provider.contextChanged();
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Address getAddress() {
        return this.address;
    }

    public AddressRange getRange() {
        if (this.address == null || this.value == null) {
            return null;
        }
        if (this.address.isConstantAddress()) {
            return new AddressRangeImpl(this.address, this.address);
        }
        try {
            return new AddressRangeImpl(this.address, (long)this.value.length);
        }
        catch (AddressOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getRawValueString() {
        if (this.value == null) {
            return "??";
        }
        if (this.address == null || !this.address.getAddressSpace().isMemorySpace()) {
            BigInteger asBigInt = Utils.bytesToBigInteger((byte[])this.value, (int)this.value.length, (boolean)this.language.isBigEndian(), (boolean)false);
            return "0x" + asBigInt.toString(16);
        }
        if (this.value.length > 64) {
            return "{ " + NumericUtilities.convertBytesToString((byte[])this.value, (int)0, (int)64, (String)" ") + " ... }";
        }
        return "{ " + NumericUtilities.convertBytesToString((byte[])this.value, (String)" ") + " }";
    }

    public AddressSet getReads() {
        return this.reads;
    }

    public TraceMemoryState getState() {
        return this.state;
    }

    public String getValueString() {
        return this.valueString;
    }

    public Object getValueObj() {
        return this.valueObj;
    }

    public boolean isValueEditable() {
        return this.address != null && this.provider.isEditsEnabled();
    }

    public void setRawValueString(String valueString) {
        if ((valueString = valueString.trim()).startsWith("{")) {
            if (!valueString.endsWith("}")) {
                throw new NumberFormatException("Byte array values must be hex enclosed in {}");
            }
            this.setRawValueBytesString(valueString.substring(1, valueString.length() - 1));
            return;
        }
        this.setRawValueIntString(valueString);
    }

    public void setRawValueBytesString(String bytesString) {
        this.setRawValueBytes(NumericUtilities.convertStringToBytes((String)bytesString));
    }

    public void setRawValueIntString(String intString) {
        BigInteger val = (intString = intString.trim()).startsWith("0x") ? new BigInteger(intString.substring(2), 16) : new BigInteger(intString, 10);
        this.setRawValueBytes(Utils.bigIntegerToBytes((BigInteger)val, (int)this.value.length, (boolean)this.trace.getBaseLanguage().isBigEndian()));
    }

    public void setRawValueBytes(byte[] bytes) {
        if (this.address == null) {
            throw new IllegalStateException("Cannot write to watch variable without an address");
        }
        if (bytes.length != this.value.length) {
            throw new IllegalArgumentException("Byte array values must match length of variable");
        }
        if (this.coordinates.isAliveAndPresent() && this.coordinates.getRecorder().isVariableOnTarget(this.coordinates.getThread(), this.address, bytes.length)) {
            this.coordinates.getRecorder().writeVariable(this.coordinates.getThread(), this.coordinates.getFrame(), this.address, bytes).exceptionally(ex -> {
                Msg.showError((Object)this, null, (String)"Write Failed", (Object)"Could not modify watch value (on target)", (Throwable)ex);
                return null;
            });
            return;
        }
        TraceSchedule time = this.coordinates.getTime().patched(this.coordinates.getThread(), this.generateSleigh(bytes));
        this.provider.goToTime(time);
    }

    protected String generateSleigh(byte[] bytes) {
        BigInteger value = Utils.bytesToBigInteger((byte[])bytes, (int)bytes.length, (boolean)this.trace.getBaseLanguage().isBigEndian(), (boolean)false);
        if (this.address.isMemoryAddress()) {
            AddressSpace space = this.address.getAddressSpace();
            return String.format("*[%s]:%d 0x%s:%d=0x%s", space.getName(), bytes.length, this.address.getOffsetAsBigInteger().toString(16), space.getPointerSize(), value.toString(16));
        }
        Register register = this.trace.getBaseLanguage().getRegister(this.address, bytes.length);
        if (register == null) {
            throw new AssertionError((Object)"Can only modify memory or register");
        }
        return String.format("%s=0x%s", register, value.toString(16));
    }

    public int getValueLength() {
        return this.value == null ? 0 : this.value.length;
    }

    public String getErrorMessage() {
        if (this.error == null) {
            return "";
        }
        String message = this.error.getMessage();
        if (message != null && message.trim().length() != 0) {
            return message;
        }
        return this.error.getClass().getSimpleName();
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean isKnown() {
        return this.state == TraceMemoryState.KNOWN;
    }

    public boolean isChanged() {
        if (this.prevValue == null) {
            return false;
        }
        return !Arrays.equals(this.value, this.prevValue);
    }

    public static class ReadDepsPcodeExecutor
    extends PcodeExecutor<Pair<byte[], Address>> {
        private ReadDepsTraceBytesPcodeExecutorState depsState;

        public ReadDepsPcodeExecutor(ReadDepsTraceBytesPcodeExecutorState depsState, SleighLanguage language, PairedPcodeArithmetic<byte[], Address> arithmetic, PcodeExecutorState<Pair<byte[], Address>> state) {
            super(language, arithmetic, state);
            this.depsState = depsState;
        }

        public PcodeFrame execute(PcodeProgram program, SleighUseropLibrary<Pair<byte[], Address>> library) {
            this.depsState.reset();
            return super.execute(program, library);
        }

        public AddressSet getReads() {
            return this.depsState.getReads();
        }
    }

    public static class ReadDepsTraceBytesPcodeExecutorState
    extends TraceBytesPcodeExecutorState {
        private AddressSet reads = new AddressSet();

        public ReadDepsTraceBytesPcodeExecutorState(Trace trace, long snap, TraceThread thread, int frame) {
            super(trace, snap, thread, frame);
        }

        public byte[] getVar(AddressSpace space, long offset, int size, boolean truncateAddressableUnit) {
            byte[] data = (byte[])super.getVar(space, offset, size, truncateAddressableUnit);
            if (space.isMemorySpace()) {
                offset = this.truncateOffset(space, offset);
            }
            if (space.isMemorySpace() || space.isRegisterSpace()) {
                try {
                    this.reads.add((AddressRange)new AddressRangeImpl(space.getAddress(offset), (long)data.length));
                }
                catch (AddressOutOfBoundsException | AddressOverflowException e) {
                    throw new AssertionError((Object)e);
                }
            }
            return data;
        }

        protected void setInSpace(TraceMemorySpace space, long offset, int size, byte[] val) {
            throw new UnsupportedOperationException("Expression cannot write to trace");
        }

        public void reset() {
            this.reads = new AddressSet();
        }

        public AddressSet getReads() {
            return new AddressSet((AddressSetView)this.reads);
        }
    }
}

