/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.pcode;

import ghidra.app.plugin.core.debug.gui.pcode.PcodeRow;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.program.model.lang.Language;
import ghidra.program.model.pcode.PcodeOp;

public class OpPcodeRow
implements PcodeRow {
    protected final Language language;
    protected final PcodeOp op;
    protected final boolean isNext;

    public OpPcodeRow(Language language, PcodeOp op, boolean isNext) {
        this.language = language;
        this.op = op;
        this.isNext = isNext;
    }

    @Override
    public int getSequence() {
        return this.op.getSeqnum().getTime();
    }

    @Override
    public String getCode() {
        return "<html>" + PcodeProgram.opToString((Language)this.language, (PcodeOp)this.op, (boolean)true) + "</html>";
    }

    public boolean isNext() {
        return this.isNext;
    }

    @Override
    public PcodeOp getOp() {
        return this.op;
    }
}

