/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.components;

import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectAttributeRow;
import java.util.function.Function;

public enum ObjectAttributeColumn implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<ObjectAttributeColumn, ObjectAttributeRow>
{
    NAME("Name", String.class, ObjectAttributeRow::getName),
    KIND("Kind", String.class, ObjectAttributeRow::getKind),
    VALUE("Value", String.class, ObjectAttributeRow::getValue),
    TYPE("Type", String.class, ObjectAttributeRow::getType);

    private final String header;
    private final Function<ObjectAttributeRow, ?> getter;
    private final Class<?> cls;

    private <T> ObjectAttributeColumn(String header, Class<T> cls, Function<ObjectAttributeRow, T> getter) {
        this.header = header;
        this.cls = cls;
        this.getter = getter;
    }

    public String getHeader() {
        return this.header;
    }

    public Class<?> getValueClass() {
        return this.cls;
    }

    public Object getValueOf(ObjectAttributeRow row) {
        return this.getter.apply(row);
    }
}

