/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import com.google.common.collect.Range;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.program.model.address.Address;
import ghidra.trace.model.modules.TraceModule;
import ghidra.util.database.UndoableTransaction;

public class ModuleRow {
    private final TraceModule module;

    public ModuleRow(TraceModule module) {
        this.module = module;
    }

    public TraceModule getModule() {
        return this.module;
    }

    public void setName(String name) {
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.module.getTrace(), (String)"Renamed module", (boolean)true);){
            this.module.setName(name);
        }
    }

    public String getShortName() {
        String name = this.module.getName();
        int sep = name.lastIndexOf(92);
        if (sep > 0 && sep < name.length()) {
            name = name.substring(sep + 1);
        }
        if ((sep = name.lastIndexOf(47)) > 0 && sep < name.length()) {
            name = name.substring(sep + 1);
        }
        return name;
    }

    public String getName() {
        return this.module.getName();
    }

    public Address getBase() {
        return this.module.getBase();
    }

    public Address getMaxAddress() {
        return this.module.getMaxAddress();
    }

    public long getLoadedSnap() {
        return this.module.getLoadedSnap();
    }

    public Long getUnloadedSnap() {
        long snap = this.module.getUnloadedSnap();
        return snap == Long.MAX_VALUE ? null : Long.valueOf(snap);
    }

    public Range<Long> getLifespan() {
        return this.module.getLifespan();
    }

    public long getLength() {
        return this.module.getLength();
    }
}

