/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.listing;

import docking.ActionContext;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.fieldpanel.support.BackgroundColorModel;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.events.TreeSelectionPluginEvent;
import ghidra.app.events.ViewChangedPluginEvent;
import ghidra.app.plugin.core.codebrowser.AbstractCodeBrowserPlugin;
import ghidra.app.plugin.core.codebrowser.CodeViewerProvider;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceLocationPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceSelectionPluginEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.LocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.listing.CursorBackgroundColorModel;
import ghidra.app.plugin.core.debug.gui.listing.DebuggerListingProvider;
import ghidra.app.plugin.core.debug.gui.listing.MemoryStateListingBackgroundColorModel;
import ghidra.app.plugin.core.debug.gui.listing.MultiBlendedListingBackgroundColorModel;
import ghidra.app.services.ClipboardService;
import ghidra.app.services.DebuggerEmulationService;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.MarkerService;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.ViewManagerService;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.framework.options.AutoOptions;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.annotation.AutoOptionDefined;
import ghidra.framework.options.annotation.HelpInfo;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.Swing;
import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jdom.Element;
import utilities.util.SuppressableCallback;

@PluginInfo(shortDescription="View and annotate listings of trace (possibly live) memory", description="Provides the memory listing display window. Functions similarly to the main program listing display window, but for traces. If the trace is the destination of a live recording, the view(s) retrieve live memory on demand.", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={ProgramOpenedPluginEvent.class, ProgramClosedPluginEvent.class, ProgramLocationPluginEvent.class, TraceActivatedPluginEvent.class, TraceClosedPluginEvent.class}, eventsProduced={ProgramLocationPluginEvent.class, TraceLocationPluginEvent.class, TraceSelectionPluginEvent.class}, servicesRequired={DebuggerModelService.class, DebuggerStaticMappingService.class, DebuggerEmulationService.class, ProgramManager.class, ClipboardService.class, MarkerService.class}, servicesProvided={DebuggerListingService.class})
public class DebuggerListingPlugin
extends AbstractCodeBrowserPlugin<DebuggerListingProvider>
implements DebuggerListingService {
    private static final String KEY_CONNECTED_PROVIDER = "connectedProvider";
    private static final String KEY_DISCONNECTED_COUNT = "disconnectedCount";
    private static final String PREFIX_DISCONNECTED_PROVIDER = "disconnectedProvider";
    protected NewListingAction actionNewListing;
    @AutoServiceConsumed
    private ProgramManager programManager;
    private AutoService.Wiring autoServiceWiring;
    @AutoOptionDefined(name={"Colors.Stale Memory"}, description="Color of memory addresses whose content is not known in the view's snap", help=@HelpInfo(anchor="colors"))
    private Color staleMemoryColor = DebuggerResources.DEFAULT_COLOR_BACKGROUND_STALE;
    @AutoOptionDefined(name={"Colors.Error Memory"}, description="Color of memory addresses whose content could not be read in the view's snap", help=@HelpInfo(anchor="colors"))
    private Color errorMemoryColor = DebuggerResources.DEFAULT_COLOR_BACKGROUND_ERROR;
    @AutoOptionDefined(name={"Colors.Tracking Markers"}, description="Background color for locations referred to by a tracked register", help=@HelpInfo(anchor="colors"))
    private Color trackingColor = DebuggerResources.DEFAULT_COLOR_REGISTER_MARKERS;
    private AutoOptions.Wiring autoOptionsWiring;
    private final SuppressableCallback<Void> cbProgramLocationEvents = new SuppressableCallback();
    private DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;

    public DebuggerListingPlugin(PluginTool tool) {
        super(tool);
        this.autoServiceWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
        this.autoOptionsWiring = AutoOptions.wireOptions((Plugin)this);
        this.createActions();
    }

    @Override
    public MultiBlendedListingBackgroundColorModel createListingBackgroundColorModel(ListingPanel listingPanel) {
        MultiBlendedListingBackgroundColorModel colorModel = new MultiBlendedListingBackgroundColorModel();
        colorModel.addModel((BackgroundColorModel)new MemoryStateListingBackgroundColorModel((Plugin)this, listingPanel));
        colorModel.addModel((BackgroundColorModel)new CursorBackgroundColorModel((Plugin)this, listingPanel));
        return colorModel;
    }

    protected DebuggerListingProvider createProvider(FormatManager formatManager, boolean isConnected) {
        return new DebuggerListingProvider(this, formatManager, isConnected);
    }

    private void createActions() {
        this.actionNewListing = new NewListingAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerListingProvider createListingIfMissing(LocationTrackingSpec spec, boolean followsCurrentThread) {
        List list = this.disconnectedProviders;
        synchronized (list) {
            for (DebuggerListingProvider provider : this.disconnectedProviders) {
                if (provider.getTrackingSpec() != spec || provider.isFollowsCurrentThread() != followsCurrentThread) continue;
                return provider;
            }
            DebuggerListingProvider provider = (DebuggerListingProvider)this.createNewDisconnectedProvider();
            provider.setTrackingSpec(spec);
            provider.setFollowsCurrentThread(followsCurrentThread);
            provider.goToCoordinates(this.current);
            return provider;
        }
    }

    protected void viewChanged(AddressSetView addrSet) {
        TraceProgramView view = this.current.getView();
        if (view == null) {
            super.viewChanged((AddressSetView)new AddressSet());
        } else {
            super.viewChanged((AddressSetView)view.getMemory());
        }
    }

    protected void updateBackgroundColorModel() {
    }

    public void locationChanged(CodeViewerProvider provider, ProgramLocation location) {
        this.firePluginEvent(new TraceLocationPluginEvent(this.getName(), location));
    }

    public void selectionChanged(CodeViewerProvider provider, ProgramSelection selection) {
        TraceProgramView view = this.current.getView();
        if (view == null) {
            return;
        }
        this.firePluginEvent(new TraceSelectionPluginEvent(this.getName(), selection, view));
    }

    public void highlightChanged(CodeViewerProvider codeViewerProvider, ProgramSelection highlight) {
    }

    protected boolean heedLocationEvent(ProgramLocationPluginEvent ev) {
        PluginEvent trigger = ev.getTriggerEvent();
        if (trigger instanceof TraceActivatedPluginEvent) {
            return false;
        }
        if (trigger instanceof ProgramActivatedPluginEvent) {
            return false;
        }
        if (trigger instanceof TreeSelectionPluginEvent) {
            return false;
        }
        return !(trigger instanceof ViewChangedPluginEvent);
    }

    public void processEvent(PluginEvent event) {
        Object ev;
        if (event instanceof ProgramLocationPluginEvent) {
            this.cbProgramLocationEvents.invoke(() -> {
                ProgramLocationPluginEvent ev = (ProgramLocationPluginEvent)event;
                if (this.heedLocationEvent(ev)) {
                    ((DebuggerListingProvider)this.connectedProvider).staticProgramLocationChanged(ev.getLocation());
                }
            });
        }
        if (event instanceof ProgramOpenedPluginEvent) {
            ev = (ProgramOpenedPluginEvent)event;
            this.allProviders(arg_0 -> DebuggerListingPlugin.lambda$processEvent$1((ProgramOpenedPluginEvent)ev, arg_0));
        }
        if (event instanceof ProgramClosedPluginEvent) {
            ev = (ProgramClosedPluginEvent)event;
            this.allProviders(arg_0 -> DebuggerListingPlugin.lambda$processEvent$2((ProgramClosedPluginEvent)ev, arg_0));
        }
        if (event instanceof TraceActivatedPluginEvent) {
            ev = (TraceActivatedPluginEvent)event;
            this.current = ((TraceActivatedPluginEvent)((Object)ev)).getActiveCoordinates();
            this.allProviders(p -> p.coordinatesActivated(this.current));
        }
        if (event instanceof TraceClosedPluginEvent) {
            ev = (TraceClosedPluginEvent)event;
            if (this.current.getTrace() == ((TraceClosedPluginEvent)((Object)ev)).getTrace()) {
                this.current = DebuggerCoordinates.NOWHERE;
            }
            this.allProviders(arg_0 -> DebuggerListingPlugin.lambda$processEvent$4((TraceClosedPluginEvent)((Object)ev), arg_0));
        }
    }

    void fireStaticLocationEvent(ProgramLocation staticLoc) {
        assert (Swing.isSwingThread());
        try (SuppressableCallback.Suppression supp = this.cbProgramLocationEvents.suppress(null);){
            this.programManager.setCurrentProgram(staticLoc.getProgram());
            this.tool.firePluginEvent((PluginEvent)new ProgramLocationPluginEvent(this.getName(), staticLoc, staticLoc.getProgram()));
        }
    }

    protected void allProviders(Consumer<DebuggerListingProvider> action) {
        action.accept((DebuggerListingProvider)this.connectedProvider);
        for (DebuggerListingProvider provider : this.disconnectedProviders) {
            action.accept(provider);
        }
    }

    @AutoServiceConsumed
    public void setTraceManager(DebuggerTraceManagerService traceManager) {
        DebuggerListingProvider provider = (DebuggerListingProvider)this.connectedProvider;
        if (provider == null || traceManager == null) {
            return;
        }
        this.current = traceManager.getCurrent();
        provider.coordinatesActivated(this.current);
    }

    @Override
    public void setTrackingSpec(LocationTrackingSpec spec) {
        ((DebuggerListingProvider)this.connectedProvider).setTrackingSpec(spec);
    }

    @Override
    public LocationTrackingSpec getTrackingSpec() {
        return ((DebuggerListingProvider)this.connectedProvider).getTrackingSpec();
    }

    @Override
    public void addTrackingSpecChangeListener(DebuggerListingService.LocationTrackingSpecChangeListener listener) {
        ((DebuggerListingProvider)this.connectedProvider).addTrackingSpecChangeListener(listener);
    }

    @Override
    public void removeTrackingSpecChangeListener(DebuggerListingService.LocationTrackingSpecChangeListener listener) {
        ((DebuggerListingProvider)this.connectedProvider).removeTrackingSpecChangeListener(listener);
    }

    @Override
    public void setCurrentSelection(ProgramSelection selection) {
        ((DebuggerListingProvider)this.connectedProvider).setSelection(selection);
    }

    public boolean goTo(ProgramLocation location, boolean centerOnScreen) {
        boolean result = super.goTo(location, centerOnScreen);
        if (!result) {
            return false;
        }
        DebuggerListingProvider provider = (DebuggerListingProvider)this.connectedProvider;
        provider.doSyncToStatic(location);
        provider.doCheckCurrentModuleMissing();
        return true;
    }

    @Override
    public boolean goTo(Address address, boolean centerOnScreen) {
        TraceProgramView view = ((DebuggerListingProvider)this.connectedProvider).current.getView();
        if (view == null) {
            return false;
        }
        ProgramLocation loc = new ProgramLocation((Program)view, address);
        return this.goTo(loc, centerOnScreen);
    }

    public Object getTransientState() {
        return new Object[0];
    }

    public void restoreTransientState(Object objectState) {
    }

    public void writeDataState(SaveState saveState) {
        SaveState connectedProviderState = new SaveState();
        ((DebuggerListingProvider)this.connectedProvider).writeDataState(connectedProviderState);
        saveState.putXmlElement(KEY_CONNECTED_PROVIDER, connectedProviderState.saveToXml());
        List disconnected = this.disconnectedProviders.stream().filter(p -> p.isFollowsCurrentThread()).collect(Collectors.toList());
        for (DebuggerListingProvider p2 : this.disconnectedProviders) {
            if (disconnected.contains((Object)p2)) continue;
            disconnected.add(p2);
        }
        int disconnectedCount = disconnected.size();
        saveState.putInt(KEY_DISCONNECTED_COUNT, disconnectedCount);
        for (int index = 0; index < disconnectedCount; ++index) {
            DebuggerListingProvider provider = (DebuggerListingProvider)((Object)disconnected.get(index));
            String stateName = PREFIX_DISCONNECTED_PROVIDER + index;
            SaveState providerState = new SaveState();
            provider.writeDataState(providerState);
            saveState.putXmlElement(stateName, providerState.saveToXml());
        }
    }

    protected void ensureProviders(int count, boolean followCurrentThread, SaveState configState) {
        while (this.disconnectedProviders.size() < count) {
            int index = this.disconnectedProviders.size();
            String stateName = PREFIX_DISCONNECTED_PROVIDER + index;
            DebuggerListingProvider provider = (DebuggerListingProvider)this.createNewDisconnectedProvider();
            provider.setFollowsCurrentThread(false);
            Element providerElement = configState.getXmlElement(stateName);
            if (providerElement != null) {
                SaveState providerState = new SaveState(providerElement);
                provider.readConfigState(providerState);
                continue;
            }
            provider.setTrackingSpec(LocationTrackingSpec.fromConfigName("TRACK_NONE"));
        }
    }

    public void readDataState(SaveState saveState) {
        Element connectedProviderElement = saveState.getXmlElement(KEY_CONNECTED_PROVIDER);
        if (connectedProviderElement != null) {
            SaveState connectedProviderState = new SaveState(connectedProviderElement);
            ((DebuggerListingProvider)this.connectedProvider).readDataState(connectedProviderState);
        }
        int disconnectedCount = saveState.getInt(KEY_DISCONNECTED_COUNT, 0);
        this.ensureProviders(disconnectedCount, false, saveState);
        List disconnected = this.disconnectedProviders;
        for (int index = 0; index < disconnectedCount; ++index) {
            String stateName = PREFIX_DISCONNECTED_PROVIDER + index;
            Element providerElement = saveState.getXmlElement(stateName);
            if (providerElement == null) continue;
            SaveState providerState = new SaveState(providerElement);
            DebuggerListingProvider provider = (DebuggerListingProvider)((Object)disconnected.get(index));
            provider.readDataState(providerState);
        }
    }

    public void writeConfigState(SaveState saveState) {
        SaveState connectedProviderState = new SaveState();
        ((DebuggerListingProvider)this.connectedProvider).writeConfigState(connectedProviderState);
        saveState.putXmlElement(KEY_CONNECTED_PROVIDER, connectedProviderState.saveToXml());
        List disconnected = this.disconnectedProviders.stream().filter(p -> p.isFollowsCurrentThread()).collect(Collectors.toList());
        int disconnectedCount = disconnected.size();
        saveState.putInt(KEY_DISCONNECTED_COUNT, disconnectedCount);
        for (int index = 0; index < disconnectedCount; ++index) {
            DebuggerListingProvider provider = (DebuggerListingProvider)((Object)disconnected.get(index));
            String stateName = PREFIX_DISCONNECTED_PROVIDER + index;
            SaveState providerState = new SaveState();
            provider.writeConfigState(providerState);
            saveState.putXmlElement(stateName, providerState.saveToXml());
        }
    }

    public void readConfigState(SaveState saveState) {
        Element connectedProviderElement = saveState.getXmlElement(KEY_CONNECTED_PROVIDER);
        if (connectedProviderElement != null) {
            SaveState connectedProviderState = new SaveState(connectedProviderElement);
            ((DebuggerListingProvider)this.connectedProvider).readConfigState(connectedProviderState);
        }
        int disconnectedCount = saveState.getInt(KEY_DISCONNECTED_COUNT, 0);
        this.ensureProviders(disconnectedCount, true, saveState);
    }

    public ViewManagerService getViewManager(CodeViewerProvider codeViewerProvider) {
        return null;
    }

    private static /* synthetic */ void lambda$processEvent$4(TraceClosedPluginEvent ev, DebuggerListingProvider p) {
        p.traceClosed(ev.getTrace());
    }

    private static /* synthetic */ void lambda$processEvent$2(ProgramClosedPluginEvent ev, DebuggerListingProvider p) {
        p.programClosed(ev.getProgram());
    }

    private static /* synthetic */ void lambda$processEvent$1(ProgramOpenedPluginEvent ev, DebuggerListingProvider p) {
        p.programOpened(ev.getProgram());
    }

    protected class NewListingAction
    extends DebuggerResources.AbstractNewListingAction {
        public static final String GROUP = "Dbg3a. Transient Views";

        public NewListingAction() {
            super((Plugin)DebuggerListingPlugin.this);
            this.setMenuBarData(new MenuData(new String[]{"Window", "Debugger", "New Dynamic Listing"}, ICON, GROUP));
            DebuggerListingPlugin.this.tool.addAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            DebuggerListingPlugin.this.createNewDisconnectedProvider();
        }
    }
}

