/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.action.LocationTrackingSpec;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.memory.TraceMemoryRegisterSpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceRegisterUtils;

public interface RegisterLocationTrackingSpec
extends LocationTrackingSpec {
    public Register computeRegister(DebuggerCoordinates var1);

    public AddressSpace computeDefaultAddressSpace(DebuggerCoordinates var1);

    @Override
    default public String computeTitle(DebuggerCoordinates coordinates) {
        Register register = this.computeRegister(coordinates);
        if (register == null) {
            return null;
        }
        return register.getName();
    }

    @Override
    default public Address computeTraceAddress(PluginTool tool, DebuggerCoordinates coordinates, long emuSnap) {
        Trace trace = coordinates.getTrace();
        TraceThread thread = coordinates.getThread();
        long snap = coordinates.getSnap();
        int frame = coordinates.getFrame();
        Register reg = this.computeRegister(coordinates);
        if (reg == null) {
            return null;
        }
        if (!thread.getLifespan().contains((Comparable)Long.valueOf(snap))) {
            return null;
        }
        TraceMemoryRegisterSpace regs = trace.getMemoryManager().getMemoryRegisterSpace(thread, frame, false);
        if (regs == null) {
            return null;
        }
        RegisterValue value = regs.getState(emuSnap, reg) == TraceMemoryState.KNOWN ? regs.getValue(emuSnap, reg) : regs.getValue(snap, reg);
        if (value == null) {
            return null;
        }
        return this.computeDefaultAddressSpace(coordinates).getAddress(value.getUnsignedValue().longValue(), true);
    }

    @Override
    default public boolean affectedByRegisterChange(TraceAddressSpace space, TraceAddressSnapRange range, DebuggerCoordinates coordinates) {
        if (!LocationTrackingSpec.changeIsCurrent(space, range, coordinates)) {
            return false;
        }
        Register register = this.computeRegister(coordinates);
        AddressRange regRng = TraceRegisterUtils.rangeForRegister((Register)register);
        return range.getRange().intersects(regRng);
    }

    @Override
    default public boolean affectedByStackChange(TraceStack stack, DebuggerCoordinates coordinates) {
        return false;
    }
}

