/*
 * Decompiled with CFR 0.152.
 */
package neobio.textui;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class RandomFactorSequenceGenerator {
    private static final char[] DNA_CHARS = new char[]{'A', 'C', 'G', 'T'};
    private static final char[] PROT_CHARS = new char[]{'A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V', 'B', 'Z', 'X'};

    public static void main(String[] stringArray) {
        int n;
        Writer writer;
        String string;
        char[] cArray;
        int n2;
        String string2;
        try {
            string2 = stringArray[0];
            n2 = Integer.parseInt(stringArray[1]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            RandomFactorSequenceGenerator.usage();
            System.exit(1);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            RandomFactorSequenceGenerator.usage();
            System.exit(1);
            return;
        }
        if (string2.equalsIgnoreCase("DNA")) {
            cArray = DNA_CHARS;
        } else if (string2.equalsIgnoreCase("PROT")) {
            cArray = PROT_CHARS;
        } else {
            RandomFactorSequenceGenerator.usage();
            System.exit(1);
            return;
        }
        if (n2 <= 3) {
            System.err.println("Error: size must be greater than 3.");
            System.exit(1);
            return;
        }
        try {
            string = stringArray[2];
            try {
                writer = new BufferedWriter(new FileWriter(string));
            }
            catch (IOException iOException) {
                System.err.println("Error: couldn't open " + string + " for writing.");
                iOException.printStackTrace();
                System.exit(2);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string = null;
            writer = new OutputStreamWriter(System.out);
        }
        int[] nArray = new int[cArray.length];
        int[] nArray2 = new int[n2 / 2];
        try {
            n = 0;
            int n3 = 0;
            while (n < n2) {
                int n4 = 0;
                while (n4 < n3 && n < n2) {
                    writer.write(cArray[nArray2[n4]]);
                    ++n;
                    int n5 = nArray2[n4];
                    nArray[n5] = nArray[n5] + 1;
                    ++n4;
                }
                if (n >= n2) continue;
                int n6 = (int)(Math.random() * (double)cArray.length);
                nArray2[n3++] = n6;
                int n7 = n6;
                nArray[n7] = nArray[n7] + 1;
                writer.write(cArray[n6]);
                ++n;
            }
            writer.flush();
            if (string != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            System.err.println("Error: failed to write sequence.");
            iOException.printStackTrace();
            System.exit(2);
            return;
        }
        System.out.println("\nCharacter distribution:");
        n = 0;
        while (n < cArray.length) {
            System.err.println(cArray[n] + ": " + nArray[n]);
            ++n;
        }
        System.exit(0);
    }

    private static void usage() {
        System.err.println("\nUsage: RandomFactorSequenceGenerator <type> <size> [<file>]\n\nwhere:\n\n   <type> = DNA for nucleotide sequences\n         or PROT for protein sequences\n\n   <size> = number os characters\n\n   <file> = name of a file to where the sequence is to be written\n            (if ommited, sequence is written to standard output)");
    }
}

