/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.structure;

import com.informagen.Sequence;
import com.informagen.sa.AnalysisPanel;
import com.informagen.sa.SAObject;
import com.informagen.sa.structure.ALOM;
import com.informagen.sa.structure.AlphaHelix;
import com.informagen.sa.structure.Antigenicity;
import com.informagen.sa.structure.BetaSheet;
import com.informagen.sa.structure.BetaTurn;
import com.informagen.sa.structure.FractionBuried;
import com.informagen.sa.structure.FreeEnergy;
import com.informagen.sa.structure.GraphPanel;
import com.informagen.sa.structure.Hydropathy;
import com.informagen.sa.structure.Hydrophilic;
import com.informagen.sa.structure.SequenceAnalyzer;
import com.informagen.sa.structure.SmoothingFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.util.prefs.Preferences;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class StructurePanel
extends AnalysisPanel {
    private final Preferences preferences = Preferences.userNodeForPackage(this.getClass());
    private static String urlTemplate = null;
    final JComboBox mAnalysisChoice = new JComboBox();
    final JPanel mSmoothingMethodsPanel = new JPanel();
    final ButtonGroup mSmoothingMethodsGrp = new ButtonGroup();
    final JRadioButton mRawDataBox = new JRadioButton("Raw data");
    final JRadioButton mRunningAveBox = new JRadioButton("Running average");
    final JRadioButton mMedianSieveBox = new JRadioButton("Median sieve");
    private GraphPanel mGraphPanel = new GraphPanel("");
    SequenceAnalyzer mAnalyzer;
    private boolean threadIsRunning = false;

    public static String getAnalysisName() {
        return "Structure";
    }

    public StructurePanel() {
        this.buildUI();
        this.wireUI();
        this.mAnalysisChoice.setSelectedItem(this.preferences.get("Structure.analysis", "Hydrophilic"));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("graphSelectionChanged")) {
            if (this.sequence == null) {
                return;
            }
            if (this.sequence.isProtein()) {
                this.pcs.firePropertyChange("selectionChanged", null, propertyChangeEvent.getNewValue());
            }
        } else if (string.equals("graphSequenceClicked")) {
            if (this.sequence == null) {
                return;
            }
            if (this.sequence.isProtein()) {
                this.pcs.firePropertyChange("positionChanged", null, propertyChangeEvent.getNewValue());
            }
            if (this.sequence.isNucleic() && this.selection == null) {
                int n = (Integer)propertyChangeEvent.getNewValue() * 3;
                this.pcs.firePropertyChange("positionChanged", null, new Integer(n));
            }
        }
    }

    public boolean ignorePropertyChangeEvents() {
        return false;
    }

    public void changeSequence(SAObject sAObject, int[] nArray) {
        this.saObject = sAObject;
        this.sequence = sAObject.getSequence();
        this.selection = nArray;
        this.graphIt();
    }

    public void sequenceUnavailable() {
        this.saObject = null;
        this.sequence = null;
        this.selection = null;
    }

    public void sequenceChanged(SAObject sAObject) {
        this.saObject = sAObject;
        this.sequence = sAObject.getSequence();
        this.graphIt();
    }

    public void selectionChanged(int[] nArray) {
        if (this.sequence == null) {
            return;
        }
        if (this.sequence.isNucleic()) {
            this.selection = nArray;
            this.graphIt();
        } else {
            this.mGraphPanel.selectionChanged(nArray[0], nArray[1]);
        }
    }

    public void selectionCancelled() {
        this.selection = null;
        if (this.sequence == null) {
            return;
        }
        if (this.sequence.isNucleic()) {
            this.graphIt();
        }
    }

    public void cursorPositionChanged(int n) {
        n = this.sequence.isNucleic() ? n / 3 : n;
        this.mGraphPanel.propertyChange(new PropertyChangeEvent(this, "caretPosition", null, new Integer(n)));
    }

    public void printPanel() {
    }

    public void savePanel() {
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.mAnalysisChoice.addItem("ALOM");
        this.mAnalysisChoice.addItem("Alpha Helix");
        this.mAnalysisChoice.addItem("Beta Sheet");
        this.mAnalysisChoice.addItem("Beta Turn");
        this.mAnalysisChoice.addItem("Antigenic Sites");
        this.mAnalysisChoice.addItem("Hydrophilic");
        this.mAnalysisChoice.addItem("Hydropathy");
        this.mAnalysisChoice.addItem("Fraction Buried");
        this.mAnalysisChoice.addItem("Free Energy");
        jPanel.add(this.mAnalysisChoice);
        this.mSmoothingMethodsPanel.setLayout(new FlowLayout(0, 1, 1));
        this.mSmoothingMethodsPanel.add(this.mRawDataBox);
        this.mSmoothingMethodsPanel.add(this.mRunningAveBox);
        this.mSmoothingMethodsPanel.add(this.mMedianSieveBox);
        this.mRunningAveBox.setSelected(true);
        jPanel.add(this.mSmoothingMethodsPanel);
        this.add((Component)jPanel, "North");
        this.mGraphPanel.setBackground(Color.white);
        this.add((Component)this.mGraphPanel, "Center");
    }

    void wireUI() {
        this.mGraphPanel.propertyChange(new PropertyChangeEvent(this, "addPropertyChangeListener", null, this));
        this.mAnalysisChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                StructurePanel.this.analysisChoiceAction();
                StructurePanel.this.preferences.put("Structure.analysis", (String)StructurePanel.this.mAnalysisChoice.getSelectedItem());
            }
        });
        this.mSmoothingMethodsGrp.add(this.mRawDataBox);
        this.mSmoothingMethodsGrp.add(this.mRunningAveBox);
        this.mSmoothingMethodsGrp.add(this.mMedianSieveBox);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                StructurePanel.this.smoothingListenerAction((JRadioButton)itemEvent.getSource());
            }
        };
        this.mRawDataBox.addItemListener(itemListener);
        this.mRunningAveBox.addItemListener(itemListener);
        this.mMedianSieveBox.addItemListener(itemListener);
    }

    private void smoothingListenerAction(JRadioButton jRadioButton) {
        int n = 2;
        if (jRadioButton == this.mRunningAveBox) {
            n = 2;
        } else if (jRadioButton == this.mMedianSieveBox) {
            n = 3;
        } else if (jRadioButton == this.mRawDataBox) {
            n = 1;
        }
        ((SmoothingFilter)this.mAnalyzer).setFilterMethod(n);
        this.graphIt();
    }

    private void analysisChoiceAction() {
        int n = 2;
        if (this.mRunningAveBox.isSelected()) {
            n = 2;
        } else if (this.mMedianSieveBox.isSelected()) {
            n = 3;
        } else if (this.mRawDataBox.isSelected()) {
            n = 1;
        }
        int n2 = this.mAnalysisChoice.getSelectedIndex();
        switch (n2) {
            case 0: {
                this.setAnalyzer(new ALOM());
                break;
            }
            case 1: {
                this.setAnalyzer(new AlphaHelix(n));
                break;
            }
            case 2: {
                this.setAnalyzer(new BetaSheet(n));
                break;
            }
            case 3: {
                this.setAnalyzer(new BetaTurn(n));
                break;
            }
            case 4: {
                this.setAnalyzer(new Antigenicity(n));
                break;
            }
            case 5: {
                this.setAnalyzer(new Hydrophilic(n));
                break;
            }
            case 6: {
                this.setAnalyzer(new Hydropathy(n));
                break;
            }
            case 7: {
                this.setAnalyzer(new FractionBuried(n));
                break;
            }
            case 8: {
                this.setAnalyzer(new FreeEnergy(n));
            }
        }
        this.adjustCheckboxGroup(this.mSmoothingMethodsPanel, n2 != 0);
    }

    private void setAnalyzer(SequenceAnalyzer sequenceAnalyzer) {
        this.mAnalyzer = sequenceAnalyzer;
        this.mGraphPanel.setName(this.mAnalyzer.getName());
        double d = this.mAnalyzer.getGraphMin();
        double d2 = this.mAnalyzer.getGraphMax();
        double d3 = this.mAnalyzer.getGraphCutoff();
        this.mGraphPanel.setGraphParameters(d, d2, d3);
        this.graphIt();
    }

    public void graphIt() {
        if (this.sequence == null) {
            return;
        }
        if (this.threadIsRunning) {
            return;
        }
        this.mAnalysisChoice.setEnabled(false);
        Thread thread = new Thread(){

            public void run() {
                String string = null;
                if (StructurePanel.this.sequence.isNucleic()) {
                    String string2 = StructurePanel.this.sequence.getSequence();
                    if (StructurePanel.this.selection != null) {
                        string2 = string2.substring(StructurePanel.this.selection[0], StructurePanel.this.selection[1]);
                    }
                    string = Sequence.nucToProtein(string2);
                } else {
                    string = StructurePanel.this.sequence.getSequence();
                }
                StructurePanel.this.mGraphPanel.setGraphData(StructurePanel.this.mAnalyzer.analyze(string));
                StructurePanel.this.threadIsRunning = false;
                StructurePanel.this.mAnalysisChoice.setEnabled(true);
            }
        };
        try {
            this.threadIsRunning = true;
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private void adjustCheckboxGroup(Container container, boolean bl) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (bl) {
                componentArray[i].setEnabled(true);
                continue;
            }
            componentArray[i].setEnabled(false);
        }
    }
}

