/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa;

import com.informagen.Sequence;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class NCBIXMLHandler
extends DefaultHandler {
    final Stack stack = new Stack();
    final StringBuffer pcdata = new StringBuffer();
    boolean inFirstEntry = true;
    Sequence sequence;
    int length = 0;
    String GID = null;

    NCBIXMLHandler() {
    }

    void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public void startDocument() throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.pcdata.append(new String(cArray, n, n2));
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.pcdata.setLength(0);
        String string4 = this.stack.empty() ? "" : (String)this.stack.peek();
        this.stack.push(string2);
        if (string4.equals("Seq-inst") && string2.equals("Seq-inst_mol") && this.inFirstEntry) {
            String string5 = attributes.getValue("value");
            if (string5.equals("dna")) {
                this.sequence.setDNA();
            } else if (string5.equals("rna")) {
                this.sequence.setRNA();
            } else if (string5.equals("aa")) {
                this.sequence.setProtein();
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4;
        this.stack.pop();
        String string5 = string4 = this.stack.empty() ? "" : (String)this.stack.peek();
        if (string4.equals("Bioseq-set_seq-set") && string2.equals("Seq-entry") && this.inFirstEntry) {
            this.inFirstEntry = false;
        } else if (string4.equals("Seqdesc") && string2.equals("Seqdesc_title") && this.inFirstEntry) {
            this.sequence.setTitle(this.pcdata.toString());
        } else if (string4.equals("Textseq-id") && string2.equals("Textseq-id_name") && this.inFirstEntry) {
            this.sequence.setUID(this.pcdata.toString());
        } else if (string4.equals("Seq-id") && string2.equals("Seq-id_gi") && this.inFirstEntry && this.GID == null) {
            this.GID = this.pcdata.toString();
        } else if (string4.equals("Seq-inst") && string2.equals("Seq-inst_length") && this.inFirstEntry) {
            this.length = Integer.parseInt(this.pcdata.toString());
        } else if (string4.equals("Seq-data_iupacna") && string2.equals("IUPACna") && this.inFirstEntry) {
            String string6 = this.pcdata.toString();
            if (this.sequence.isRNA()) {
                string6 = string6.replace('T', 'U');
            }
            this.sequence.setSequence(string6);
        } else if (string4.equals("Seq-data_ncbi2na") && string2.equals("NCBI2na") && this.inFirstEntry) {
            String string7 = this.decode2BitSequence(this.pcdata.toString());
            if (this.sequence.isRNA()) {
                string7 = string7.replace('T', 'U');
            }
            this.sequence.setSequence(string7);
        } else if (string4.equals("Seq-data_ncbi4na") && string2.equals("NCBI4na") && this.inFirstEntry) {
            String string8 = this.decode4BitSequence(this.pcdata.toString());
            if (this.sequence.isRNA()) {
                string8 = string8.replace('T', 'U');
            }
            this.sequence.setSequence(string8);
        } else if (string4.equals("Seq-data_ncbieaa") && string2.equals("NCBIeaa") && this.inFirstEntry) {
            this.sequence.setSequence(this.pcdata.toString());
        } else if (string4.equals("Seq-data_iupacaa") && string2.equals("IUPACaa") && this.inFirstEntry) {
            this.sequence.setSequence(this.pcdata.toString());
        }
    }

    public void endDocument() throws SAXException {
        this.stack.removeAllElements();
    }

    private String decode2BitSequence(String string) {
        byte[] byArray = string.getBytes();
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        block18: for (int i = 0; i < byArray.length; ++i) {
            switch (byArray[i]) {
                case 48: {
                    stringBuffer.append("AA");
                    continue block18;
                }
                case 49: {
                    stringBuffer.append("AC");
                    continue block18;
                }
                case 50: {
                    stringBuffer.append("AG");
                    continue block18;
                }
                case 51: {
                    stringBuffer.append("AT");
                    continue block18;
                }
                case 52: {
                    stringBuffer.append("CA");
                    continue block18;
                }
                case 53: {
                    stringBuffer.append("CC");
                    continue block18;
                }
                case 54: {
                    stringBuffer.append("CG");
                    continue block18;
                }
                case 55: {
                    stringBuffer.append("CT");
                    continue block18;
                }
                case 56: {
                    stringBuffer.append("GA");
                    continue block18;
                }
                case 57: {
                    stringBuffer.append("GC");
                    continue block18;
                }
                case 65: {
                    stringBuffer.append("GG");
                    continue block18;
                }
                case 66: {
                    stringBuffer.append("GT");
                    continue block18;
                }
                case 67: {
                    stringBuffer.append("TA");
                    continue block18;
                }
                case 68: {
                    stringBuffer.append("TC");
                    continue block18;
                }
                case 69: {
                    stringBuffer.append("TG");
                    continue block18;
                }
                case 70: {
                    stringBuffer.append("TT");
                }
            }
        }
        if (this.length > 0) {
            stringBuffer.setLength(this.length);
        }
        return stringBuffer.toString();
    }

    private String decode4BitSequence(String string) {
        byte[] byArray = string.getBytes();
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        block18: for (int i = 0; i < byArray.length; ++i) {
            switch (byArray[i]) {
                case 48: {
                    continue block18;
                }
                case 49: {
                    stringBuffer.append("A");
                    continue block18;
                }
                case 50: {
                    stringBuffer.append("C");
                    continue block18;
                }
                case 51: {
                    stringBuffer.append("M");
                    continue block18;
                }
                case 52: {
                    stringBuffer.append("G");
                    continue block18;
                }
                case 53: {
                    stringBuffer.append("R");
                    continue block18;
                }
                case 54: {
                    stringBuffer.append("S");
                    continue block18;
                }
                case 55: {
                    stringBuffer.append("V");
                    continue block18;
                }
                case 56: {
                    stringBuffer.append("T");
                    continue block18;
                }
                case 57: {
                    stringBuffer.append("W");
                    continue block18;
                }
                case 65: {
                    stringBuffer.append("Y");
                    continue block18;
                }
                case 66: {
                    stringBuffer.append("H");
                    continue block18;
                }
                case 67: {
                    stringBuffer.append("K");
                    continue block18;
                }
                case 68: {
                    stringBuffer.append("D");
                    continue block18;
                }
                case 69: {
                    stringBuffer.append("B");
                    continue block18;
                }
                case 70: {
                    stringBuffer.append("N");
                }
            }
        }
        if (this.length > 0) {
            stringBuffer.setLength(this.length);
        }
        return stringBuffer.toString();
    }
}

