/*
 * Decompiled with CFR 0.152.
 */
package com.infocom.print;

import com.infocom.print.PFInchUnit;
import com.infocom.print.PFPage;
import com.infocom.print.PFPoint;
import com.infocom.print.PFSize;
import com.infocom.print.PFUnit;
import java.awt.Graphics2D;
import java.util.Vector;

public abstract class PFPrintObject {
    public static final int STICKY_LEFT = 0;
    public static final int STICKY_RIGHT = 1;
    public static final int STICKY_CENTER = 2;
    public static final int STICKY_TOP = 3;
    public static final int STICKY_BOTTOM = 4;
    public static final int STICKY_NONE = 5;
    private PFPoint position = new PFPoint(new PFInchUnit(0.0), new PFInchUnit(0.0));
    private PFSize size = new PFSize(new PFInchUnit(1.0), new PFInchUnit(1.0));
    private Vector printObjectCollection = new Vector();
    private PFPrintObject parentObject = null;
    private PFPage page = null;
    private int verticalSticky = 5;
    private int horizontalSticky = 5;
    private boolean horizontalFill = false;
    private boolean verticalFill = false;
    private PFPoint drawOrigin = new PFPoint(new PFInchUnit(0.0), new PFInchUnit(0.0));
    private PFSize drawSize = new PFSize(new PFInchUnit(0.0), new PFInchUnit(0.0));
    private boolean relativeMode = true;
    private PFUnit leftMargin = new PFInchUnit(0.0);
    private PFUnit rightMargin = new PFInchUnit(0.0);
    private PFUnit topMargin = new PFInchUnit(0.0);
    private PFUnit bottomMargin = new PFInchUnit(0.0);

    public abstract void print(Graphics2D var1);

    public void printChilds(Graphics2D graphics2D) {
        for (int i = 0; i < this.printObjectCollection.size(); ++i) {
            PFPrintObject pFPrintObject = (PFPrintObject)this.printObjectCollection.get(i);
            pFPrintObject.print(graphics2D);
        }
    }

    public PFPoint getDrawingOrigin() {
        return this.drawOrigin;
    }

    public PFSize getDrawingSize() {
        return this.drawSize;
    }

    public void computePositionAndSize() {
        PFInchUnit pFInchUnit;
        PFInchUnit pFInchUnit2;
        PFInchUnit pFInchUnit3;
        PFSize pFSize;
        PFPoint pFPoint;
        if (this.isChild()) {
            pFPoint = this.getParent().getDrawingOrigin();
            pFSize = this.getParent().getDrawingSize();
        } else {
            pFPoint = this.getPage().getPrintableAreaOrigin();
            pFSize = this.getPage().getPrintableAreaSize();
        }
        if (this.relativeMode) {
            this.drawOrigin = (PFPoint)this.position.clone();
            this.drawOrigin.add(pFPoint);
        } else {
            this.drawOrigin = (PFPoint)this.position.clone();
        }
        this.drawSize = (PFSize)this.size.clone();
        this.drawOrigin.setX(this.drawOrigin.getX().add(this.leftMargin));
        this.drawOrigin.setY(this.drawOrigin.getY().add(this.topMargin));
        this.drawSize.setWidth(this.drawSize.getWidth().substract(this.leftMargin.add(this.rightMargin)));
        this.drawSize.setHeight(this.drawSize.getHeight().substract(this.topMargin.add(this.bottomMargin)));
        if (this.horizontalFill) {
            this.drawSize = new PFSize(pFSize.getWidth(), this.drawSize.getHeight());
        }
        if (this.verticalFill) {
            this.drawSize = new PFSize(this.drawSize.getWidth(), pFSize.getHeight());
        }
        switch (this.verticalSticky) {
            case 3: {
                this.drawOrigin.setLocation(this.drawOrigin.getX(), pFPoint.getY());
                break;
            }
            case 2: {
                pFInchUnit3 = (PFInchUnit)pFSize.getHeight().divide(2.0);
                pFInchUnit2 = (PFInchUnit)this.getSize().getHeight().divide(2.0);
                pFInchUnit = (PFInchUnit)pFInchUnit3.substract(pFInchUnit2);
                this.drawOrigin.setLocation(this.drawOrigin.getX(), pFInchUnit.add(this.drawOrigin.getY()));
                break;
            }
            case 4: {
                pFInchUnit = (PFInchUnit)pFSize.getHeight().substract(this.getSize().getHeight());
                this.drawOrigin.setLocation(this.drawOrigin.getX(), pFInchUnit.add(this.drawOrigin.getY()));
            }
        }
        switch (this.horizontalSticky) {
            case 0: {
                this.drawOrigin.setLocation(this.drawOrigin.getX(), this.drawOrigin.getY());
                break;
            }
            case 2: {
                pFInchUnit3 = (PFInchUnit)pFSize.getWidth().divide(2.0);
                pFInchUnit2 = (PFInchUnit)this.getSize().getWidth().divide(2.0);
                pFInchUnit = (PFInchUnit)pFInchUnit3.substract(pFInchUnit2);
                this.drawOrigin.setLocation(pFInchUnit.add(this.drawOrigin.getX()), this.drawOrigin.getY());
                break;
            }
            case 1: {
                pFInchUnit = (PFInchUnit)pFSize.getWidth().substract(this.getSize().getWidth());
                this.drawOrigin.setLocation(pFInchUnit.add(this.drawOrigin.getX()), this.drawOrigin.getY());
            }
        }
    }

    public void setVerticalSticky(int n) {
        this.verticalSticky = n;
    }

    public int getVerticalSticky() {
        return this.verticalSticky;
    }

    public void setHorizontalSticky(int n) {
        this.horizontalSticky = n;
    }

    public int getHorizontalSticky() {
        return this.horizontalSticky;
    }

    public void setHorizontalFill(boolean bl) {
        this.horizontalFill = bl;
    }

    public boolean getHorizontalFill() {
        return this.horizontalFill;
    }

    public void setVerticalFill(boolean bl) {
        this.verticalFill = bl;
    }

    public boolean getVerticalFill() {
        return this.verticalFill;
    }

    public void add(PFPrintObject pFPrintObject) {
        this.printObjectCollection.add(pFPrintObject);
        pFPrintObject.setParent(this);
    }

    private void setParent(PFPrintObject pFPrintObject) {
        this.parentObject = pFPrintObject;
    }

    public PFPrintObject getParent() {
        return this.parentObject;
    }

    public boolean isChild() {
        return this.parentObject != null;
    }

    public void remove(PFPrintObject pFPrintObject) {
        this.printObjectCollection.remove(pFPrintObject);
        pFPrintObject.setParent(null);
    }

    public void setPage(PFPage pFPage) {
        this.page = pFPage;
        for (int i = 0; i < this.printObjectCollection.size(); ++i) {
            PFPrintObject pFPrintObject = (PFPrintObject)this.printObjectCollection.get(i);
            pFPrintObject.setPage(pFPage);
        }
    }

    public PFPage getPage() {
        return this.page;
    }

    public void setPosition(PFPoint pFPoint) {
        this.position = pFPoint;
    }

    public PFPoint getPosition() {
        return this.position;
    }

    public void setSize(PFSize pFSize) {
        this.size = pFSize;
    }

    public PFSize getSize() {
        return this.size;
    }

    public void setWidth(PFUnit pFUnit) {
        this.size.setWidth(pFUnit);
    }

    public void setHeight(PFUnit pFUnit) {
        this.size.setHeight(pFUnit);
    }

    public void setRelativeMode(boolean bl) {
        this.relativeMode = bl;
    }

    public void setLeftMargin(PFUnit pFUnit) {
        this.leftMargin = pFUnit;
    }

    public PFUnit getLeftMargin() {
        return this.leftMargin;
    }

    public void setRightMargin(PFUnit pFUnit) {
        this.rightMargin = pFUnit;
    }

    public PFUnit getRightMargin() {
        return this.rightMargin;
    }

    public void setTopMargin(PFUnit pFUnit) {
        this.topMargin = pFUnit;
    }

    public PFUnit getTopMargin() {
        return this.topMargin;
    }

    public void setBottomMargin(PFUnit pFUnit) {
        this.bottomMargin = pFUnit;
    }

    public PFUnit getBottomMargin() {
        return this.bottomMargin;
    }
}

