/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh;

import edsim51sh.ClipboardManager;
import edsim51sh.MainPanel;
import edsim51sh.Region;
import edsim51sh.Text;
import edsim51sh.VisibleCaretListener;
import edsim51sh.exceptions.Edsim51Exception;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class AssemblyCodeBox
extends JTextPane
implements MouseListener,
KeyListener {
    private static final String[] INSTRUCTIONS = new String[]{"PUSH", "POP", "MOV", "MOVX", "MOVC", "ADD", "ADDC", "SUBB", "INC", "DEC", "CLR", "CPL", "SETB", "SJMP", "AJMP", "LJMP", "JMP @A+DPTR", "ACALL", "LCALL", "RET", "RETI", "DJNZ", "CJNE", "JZ", "JNZ", "JC", "JNC", "JB", "JBC", "JNB", "ANL", "ORL", "XRL", "RL", "RLC", "RR", "RRC", "MUL", "DIV", "SWAP", "XCH", "XCHD", "DA", "NOP", "A", "AB", "C", "R0", "R1", "R2", "R3", "R4", "R5", "R6", "R7", "@R0", "@R1", "DPTR", "@DPTR", "@A+DPTR", "@A+PC"};
    private static final String[] DIRECTIVES = new String[]{"DB", "HIGH", "LOW", "ORG", "USING", "EQU", "SET", "CALL", "JMP", "$", "END"};
    private static final String[] ALIASES = new String[]{"P0", "SP", "DPL", "DPH", "PCON", "TCON", "TMOD", "TL0", "TL1", "TH0", "TH1", "P1", "SCON", "SBUF", "P2", "PCON", "IE", "P3", "IP", "PSW", "ACC", "B", "AR0", "AR1", "AR2", "AR3", "AR4", "AR5", "AR6", "AR7", "IT0", "IE0", "IT1", "IE1", "TR0", "TF0", "TR1", "TF1", "RI", "TI", "RB8", "TB8", "REN", "SM2", "SM1", "SM0", "EX0", "ET0", "EX1", "ET1", "ES", "EA", "PT0", "PX1", "PT1", "PS", "P", "OV", "RS0", "RS1", "F0", "AC", "CY"};
    private static final Color PURPLE = new Color(180, 51, 180);
    private static final Color GREY = new Color(240, 240, 240);
    private static final Color GREEN = new Color(0, 180, 0);
    private static final Color ORANGE = new Color(200, 100, 0);
    private ClipboardManager clipboard = new ClipboardManager();
    private UndoManager undo = new UndoManager();
    private MainPanel sim;
    private char specialZero = (char)216;
    private String fontName = null;
    private int fontSize = 14;
    private Region highlightedAddress = null;
    private Edsim51Exception assemblerError = null;
    private boolean movedToError = false;
    private boolean highlightSyntax = true;

    public AssemblyCodeBox(MainPanel sim) {
        this.sim = sim;
        this.init();
        this.addUndoRedoFunctionality();
        this.getDocument().putProperty("__EndOfLine__", "\n");
    }

    public void setFontSize(boolean small) {
        this.fontSize = small ? 14 : 21;
        this.setFont(new Font(this.fontName, 1, this.fontSize));
    }

    public void setTextWithoutModification(String s) {
        super.setText(s.replace('0', this.specialZero));
        this.highlightSyntax();
    }

    @Override
    public void setText(String s) {
        super.setText(s.replace('0', this.specialZero));
        this.modified();
    }

    @Override
    public String getText() {
        return super.getText().replace(this.specialZero, '0');
    }

    @Override
    public void replaceSelection(String s) {
        super.replaceSelection(s.replace('0', this.specialZero));
        this.modified();
    }

    @Override
    public String getSelectedText() {
        return super.getSelectedText().replace(this.specialZero, '0');
    }

    public void pasteTextFromClipboard() {
        String s = this.clipboard.paste();
        if (s != null && !s.equals("")) {
            if (this.isEditable()) {
                this.replaceSelection(s);
            } else {
                this.sim.messageBox.setText("You must click Reset before pasting text.");
            }
        }
    }

    public void setAssemblerError(Edsim51Exception ex) {
        this.movedToError = false;
        this.assemblerError = ex;
        if (ex != null) {
            this.highlightError();
        } else {
            this.highlightSyntax();
        }
    }

    private void highlightError() {
        String code;
        int errorStart;
        if (this.assemblerError != null && (errorStart = this.assemblerError.getErrorStart(code = this.getText(), this.getComments(code))) != -1) {
            int errorEnd = this.assemblerError.getErrorEnd(errorStart);
            this.setTextColor(Color.RED, errorStart, errorEnd - errorStart);
            if (!this.movedToError) {
                this.setCaretPosition(errorStart);
                this.movedToError = true;
            }
        }
    }

    public void copyTextToClipboard() {
        String s = this.getSelectedText();
        if (!s.equals("")) {
            this.clipboard.copy(s);
        }
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (editable) {
            this.setBackground(Color.WHITE);
        } else {
            this.setBackground(GREY);
        }
    }

    private void modified() {
        this.sim.instructions = null;
        this.sim.codeSaved = false;
        this.highlightSyntax();
        this.highlightedAddress = null;
    }

    public void highlightAddress(int pc) {
        if (this.highlightedAddress != null) {
            this.setTextColor(Color.BLACK, this.highlightedAddress.start, this.highlightedAddress.length);
        }
        String pcString = Text.inHex(pc, false, 4);
        String[] ss = new String[]{pcString + "|", pcString + "*"};
        Vector v = this.getRegions(ss, this.getText());
        if (v.size() > 0) {
            this.highlightedAddress = (Region)v.elementAt(0);
            this.setTextColor(Color.RED, this.highlightedAddress.start, this.highlightedAddress.length);
            this.setCaretPosition(this.highlightedAddress.start);
        }
    }

    private void setTextColor(Color color, int start, int length) {
        MutableAttributeSet attrs = this.getInputAttributes();
        StyleConstants.setForeground(attrs, color);
        StyledDocument doc = this.getStyledDocument();
        doc.setCharacterAttributes(start, length, attrs, false);
    }

    private void highlightSyntax() {
        this.setTextColor(Color.BLACK, 0, this.getText().length());
        if (this.highlightSyntax) {
            Region r;
            int i;
            Vector v = this.getRegions(INSTRUCTIONS, this.getText().toUpperCase());
            for (i = 0; i < v.size(); ++i) {
                r = (Region)v.elementAt(i);
                this.setTextColor(Color.BLUE, r.start, r.length);
            }
            v = this.getRegions(DIRECTIVES, this.getText().toUpperCase());
            for (i = 0; i < v.size(); ++i) {
                r = (Region)v.elementAt(i);
                this.setTextColor(PURPLE, r.start, r.length);
            }
            v = this.getRegions(ALIASES, this.getText().toUpperCase());
            for (i = 0; i < v.size(); ++i) {
                r = (Region)v.elementAt(i);
                this.setTextColor(ORANGE, r.start, r.length);
            }
            v = this.getComments(this.getText());
            for (i = 0; i < v.size(); ++i) {
                r = (Region)v.elementAt(i);
                this.setTextColor(GREEN, r.start, r.length);
            }
        }
        this.highlightError();
        this.setTextColor(Color.BLACK, this.getText().length(), 0);
    }

    private Vector getComments(String text) {
        Vector<Region> v = new Vector<Region>();
        int start = -1;
        do {
            if ((start = text.indexOf(59, start + 1)) == -1) continue;
            int newlineIndex = text.indexOf(10, start + 1);
            if (newlineIndex == -1) {
                newlineIndex = text.length();
            }
            Region r = new Region();
            r.start = start;
            r.length = newlineIndex - start;
            v.addElement(r);
            start = newlineIndex;
        } while (start != -1);
        return v;
    }

    private Vector getRegions(String[] keys, String text) {
        Vector v = new Vector();
        for (int i = 0; i < keys.length; ++i) {
            v = this.getRegions(keys[i], text, v);
        }
        return v;
    }

    private Vector getRegions(String key, String text, Vector v) {
        int start = -1;
        do {
            if ((start = text.indexOf(key, start + 1)) == -1 || !this.isAWord(start, text, key)) continue;
            Region r = new Region();
            r.start = start;
            r.length = key.length();
            v.addElement(r);
        } while (start != -1);
        return v;
    }

    private boolean isAWord(int start, String text, String key) {
        if (start == 0) {
            text = " " + text;
            start = 1;
        }
        text = (text = text.substring(start - 1)).length() > key.length() + 1 ? text.substring(0, key.length() + 2) : text + " ";
        return !this.isLetterOrNumberOrQuote(text.charAt(0)) && !this.isLetterOrNumberOrQuote(text.charAt(text.length() - 1));
    }

    private boolean isLetterOrNumberOrQuote(char c) {
        return c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '\'' || c == '\"';
    }

    public void init() {
        int i;
        this.fontName = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        for (i = 0; i < fontNames.length; ++i) {
            if (!fontNames[i].toLowerCase().equals("monospaced")) continue;
            this.fontName = fontNames[i];
            break;
        }
        if (this.fontName == null) {
            for (i = 0; i < fontNames.length; ++i) {
                if (!fontNames[i].toLowerCase().contains("mono")) continue;
                this.fontName = fontNames[i];
                break;
            }
        }
        if (this.fontName == null) {
            for (i = 0; i < fontNames.length; ++i) {
                if (!fontNames[i].toLowerCase().contains("fixed")) continue;
                this.fontName = fontNames[i];
                break;
            }
        }
        if (this.fontName == null) {
            for (i = 0; i < fontNames.length; ++i) {
                if (!fontNames[i].toLowerCase().contains("courier")) continue;
                this.fontName = fontNames[i];
                break;
            }
        }
        if (this.fontName == null) {
            this.fontName = this.getFont().getName();
        }
        this.setFont(new Font(this.fontName, 1, this.fontSize));
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.setTabs();
        this.addCaretListener(new VisibleCaretListener());
    }

    private void setTabs() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int charWidth = fm.charWidth('w');
        int tabWidth = charWidth * 4;
        TabStop[] tabs = new TabStop[10];
        for (int j = 0; j < tabs.length; ++j) {
            int tab = j + 1;
            tabs[j] = new TabStop(tab * tabWidth);
        }
        TabSet tabSet = new TabSet(tabs);
        MutableAttributeSet attrs = this.getInputAttributes();
        StyleConstants.setTabSet(attrs, tabSet);
        this.getStyledDocument().setParagraphAttributes(0, this.getDocument().getLength(), attrs, false);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container parent = this.getParent();
        TextUI cui = this.getUI();
        if (parent != null) {
            return cui.getPreferredSize((JComponent)this).width <= parent.getSize().width;
        }
        return false;
    }

    @Override
    public void keyPressed(KeyEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 8 || evt.getKeyCode() == 127) {
            this.modified();
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        boolean rightClick;
        boolean bl = rightClick = (evt.getModifiers() & 4) == 4;
        if (rightClick) {
            int response = JOptionPane.showConfirmDialog(this.sim, "Do you want syntax highlighting turned on?", "Syntax Highlighting", 0, 3);
            if (response == 0) {
                this.highlightSyntax = true;
            } else if (response == 1) {
                this.highlightSyntax = false;
            }
            this.highlightSyntax();
            return;
        }
        if (!this.isEditable()) {
            if (evt.getClickCount() == 2 && evt.getX() < 25) {
                this.sim.setBreakpoint(this.getSelectedText());
            }
        } else {
            this.modified();
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    private void addUndoRedoFunctionality() {
        this.getDocument().addUndoableEditListener(new Uel());
        this.getActionMap().put("Undo", new Undo());
        this.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.getActionMap().put("Redo", new Redo());
        this.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
    }

    private class Uel
    implements UndoableEditListener {
        private Uel() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent evt) {
            if (!evt.getEdit().getPresentationName().equals("style change")) {
                AssemblyCodeBox.this.undo.addEdit(evt.getEdit());
            }
        }
    }

    private class Undo
    extends AbstractAction {
        private Undo() {
            super("undo");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (AssemblyCodeBox.this.undo.canUndo()) {
                    AssemblyCodeBox.this.undo.undo();
                    AssemblyCodeBox.this.modified();
                }
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
        }
    }

    private class Redo
    extends AbstractAction {
        private Redo() {
            super("redo");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (AssemblyCodeBox.this.undo.canRedo()) {
                    AssemblyCodeBox.this.undo.redo();
                    AssemblyCodeBox.this.modified();
                }
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
        }
    }
}

