/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Board;
import edsim51di.Gui;
import edsim51di.PeripheralMainPanel;
import edsim51di.ScopeFrame;
import edsim51sh.EdSim51Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JTextField;

class DACGraphics
extends PeripheralMainPanel
implements ActionListener {
    private JTextField voltageField = new JTextField();
    private Dimension voltageFieldDimensionSmall = new Dimension(60, 20);
    private Dimension voltageFieldDimensionLarge = new Dimension(90, 30);
    private JLabel dacLabel = new JLabel("DAC");
    private JLabel voltageLabel = new JLabel("output");
    private EdSim51Button scopeButton = new EdSim51Button("Scope");
    private ScopeFrame scopeFrame;
    private Board board;

    DACGraphics(ScopeFrame scopeFrame, Board board) {
        this.scopeFrame = scopeFrame;
        this.board = board;
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        this.voltageField.setText("0.0 V");
        this.voltageField.setEditable(false);
        this.voltageField.setBackground(Gui.UNEDITABLE_FIELD_GREY);
        this.voltageField.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        this.add((Component)this.voltageField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 0, 2, 2);
        this.add((Component)this.voltageLabel, gbc);
        this.scopeButton.setToolTipText("see output on scope");
        this.scopeButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.insets = insets;
        this.add((Component)this.scopeButton, gbc);
        this.dacLabel.setToolTipText("digital to analogue converter");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        this.add((Component)this.dacLabel, gbc);
    }

    void setScopeColor(Color c) {
        this.scopeFrame.setColor(c);
    }

    @Override
    void setSize(boolean small) {
        Dimension d;
        int size;
        if (small) {
            size = 12;
            d = this.voltageFieldDimensionSmall;
        } else {
            size = 18;
            d = this.voltageFieldDimensionLarge;
        }
        Gui.setSize(this.voltageField, d, 0, size);
        Gui.setFont(this.dacLabel, 1, size);
        Gui.setFont(this.voltageLabel, 1, size);
        this.scopeButton.setFont(1, size);
    }

    void setVoltage(int voltage) {
        float f = (float)voltage * 5.0f / 255.0f;
        int i = Math.round(f * 100.0f);
        f = (float)i / 100.0f;
        this.voltageField.setText(f + " V");
    }

    String getVoltageString() {
        return this.voltageField.getText();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.scopeButton) {
            this.board.registerAlwaysOnTopFrame(this.scopeFrame);
            this.board.registerAlwaysOnTopCheckBox(this.scopeFrame.getAlwaysOnTopCheckBox());
            this.scopeFrame.setVisible(true);
        }
    }
}

