/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.logicle;

import edu.stanford.facs.logicle.LogicleParameterException;

public class Logicle {
    public static final double DEFAULT_DECADES = 4.5;
    public final double a;
    public final double b;
    public final double c;
    public final double d;
    public final double f;
    public final double w;
    public final double x0;
    public final double x1;
    public final double x2;
    public final double T;
    public final double W;
    public final double M;
    public final double A;
    protected static final double LN_10 = Math.log(10.0);
    protected final double xTaylor;
    protected final double[] taylor;

    protected Logicle(double T, double W, double M, double A, int bins) {
        if (T <= 0.0) {
            throw new LogicleParameterException("T is not positive");
        }
        if (W < 0.0) {
            throw new LogicleParameterException("W is negative");
        }
        if (M <= 0.0) {
            throw new LogicleParameterException("M is not positive");
        }
        if (2.0 * W > M) {
            throw new LogicleParameterException("W is too large");
        }
        if (-A > W || A + W > M - W) {
            throw new LogicleParameterException("A is too large");
        }
        if (bins > 0) {
            double zero = (W + A) / (M + A);
            zero = Math.rint(zero * (double)bins) / (double)bins;
            A = (M * zero - W) / (1.0 - zero);
        }
        this.T = T;
        this.M = M;
        this.W = W;
        this.A = A;
        this.w = W / (M + A);
        this.x2 = A / (M + A);
        this.x1 = this.x2 + this.w;
        this.x0 = this.x2 + 2.0 * this.w;
        this.b = (M + A) * LN_10;
        this.d = Logicle.solve(this.b, this.w);
        double c_a = Math.exp(this.x0 * (this.b + this.d));
        double mf_a = Math.exp(this.b * this.x1) - c_a / Math.exp(this.d * this.x1);
        this.a = T / (Math.exp(this.b) - mf_a - c_a / Math.exp(this.d));
        this.c = c_a * this.a;
        this.f = -mf_a * this.a;
        this.xTaylor = this.x1 + this.w / 4.0;
        double posCoef = this.a * Math.exp(this.b * this.x1);
        double negCoef = -this.c / Math.exp(this.d * this.x1);
        this.taylor = new double[16];
        for (int i = 0; i < this.taylor.length; ++i) {
            this.taylor[i] = (posCoef *= this.b / (double)(i + 1)) + (negCoef *= -this.d / (double)(i + 1));
        }
        this.taylor[1] = 0.0;
    }

    public Logicle(double T, double W, double M, double A) {
        this(T, W, M, A, 0);
    }

    public Logicle(double T, double W, double M) {
        this(T, W, M, 0.0);
    }

    public Logicle(double T, double W) {
        this(T, W, 4.5, 0.0);
    }

    protected static double solve(double b, double w) {
        if (w == 0.0) {
            return b;
        }
        double tolerance = 2.0 * Math.ulp(b);
        double d_lo = 0.0;
        double d_hi = b;
        double d = (d_lo + d_hi) / 2.0;
        double last_delta = d_hi - d_lo;
        double f_b = -2.0 * Math.log(b) + w * b;
        double f = 2.0 * Math.log(d) + w * d + f_b;
        double last_f = Double.NaN;
        for (int i = 1; i < 20; ++i) {
            double t;
            double delta;
            double df = 2.0 / d + w;
            if (((d - d_hi) * df - f) * ((d - d_lo) * df - f) >= 0.0 || Math.abs(1.9 * f) > Math.abs(last_delta * df) ? (d = d_lo + (delta = (d_hi - d_lo) / 2.0)) == d_lo : (d -= (delta = f / df)) == (t = d)) {
                return d;
            }
            if (Math.abs(delta) < tolerance) {
                return d;
            }
            last_delta = delta;
            f = 2.0 * Math.log(d) + w * d + f_b;
            if (f == 0.0 || f == last_f) {
                return d;
            }
            last_f = f;
            if (f < 0.0) {
                d_lo = d;
                continue;
            }
            d_hi = d;
        }
        throw new IllegalStateException("exceeded maximum iterations in solve()");
    }

    protected double slope(double scale) {
        if (scale < this.x1) {
            scale = 2.0 * this.x1 - scale;
        }
        return this.a * this.b * Math.exp(this.b * scale) + this.c * this.d / Math.exp(this.d * scale);
    }

    protected double seriesBiexponential(double scale) {
        double x = scale - this.x1;
        double sum = this.taylor[this.taylor.length - 1] * x;
        for (int i = this.taylor.length - 2; i >= 2; --i) {
            sum = (sum + this.taylor[i]) * x;
        }
        return (sum * x + this.taylor[0]) * x;
    }

    public double scale(double value) {
        boolean negative;
        if (value == 0.0) {
            return this.x1;
        }
        boolean bl = negative = value < 0.0;
        if (negative) {
            value = -value;
        }
        double x = value < this.f ? this.x1 + value / this.taylor[0] : Math.log(value / this.a) / this.b;
        double tolerance = 3.0 * Math.ulp(1.0);
        if (x > 1.0) {
            tolerance = 3.0 * Math.ulp(x);
        }
        for (int i = 0; i < 10; ++i) {
            double ae2bx = this.a * Math.exp(this.b * x);
            double ce2mdx = this.c / Math.exp(this.d * x);
            double y = x < this.xTaylor ? this.seriesBiexponential(x) - value : ae2bx + this.f - (ce2mdx + value);
            double abe2bx = this.b * ae2bx;
            double cde2mdx = this.d * ce2mdx;
            double dy = abe2bx + cde2mdx;
            double ddy = this.b * abe2bx - this.d * cde2mdx;
            double delta = y / (dy * (1.0 - y * ddy / (2.0 * dy * dy)));
            x -= delta;
            if (!(Math.abs(delta) < tolerance)) continue;
            if (negative) {
                return 2.0 * this.x1 - x;
            }
            return x;
        }
        throw new IllegalStateException("scale() didn't converge");
    }

    public double inverse(double scale) {
        boolean negative;
        boolean bl = negative = scale < this.x1;
        if (negative) {
            scale = 2.0 * this.x1 - scale;
        }
        double inverse = scale < this.xTaylor ? this.seriesBiexponential(scale) : this.a * Math.exp(this.b * scale) + this.f - this.c / Math.exp(this.d * scale);
        if (negative) {
            return -inverse;
        }
        return inverse;
    }

    public double dynamicRange() {
        return this.slope(1.0) / this.slope(this.x1);
    }

    public double[] axisLabels() {
        int i;
        int np;
        double p = this.M - 2.0 * this.W;
        double log10x = Math.ceil(Math.log(this.T) / LN_10 - p);
        double x = Math.exp(LN_10 * log10x);
        if (x > this.T) {
            x = this.T;
            np = 1;
        } else {
            np = (int)Math.floor(Math.log(this.T) / LN_10 - log10x) + 1;
        }
        double B = this.inverse(0.0);
        int nn = x > -B ? 0 : (x == this.T ? 1 : (int)Math.floor(Math.log(-B) / LN_10 - log10x) + 1);
        double[] label = new double[nn + np + 1];
        label[nn] = 0.0;
        for (i = 1; i <= nn; ++i) {
            label[nn - i] = -x;
            label[nn + i] = x;
            x *= 10.0;
        }
        for (i = nn + 1; i <= np; ++i) {
            label[nn + i] = x;
            x *= 10.0;
        }
        return label;
    }
}

