/*
 * Decompiled with CFR 0.152.
 */
package data2fcs;

import data2fcs.Converter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Matcher;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class Source
extends AbstractCellEditor
implements TableModel,
TableCellEditor,
TableCellRenderer,
FocusListener,
ActionListener {
    File theFile;
    FileReader theReader;
    RandomAccessFile ranFile;
    private long[] linePositions;
    private String separator;
    private boolean decimalPeriod = true;
    private int columnCount;
    private int parameterCount;
    private String[] options = new String[]{"[Name]", "[Log Display]", "[Categorical]", "[Jitter]", "[Range]", "[Highest Value]", "[Skip]", "[Status]"};
    private int rowOffSet;
    private ArrayList<TableModelListener> theListeners = new ArrayList();
    private boolean hasHeaderLine = false;
    private String[] header;
    private Parameter[] theParameters;
    private DecimalFormat formatter;
    public JProgressBar theProgressBar = new JProgressBar();
    private JDialog theProgressDialog = new JDialog();
    private JCheckBox editorCheckBox = new JCheckBox();
    private TableCellEditor booleanEditor;
    private TableCellRenderer booleanRenderer;
    private TableCellEditor regularEditor;
    private TableCellRenderer regularRenderer;
    private TableCellEditor currentEditor;
    private boolean addedListeners = false;
    private Component editorComponent;
    private int editorRow;
    private int editorColumn;
    private float[] jitterFactor;

    public Source(File theData, String theSeparator, Converter theConverter) throws FileNotFoundException {
        this.rowOffSet = this.options.length;
        this.theFile = theData;
        this.separator = theSeparator;
        this.ranFile = new RandomAccessFile(this.theFile, "r");
        this.formatter = new DecimalFormat();
        DecimalFormatSymbols ds = this.formatter.getDecimalFormatSymbols();
        if (this.decimalPeriod) {
            ds.setDecimalSeparator('.');
        } else {
            ds.setDecimalSeparator(',');
        }
        this.formatter.setDecimalFormatSymbols(ds);
        this.theProgressDialog.add(this.theProgressBar);
        this.theProgressDialog.setTitle("analyzing file ...");
        this.theProgressDialog.setSize(400, 70);
        this.theProgressDialog.setLocationRelativeTo(null);
        this.theProgressBar.setIndeterminate(false);
        this.theProgressBar.setMinimum(0);
        this.theProgressBar.setMaximum((int)theData.length());
        this.theProgressDialog.setVisible(true);
        this.initialise();
        if (this.linePositions.length == 0) {
            JOptionPane.showMessageDialog(null, "The file is empty! Data2FCS will exit now.", "File Error", 0);
            try {
                this.ranFile.close();
            }
            catch (IOException io) {
                // empty catch block
            }
            System.exit(0);
        }
        boolean isNumber = false;
        for (String currValue : this.getSeparatedLine(0)) {
            boolean success = true;
            try {
                float f = Float.parseFloat(currValue);
            }
            catch (NumberFormatException nf) {
                success = false;
            }
            if (!success) continue;
            isNumber = true;
        }
        if (!isNumber) {
            this.hasHeaderLine = true;
            theConverter.setHasHeader();
        }
        this.theProgressBar.setIndeterminate(false);
        int[] count = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 23, 25, 26, 28, 30, 31, 33, 35, 37, 39, 41, 43, 45, 48, 50, 52, 55, 57, 60, 62, 65, 67, 70, 73, 75, 78, 81, 83, 86, 89, 91, 94, 97, 99, 102, 104, 106, 109, 111, 113, 115, 117, 119, 121, 123, 124, 126, 127, 128, 129, 130, 131, 132, 132, 133, 133, 133, 133, 133, 132, 132, 131, 130, 129, 128, 127, 126, 124, 123, 121, 119, 117, 115, 113, 111, 109, 106, 104, 102, 99, 97, 94, 91, 89, 86, 83, 81, 78, 75, 73, 70, 67, 65, 62, 60, 57, 55, 52, 50, 48, 45, 43, 41, 39, 37, 35, 33, 31, 30, 28, 26, 25, 23, 22, 21, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 9, 8, 7, 7, 6, 6, 5, 5, 5, 4, 4, 3, 3, 3, 3, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        float[] factors = new float[]{-30.0f, -29.7f, -29.4f, -29.1f, -28.8f, -28.5f, -28.2f, -27.9f, -27.6f, -27.3f, -27.0f, -26.7f, -26.4f, -26.1f, -25.8f, -25.5f, -25.2f, -24.9f, -24.6f, -24.3f, -24.0f, -23.7f, -23.4f, -23.1f, -22.8f, -22.5f, -22.2f, -21.9f, -21.6f, -21.3f, -21.0f, -20.7f, -20.4f, -20.1f, -19.8f, -19.5f, -19.2f, -18.9f, -18.6f, -18.3f, -18.0f, -17.7f, -17.4f, -17.1f, -16.8f, -16.5f, -16.2f, -15.9f, -15.6f, -15.3f, -15.0f, -14.7f, -14.4f, -14.1f, -13.8f, -13.5f, -13.2f, -12.9f, -12.6f, -12.3f, -12.0f, -11.7f, -11.4f, -11.1f, -10.8f, -10.5f, -10.2f, -9.9f, -9.6f, -9.3f, -9.0f, -8.7f, -8.4f, -8.1f, -7.8f, -7.5f, -7.2f, -6.9f, -6.6f, -6.3f, -6.0f, -5.7f, -5.4f, -5.1f, -4.8f, -4.5f, -4.2f, -3.9f, -3.6f, -3.3f, -3.0f, -2.7f, -2.4f, -2.1f, -1.8f, -1.5f, -1.2f, -0.9f, -0.6f, -0.3f, 0.0f, 0.3f, 0.6f, 0.9f, 1.2f, 1.5f, 1.8f, 2.1f, 2.4f, 2.7f, 3.0f, 3.3f, 3.6f, 3.9f, 4.2f, 4.5f, 4.8f, 5.1f, 5.4f, 5.7f, 6.0f, 6.3f, 6.6f, 6.9f, 7.2f, 7.5f, 7.8f, 8.1f, 8.4f, 8.7f, 9.0f, 9.3f, 9.6f, 9.9f, 10.2f, 10.5f, 10.8f, 11.1f, 11.4f, 11.7f, 12.0f, 12.3f, 12.6f, 12.9f, 13.2f, 13.5f, 13.8f, 14.1f, 14.4f, 14.7f, 15.0f, 15.3f, 15.6f, 15.9f, 16.2f, 16.5f, 16.8f, 17.1f, 17.4f, 17.7f, 18.0f, 18.3f, 18.6f, 18.9f, 19.2f, 19.5f, 19.8f, 20.1f, 20.4f, 20.7f, 21.0f, 21.3f, 21.6f, 21.9f, 22.2f, 22.5f, 22.8f, 23.1f, 23.4f, 23.7f, 24.0f, 24.3f, 24.6f, 24.9f, 25.2f, 25.5f, 25.8f, 26.1f, 26.4f, 26.7f, 27.0f, 27.3f, 27.6f, 27.9f, 28.2f, 28.5f, 28.8f, 29.1f, 29.4f, 29.7f, 30.0f};
        this.jitterFactor = new float[9991];
        int curr = 0;
        for (int i = 0; i < count.length; ++i) {
            for (int j = 0; j < count[i]; ++j) {
                this.jitterFactor[curr] = factors[i];
                ++curr;
            }
        }
        this.analyze(true);
        this.theProgressDialog.setVisible(false);
        this.theProgressDialog.remove(this.theProgressBar);
        this.theProgressDialog.dispose();
    }

    public void setRegulars(TableCellEditor oldEditor, TableCellRenderer oldRenderer, TableCellEditor oldBooleanEditor, TableCellRenderer oldBooleanRenderer) {
        this.regularEditor = oldEditor;
        this.regularRenderer = oldRenderer;
        this.booleanEditor = oldBooleanEditor;
        this.booleanRenderer = oldBooleanRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialise() {
        int threshold;
        int nextUpdate = threshold = this.theProgressBar.getMaximum() / 100;
        try {
            RandomAccessFile randomAccessFile = this.ranFile;
            synchronized (randomAccessFile) {
                this.ranFile.seek(0L);
                ArrayList<Long> positions = new ArrayList<Long>();
                String next = null;
                do {
                    long currPos;
                    if ((currPos = this.ranFile.getFilePointer()) > (long)nextUpdate) {
                        this.theProgressBar.setValue((int)currPos);
                        nextUpdate += threshold;
                    }
                    positions.add(currPos);
                } while ((next = this.ranFile.readLine()) != null);
                this.linePositions = new long[positions.size() - 1];
                for (int i = 0; i < this.linePositions.length; ++i) {
                    this.linePositions[i] = (Long)positions.get(i);
                }
            }
        }
        catch (IOException io) {
            this.linePositions = new long[0];
        }
    }

    private void analyze(boolean recountParameters) {
        this.theProgressDialog.setTitle("screening data ...");
        this.defineHeader();
        this.theProgressBar.setValue(0);
        this.theProgressBar.setMaximum(this.linePositions.length);
        this.theProgressBar.setVisible(true);
        this.defineParameters(recountParameters);
    }

    private void defineHeader() {
        this.header = this.getSeparatedLine(0);
        this.columnCount = this.header.length + 1;
        this.parameterCount = this.header.length;
    }

    private void defineParameters(boolean changeParameterCount) {
        int i;
        if (changeParameterCount) {
            this.theParameters = new Parameter[this.parameterCount];
            for (i = 0; i < this.parameterCount; ++i) {
                Parameter currParam = new Parameter();
                currParam.name = "Param #" + i;
                if (this.hasHeaderLine) {
                    currParam.name = this.header[i];
                }
                this.theParameters[i] = currParam;
            }
        } else {
            for (i = 0; i < this.parameterCount; ++i) {
                this.theParameters[i].reset();
            }
        }
        int start = 0;
        if (this.hasHeaderLine) {
            start = 1;
        }
        for (int i2 = start; i2 < this.linePositions.length; ++i2) {
            int j;
            if (i2 % 200 == 0) {
                this.theProgressBar.setValue(i2);
                this.theProgressBar.paintImmediately(0, 0, this.theProgressBar.getWidth(), this.theProgressBar.getHeight());
            }
            String[] currEvent = this.getSeparatedLine(i2);
            for (j = 0; j < currEvent.length; ++j) {
                float currValue = 0.0f;
                if (currEvent[j].trim().isEmpty()) {
                    this.theParameters[j].hasEmptyValue = true;
                    continue;
                }
                boolean success = true;
                try {
                    currValue = this.formatter.parse(currEvent[j]).floatValue();
                }
                catch (ParseException p) {
                    this.theParameters[j].hasNonNumericalValue = true;
                    success = false;
                }
                if (!success || !(this.theParameters[j].maxValue < currValue)) continue;
                this.theParameters[j].maxValue = currValue;
            }
            for (j = currEvent.length; j < this.parameterCount; ++j) {
                this.theParameters[j].hasEmptyValue = true;
            }
        }
        for (Parameter currParam : this.theParameters) {
            if (currParam.hasEmptyValue && currParam.hasNonNumericalValue) {
                currParam.status = "not numerical, incomplete";
            }
            if (currParam.hasEmptyValue && !currParam.hasNonNumericalValue) {
                currParam.status = "incomplete";
            }
            if (currParam.hasEmptyValue || !currParam.hasNonNumericalValue) continue;
            currParam.status = "not numerical, complete";
        }
        this.theProgressBar.setValue(this.theProgressBar.getMaximum());
        this.theProgressBar.paintImmediately(0, 0, this.theProgressBar.getWidth(), this.theProgressBar.getHeight());
        for (int j = 0; j < this.parameterCount; ++j) {
            this.theParameters[j].maxValueString = String.valueOf(this.theParameters[j].maxValue);
            this.theParameters[j].range = (int)(this.theParameters[j].maxValue + 1.0f);
            this.theParameters[j].rangeString = String.valueOf(this.theParameters[j].range);
        }
    }

    public String getLine(int index) {
        try {
            this.ranFile.seek(this.linePositions[index]);
            return this.ranFile.readLine();
        }
        catch (IOException io) {
            return null;
        }
    }

    public String[] getSeparatedLine(int index) {
        String toSeparate = this.getLine(index);
        if (toSeparate == null) {
            return null;
        }
        return toSeparate.split(Matcher.quoteReplacement(this.separator));
    }

    public void setSeparator(String newSep) {
        this.separator = newSep;
        this.analyze(true);
        for (TableModelListener currList : this.theListeners) {
            currList.tableChanged(null);
        }
    }

    public void setUseDecimalPeriod(boolean usePeriod) {
        this.decimalPeriod = usePeriod;
        DecimalFormatSymbols ds = this.formatter.getDecimalFormatSymbols();
        if (this.decimalPeriod) {
            ds.setDecimalSeparator('.');
        } else {
            ds.setDecimalSeparator(',');
        }
        this.formatter.setDecimalFormatSymbols(ds);
        this.analyze(false);
        for (TableModelListener currList : this.theListeners) {
            currList.tableChanged(null);
        }
    }

    public void setHasHeader(boolean newStatus) {
        if (this.hasHeaderLine != newStatus) {
            this.hasHeaderLine = newStatus;
            String[] header = this.getSeparatedLine(0);
            for (int i = 0; i < this.parameterCount; ++i) {
                this.theParameters[i].name = header[i];
            }
            for (TableModelListener currList : this.theListeners) {
                currList.tableChanged(null);
            }
        }
    }

    @Override
    public int getRowCount() {
        if (this.hasHeaderLine) {
            return this.linePositions.length - 1 + this.rowOffSet;
        }
        return this.linePositions.length + this.rowOffSet;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Event#";
        }
        if (this.hasHeaderLine) {
            return this.header[columnIndex - 1];
        }
        return "Param #" + (columnIndex - 1);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return false;
        }
        if (rowIndex == 5) {
            return false;
        }
        if (rowIndex == 6) {
            return true;
        }
        return rowIndex < this.rowOffSet - 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.rowOffSet) {
            if (columnIndex == 0) {
                return this.options[rowIndex];
            }
            if (rowIndex == 0) {
                return this.theParameters[columnIndex - 1].name;
            }
            if (rowIndex == 1) {
                return this.theParameters[columnIndex - 1].displayLog;
            }
            if (rowIndex == 2) {
                return this.theParameters[columnIndex - 1].isCategory;
            }
            if (rowIndex == 3) {
                return this.theParameters[columnIndex - 1].useJitter;
            }
            if (rowIndex == 4) {
                return this.theParameters[columnIndex - 1].rangeString;
            }
            if (rowIndex == 5) {
                return this.theParameters[columnIndex - 1].maxValueString;
            }
            if (rowIndex == 6) {
                return this.theParameters[columnIndex - 1].skip;
            }
            if (rowIndex == 7) {
                return this.theParameters[columnIndex - 1].status;
            }
        }
        if (columnIndex == 0) {
            return String.valueOf(rowIndex - this.rowOffSet);
        }
        String[] values = this.hasHeaderLine ? this.getSeparatedLine(rowIndex + 1 - this.rowOffSet) : this.getSeparatedLine(rowIndex - this.rowOffSet);
        if (values.length > columnIndex - 1) {
            if (values[columnIndex - 1].trim().isEmpty()) {
                return "#missing#";
            }
            return values[columnIndex - 1];
        }
        return "#missing#";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue == null) {
            return;
        }
        if (rowIndex == 1 || rowIndex == 2 || rowIndex == 3 || rowIndex == 6) {
            if (aValue instanceof Boolean) {
                if (rowIndex == 1) {
                    this.theParameters[columnIndex - 1].displayLog = (Boolean)aValue;
                }
                if (rowIndex == 2) {
                    this.theParameters[columnIndex - 1].isCategory = (Boolean)aValue;
                }
                if (rowIndex == 3) {
                    this.theParameters[columnIndex - 1].useJitter = (Boolean)aValue;
                }
                if (rowIndex == 6) {
                    this.theParameters[columnIndex - 1].skip = (Boolean)aValue;
                }
            }
        } else {
            String value = aValue.toString();
            if (rowIndex == 0) {
                this.theParameters[columnIndex - 1].name = value;
            }
            if (rowIndex == 4) {
                int x = 0;
                boolean success = true;
                try {
                    x = Integer.parseInt(value);
                }
                catch (NumberFormatException nf) {
                    success = false;
                }
                if (success) {
                    if ((float)x <= this.theParameters[columnIndex - 1].maxValue) {
                        x = (int)(this.theParameters[columnIndex - 1].maxValue + 1.0f);
                    }
                    this.theParameters[columnIndex - 1].range = x;
                    this.theParameters[columnIndex - 1].rangeString = String.valueOf(x);
                }
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.theListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.theListeners.remove(l);
    }

    public void dispose() {
        this.theProgressDialog.dispose();
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentEditor.getCellEditorValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (!this.addedListeners) {
            JComponent ch;
            Component c = this.booleanEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (c instanceof JCheckBox) {
                ch = (JCheckBox)c;
                ((AbstractButton)ch).addActionListener(this);
            }
            if ((c = this.regularEditor.getTableCellEditorComponent(table, value, isSelected, row, column)) instanceof JTextField) {
                ch = (JTextField)c;
                ch.addFocusListener(this);
            }
            this.addedListeners = true;
        }
        if (row == 1 || row == 2 || row == 3 || row == 6) {
            this.currentEditor = this.booleanEditor;
            this.editorComponent = this.booleanEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
            this.editorRow = row;
            this.editorColumn = column;
            return this.editorComponent;
        }
        this.currentEditor = this.regularEditor;
        this.editorComponent = this.regularEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        this.editorRow = row;
        this.editorColumn = column;
        return this.editorComponent;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if ((row == 1 || row == 2 || row == 3 || row == 6) && column != 0) {
            return this.booleanRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        return this.regularRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() instanceof JTextField) {
            this.setValueAt(((JTextField)e.getSource()).getText(), this.editorRow, this.editorColumn);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            this.setValueAt(((JCheckBox)e.getSource()).isSelected(), this.editorRow, this.editorColumn);
        }
    }

    public void convert(File selectedFile) throws IOException {
        if (!selectedFile.exists()) {
            selectedFile.createNewFile();
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(selectedFile));
        boolean hasCat = false;
        for (Parameter currPar : this.theParameters) {
            if (!currPar.isCategory || currPar.skip) continue;
            hasCat = true;
            currPar.catValues = new HashSet();
        }
        int offset = 0;
        if (hasCat) {
            offset = this.linePositions.length;
            this.theProgressBar.setMaximum(this.linePositions.length * 2);
            this.theProgressBar.setValue(0);
            int lineStart = 0;
            if (this.hasHeaderLine) {
                lineStart = 1;
            }
            for (int i = lineStart; i < this.linePositions.length; ++i) {
                if (i % 200 == 0) {
                    this.theProgressBar.setValue(i);
                    this.theProgressBar.paintImmediately(0, 0, this.theProgressBar.getWidth(), this.theProgressBar.getHeight());
                }
                String[] values = this.getSeparatedLine(i);
                for (int j = 0; j < values.length; ++j) {
                    if (!this.theParameters[j].isCategory || this.theParameters[j].skip || values[j].trim().isEmpty()) continue;
                    this.theParameters[j].catValues.add(values[j].trim());
                }
            }
            for (int j = 0; j < this.parameterCount; ++j) {
                if (!this.theParameters[j].isCategory || this.theParameters[j].skip) continue;
                Object[] theValues = this.theParameters[j].catValues.toArray(new String[0]);
                Arrays.sort(theValues);
                this.theParameters[j].orderedCatValues = new ArrayList();
                for (int i = 0; i < theValues.length; ++i) {
                    this.theParameters[j].orderedCatValues.add(theValues[i]);
                }
                this.theParameters[j].catValues = null;
            }
        } else {
            this.theProgressBar.setMaximum(this.linePositions.length);
            this.theProgressBar.setValue(0);
        }
        int paramsToExport = 0;
        for (Parameter currParam : this.theParameters) {
            if (currParam.skip) continue;
            ++paramsToExport;
        }
        int totalDataSize = this.linePositions.length * 4 * paramsToExport;
        if (this.hasHeaderLine) {
            totalDataSize = (this.linePositions.length - 1) * 4 * paramsToExport;
        }
        StringBuilder text = new StringBuilder();
        text.append("/$COM/");
        text.append("This dataset was created by Data2FCS from a comma (or other)-separated-values data file.");
        text.append("/$SRC/");
        text.append(this.theFile.getName());
        text.append("/$FIL/");
        text.append(selectedFile.getName());
        text.append("/$DATE/");
        Calendar c = Calendar.getInstance();
        int day = c.get(5);
        int year = c.get(1);
        String month = c.getDisplayName(2, 1, Locale.ENGLISH);
        String dayS = String.valueOf(day);
        if (dayS.length() == 1) {
            text.append("0");
        }
        text.append(dayS);
        text.append("-");
        text.append(month);
        text.append("-");
        text.append(year);
        text.append("/$CYT/Data2FCS");
        text.append("/$CYTSN/1.0");
        text.append("/$BYTEORD/4,3,2,1");
        text.append("/$DATATYPE/F");
        text.append("/$MODE/L");
        text.append("/$TOT/");
        if (this.hasHeaderLine) {
            text.append(this.linePositions.length - 1);
        } else {
            text.append(this.linePositions.length);
        }
        text.append("/$PAR/");
        text.append(paramsToExport);
        int currParam = 0;
        for (int i = 0; i < this.parameterCount; ++i) {
            if (this.theParameters[i].skip) continue;
            text.append("/$P");
            text.append(++currParam);
            text.append("B/32");
            text.append("/$P");
            text.append(currParam);
            text.append("E/0,0");
            text.append("/$P");
            text.append(currParam);
            text.append("N/Param #");
            text.append(currParam);
            if (this.theParameters[i].isCategory) {
                text.append("/$P");
                text.append(currParam);
                text.append("R/");
                text.append((this.theParameters[i].orderedCatValues.size() + 1) * 100);
            } else {
                text.append("/$P");
                text.append(currParam);
                text.append("R/");
                text.append(this.theParameters[i].range);
            }
            text.append("/$P");
            text.append(currParam);
            text.append("S/");
            text.append(this.theParameters[i].name.trim().replace("/", "//"));
            text.append("/$P");
            text.append(currParam);
            text.append("D/");
            if (this.theParameters[i].displayLog) {
                text.append("Logarithmic,");
                int range = this.theParameters[i].range;
                int logs = (int)Math.log10(range);
                text.append(++logs);
                text.append(",1");
            } else {
                text.append("Linear,0,");
                text.append(this.theParameters[i].range);
            }
            text.append("/P");
            text.append(currParam);
            text.append("DISPLAY/");
            if (this.theParameters[i].displayLog) {
                text.append("LOG");
            } else {
                text.append("LIN");
            }
            if (!this.theParameters[i].isCategory) continue;
            text.append("/P");
            text.append(currParam);
            text.append("Data2FCS_CATEGORIES/");
            for (int k = 0; k < this.theParameters[i].orderedCatValues.size(); ++k) {
                text.append((k + 1) * 100);
                text.append("=");
                text.append(((String)this.theParameters[i].orderedCatValues.get(k)).trim().replace("/", "//"));
                if (k == this.theParameters[i].orderedCatValues.size() - 1) continue;
                text.append("\n");
            }
        }
        text.append("/$BEGINANALYSIS/0/$ENDANALYSIS/0");
        text.append("/$BEGINSTEXT/0/$ENDSTEXT/0");
        text.append("/$NEXTDATA/0");
        String textTemp = text.toString();
        Charset utf8 = Charset.forName("utf-8");
        byte[] textBytes = textTemp.getBytes(utf8);
        int currLength = textBytes.length + 22 + 60;
        text.append("/$BEGINDATA/");
        int dataBegin = currLength += 20;
        text.append(currLength);
        text.append("/$ENDDATA/");
        text.append(currLength + totalDataSize);
        int dataEnd = currLength + totalDataSize;
        text.append("/");
        String beginning = "FCS3.1    ";
        String text_start = "      60";
        String data_start = "        ";
        String data_end = "        ";
        String analysis_start = "       0";
        String analysis_end = "       0";
        String header_padding = "  ";
        text.insert(0, header_padding);
        text.insert(0, analysis_end);
        text.insert(0, analysis_start);
        if (dataEnd < 100000000) {
            int k;
            String temp = String.valueOf(dataEnd);
            text.insert(0, temp);
            int l = 8 - temp.length();
            for (k = 0; k < l; ++k) {
                text.insert(0, " ");
            }
            temp = String.valueOf(dataBegin);
            text.insert(0, temp);
            l = 8 - temp.length();
            for (k = 0; k < l; ++k) {
                text.insert(0, " ");
            }
        } else {
            text.insert(0, data_end);
            text.insert(0, data_start);
        }
        int textEnd = text.length() + 8 + text_start.length() + beginning.length() - 1;
        String tempEnd = String.valueOf(textEnd);
        text.insert(0, tempEnd);
        int l = 8 - tempEnd.length();
        for (int k = 0; k < l; ++k) {
            text.insert(0, " ");
        }
        text.insert(0, text_start);
        text.insert(0, beginning);
        textTemp = text.toString();
        textBytes = textTemp.getBytes(utf8);
        out.write(textBytes);
        for (int i = textBytes.length; i < dataBegin; ++i) {
            out.write(32);
        }
        int lineStart = 0;
        if (this.hasHeaderLine) {
            lineStart = 1;
        }
        for (int i = lineStart; i < this.linePositions.length; ++i) {
            if (i % 200 == 0) {
                this.theProgressBar.setValue(i + offset);
                this.theProgressBar.paintImmediately(0, 0, this.theProgressBar.getWidth(), this.theProgressBar.getHeight());
            }
            String[] values = this.getSeparatedLine(i);
            for (int j = 0; j < this.parameterCount; ++j) {
                if (this.theParameters[j].skip) continue;
                float currValue = 0.0f;
                if (j < values.length && !values[j].isEmpty()) {
                    if (this.theParameters[j].isCategory) {
                        currValue = 100 * (this.theParameters[j].orderedCatValues.indexOf(values[j]) + 1);
                        if (this.theParameters[j].useJitter) {
                            int jitterRandom = (int)(Math.random() * 9991.0);
                            if (jitterRandom > 9990) {
                                jitterRandom = 4995;
                            }
                            currValue += this.jitterFactor[jitterRandom];
                        }
                    } else {
                        try {
                            currValue = Float.parseFloat(values[j]);
                        }
                        catch (NumberFormatException nf) {
                            currValue = 0.0f;
                        }
                    }
                }
                int toWrite = Float.floatToIntBits(currValue);
                int four = toWrite >>> 24 & 0xFF;
                int three = toWrite >>> 16 & 0xFF;
                int two = toWrite >>> 8 & 0xFF;
                int one = toWrite >>> 0 & 0xFF;
                out.write(four);
                out.write(three);
                out.write(two);
                out.write(one);
            }
        }
        out.close();
        this.theProgressBar.setValue(this.linePositions.length + offset);
    }

    private class Parameter {
        private String name = "";
        private boolean displayLog = false;
        private boolean isCategory = false;
        private boolean useJitter = false;
        private boolean skip = false;
        private static final String COMP = "complete";
        private static final String INCOMP = "incomplete";
        private static final String NONNUM_COMP = "not numerical, complete";
        private static final String NONNUM_INCOMP = "not numerical, incomplete";
        private boolean hasEmptyValue = false;
        private boolean hasNonNumericalValue = false;
        private String status = "complete";
        private String maxValueString = "";
        private float maxValue;
        private String rangeString = "";
        private int range;
        private HashSet<String> catValues;
        private ArrayList<String> orderedCatValues;

        private Parameter() {
        }

        private void reset() {
            this.maxValueString = "";
            this.maxValue = 0.0f;
            this.rangeString = "";
            this.range = 0;
            this.status = COMP;
            this.hasEmptyValue = false;
            this.hasNonNumericalValue = false;
        }
    }
}

