/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.sf.profiler4j.console.AboutDialog;
import net.sf.profiler4j.console.AppEvent;
import net.sf.profiler4j.console.AppEventListener;
import net.sf.profiler4j.console.AppEventType;
import net.sf.profiler4j.console.CallGraphPanel;
import net.sf.profiler4j.console.ClassListPanel;
import net.sf.profiler4j.console.Console;
import net.sf.profiler4j.console.MemoryPanel;
import net.sf.profiler4j.console.MethodRenderer;
import net.sf.profiler4j.console.OptionsDialog;
import net.sf.profiler4j.console.StatusBarPanel;
import net.sf.profiler4j.console.ThreadPanel;
import net.sf.profiler4j.console.TipDialog;
import net.sf.profiler4j.console.TreeBuilder;
import net.sf.profiler4j.console.client.ClientException;
import net.sf.profiler4j.console.client.Snapshot;

public class MainFrame
extends JFrame
implements AppEventListener {
    private Console app;
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JButton connectButton = null;
    private JButton snapshotButton = null;
    private JButton resetButton = null;
    private JMenuBar jJMenuBar = null;
    private JMenu fileMenu = null;
    private JMenuItem openMenuItem = null;
    private FileFilter fileFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.isDirectory() || f.toString().endsWith("-profiler4j.ser");
        }

        public String getDescription() {
            return "Profiler4j Snapshots (*-profiler4j.ser)";
        }
    };
    private String lastDir = System.getProperty("user.dir");
    private JTree tree = null;
    private JScrollPane treeScrollPane = null;
    private JScrollPane detailScrollPane = null;
    private JTextArea detailTextArea = null;
    private JToolBar remoteCommandPanel = null;
    private JMenu helpMenu = null;
    private JMenuItem aboutMenuItem = null;
    private JMenuItem exitMenuItem = null;
    private JTabbedPane tabbedPane = null;
    private JPanel callTreePanel = null;
    private JPanel callGraphTabPanel = null;
    private CallGraphPanel callGraphPanel = null;
    private JScrollPane jScrollPane = null;
    private JPanel jPanel1 = null;
    private JSlider ncutSlider = null;
    private JButton runGcButton = null;
    private MemoryPanel memoryMonitorPanel = null;
    private JButton applyRulesButton = null;
    private JButton editProjectButton = null;
    private ClassListPanel classListPanel = null;
    private JButton helpButton = null;
    private JButton openProjectButton = null;
    private JButton newProjectButton = null;
    private JButton saveProjectButton = null;
    private JButton saveProjectAsButton = null;
    private ThreadPanel threadPanel = null;
    private StatusBarPanel statusBarPanel = null;
    private JMenuItem showTipsMenuItem = null;
    private JMenuItem optionsMenuItem = null;

    public MainFrame(Console app) {
        this.app = app;
        this.initialize();
        app.addListener(this);
    }

    private void initialize() {
        this.setSize(629, 342);
        this.setPreferredSize(new Dimension(800, 600));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/net/sf/profiler4j/console/images/pill.png")));
        this.setJMenuBar(this.getJJMenuBar());
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Profiler4j Console (SC integrated)");
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                if (MainFrame.this.app.getPrefs().isShowTip()) {
                    TipDialog td = new TipDialog(MainFrame.this);
                    td.showTip(MainFrame.this.app);
                }
            }

            public void windowClosing(WindowEvent e) {
                if (MainFrame.this.app.getClient().isConnected()) {
                    MainFrame.this.app.disconnect();
                }
            }
        });
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.jContentPane.add((Component)this.getTabbedPane(), "Center");
            this.jContentPane.add((Component)this.getRemoteCommandPanel(), "North");
            this.jContentPane.add((Component)this.getStatusBarPanel(), "South");
        }
        return this.jContentPane;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getHelpMenu());
        }
        return this.jJMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getOpenMenuItem());
            this.fileMenu.add(this.getOptionsMenuItem());
            this.fileMenu.add(this.getExitMenuItem());
        }
        return this.fileMenu;
    }

    private JMenuItem getOpenMenuItem() {
        if (this.openMenuItem == null) {
            this.openMenuItem = new JMenuItem();
            this.openMenuItem.setText("Open dump file...");
            this.openMenuItem.setEnabled(false);
            this.openMenuItem.setVisible(false);
            this.openMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.open();
                }
            });
        }
        return this.openMenuItem;
    }

    private JTree getTree() {
        if (this.tree == null) {
            this.tree = new JTree();
            this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
            this.tree.setPreferredSize(null);
            this.tree.setRowHeight(18);
            this.tree.setDoubleBuffered(true);
            this.tree.setRootVisible(true);
            this.tree.setToggleClickCount(2);
            this.tree.setEnabled(true);
            this.tree.setEditable(false);
            this.tree.setShowsRootHandles(true);
            this.tree.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    TreePath path = MainFrame.this.tree.getPathForLocation(e.getX(), e.getY());
                    MainFrame.this.tree.getSelectionModel().addSelectionPath(path);
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)MainFrame.this.tree.getLastSelectedPathComponent();
                    if (node == null) {
                        return;
                    }
                    if (node.getUserObject() instanceof TreeBuilder.NodeInfo) {
                        TreeBuilder.NodeInfo info = (TreeBuilder.NodeInfo)node.getUserObject();
                        MainFrame.this.viewDetail(info);
                    }
                }
            });
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                    if (node != null) {
                        TreeBuilder.NodeInfo info = (TreeBuilder.NodeInfo)node.getUserObject();
                        MainFrame.this.viewDetail(info);
                    }
                }
            });
        }
        return this.tree;
    }

    private JScrollPane getTreeScrollPane() {
        if (this.treeScrollPane == null) {
            this.treeScrollPane = new JScrollPane();
            this.treeScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 4, 8), BorderFactory.createLineBorder(Color.gray, 1)));
            this.treeScrollPane.setPreferredSize(new Dimension(200, 200));
            this.treeScrollPane.setVisible(true);
            this.treeScrollPane.setViewportView(this.getTree());
        }
        return this.treeScrollPane;
    }

    private JScrollPane getDetailScrollPane() {
        if (this.detailScrollPane == null) {
            this.detailScrollPane = new JScrollPane();
            this.detailScrollPane.setPreferredSize(null);
            this.detailScrollPane.setViewportView(this.getDetailTextArea());
            this.detailScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 8, 8, 8), BorderFactory.createLineBorder(Color.gray, 1)));
            this.detailScrollPane.setVisible(true);
        }
        return this.detailScrollPane;
    }

    private JTextArea getDetailTextArea() {
        if (this.detailTextArea == null) {
            this.detailTextArea = new JTextArea();
            this.detailTextArea.setEditable(false);
            this.detailTextArea.setMargin(new Insets(4, 4, 4, 4));
            this.detailTextArea.setRows(5);
            this.detailTextArea.setPreferredSize(null);
            this.detailTextArea.setEnabled(true);
            this.detailTextArea.setToolTipText("Details about the method selected above");
            this.detailTextArea.setFont(new Font("Monospaced", 0, 12));
        }
        return this.detailTextArea;
    }

    private JButton getConnectButton() {
        if (this.connectButton == null) {
            this.connectButton = new JButton();
            this.connectButton.setPreferredSize(new Dimension(32, 32));
            this.connectButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/connect.png")));
            this.connectButton.setFocusPainted(false);
            this.connectButton.setToolTipText("Connect to remote JVM");
            this.connectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (MainFrame.this.app.getClient().isConnected()) {
                        MainFrame.this.app.disconnect();
                    } else {
                        MainFrame.this.app.connect();
                    }
                }
            });
        }
        return this.connectButton;
    }

    private JButton getSnapshotButton() {
        if (this.snapshotButton == null) {
            this.snapshotButton = new JButton();
            this.snapshotButton.setText("");
            this.snapshotButton.setPreferredSize(new Dimension(32, 32));
            this.snapshotButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/camera.gif")));
            this.snapshotButton.setToolTipText("Take snaphot");
            this.snapshotButton.setFocusPainted(false);
            this.snapshotButton.setEnabled(true);
            this.snapshotButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.app.takeSnapshot();
                }
            });
        }
        return this.snapshotButton;
    }

    private JButton getResetButton() {
        if (this.resetButton == null) {
            this.resetButton = new JButton();
            this.resetButton.setText("");
            this.resetButton.setPreferredSize(new Dimension(32, 32));
            this.resetButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/timeline_marker.png")));
            this.resetButton.setToolTipText("Reset counters");
            this.resetButton.setFocusPainted(false);
            this.resetButton.setEnabled(true);
            this.resetButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MainFrame.this.app.getClient().reset();
                    }
                    catch (ClientException e1) {
                        MainFrame.this.app.error("Could not reset stats", e1);
                    }
                }
            });
        }
        return this.resetButton;
    }

    private JToolBar getRemoteCommandPanel() {
        if (this.remoteCommandPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.remoteCommandPanel = new JToolBar();
            this.remoteCommandPanel.setFloatable(false);
            this.remoteCommandPanel.setLayout(flowLayout);
            this.remoteCommandPanel.add((Component)this.getEditProjectButton(), null);
            this.remoteCommandPanel.add(this.getApplyRulesButton());
            this.remoteCommandPanel.add((Component)this.getSnapshotButton(), null);
            this.remoteCommandPanel.add((Component)this.getResetButton(), null);
            this.remoteCommandPanel.add((Component)this.getRunGcButton(), null);
        }
        return this.remoteCommandPanel;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.add(this.getShowTipsMenuItem());
            this.helpMenu.add(this.getAboutMenuItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText("About...");
            this.aboutMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AboutDialog d = new AboutDialog(MainFrame.this);
                    d.setVisible(true);
                }
            });
        }
        return this.aboutMenuItem;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText("Exit");
            this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8, false));
            this.exitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.app.exit();
                }
            });
        }
        return this.exitMenuItem;
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.setPreferredSize(new Dimension(400, 400));
            this.tabbedPane.setFont(new Font("Arial", 0, 14));
            this.tabbedPane.addTab(" Call Graph ", null, this.getCallGraphTabPanel(), null);
            this.tabbedPane.addTab(" Call Tree ", null, this.getCallTreePanel(), null);
            this.tabbedPane.addTab(" Memory ", null, this.getMemoryMonitorPanel(), null);
            this.tabbedPane.addTab(" Class List ", null, this.getClassListPanel(), null);
            this.tabbedPane.addTab(" Threads ", null, this.getThreadPanel(), null);
            this.tabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (MainFrame.this.app.getClient().isConnected() && MainFrame.this.tabbedPane.getSelectedIndex() == 3) {
                        MainFrame.this.classListPanel.refreshClassList();
                    }
                }
            });
        }
        return this.tabbedPane;
    }

    private JPanel getCallTreePanel() {
        if (this.callTreePanel == null) {
            this.callTreePanel = new JPanel();
            this.callTreePanel.setLayout(new BorderLayout());
            this.callTreePanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.callTreePanel.setEnabled(true);
            this.callTreePanel.setVisible(true);
            this.callTreePanel.add((Component)this.getTreeScrollPane(), "Center");
            this.callTreePanel.add((Component)this.getDetailScrollPane(), "South");
        }
        return this.callTreePanel;
    }

    private JPanel getCallGraphTabPanel() {
        if (this.callGraphTabPanel == null) {
            this.callGraphTabPanel = new JPanel();
            this.callGraphTabPanel.setLayout(new BorderLayout());
            this.callGraphTabPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.callGraphTabPanel.add((Component)this.getJScrollPane(), "Center");
            this.callGraphTabPanel.add((Component)this.getJPanel1(), "North");
        }
        return this.callGraphTabPanel;
    }

    private CallGraphPanel getCallGraphPanel() {
        if (this.callGraphPanel == null) {
            this.callGraphPanel = new CallGraphPanel();
            this.callGraphPanel.setBorder(null);
        }
        return this.callGraphPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getCallGraphPanel());
        }
        return this.jScrollPane;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            flowLayout1.setAlignment(0);
            this.jPanel1 = new JPanel();
            this.jPanel1.setBorder(null);
            this.jPanel1.setLayout(flowLayout1);
            this.jPanel1.add((Component)this.getNcutSlider(), null);
        }
        return this.jPanel1;
    }

    private JSlider getNcutSlider() {
        if (this.ncutSlider == null) {
            this.ncutSlider = new JSlider();
            this.ncutSlider.setMaximum(100);
            this.ncutSlider.setMinorTickSpacing(5);
            this.ncutSlider.setPaintTicks(true);
            this.ncutSlider.setPaintLabels(true);
            this.ncutSlider.setValue(20);
            this.ncutSlider.setToolTipText("Number of methods to show");
            this.ncutSlider.setSnapToTicks(true);
            this.ncutSlider.setMajorTickSpacing(20);
            this.ncutSlider.setPreferredSize(new Dimension(200, 42));
            this.ncutSlider.setMinimum(10);
            this.ncutSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    MainFrame.this.callGraphPanel.applyNCut(MainFrame.this.ncutSlider.getValue());
                    MainFrame.this.callGraphPanel.repaint();
                }
            });
        }
        return this.ncutSlider;
    }

    private JButton getRunGcButton() {
        if (this.runGcButton == null) {
            this.runGcButton = new JButton();
            this.runGcButton.setEnabled(true);
            this.runGcButton.setToolTipText("Run GC");
            this.runGcButton.setFocusPainted(false);
            this.runGcButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/bin_closed.png")));
            this.runGcButton.setHorizontalTextPosition(0);
            this.runGcButton.setPreferredSize(new Dimension(32, 32));
            this.runGcButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MainFrame.this.app.getClient().runGc();
                    }
                    catch (ClientException e1) {
                        MainFrame.this.app.error("Could not run remote CG", e1);
                    }
                }
            });
        }
        return this.runGcButton;
    }

    private MemoryPanel getMemoryMonitorPanel() {
        if (this.memoryMonitorPanel == null) {
            this.memoryMonitorPanel = new MemoryPanel(this.app);
        }
        return this.memoryMonitorPanel;
    }

    private void open() {
        String dir = this.lastDir;
        JFileChooser fc = new JFileChooser(dir);
        fc.setFileFilter(this.fileFilter);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.lastDir = file.getParent();
            try {
                this.viewSnapshot(Snapshot.load(file));
            }
            catch (Exception e) {
                this.app.error("Could not open snapshot", e);
            }
        }
    }

    private void viewDetail(TreeBuilder.NodeInfo info) {
        StringBuilder out = new StringBuilder();
        if (info != null) {
            Snapshot.Method g = info.getMethodInfo();
            out.append(String.format("Method: %s\n", g.getName()));
            out.append(String.format("Hits  : %d\n", g.getHits()));
            out.append(String.format("Total : %.1fms\n", g.getNetTime()));
            out.append(String.format("Local : %.1fms\n", g.getSelfTime()));
        }
        this.detailTextArea.setText(out.toString());
        this.detailTextArea.setCaretPosition(0);
    }

    public boolean receiveEvent(AppEvent ev) {
        if (ev.getType() == AppEventType.DISCONNECTED) {
            this.callGraphPanel.setSnapshot(null);
            this.snapshotButton.setEnabled(false);
            this.resetButton.setEnabled(false);
            this.runGcButton.setEnabled(false);
            this.applyRulesButton.setEnabled(true);
            DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
            root.removeAllChildren();
            model.reload();
        } else if (ev.getType() == AppEventType.SNAPSHOT) {
            Snapshot s = (Snapshot)ev.getArg();
            this.viewSnapshot(s);
        }
        return false;
    }

    private void viewSnapshot(Snapshot sn) {
        TreeBuilder builder = new TreeBuilder(sn);
        DefaultMutableTreeNode root = builder.buildTree();
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.tree.setModel(model);
        this.tree.setShowsRootHandles(false);
        this.tree.setCellRenderer(new MethodRenderer());
        this.callGraphPanel.setSnapshot(sn);
        this.callGraphPanel.applyNCut(this.ncutSlider.getValue());
    }

    private JButton getApplyRulesButton() {
        if (this.applyRulesButton == null) {
            this.applyRulesButton = new JButton();
            this.applyRulesButton.setEnabled(true);
            this.applyRulesButton.setToolTipText("Apply current profiling rules");
            this.applyRulesButton.setPreferredSize(new Dimension(32, 32));
            this.applyRulesButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/tick.png")));
            this.applyRulesButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.app.applyRules();
                }
            });
        }
        return this.applyRulesButton;
    }

    private JButton getEditProjectButton() {
        if (this.editProjectButton == null) {
            this.editProjectButton = new JButton();
            this.editProjectButton.setEnabled(true);
            this.editProjectButton.setToolTipText("Edit profiling project details");
            this.editProjectButton.setFocusPainted(false);
            this.editProjectButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/pencil.png")));
            this.editProjectButton.setText("");
            this.editProjectButton.setPreferredSize(new Dimension(32, 32));
            this.editProjectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.app.editProject();
                }
            });
        }
        return this.editProjectButton;
    }

    private ClassListPanel getClassListPanel() {
        if (this.classListPanel == null) {
            this.classListPanel = new ClassListPanel(this.app);
            this.classListPanel.setToolTipText("Type the begining of a class name here");
        }
        return this.classListPanel;
    }

    private JButton getJButton2() {
        if (this.helpButton == null) {
            this.helpButton = new JButton();
            this.helpButton.setEnabled(true);
            this.helpButton.setToolTipText("Show Help");
            this.helpButton.setFocusPainted(false);
            this.helpButton.setHorizontalTextPosition(0);
            this.helpButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/help.png")));
            this.helpButton.setPreferredSize(new Dimension(32, 32));
            this.helpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(MainFrame.this, "Help not yet written");
                }
            });
        }
        return this.helpButton;
    }

    private JButton getOpenProjectButton() {
        if (this.openProjectButton == null) {
            this.openProjectButton = new JButton();
            this.openProjectButton.setEnabled(true);
            this.openProjectButton.setToolTipText("Open profiling project");
            this.openProjectButton.setFocusPainted(false);
            this.openProjectButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/fldr_obj.gif")));
            this.openProjectButton.setText("");
            this.openProjectButton.setPreferredSize(new Dimension(32, 32));
            this.openProjectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.app.openProject();
                }
            });
        }
        return this.openProjectButton;
    }

    private JButton getNewProjectButton() {
        if (this.newProjectButton == null) {
            this.newProjectButton = new JButton();
            this.newProjectButton.setEnabled(true);
            this.newProjectButton.setToolTipText("Create new profiling project");
            this.newProjectButton.setFocusPainted(false);
            this.newProjectButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/newfile_wiz.gif")));
            this.newProjectButton.setText("");
            this.newProjectButton.setPreferredSize(new Dimension(32, 32));
            this.newProjectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.app.newProject();
                }
            });
        }
        return this.newProjectButton;
    }

    private JButton getSaveProjectButton() {
        if (this.saveProjectButton == null) {
            this.saveProjectButton = new JButton();
            this.saveProjectButton.setEnabled(true);
            this.saveProjectButton.setToolTipText("Save profiling project");
            this.saveProjectButton.setFocusPainted(false);
            this.saveProjectButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/save_edit.gif")));
            this.saveProjectButton.setText("");
            this.saveProjectButton.setPreferredSize(new Dimension(32, 32));
            this.saveProjectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.app.saveProject(false);
                }
            });
        }
        return this.saveProjectButton;
    }

    private JButton getSaveProjectAsButton() {
        if (this.saveProjectAsButton == null) {
            this.saveProjectAsButton = new JButton();
            this.saveProjectAsButton.setEnabled(true);
            this.saveProjectAsButton.setToolTipText("Save profiling project as");
            this.saveProjectAsButton.setFocusPainted(false);
            this.saveProjectAsButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/saveas_edit.gif")));
            this.saveProjectAsButton.setText("");
            this.saveProjectAsButton.setPreferredSize(new Dimension(32, 32));
            this.saveProjectAsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.app.saveProject(true);
                }
            });
        }
        return this.saveProjectAsButton;
    }

    private ThreadPanel getThreadPanel() {
        if (this.threadPanel == null) {
            this.threadPanel = new ThreadPanel(this.app);
        }
        return this.threadPanel;
    }

    public StatusBarPanel getStatusBarPanel() {
        if (this.statusBarPanel == null) {
            this.statusBarPanel = new StatusBarPanel();
            this.statusBarPanel.setMessage("");
        }
        return this.statusBarPanel;
    }

    private JMenuItem getShowTipsMenuItem() {
        if (this.showTipsMenuItem == null) {
            this.showTipsMenuItem = new JMenuItem();
            this.showTipsMenuItem.setText("Show tips...");
            this.showTipsMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TipDialog d = new TipDialog(MainFrame.this);
                    d.showTip(MainFrame.this.app);
                }
            });
        }
        return this.showTipsMenuItem;
    }

    private JMenuItem getOptionsMenuItem() {
        if (this.optionsMenuItem == null) {
            this.optionsMenuItem = new JMenuItem();
            this.optionsMenuItem.setEnabled(false);
            this.optionsMenuItem.setText("Options...");
            this.optionsMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OptionsDialog d = new OptionsDialog(MainFrame.this);
                    d.pack();
                    d.setLocationRelativeTo(null);
                    d.setVisible(true);
                }
            });
        }
        return this.optionsMenuItem;
    }
}

