/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.service;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.events.Event4;
import com.db4o.events.EventArgs;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistry;
import com.db4o.events.EventRegistryFactory;
import com.db4o.events.ObjectEventArgs;
import com.db4o.query.Query;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.InternalOwl;
import org.rssowl.core.internal.persist.BookMark;
import org.rssowl.core.internal.persist.Description;
import org.rssowl.core.internal.persist.Feed;
import org.rssowl.core.internal.persist.News;
import org.rssowl.core.internal.persist.NewsBin;
import org.rssowl.core.internal.persist.service.DB4OIDGenerator;
import org.rssowl.core.internal.persist.service.DBHelper;
import org.rssowl.core.internal.persist.service.DBManager;
import org.rssowl.core.internal.persist.service.DatabaseEvent;
import org.rssowl.core.internal.persist.service.DatabaseListener;
import org.rssowl.core.internal.persist.service.EventsMap;
import org.rssowl.core.persist.IAttachment;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.ICategory;
import org.rssowl.core.persist.IConditionalGet;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.persist.IPreference;
import org.rssowl.core.persist.ISearch;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.dao.IConditionalGetDAO;
import org.rssowl.core.persist.dao.INewsCounterDAO;
import org.rssowl.core.persist.event.AttachmentEvent;
import org.rssowl.core.persist.event.BookMarkEvent;
import org.rssowl.core.persist.event.CategoryEvent;
import org.rssowl.core.persist.event.FeedEvent;
import org.rssowl.core.persist.event.FolderEvent;
import org.rssowl.core.persist.event.LabelEvent;
import org.rssowl.core.persist.event.ModelEvent;
import org.rssowl.core.persist.event.NewsBinEvent;
import org.rssowl.core.persist.event.NewsEvent;
import org.rssowl.core.persist.event.PersonEvent;
import org.rssowl.core.persist.event.PreferenceEvent;
import org.rssowl.core.persist.event.SearchConditionEvent;
import org.rssowl.core.persist.event.SearchEvent;
import org.rssowl.core.persist.event.SearchFilterEvent;
import org.rssowl.core.persist.event.SearchMarkEvent;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.persist.service.IDGenerator;

public class EventManager
implements DatabaseListener {
    private final ThreadLocal<Set<Object>> fItemsBeingDeleted = new ThreadLocal();
    private static final String PARENT_DELETED_KEY = "rssowl.db4o.EventManager.parentDeleted";
    private static final EventManager INSTANCE = new EventManager();
    private ObjectContainer fDb;
    private IConditionalGetDAO fConditionalGetDAO;
    private IDGenerator fIDGenerator;
    private INewsCounterDAO fNewsCounterDAO;

    private EventManager() {
        this.initEntityStoreListener();
    }

    private IDGenerator getIDGenerator() {
        if (this.fIDGenerator == null) {
            this.fIDGenerator = Owl.getPersistenceService().getIDGenerator();
        }
        return this.fIDGenerator;
    }

    private IConditionalGetDAO getConditionalGetDAO() {
        if (this.fConditionalGetDAO == null) {
            this.fConditionalGetDAO = Owl.getPersistenceService().getDAOService().getConditionalGetDAO();
        }
        return this.fConditionalGetDAO;
    }

    private INewsCounterDAO getNewsCounterDAO() {
        if (this.fNewsCounterDAO == null) {
            this.fNewsCounterDAO = InternalOwl.getDefault().getPersistenceService().getDAOService().getNewsCounterDAO();
        }
        return this.fNewsCounterDAO;
    }

    private void initEventRegistry() {
        EventRegistry eventRegistry = EventRegistryFactory.forObjectContainer((ObjectContainer)this.fDb);
        EventListener4 updatedListener = new EventListener4(){

            public void onEvent(Event4 e, EventArgs args) {
                EventManager.this.processUpdatedEvent(args);
            }
        };
        EventListener4 creatingListener = new EventListener4(){

            public void onEvent(Event4 e, EventArgs args) {
                EventManager.this.processCreatingEvent(args);
            }
        };
        EventListener4 createdListener = new EventListener4(){

            public void onEvent(Event4 e, EventArgs args) {
                EventManager.this.processCreatedEvent(args);
            }
        };
        EventListener4 deletingListener = new EventListener4(){

            public void onEvent(Event4 e, EventArgs args) {
                EventManager.this.processDeletingEvent(args);
            }
        };
        EventListener4 deletedListener = new EventListener4(){

            public void onEvent(Event4 e, EventArgs args) {
                EventManager.this.processDeletedEvent(args);
            }
        };
        EventListener4 activatedListener = new EventListener4(){

            public void onEvent(Event4 e, EventArgs args) {
                EventManager.this.processActivated(args);
            }
        };
        eventRegistry.activated().addListener(activatedListener);
        eventRegistry.created().addListener(createdListener);
        eventRegistry.creating().addListener(creatingListener);
        eventRegistry.updated().addListener(updatedListener);
        eventRegistry.deleting().addListener(deletingListener);
        eventRegistry.deleted().addListener(deletedListener);
    }

    private void processActivated(EventArgs args) {
        IEntity entity = this.getEntity(args);
        if (entity == null) {
            return;
        }
        if (entity instanceof News) {
            ((News)entity).init();
        } else if (entity instanceof BookMark) {
            this.initBookMark((BookMark)entity);
        }
    }

    private void initBookMark(BookMark entity) {
        entity.setNewsCounter(this.getNewsCounterDAO().load());
    }

    private void processUpdatedEvent(EventArgs args) {
        IEntity entity = this.getEntity(args);
        if (entity == null) {
            return;
        }
        ModelEvent event = this.createModelEvent(entity);
        if (event != null) {
            EventsMap.getInstance().putUpdateEvent(event);
        }
    }

    private void processCreatingEvent(EventArgs args) {
        IEntity entity = this.getEntity(args);
        if (entity != null) {
            this.setId(entity);
            if (entity instanceof BookMark) {
                this.initBookMark((BookMark)entity);
            }
        }
    }

    private void processCreatedEvent(EventArgs args) {
        IEntity entity = this.getEntity(args);
        if (entity == null) {
            return;
        }
        ModelEvent event = this.createModelEvent(entity);
        if (event != null) {
            EventsMap.getInstance().putPersistEvent(event);
        }
    }

    private void processDeletingEvent(EventArgs args) {
        IEntity entity = this.getEntity(args);
        if (entity == null) {
            return;
        }
        if (entity instanceof INews) {
            this.cascadeNewsDeletion((INews)entity);
        } else if (entity instanceof IFeed) {
            this.cascadeFeedDeletion((IFeed)entity);
        } else if (entity instanceof IMark) {
            this.cascadeMarkDeletion((IMark)entity);
        } else if (entity instanceof IFolder) {
            this.removeFromParentFolderAndCascade((IFolder)entity);
        } else if (entity instanceof IAttachment) {
            this.removeFromParentNews((IAttachment)entity);
        } else if (entity instanceof ISearchCondition) {
            this.cascadeSearchConditionDeletion((ISearchCondition)entity);
        } else if (entity instanceof ISearchFilter) {
            this.cascadeSearchFilterDeletion((ISearchFilter)entity);
        } else if (entity instanceof ISearch) {
            this.cascadeSearchDeletion((ISearch)entity);
        }
    }

    private void cascadeSearchFilterDeletion(ISearchFilter entity) {
        this.fDb.delete((Object)entity.getSearch());
    }

    private void cascadeNewsBinDeletion(INewsBin entity) {
        HashSet<FeedLinkReference> removedFeedRefs = new HashSet<FeedLinkReference>();
        DBHelper.removeNews(this.fDb, removedFeedRefs, entity.getNewsRefs());
        DBHelper.removeFeedsAfterNewsBinUpdate(this.fDb, removedFeedRefs);
        if (entity instanceof NewsBin) {
            this.fDb.delete((Object)((NewsBin)entity).internalGetNewsContainer());
        }
    }

    private void cascadeSearchConditionDeletion(ISearchCondition searchCondition) {
        ISearchMark searchMark = this.loadSearchMark(searchCondition);
        if (searchMark != null && !this.itemsBeingDeletedContains(searchMark) && searchMark.removeSearchCondition(searchCondition)) {
            this.fDb.ext().set((Object)searchMark, 2);
        }
        this.fDb.delete((Object)searchCondition.getField());
    }

    private ISearchMark loadSearchMark(ISearchCondition searchCondition) {
        ISearchMark mark = Owl.getPersistenceService().getDAOService().getSearchMarkDAO().load(searchCondition);
        return mark;
    }

    private void cascadeNewsDeletion(INews news) {
        this.addItemBeingDeleted(news);
        if (news.getParentId() == 0L) {
            this.removeFromParentFeed(news);
        }
        if (news.getCategories().isEmpty()) {
            this.fDb.activate((Object)news, Integer.MAX_VALUE);
        }
        this.fDb.delete((Object)news.getGuid());
        this.fDb.delete((Object)news.getSource());
        this.fDb.delete((Object)news.getAuthor());
        for (ICategory category : ReverseIterator.createInstance(news.getCategories())) {
            this.fDb.delete((Object)category);
        }
        for (IAttachment attachment : ReverseIterator.createInstance(news.getAttachments())) {
            this.fDb.delete((Object)attachment);
        }
        Description description = DBHelper.getDescriptionDAO().load(news.getId());
        if (description != null) {
            this.fDb.delete((Object)description);
        }
    }

    private void cascadeMarkDeletion(IMark mark) {
        this.removeFromParentFolder(mark);
        if (mark instanceof IBookMark) {
            this.deleteFeedIfNecessary((IBookMark)mark);
        } else if (mark instanceof ISearchMark) {
            this.cascadeSearchMarkDeletion((ISearchMark)mark);
        } else if (mark instanceof INewsBin) {
            this.cascadeNewsBinDeletion((INewsBin)mark);
        }
    }

    private void cascadeSearchMarkDeletion(ISearchMark mark) {
        this.addItemBeingDeleted(mark);
        for (ISearchCondition condition : mark.getSearchConditions()) {
            this.fDb.delete((Object)condition);
        }
    }

    private void cascadeSearchDeletion(ISearch search) {
        for (ISearchCondition condition : search.getSearchConditions()) {
            this.fDb.delete((Object)condition);
        }
    }

    private void cascadeFeedDeletion(IFeed feed) {
        this.addItemBeingDeleted(new FeedLinkReference(feed.getLink()));
        this.fDb.delete((Object)feed.getImage());
        this.fDb.delete((Object)feed.getAuthor());
        for (ICategory category : ReverseIterator.createInstance(feed.getCategories())) {
            this.fDb.delete((Object)category);
        }
        for (INews news : ReverseIterator.createInstance(feed.getNews())) {
            this.fDb.delete((Object)news);
        }
        IConditionalGet conditionalGet = this.getConditionalGetDAO().load(feed.getLink());
        if (conditionalGet != null) {
            this.fDb.delete((Object)conditionalGet);
        }
        this.removeFromItemsBeingDeleted(feed);
    }

    private void removeFromParentNews(IAttachment attachment) {
        INews news = attachment.getNews();
        if (this.itemsBeingDeletedContains(news)) {
            return;
        }
        news.removeAttachment(attachment);
        this.fDb.set((Object)news);
    }

    private void removeFromParentFolderAndCascade(IFolder folder) {
        IFolder parentFolder = folder.getParent();
        if (parentFolder != null) {
            parentFolder.removeChild(folder);
            this.fDb.set((Object)parentFolder);
        }
        for (IFolder child : ReverseIterator.createInstance(folder.getFolders())) {
            this.cascadeFolderDeletion(child);
        }
        for (IMark mark : ReverseIterator.createInstance(folder.getMarks())) {
            mark.setProperty(PARENT_DELETED_KEY, Boolean.valueOf(true));
            this.fDb.delete((Object)mark);
        }
    }

    private void cascadeFolderDeletion(IFolder folder) {
        for (IFolder child : ReverseIterator.createInstance(folder.getFolders())) {
            this.cascadeFolderDeletion(child);
        }
        for (IMark mark : ReverseIterator.createInstance(folder.getMarks())) {
            mark.setProperty(PARENT_DELETED_KEY, Boolean.valueOf(true));
            this.fDb.delete((Object)mark);
        }
        folder.setParent(null);
        this.fDb.delete((Object)folder);
    }

    private void removeFromParentFolder(IMark mark) {
        IFolder parentFolder = mark.getParent();
        parentFolder.removeChild(mark);
        if (mark.getProperty(PARENT_DELETED_KEY) == null) {
            this.fDb.set((Object)parentFolder);
        } else {
            mark.removeProperty(PARENT_DELETED_KEY);
        }
    }

    private void removeFromParentFeed(INews news) {
        FeedLinkReference feedRef = news.getFeedReference();
        if (this.itemsBeingDeletedContains(feedRef)) {
            return;
        }
        IFeed feed = feedRef.resolve();
        if (feed.removeNews(news)) {
            this.fDb.ext().set((Object)feed, 2);
        }
    }

    private boolean removeFromItemsBeingDeleted(Object entity) {
        Set<Object> entities = this.fItemsBeingDeleted.get();
        if (entities == null) {
            return false;
        }
        return entities.remove(entity);
    }

    private boolean itemsBeingDeletedContains(Object entity) {
        Set<Object> entities = this.fItemsBeingDeleted.get();
        if (entities == null) {
            return false;
        }
        return entities.contains(entity);
    }

    private void deleteFeedIfNecessary(IBookMark mark) {
        Query query = this.fDb.query();
        query.constrain(Feed.class);
        query.descend("fLinkText").constrain((Object)mark.getFeedLinkReference().getLink().toString());
        ObjectSet feeds = query.execute();
        for (IFeed feed : feeds) {
            FeedLinkReference feedRef = new FeedLinkReference(feed.getLink());
            if (DBHelper.countBookMarkReference(this.fDb, feedRef) != 1) continue;
            if (DBHelper.feedHasNewsWithCopies(this.fDb, feedRef)) {
                ArrayList<INews> newsList = new ArrayList<INews>(feed.getNews());
                for (INews news : newsList) {
                    feed.removeNews(news);
                    this.addItemBeingDeleted(feed);
                    this.fDb.delete((Object)news);
                }
                this.fDb.ext().set((Object)feed, 2);
                continue;
            }
            this.fDb.delete((Object)feed);
        }
    }

    private void processDeletedEvent(EventArgs args) {
        IEntity entity = this.getEntity(args);
        if (entity == null) {
            return;
        }
        ModelEvent event = this.createModelEvent(entity);
        if (event != null) {
            EventsMap.getInstance().putRemoveEvent(event);
        }
    }

    private IEntity getEntity(EventArgs args) {
        ObjectEventArgs queryArgs = (ObjectEventArgs)args;
        Object o = queryArgs.object();
        if (o instanceof IEntity) {
            IEntity entity = (IEntity)o;
            return entity;
        }
        return null;
    }

    private ModelEvent createModelEvent(IEntity entity) {
        ModelEvent modelEvent = null;
        Map<IEntity, ModelEvent> templatesMap = EventsMap.getInstance().getEventTemplatesMap();
        ModelEvent template = templatesMap.get(entity);
        boolean root = this.isRoot(template);
        boolean merged = this.isMerged(template);
        if (entity instanceof INews) {
            modelEvent = this.createNewsEvent((INews)entity, template, root, merged);
        } else if (entity instanceof IAttachment) {
            IAttachment attachment = (IAttachment)entity;
            modelEvent = new AttachmentEvent(attachment, root);
        } else if (entity instanceof ICategory) {
            ICategory category = (ICategory)entity;
            modelEvent = new CategoryEvent(category, root);
        } else if (entity instanceof IFeed) {
            IFeed feed = (IFeed)entity;
            modelEvent = new FeedEvent(feed, root);
        } else if (entity instanceof IPerson) {
            IPerson person = (IPerson)entity;
            modelEvent = new PersonEvent(person, root);
        } else if (entity instanceof IBookMark) {
            IBookMark mark = (IBookMark)entity;
            BookMarkEvent eventTemplate = (BookMarkEvent)template;
            IFolder oldParent = eventTemplate == null ? null : eventTemplate.getOldParent();
            modelEvent = new BookMarkEvent(mark, oldParent, root);
        } else if (entity instanceof ISearchMark) {
            ISearchMark mark = (ISearchMark)entity;
            SearchMarkEvent eventTemplate = (SearchMarkEvent)template;
            IFolder oldParent = eventTemplate == null ? null : eventTemplate.getOldParent();
            modelEvent = new SearchMarkEvent(mark, oldParent, root);
        } else if (entity instanceof INewsBin) {
            INewsBin newsBin = (INewsBin)entity;
            NewsBinEvent eventTemplate = (NewsBinEvent)template;
            IFolder oldParent = eventTemplate == null ? null : eventTemplate.getOldParent();
            modelEvent = new NewsBinEvent(newsBin, oldParent, root);
        } else if (entity instanceof IFolder) {
            IFolder folder = (IFolder)entity;
            FolderEvent eventTemplate = (FolderEvent)template;
            IFolder oldParent = eventTemplate == null ? null : eventTemplate.getOldParent();
            modelEvent = new FolderEvent(folder, oldParent, root);
        } else if (entity instanceof ILabel) {
            ILabel label = (ILabel)entity;
            LabelEvent eventTemplate = (LabelEvent)template;
            ILabel oldLabel = eventTemplate == null ? null : eventTemplate.getOldLabel();
            modelEvent = new LabelEvent(oldLabel, label, root);
        } else if (entity instanceof ISearchCondition) {
            ISearchCondition searchCond = (ISearchCondition)entity;
            modelEvent = new SearchConditionEvent(searchCond, root);
        } else if (entity instanceof IPreference) {
            IPreference pref = (IPreference)entity;
            modelEvent = new PreferenceEvent(pref);
        } else if (entity instanceof ISearch) {
            ISearch search = (ISearch)entity;
            modelEvent = new SearchEvent(search, root);
        } else if (entity instanceof ISearchFilter) {
            ISearchFilter filter = (ISearchFilter)entity;
            modelEvent = new SearchFilterEvent(filter, root);
        }
        return modelEvent;
    }

    private ModelEvent createNewsEvent(INews news, ModelEvent template, boolean root, boolean merged) {
        NewsEvent newsTemplate = (NewsEvent)template;
        INews oldNews = newsTemplate == null ? null : newsTemplate.getOldNews();
        NewsEvent modelEvent = new NewsEvent(oldNews, news, root, merged);
        return modelEvent;
    }

    private boolean isRoot(ModelEvent template) {
        if (template == null) {
            return false;
        }
        return template.isRoot();
    }

    private boolean isMerged(ModelEvent template) {
        if (template == null) {
            return false;
        }
        return template instanceof NewsEvent && ((NewsEvent)template).isMerged();
    }

    private void setId(IEntity entity) {
        if (entity.getId() == null) {
            IDGenerator idGenerator = this.getIDGenerator();
            long id = idGenerator instanceof DB4OIDGenerator ? ((DB4OIDGenerator)idGenerator).getNext(false) : idGenerator.getNext();
            if (entity instanceof News) {
                News n = (News)entity;
                n.releaseReadLockSpecial();
                try {
                    entity.setId(id);
                }
                finally {
                    n.acquireReadLockSpecial();
                }
            } else {
                entity.setId(id);
            }
        }
    }

    void initEntityStoreListener() {
        DBManager.getDefault().addEntityStoreListener(this);
    }

    public void databaseOpened(DatabaseEvent event) {
        this.fDb = event.getObjectContainer();
        this.initEventRegistry();
    }

    public void databaseClosed(DatabaseEvent event) {
        this.fDb = null;
    }

    public final void addItemBeingDeleted(Object entity) {
        Set<Object> entities = this.fItemsBeingDeleted.get();
        if (entities == null) {
            entities = new HashSet<Object>(3);
            this.fItemsBeingDeleted.set(entities);
        }
        entities.add(entity);
    }

    public void clear() {
        this.fItemsBeingDeleted.set(null);
    }

    public static final EventManager getInstance() {
        return INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReverseIterator<T>
    implements Iterable<T>,
    Iterator<T> {
        private final List<T> fList;
        private int index;

        static <T> ReverseIterator<T> createInstance(List<T> list) {
            return new ReverseIterator<T>(list);
        }

        private ReverseIterator(List<T> list) {
            this.fList = list;
            this.index = list.size() - 1;
        }

        @Override
        public final Iterator<T> iterator() {
            return this;
        }

        @Override
        public final boolean hasNext() {
            return this.index > -1;
        }

        @Override
        public final T next() {
            return this.fList.get(this.index--);
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

