/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.fileheader;

import com.db4o.ext.DatabaseFileLockedException;
import com.db4o.foundation.Cool;
import com.db4o.foundation.PrimitiveCodec;
import com.db4o.internal.IoAdaptedObjectContainer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.fileheader.TimerFileLock;
import com.db4o.io.IoAdapter;
import java.io.IOException;

public class TimerFileLockEnabled
extends TimerFileLock {
    private final IoAdapter _timerFile;
    private final Object _timerLock;
    private byte[] _longBytes = new byte[8];
    private byte[] _intBytes = new byte[4];
    private int _headerLockOffset = 6;
    private final long _opentime;
    private int _baseAddress = -1;
    private int _openTimeOffset;
    private int _accessTimeOffset;
    private boolean _closed = false;

    public TimerFileLockEnabled(IoAdaptedObjectContainer ioAdaptedObjectContainer) {
        this._timerLock = ioAdaptedObjectContainer.lock();
        this._timerFile = ioAdaptedObjectContainer.timerFile();
        this._opentime = this.uniqueOpenTime();
    }

    public void checkHeaderLock() {
        try {
            if ((long)((int)this._opentime) == this.readInt(0, this._headerLockOffset)) {
                this.writeHeaderLock();
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new DatabaseFileLockedException(this._timerFile.toString());
    }

    public void checkOpenTime() {
        try {
            long l = this.readLong(this._baseAddress, this._openTimeOffset);
            if (this._opentime == l) {
                this.writeOpenTime();
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new DatabaseFileLockedException(this._timerFile.toString());
    }

    public void checkIfOtherSessionAlive(LocalObjectContainer localObjectContainer, int n, int n2, long l) {
        if (this._timerFile == null) {
            return;
        }
        long l2 = 5000L;
        long l3 = System.currentTimeMillis();
        while (System.currentTimeMillis() < l3 + l2) {
            Cool.sleepIgnoringInterruption(l2);
        }
        try {
            long l4 = this.readLong(n, n2);
            if (l4 > l) {
                throw new DatabaseFileLockedException(localObjectContainer.toString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() throws IOException {
        this.writeAccessTime(true);
        this._closed = true;
    }

    public boolean lockFile() {
        return true;
    }

    public long openTime() {
        return this._opentime;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        thread.setName("db4o file lock");
        try {
            while (this.writeAccessTime(false)) {
                Cool.sleepIgnoringInterruption(1000L);
                if (!this._closed) continue;
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setAddresses(int n, int n2, int n3) {
        this._baseAddress = n;
        this._openTimeOffset = n2;
        this._accessTimeOffset = n3;
    }

    public void start() throws IOException {
        this.writeAccessTime(false);
        this._timerFile.sync();
        this.checkOpenTime();
        new Thread(this).start();
    }

    private long uniqueOpenTime() {
        return System.currentTimeMillis();
    }

    private boolean writeAccessTime(boolean bl) throws IOException {
        if (this.noAddressSet()) {
            return true;
        }
        long l = bl ? 0L : System.currentTimeMillis();
        boolean bl2 = this.writeLong(this._baseAddress, this._accessTimeOffset, l);
        this.sync();
        return bl2;
    }

    private boolean noAddressSet() {
        return this._baseAddress < 0;
    }

    public void writeHeaderLock() {
        try {
            this.writeInt(0, this._headerLockOffset, (int)this._opentime);
            this.sync();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeOpenTime() {
        try {
            this.writeLong(this._baseAddress, this._openTimeOffset, this._opentime);
            this.sync();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeLong(int n, int n2, long l) throws IOException {
        Object object = this._timerLock;
        synchronized (object) {
            if (this._timerFile == null) {
                return false;
            }
            this._timerFile.blockSeek(n, n2);
            PrimitiveCodec.writeLong(this._longBytes, l);
            this._timerFile.write(this._longBytes);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readLong(int n, int n2) throws IOException {
        Object object = this._timerLock;
        synchronized (object) {
            if (this._timerFile == null) {
                return 0L;
            }
            this._timerFile.blockSeek(n, n2);
            this._timerFile.read(this._longBytes);
            return PrimitiveCodec.readLong(this._longBytes, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeInt(int n, int n2, int n3) throws IOException {
        Object object = this._timerLock;
        synchronized (object) {
            if (this._timerFile == null) {
                return false;
            }
            this._timerFile.blockSeek(n, n2);
            PrimitiveCodec.writeInt(this._intBytes, 0, n3);
            this._timerFile.write(this._intBytes);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readInt(int n, int n2) throws IOException {
        Object object = this._timerLock;
        synchronized (object) {
            if (this._timerFile == null) {
                return 0L;
            }
            this._timerFile.blockSeek(n, n2);
            this._timerFile.read(this._longBytes);
            return PrimitiveCodec.readInt(this._longBytes, 0);
        }
    }

    private void sync() throws IOException {
        this._timerFile.sync();
    }
}

