/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.CorruptionException;
import com.db4o.ObjectSet;
import com.db4o.StaticClass;
import com.db4o.StaticField;
import com.db4o.TransactionAware;
import com.db4o.config.ConfigScope;
import com.db4o.config.ObjectMarshaller;
import com.db4o.config.ObjectTranslator;
import com.db4o.ext.ObjectNotStorableException;
import com.db4o.ext.StoredClass;
import com.db4o.ext.StoredField;
import com.db4o.foundation.Arrays4;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Function4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.No4;
import com.db4o.foundation.Predicate4;
import com.db4o.foundation.TernaryBool;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.Buffer;
import com.db4o.internal.Comparable4;
import com.db4o.internal.Config4Class;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Const4;
import com.db4o.internal.CustomMarshallerFieldMetadata;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.EventDispatcher;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.Messages;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.ReaderPair;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TranslatedFieldMetadata;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TypeHandler4;
import com.db4o.internal.UUIDFieldMetadata;
import com.db4o.internal.UnicodeStringIO;
import com.db4o.internal.VersionFieldMetadata;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import com.db4o.internal.classindex.ClassIndexStrategy;
import com.db4o.internal.diagnostic.DiagnosticProcessor;
import com.db4o.internal.handlers.ArrayHandler;
import com.db4o.internal.marshall.ClassMarshaller;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.marshall.ObjectHeaderAttributes;
import com.db4o.internal.query.processor.QCandidate;
import com.db4o.internal.query.processor.QCandidates;
import com.db4o.internal.query.processor.QConObject;
import com.db4o.internal.slots.Slot;
import com.db4o.query.Query;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.generic.GenericReflector;

public class ClassMetadata
extends PersistentBase
implements TypeHandler4,
StoredClass {
    public ClassMetadata i_ancestor;
    Config4Class i_config;
    public int _metaClassID;
    public FieldMetadata[] i_fields;
    private final ClassIndexStrategy _index;
    protected String i_name;
    protected final ObjectContainerBase i_stream;
    byte[] i_nameBytes;
    private Buffer i_reader;
    private boolean _classIndexed;
    private ReflectClass _reflector;
    private boolean _isEnum;
    public boolean i_dontCallConstructors;
    private EventDispatcher _eventDispatcher;
    private boolean _internal;
    private boolean _unversioned;
    private int i_lastID;
    private TernaryBool _canUpdateFast = TernaryBool.UNSPECIFIED;
    private ReflectClass i_compareTo;

    public final boolean canUpdateFast() {
        return this._canUpdateFast.booleanValue(this.checkCanUpdateFast());
    }

    private final boolean checkCanUpdateFast() {
        if (this.i_ancestor != null && !this.i_ancestor.canUpdateFast()) {
            return false;
        }
        if (this.i_config != null && this.i_config.cascadeOnDelete() == TernaryBool.YES) {
            return false;
        }
        for (int i = 0; i < this.i_fields.length; ++i) {
            if (!this.i_fields[i].hasIndex()) continue;
            return false;
        }
        return true;
    }

    boolean isInternal() {
        return this._internal;
    }

    private ClassIndexStrategy createIndexStrategy() {
        return new BTreeClassIndexStrategy(this);
    }

    ClassMetadata(ObjectContainerBase objectContainerBase, ReflectClass reflectClass) {
        this.i_stream = objectContainerBase;
        this._reflector = reflectClass;
        this._index = this.createIndexStrategy();
        this._classIndexed = true;
    }

    void activateFields(Transaction transaction, Object object, int n) {
        if (this.objectCanActivate(transaction.stream(), object)) {
            this.activateFields1(transaction, object, n);
        }
    }

    void activateFields1(Transaction transaction, Object object, int n) {
        for (int i = 0; i < this.i_fields.length; ++i) {
            this.i_fields[i].cascadeActivation(transaction, object, n, true);
        }
        if (this.i_ancestor != null) {
            this.i_ancestor.activateFields1(transaction, object, n);
        }
    }

    public final void addFieldIndices(StatefulBuffer statefulBuffer, Slot slot) {
        if (this.hasIndex() || this.hasVirtualAttributes()) {
            ObjectHeader objectHeader = new ObjectHeader(this.i_stream, this, statefulBuffer);
            objectHeader._marshallerFamily._object.addFieldIndices(this, objectHeader._headerAttributes, statefulBuffer, slot);
        }
    }

    void addMembers(ObjectContainerBase objectContainerBase) {
        this.bitTrue(6);
        if (this.installTranslator(objectContainerBase) || this.installMarshaller(objectContainerBase)) {
            return;
        }
        if (objectContainerBase.detectSchemaChanges()) {
            DiagnosticProcessor diagnosticProcessor;
            boolean bl = this.isDirty();
            Collection4 collection4 = new Collection4();
            if (null != this.i_fields) {
                collection4.addAll(this.i_fields);
                if (this.i_fields.length == 1 && this.i_fields[0] instanceof TranslatedFieldMetadata) {
                    this.setStateOK();
                    return;
                }
            }
            if (this.generateVersionNumbers() && !this.hasVersionField()) {
                collection4.add(objectContainerBase.getVersionIndex());
                bl = true;
            }
            if (this.generateUUIDs() && !this.hasUUIDField()) {
                collection4.add(objectContainerBase.getUUIDIndex());
                bl = true;
            }
            if (bl = this.collectReflectFields(objectContainerBase, collection4) | bl) {
                this.i_stream.setDirtyInSystemTransaction(this);
                this.i_fields = new FieldMetadata[collection4.size()];
                collection4.toArray(this.i_fields);
                for (int i = 0; i < this.i_fields.length; ++i) {
                    this.i_fields[i].setArrayPosition(i);
                }
            } else if (collection4.size() == 0) {
                this.i_fields = new FieldMetadata[0];
            }
            if ((diagnosticProcessor = this.i_stream.i_handlers._diagnosticProcessor).enabled()) {
                diagnosticProcessor.checkClassHasFields(this);
            }
        } else if (this.i_fields == null) {
            this.i_fields = new FieldMetadata[0];
        }
        this.setStateOK();
        objectContainerBase.callbacks().classOnRegistered(this);
    }

    private boolean collectReflectFields(ObjectContainerBase objectContainerBase, Collection4 collection4) {
        boolean bl = false;
        ReflectField[] reflectFieldArray = this.reflectFields();
        for (int i = 0; i < reflectFieldArray.length; ++i) {
            TypeHandler4 typeHandler4;
            if (!this.storeField(reflectFieldArray[i]) || (typeHandler4 = objectContainerBase.i_handlers.handlerForClass(objectContainerBase, reflectFieldArray[i].getFieldType())) == null) continue;
            FieldMetadata fieldMetadata = new FieldMetadata(this, reflectFieldArray[i], typeHandler4);
            boolean bl2 = false;
            Iterator4 iterator4 = collection4.iterator();
            while (iterator4.moveNext()) {
                if (!((FieldMetadata)iterator4.current()).equals(fieldMetadata)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            bl = true;
            collection4.add(fieldMetadata);
        }
        return bl;
    }

    private boolean installMarshaller(ObjectContainerBase objectContainerBase) {
        ObjectMarshaller objectMarshaller = this.getMarshaller();
        if (objectMarshaller == null) {
            return false;
        }
        this.installCustomFieldMetadata(objectContainerBase, new CustomMarshallerFieldMetadata(this, objectMarshaller));
        return true;
    }

    private boolean installTranslator(ObjectContainerBase objectContainerBase) {
        ObjectTranslator objectTranslator = this.getTranslator();
        if (objectTranslator == null) {
            return false;
        }
        if (this.isNewTranslator(objectTranslator)) {
            this.i_stream.setDirtyInSystemTransaction(this);
        }
        this.installCustomFieldMetadata(objectContainerBase, new TranslatedFieldMetadata(this, objectTranslator));
        return true;
    }

    private void installCustomFieldMetadata(ObjectContainerBase objectContainerBase, FieldMetadata fieldMetadata) {
        boolean bl;
        int n = 1;
        boolean bl2 = this.generateVersionNumbers() && !this.ancestorHasVersionField();
        boolean bl3 = bl = this.generateUUIDs() && !this.ancestorHasUUIDField();
        if (bl2) {
            n = 2;
        }
        if (bl) {
            n = 3;
        }
        this.i_fields = new FieldMetadata[n];
        this.i_fields[0] = fieldMetadata;
        if (bl2 || bl) {
            this.i_fields[1] = objectContainerBase.getVersionIndex();
        }
        if (bl) {
            this.i_fields[2] = objectContainerBase.getUUIDIndex();
        }
        this.setStateOK();
    }

    private ObjectTranslator getTranslator() {
        return this.i_config == null ? null : this.i_config.getTranslator();
    }

    private ObjectMarshaller getMarshaller() {
        return this.i_config == null ? null : this.i_config.getMarshaller();
    }

    private boolean isNewTranslator(ObjectTranslator objectTranslator) {
        return !this.hasFields() || !objectTranslator.getClass().getName().equals(this.i_fields[0].getName());
    }

    private boolean hasFields() {
        return this.i_fields != null && this.i_fields.length > 0;
    }

    void addToIndex(LocalObjectContainer localObjectContainer, Transaction transaction, int n) {
        if (localObjectContainer.maintainsIndices()) {
            this.addToIndex1(localObjectContainer, transaction, n);
        }
    }

    void addToIndex1(LocalObjectContainer localObjectContainer, Transaction transaction, int n) {
        if (this.i_ancestor != null) {
            this.i_ancestor.addToIndex1(localObjectContainer, transaction, n);
        }
        if (this.hasIndex()) {
            this._index.add(transaction, n);
        }
    }

    boolean allowsQueries() {
        return this.hasIndex();
    }

    public boolean canHold(ReflectClass reflectClass) {
        if (reflectClass == null) {
            return true;
        }
        if (this._reflector != null) {
            if (this.classReflector().isCollection()) {
                return true;
            }
            return this.classReflector().isAssignableFrom(reflectClass);
        }
        return false;
    }

    public void cascadeActivation(Transaction transaction, Object object, int n, boolean bl) {
        Config4Class config4Class = this.configOrAncestorConfig();
        if (config4Class != null && bl) {
            n = config4Class.adjustActivationDepth(n);
        }
        if (n > 0) {
            ObjectContainerBase objectContainerBase = transaction.stream();
            if (bl) {
                if (this.isValueType()) {
                    this.activateFields(transaction, object, n - 1);
                } else {
                    objectContainerBase.stillToActivate(object, n - 1);
                }
            } else {
                objectContainerBase.stillToDeactivate(object, n - 1, false);
            }
        }
    }

    void checkChanges() {
        if (this.stateOK() && !this.bitIsTrue(6)) {
            this.bitTrue(6);
            if (this.i_ancestor != null) {
                this.i_ancestor.checkChanges();
            }
            if (this._reflector != null) {
                this.addMembers(this.i_stream);
                if (!this.i_stream.isClient()) {
                    this.write(this.i_stream.getSystemTransaction());
                }
            }
        }
    }

    public void checkType() {
        ReflectClass reflectClass = this.classReflector();
        if (reflectClass == null) {
            return;
        }
        if (this.i_stream.i_handlers.ICLASS_INTERNAL.isAssignableFrom(reflectClass)) {
            this._internal = true;
        }
        if (this.i_stream.i_handlers.ICLASS_UNVERSIONED.isAssignableFrom(reflectClass)) {
            this._unversioned = true;
        }
        if (this.i_stream.i_handlers.ICLASS_DB4OTYPEIMPL.isAssignableFrom(reflectClass)) {
            Db4oTypeImpl db4oTypeImpl = (Db4oTypeImpl)reflectClass.newInstance();
            this._classIndexed = db4oTypeImpl == null || db4oTypeImpl.hasClassIndex();
        } else if (this.i_config != null) {
            this._classIndexed = this.i_config.indexed();
        }
    }

    public void checkUpdateDepth(StatefulBuffer statefulBuffer) {
        int n = statefulBuffer.getUpdateDepth();
        Config4Class config4Class = this.configOrAncestorConfig();
        if (n == -2147483548) {
            n = this.checkUpdateDepthUnspecified(statefulBuffer.getStream());
            if (this.classReflector().isCollection()) {
                n = this.adjustDepth(n);
            }
        }
        if (config4Class != null && (config4Class.cascadeOnDelete() == TernaryBool.YES || config4Class.cascadeOnUpdate() == TernaryBool.YES)) {
            n = this.adjustDepth(n);
        }
        statefulBuffer.setUpdateDepth(n - 1);
    }

    private int adjustDepth(int n) {
        int n2 = this.reflector().collectionUpdateDepth(this.classReflector());
        if (n > Integer.MIN_VALUE && n < n2) {
            n = n2;
        }
        return n;
    }

    int checkUpdateDepthUnspecified(ObjectContainerBase objectContainerBase) {
        int n;
        int n2 = objectContainerBase.configImpl().updateDepth() + 1;
        if (this.i_config != null && this.i_config.updateDepth() != 0) {
            n2 = this.i_config.updateDepth() + 1;
        }
        if (this.i_ancestor != null && (n = this.i_ancestor.checkUpdateDepthUnspecified(objectContainerBase)) > n2) {
            return n;
        }
        return n2;
    }

    public Object coerce(ReflectClass reflectClass, Object object) {
        return this.canHold(reflectClass) ? object : No4.INSTANCE;
    }

    public void collectConstraints(Transaction transaction, QConObject qConObject, Object object, Visitor4 visitor4) {
        if (this.i_fields != null) {
            for (int i = 0; i < this.i_fields.length; ++i) {
                this.i_fields[i].collectConstraints(transaction, qConObject, object, visitor4);
            }
        }
        if (this.i_ancestor != null) {
            this.i_ancestor.collectConstraints(transaction, qConObject, object, visitor4);
        }
    }

    public final TreeInt collectFieldIDs(MarshallerFamily marshallerFamily, ObjectHeaderAttributes objectHeaderAttributes, TreeInt treeInt, StatefulBuffer statefulBuffer, String string) {
        return marshallerFamily._object.collectFieldIDs(treeInt, this, objectHeaderAttributes, statefulBuffer, string);
    }

    public final boolean configInstantiates() {
        return this.i_config != null && this.i_config.instantiates();
    }

    public Config4Class config() {
        return this.i_config;
    }

    public Config4Class configOrAncestorConfig() {
        if (this.i_config != null) {
            return this.i_config;
        }
        if (this.i_ancestor != null) {
            return this.i_ancestor.configOrAncestorConfig();
        }
        return null;
    }

    public void copyValue(Object object, Object object2) {
    }

    private boolean createConstructor(ObjectContainerBase objectContainerBase, String string) {
        ReflectClass reflectClass;
        try {
            reflectClass = objectContainerBase.reflector().forName(string);
        }
        catch (Throwable throwable) {
            reflectClass = null;
        }
        return this.createConstructor(objectContainerBase, reflectClass, string, true);
    }

    public boolean createConstructor(ObjectContainerBase objectContainerBase, ReflectClass reflectClass, String string, boolean bl) {
        this._reflector = reflectClass;
        this._eventDispatcher = EventDispatcher.forClass(objectContainerBase, reflectClass);
        if (reflectClass != null) {
            this._isEnum = Platform4.jdk().isEnum(this.reflector(), reflectClass);
        }
        if (this.configInstantiates()) {
            return true;
        }
        if (reflectClass != null && (objectContainerBase.i_handlers.ICLASS_TRANSIENTCLASS.isAssignableFrom(reflectClass) || Platform4.isTransient(reflectClass))) {
            reflectClass = null;
        }
        if (reflectClass == null) {
            if ((string == null || !Platform4.isDb4oClass(string)) && bl) {
                objectContainerBase.logMsg(23, string);
            }
            this.setStateDead();
            return false;
        }
        if (objectContainerBase.i_handlers.createConstructor(reflectClass, !this.callConstructor())) {
            return true;
        }
        this.setStateDead();
        if (bl) {
            objectContainerBase.logMsg(7, string);
        }
        if (objectContainerBase.configImpl().exceptionsOnNotStorable()) {
            throw new ObjectNotStorableException(reflectClass);
        }
        return false;
    }

    public void deactivate(Transaction transaction, Object object, int n) {
        if (this.objectCanDeactivate(transaction.stream(), object)) {
            this.deactivate1(transaction, object, n);
            this.objectOnDeactivate(transaction.stream(), object);
        }
    }

    private void objectOnDeactivate(ObjectContainerBase objectContainerBase, Object object) {
        objectContainerBase.callbacks().objectOnDeactivate(object);
        this.dispatchEvent(objectContainerBase, object, 3);
    }

    private boolean objectCanDeactivate(ObjectContainerBase objectContainerBase, Object object) {
        return objectContainerBase.callbacks().objectCanDeactivate(object) && this.dispatchEvent(objectContainerBase, object, 7);
    }

    void deactivate1(Transaction transaction, Object object, int n) {
        for (int i = 0; i < this.i_fields.length; ++i) {
            this.i_fields[i].deactivate(transaction, object, n);
        }
        if (this.i_ancestor != null) {
            this.i_ancestor.deactivate1(transaction, object, n);
        }
    }

    final void delete(StatefulBuffer statefulBuffer, Object object) {
        ObjectHeader objectHeader = new ObjectHeader(this.i_stream, this, statefulBuffer);
        this.delete1(objectHeader._marshallerFamily, objectHeader._headerAttributes, statefulBuffer, object);
    }

    private final void delete1(MarshallerFamily marshallerFamily, ObjectHeaderAttributes objectHeaderAttributes, StatefulBuffer statefulBuffer, Object object) {
        this.removeFromIndex(statefulBuffer.getTransaction(), statefulBuffer.getID());
        this.deleteMembers(marshallerFamily, objectHeaderAttributes, statefulBuffer, statefulBuffer.getTransaction().stream().i_handlers.arrayType(object), false);
    }

    public void deleteEmbedded(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer) {
        if (statefulBuffer.cascadeDeletes() > 0) {
            int n = statefulBuffer.readInt();
            if (n > 0) {
                this.deleteEmbedded1(marshallerFamily, statefulBuffer, n);
            }
        } else {
            statefulBuffer.incrementOffset(this.linkLength());
        }
    }

    public void deleteEmbedded1(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer, int n) {
        if (statefulBuffer.cascadeDeletes() > 0) {
            ObjectReference objectReference;
            ObjectContainerBase objectContainerBase = statefulBuffer.getStream();
            Object object = objectContainerBase.getByID2(statefulBuffer.getTransaction(), n);
            int n2 = statefulBuffer.cascadeDeletes() - 1;
            if (object != null && this.isCollection(object)) {
                n2 += this.reflector().collectionUpdateDepth(this.reflector().forObject(object)) - 1;
            }
            if ((objectReference = objectContainerBase.getYapObject(n)) != null) {
                statefulBuffer.getStream().delete2(statefulBuffer.getTransaction(), objectReference, object, n2, false);
            }
        }
    }

    void deleteMembers(MarshallerFamily marshallerFamily, ObjectHeaderAttributes objectHeaderAttributes, StatefulBuffer statefulBuffer, int n, boolean bl) {
        try {
            Config4Class config4Class = this.configOrAncestorConfig();
            if (config4Class != null && config4Class.cascadeOnDelete() == TernaryBool.YES) {
                int n2 = statefulBuffer.cascadeDeletes();
                if (this.classReflector().isCollection()) {
                    int n3 = n2 + this.reflector().collectionUpdateDepth(this.classReflector()) - 3;
                    if (n3 < 1) {
                        n3 = 1;
                    }
                    statefulBuffer.setCascadeDeletes(n3);
                } else {
                    statefulBuffer.setCascadeDeletes(1);
                }
                marshallerFamily._object.deleteMembers(this, objectHeaderAttributes, statefulBuffer, n, bl);
                statefulBuffer.setCascadeDeletes(n2);
            } else {
                marshallerFamily._object.deleteMembers(this, objectHeaderAttributes, statefulBuffer, n, bl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final boolean dispatchEvent(ObjectContainerBase objectContainerBase, Object object, int n) {
        if (this._eventDispatcher == null || !objectContainerBase.dispatchsEvents()) {
            return true;
        }
        return this._eventDispatcher.dispatch(objectContainerBase, object, n);
    }

    public final boolean isEqual(TypeHandler4 typeHandler4) {
        return this == typeHandler4;
    }

    public final int fieldCount() {
        int n = this.i_fields.length;
        if (this.i_ancestor != null) {
            n += this.i_ancestor.fieldCount();
        }
        return n;
    }

    public Iterator4 fields() {
        return new FieldMetadataIterator(this);
    }

    public final MarshallerFamily findOffset(Buffer buffer, FieldMetadata fieldMetadata) {
        if (buffer == null) {
            return null;
        }
        buffer._offset = 0;
        ObjectHeader objectHeader = new ObjectHeader(this.i_stream, this, buffer);
        boolean bl = objectHeader.objectMarshaller().findOffset(this, objectHeader._headerAttributes, buffer, fieldMetadata);
        if (!bl) {
            return null;
        }
        return objectHeader._marshallerFamily;
    }

    void forEachYapField(Visitor4 visitor4) {
        if (this.i_fields != null) {
            for (int i = 0; i < this.i_fields.length; ++i) {
                visitor4.visit(this.i_fields[i]);
            }
        }
        if (this.i_ancestor != null) {
            this.i_ancestor.forEachYapField(visitor4);
        }
    }

    public static ClassMetadata forObject(Transaction transaction, Object object, boolean bl) {
        ReflectClass reflectClass = transaction.reflector().forObject(object);
        if (reflectClass != null && reflectClass.getSuperclass() == null && object != null) {
            throw new ObjectNotStorableException(object.toString());
        }
        if (bl) {
            return transaction.stream().produceYapClass(reflectClass);
        }
        return transaction.stream().getYapClass(reflectClass);
    }

    public boolean generateUUIDs() {
        if (!this.generateVirtual()) {
            return false;
        }
        boolean bl = this.i_config == null ? false : this.i_config.generateUUIDs();
        return this.generate1(this.i_stream.config().generateUUIDs(), bl);
    }

    private boolean generateVersionNumbers() {
        if (!this.generateVirtual()) {
            return false;
        }
        boolean bl = this.i_config == null ? false : this.i_config.generateVersionNumbers();
        return this.generate1(this.i_stream.config().generateVersionNumbers(), bl);
    }

    private boolean generateVirtual() {
        if (this._unversioned) {
            return false;
        }
        return !this._internal;
    }

    private boolean generate1(ConfigScope configScope, boolean bl) {
        return configScope.applyConfig(bl);
    }

    ClassMetadata getAncestor() {
        return this.i_ancestor;
    }

    public Object getComparableObject(Object object) {
        if (this.i_config != null && this.i_config.queryAttributeProvider() != null) {
            return this.i_config.queryAttributeProvider().attribute(object);
        }
        return object;
    }

    public ClassMetadata getHigherHierarchy(ClassMetadata classMetadata) {
        ClassMetadata classMetadata2 = this.getHigherHierarchy1(classMetadata);
        if (classMetadata2 != null) {
            return classMetadata2;
        }
        return classMetadata.getHigherHierarchy1(this);
    }

    private ClassMetadata getHigherHierarchy1(ClassMetadata classMetadata) {
        if (classMetadata == this) {
            return this;
        }
        if (this.i_ancestor != null) {
            return this.i_ancestor.getHigherHierarchy1(classMetadata);
        }
        return null;
    }

    public ClassMetadata getHigherOrCommonHierarchy(ClassMetadata classMetadata) {
        ClassMetadata classMetadata2 = this.getHigherHierarchy1(classMetadata);
        if (classMetadata2 != null) {
            return classMetadata2;
        }
        if (this.i_ancestor != null && (classMetadata2 = this.i_ancestor.getHigherOrCommonHierarchy(classMetadata)) != null) {
            return classMetadata2;
        }
        return classMetadata.getHigherHierarchy1(this);
    }

    public byte getIdentifier() {
        return 67;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getIDs() {
        Object object = this.i_stream.i_lock;
        synchronized (object) {
            if (!this.stateOK()) {
                return new long[0];
            }
            return this.getIDs(this.i_stream.getTransaction());
        }
    }

    public long[] getIDs(Transaction transaction) {
        if (!this.stateOK()) {
            return new long[0];
        }
        if (!this.hasIndex()) {
            return new long[0];
        }
        return transaction.stream().getIDsForClass(transaction, this);
    }

    public boolean hasIndex() {
        return this._classIndexed;
    }

    private boolean ancestorHasUUIDField() {
        if (this.i_ancestor == null) {
            return false;
        }
        return this.i_ancestor.hasUUIDField();
    }

    private boolean hasUUIDField() {
        if (this.ancestorHasUUIDField()) {
            return true;
        }
        return Arrays4.containsInstanceOf(this.i_fields, UUIDFieldMetadata.class);
    }

    private boolean ancestorHasVersionField() {
        if (this.i_ancestor == null) {
            return false;
        }
        return this.i_ancestor.hasVersionField();
    }

    private boolean hasVersionField() {
        if (this.ancestorHasVersionField()) {
            return true;
        }
        return Arrays4.containsInstanceOf(this.i_fields, VersionFieldMetadata.class);
    }

    public ClassIndexStrategy index() {
        return this._index;
    }

    public int indexEntryCount(Transaction transaction) {
        if (!this.stateOK()) {
            return 0;
        }
        return this._index.entryCount(transaction);
    }

    public Object indexEntryToObject(Transaction transaction, Object object) {
        if (object == null) {
            return null;
        }
        int n = (Integer)object;
        return this.getStream().getByID2(transaction, n);
    }

    public ReflectClass classReflector() {
        return this._reflector;
    }

    public String getName() {
        if (this.i_name == null && this._reflector != null) {
            this.i_name = this._reflector.getName();
        }
        return this.i_name;
    }

    public StoredClass getParentStoredClass() {
        return this.getAncestor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredField[] getStoredFields() {
        Object object = this.i_stream.i_lock;
        synchronized (object) {
            if (this.i_fields == null) {
                return null;
            }
            StoredField[] storedFieldArray = new StoredField[this.i_fields.length];
            System.arraycopy(this.i_fields, 0, storedFieldArray, 0, this.i_fields.length);
            return storedFieldArray;
        }
    }

    ObjectContainerBase getStream() {
        return this.i_stream;
    }

    public int getTypeID() {
        return 2;
    }

    public ClassMetadata getYapClass(ObjectContainerBase objectContainerBase) {
        return this;
    }

    public FieldMetadata getYapField(final String string) {
        final FieldMetadata[] fieldMetadataArray = new FieldMetadata[1];
        this.forEachYapField(new Visitor4(){

            public void visit(Object object) {
                if (string.equals(((FieldMetadata)object).getName())) {
                    fieldMetadataArray[0] = (FieldMetadata)object;
                }
            }
        });
        return fieldMetadataArray[0];
    }

    public boolean hasFixedLength() {
        return true;
    }

    public boolean hasField(ObjectContainerBase objectContainerBase, String string) {
        if (this.classReflector().isCollection()) {
            return true;
        }
        return this.getYapField(string) != null;
    }

    boolean hasVirtualAttributes() {
        if (this._internal) {
            return false;
        }
        return this.hasVersionField() || this.hasUUIDField();
    }

    public boolean holdsAnyClass() {
        return this.classReflector().isCollection();
    }

    void incrementFieldsOffset1(Buffer buffer) {
        int n = this.readFieldCount(buffer);
        for (int i = 0; i < n; ++i) {
            this.i_fields[i].incrementOffset(buffer);
        }
    }

    public Object comparableObject(Transaction transaction, Object object) {
        return object;
    }

    final boolean init(ObjectContainerBase objectContainerBase, ClassMetadata classMetadata, ReflectClass reflectClass) {
        this.i_ancestor = classMetadata;
        Config4Impl config4Impl = objectContainerBase.configImpl();
        String string = reflectClass.getName();
        this.setConfig(config4Impl.configClass(string));
        if (!this.createConstructor(objectContainerBase, reflectClass, string, false)) {
            return false;
        }
        this.checkType();
        if (this.allowsQueries()) {
            this._index.initialize(objectContainerBase);
        }
        this.i_name = string;
        this.i_ancestor = classMetadata;
        this.bitTrue(6);
        return true;
    }

    final void initConfigOnUp(Transaction transaction) {
        Config4Class config4Class = Platform4.extendConfiguration(this._reflector, this.i_stream.configure(), this.i_config);
        if (config4Class != null) {
            this.i_config = config4Class;
        }
        if (this.i_config == null) {
            return;
        }
        if (!this.stateOK()) {
            return;
        }
        if (this.i_fields == null) {
            return;
        }
        for (int i = 0; i < this.i_fields.length; ++i) {
            FieldMetadata fieldMetadata = this.i_fields[i];
            String string = fieldMetadata.getName();
            if (!fieldMetadata.hasConfig() && config4Class != null && config4Class.configField(string) != null) {
                fieldMetadata.initIndex(this, string);
            }
            fieldMetadata.initConfigOnUp(transaction);
        }
    }

    void initOnUp(Transaction transaction) {
        if (!this.stateOK()) {
            return;
        }
        this.initConfigOnUp(transaction);
        this.storeStaticFieldValues(transaction, false);
    }

    Object instantiate(ObjectReference objectReference, Object object, MarshallerFamily marshallerFamily, ObjectHeaderAttributes objectHeaderAttributes, StatefulBuffer statefulBuffer, boolean bl) {
        boolean bl2;
        boolean bl3;
        this.adjustInstantiationDepth(statefulBuffer);
        ObjectContainerBase objectContainerBase = statefulBuffer.getStream();
        boolean bl4 = bl3 = object == null;
        if (bl3) {
            object = this.instantiateObject(statefulBuffer, marshallerFamily);
            if (object == null) {
                return null;
            }
            this.shareTransaction(object, statefulBuffer.getTransaction());
            this.shareYapObject(object, objectReference);
            objectReference.setObjectWeak(objectContainerBase, object);
            objectContainerBase.referenceSystem().addExistingReferenceToObjectTree(objectReference);
        }
        if (bl) {
            objectReference.addExistingReferenceToIdTree(objectContainerBase);
        }
        boolean bl5 = bl2 = statefulBuffer.getInstantiationDepth() > 0 || this.cascadeOnActivate();
        if (bl2 && !this.activatingAlreadyActiveObject(bl3, objectContainerBase, objectReference)) {
            if (this.objectCanActivate(objectContainerBase, object)) {
                objectReference.setStateClean();
                this.instantiateFields(objectReference, object, marshallerFamily, objectHeaderAttributes, statefulBuffer);
                this.objectOnActivate(objectContainerBase, object);
            } else if (bl3) {
                objectReference.setStateDeactivated();
            }
        } else if (bl3) {
            objectReference.setStateDeactivated();
        } else if (statefulBuffer.getInstantiationDepth() > 1) {
            this.activateFields(statefulBuffer.getTransaction(), object, statefulBuffer.getInstantiationDepth() - 1);
        }
        return object;
    }

    private boolean activatingAlreadyActiveObject(boolean bl, ObjectContainerBase objectContainerBase, ObjectReference objectReference) {
        return !bl && !objectContainerBase.i_refreshInsteadOfActivate && objectReference.isActive();
    }

    private Object instantiateObject(StatefulBuffer statefulBuffer, MarshallerFamily marshallerFamily) {
        Object object = null;
        object = this.configInstantiates() ? this.instantiateFromConfig(statefulBuffer.getStream(), statefulBuffer, marshallerFamily) : this.instantiateFromReflector(statefulBuffer.getStream());
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object instantiateFromReflector(ObjectContainerBase objectContainerBase) {
        if (this._reflector == null) {
            return null;
        }
        objectContainerBase.instantiating(true);
        try {
            Object object = this._reflector.newInstance();
            return object;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            objectContainerBase.logMsg(7, this.classReflector().getName());
            Object var3_5 = null;
            return var3_5;
        }
        catch (Exception exception) {
            Object var3_6 = null;
            return var3_6;
        }
        finally {
            objectContainerBase.instantiating(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object instantiateFromConfig(ObjectContainerBase objectContainerBase, StatefulBuffer statefulBuffer, MarshallerFamily marshallerFamily) {
        int n = statefulBuffer._offset;
        statefulBuffer.incrementOffset(4);
        try {
            Object object = this.i_config.instantiate(objectContainerBase, this.i_fields[0].read(marshallerFamily, statefulBuffer));
            return object;
        }
        catch (Exception exception) {
            Messages.logErr(objectContainerBase.configImpl(), 6, this.classReflector().getName(), exception);
            Object var6_7 = null;
            return var6_7;
        }
        finally {
            statefulBuffer._offset = n;
        }
    }

    private void adjustInstantiationDepth(StatefulBuffer statefulBuffer) {
        if (this.i_config != null) {
            statefulBuffer.setInstantiationDepth(this.i_config.adjustActivationDepth(statefulBuffer.getInstantiationDepth()));
        }
    }

    private boolean cascadeOnActivate() {
        return this.i_config != null && this.i_config.cascadeOnActivate() == TernaryBool.YES;
    }

    private void shareYapObject(Object object, ObjectReference objectReference) {
        if (object instanceof Db4oTypeImpl) {
            ((Db4oTypeImpl)object).setYapObject(objectReference);
        }
    }

    private void shareTransaction(Object object, Transaction transaction) {
        if (object instanceof TransactionAware) {
            ((TransactionAware)object).setTrans(transaction);
        }
    }

    private void objectOnActivate(ObjectContainerBase objectContainerBase, Object object) {
        objectContainerBase.callbacks().objectOnActivate(object);
        this.dispatchEvent(objectContainerBase, object, 2);
    }

    private boolean objectCanActivate(ObjectContainerBase objectContainerBase, Object object) {
        return objectContainerBase.callbacks().objectCanActivate(object) && this.dispatchEvent(objectContainerBase, object, 6);
    }

    Object instantiateTransient(ObjectReference objectReference, Object object, MarshallerFamily marshallerFamily, ObjectHeaderAttributes objectHeaderAttributes, StatefulBuffer statefulBuffer) {
        Object object2 = this.instantiateObject(statefulBuffer, marshallerFamily);
        if (object2 == null) {
            return null;
        }
        statefulBuffer.getStream().peeked(objectReference.getID(), object2);
        this.instantiateFields(objectReference, object2, marshallerFamily, objectHeaderAttributes, statefulBuffer);
        return object2;
    }

    void instantiateFields(ObjectReference objectReference, Object object, MarshallerFamily marshallerFamily, ObjectHeaderAttributes objectHeaderAttributes, StatefulBuffer statefulBuffer) {
        marshallerFamily._object.instantiateFields(this, objectHeaderAttributes, objectReference, object, statefulBuffer);
    }

    public boolean indexNullHandling() {
        return true;
    }

    public boolean isArray() {
        return this.classReflector().isCollection();
    }

    boolean isCollection(Object object) {
        return this.reflector().forObject(object).isCollection();
    }

    public boolean isDirty() {
        if (!this.stateOK()) {
            return false;
        }
        return super.isDirty();
    }

    boolean isEnum() {
        return this._isEnum;
    }

    public boolean isPrimitive() {
        return false;
    }

    public TernaryBool isSecondClass() {
        return TernaryBool.NO;
    }

    public boolean isStrongTyped() {
        return true;
    }

    boolean isValueType() {
        return Platform4.isValueType(this.classReflector());
    }

    public void calculateLengths(Transaction transaction, ObjectHeaderAttributes objectHeaderAttributes, boolean bl, Object object, boolean bl2) {
        if (bl) {
            objectHeaderAttributes.addBaseLength(this.linkLength());
        } else {
            objectHeaderAttributes.addPayLoadLength(this.linkLength());
        }
    }

    public String nameToWrite() {
        if (this.i_config != null && this.i_config.writeAs() != null) {
            return this.i_config.writeAs();
        }
        if (this.i_name == null) {
            return "";
        }
        return this.i_stream.configImpl().resolveAliasRuntimeName(this.i_name);
    }

    final boolean callConstructor() {
        this.i_dontCallConstructors = !this.callConstructor1();
        return !this.i_dontCallConstructors;
    }

    private final boolean callConstructor1() {
        TernaryBool ternaryBool = this.callConstructorSpecialized();
        if (!ternaryBool.unspecified()) {
            return ternaryBool == TernaryBool.YES;
        }
        return this.i_stream.configImpl().callConstructors().definiteYes();
    }

    private final TernaryBool callConstructorSpecialized() {
        TernaryBool ternaryBool;
        if (this.i_config != null && !(ternaryBool = this.i_config.callConstructor()).unspecified()) {
            return ternaryBool;
        }
        if (this._isEnum) {
            return TernaryBool.NO;
        }
        if (this.i_ancestor != null) {
            return this.i_ancestor.callConstructorSpecialized();
        }
        return TernaryBool.UNSPECIFIED;
    }

    public int ownLength() {
        return MarshallerFamily.current()._class.marshalledLength(this.i_stream, this);
    }

    public ReflectClass primitiveClassReflector() {
        return null;
    }

    void purge() {
        this._index.purge();
    }

    public Object read(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer, boolean bl) throws CorruptionException {
        try {
            int n = statefulBuffer.readInt();
            int n2 = statefulBuffer.getInstantiationDepth() - 1;
            Transaction transaction = statefulBuffer.getTransaction();
            ObjectContainerBase objectContainerBase = transaction.stream();
            if (statefulBuffer.getUpdateDepth() == -1) {
                return objectContainerBase.peekPersisted1(transaction, n, n2);
            }
            if (this.isValueType()) {
                ObjectReference objectReference;
                if (n2 < 1) {
                    n2 = 1;
                }
                if ((objectReference = objectContainerBase.getYapObject(n)) != null) {
                    Object object = objectReference.getObject();
                    if (object == null) {
                        objectContainerBase.removeReference(objectReference);
                    } else {
                        objectReference.activate(transaction, object, n2, false);
                        return objectReference.getObject();
                    }
                }
                return new ObjectReference(n).read(transaction, null, null, n2, 1, false);
            }
            Object object = objectContainerBase.getByID2(transaction, n);
            if (object instanceof Db4oTypeImpl) {
                n2 = ((Db4oTypeImpl)object).adjustReadDepth(n2);
            }
            objectContainerBase.stillToActivate(object, n2);
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object readQuery(Transaction transaction, MarshallerFamily marshallerFamily, boolean bl, Buffer buffer, boolean bl2) throws CorruptionException {
        try {
            return transaction.stream().getByID2(transaction, buffer.readInt());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public TypeHandler4 readArrayHandler(Transaction transaction, MarshallerFamily marshallerFamily, Buffer[] bufferArray) {
        if (this.isArray()) {
            return this;
        }
        return null;
    }

    public TypeHandler4 readArrayHandler1(Buffer[] bufferArray) {
        if (this.isArray()) {
            if (Platform4.isCollectionTranslator(this.i_config)) {
                bufferArray[0].incrementOffset(4);
                return new ArrayHandler(this.i_stream, null, false);
            }
            this.incrementFieldsOffset1(bufferArray[0]);
            if (this.i_ancestor != null) {
                return this.i_ancestor.readArrayHandler1(bufferArray);
            }
        }
        return null;
    }

    public QCandidate readSubCandidate(MarshallerFamily marshallerFamily, Buffer buffer, QCandidates qCandidates, boolean bl) {
        int n = buffer.readInt();
        if (n == 0) {
            return null;
        }
        return new QCandidate(qCandidates, null, n, true);
    }

    public void readCandidates(MarshallerFamily marshallerFamily, Buffer buffer, final QCandidates qCandidates) {
        Transaction transaction;
        Object object;
        int n = 0;
        int n2 = buffer._offset;
        try {
            n = buffer.readInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        buffer._offset = n2;
        if (n != 0 && (object = (transaction = qCandidates.i_trans).stream().getByID1(transaction, n)) != null) {
            qCandidates.i_trans.stream().activate1(transaction, object, 2);
            Platform4.forEachCollectionElement(object, new Visitor4(){

                public void visit(Object object) {
                    qCandidates.addByIdentity(new QCandidate(qCandidates, object, (int)transaction.stream().getID(object), true));
                }
            });
        }
    }

    public final int readFieldCount(Buffer buffer) {
        int n = buffer.readInt();
        if (n > this.i_fields.length) {
            return this.i_fields.length;
        }
        return n;
    }

    public int readFieldCountSodaAtHome(Buffer buffer) {
        return 0;
    }

    public Object readIndexEntry(Buffer buffer) {
        return new Integer(buffer.readInt());
    }

    public Object readIndexEntry(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer) throws CorruptionException {
        return this.readIndexEntry(statefulBuffer);
    }

    byte[] readName(Transaction transaction) {
        this.i_reader = transaction.stream().readReaderByID(transaction, this.getID());
        return this.readName1(transaction, this.i_reader);
    }

    public final byte[] readName1(Transaction transaction, Buffer buffer) {
        if (buffer == null) {
            return null;
        }
        this.i_reader = buffer;
        try {
            ClassMarshaller classMarshaller = MarshallerFamily.current()._class;
            this.i_nameBytes = classMarshaller.readName(transaction, buffer);
            this._metaClassID = classMarshaller.readMetaClassID(buffer);
            this.setStateUnread();
            this.bitFalse(6);
            this.bitFalse(5);
            return this.i_nameBytes;
        }
        catch (Throwable throwable) {
            this.setStateDead();
            return null;
        }
    }

    void readVirtualAttributes(Transaction transaction, ObjectReference objectReference) {
        int n = objectReference.getID();
        ObjectContainerBase objectContainerBase = transaction.stream();
        Buffer buffer = objectContainerBase.readReaderByID(transaction, n);
        ObjectHeader objectHeader = new ObjectHeader(objectContainerBase, this, buffer);
        objectHeader.objectMarshaller().readVirtualAttributes(transaction, this, objectReference, objectHeader._headerAttributes, buffer);
    }

    GenericReflector reflector() {
        return this.i_stream.reflector();
    }

    public void rename(String string) {
        if (!this.i_stream.isClient()) {
            int n = this.i_state;
            this.setStateOK();
            this.i_name = string;
            this.setStateDirty();
            this.write(this.i_stream.getSystemTransaction());
            this.i_state = n;
        } else {
            Exceptions4.throwRuntimeException(58);
        }
    }

    void createConfigAndConstructor(Hashtable4 hashtable4, ObjectContainerBase objectContainerBase, ReflectClass reflectClass) {
        if (reflectClass == null) {
            if (this.i_nameBytes != null) {
                String string = objectContainerBase.stringIO().read(this.i_nameBytes);
                this.i_name = objectContainerBase.configImpl().resolveAliasStoredName(string);
            }
        } else {
            this.i_name = reflectClass.getName();
        }
        this.setConfig(this.i_stream.configImpl().configClass(this.i_name));
        if (reflectClass == null) {
            this.createConstructor(objectContainerBase, this.i_name);
        } else {
            this.createConstructor(objectContainerBase, reflectClass, this.i_name, true);
        }
        if (this.i_nameBytes != null) {
            hashtable4.remove(this.i_nameBytes);
            this.i_nameBytes = null;
        }
    }

    boolean readThis() {
        if (this.stateUnread()) {
            this.setStateOK();
            this.setStateClean();
            this.forceRead();
            return true;
        }
        return false;
    }

    final void forceRead() {
        if (this.i_reader == null || this.bitIsTrue(8)) {
            return;
        }
        this.bitTrue(8);
        MarshallerFamily.forConverterVersion((int)this.i_stream.converterVersion())._class.read(this.i_stream, this, this.i_reader);
        this.i_nameBytes = null;
        this.i_reader = null;
        this.bitFalse(8);
    }

    public boolean readArray(Object object, Buffer buffer) {
        return false;
    }

    public void readThis(Transaction transaction, Buffer buffer) {
        throw Exceptions4.virtualException();
    }

    public void refresh() {
        if (!this.stateUnread()) {
            this.createConstructor(this.i_stream, this.i_name);
            this.bitFalse(6);
            this.checkChanges();
            if (this.i_fields != null) {
                for (int i = 0; i < this.i_fields.length; ++i) {
                    this.i_fields[i].refresh();
                }
            }
        }
    }

    void removeFromIndex(Transaction transaction, int n) {
        if (this.hasIndex()) {
            this._index.remove(transaction, n);
        }
        if (this.i_ancestor != null) {
            this.i_ancestor.removeFromIndex(transaction, n);
        }
    }

    boolean renameField(String string, String string2) {
        int n;
        boolean bl = false;
        for (n = 0; n < this.i_fields.length; ++n) {
            if (!this.i_fields[n].getName().equals(string2)) continue;
            this.i_stream.logMsg(9, "class:" + this.getName() + " field:" + string2);
            return false;
        }
        for (n = 0; n < this.i_fields.length; ++n) {
            if (!this.i_fields[n].getName().equals(string)) continue;
            this.i_fields[n].setName(string2);
            bl = true;
        }
        return bl;
    }

    void setConfig(Config4Class config4Class) {
        if (this.i_config == null) {
            this.i_config = config4Class;
        }
    }

    void setName(String string) {
        this.i_name = string;
    }

    private final void setStateDead() {
        this.bitTrue(7);
        this.bitFalse(4);
    }

    private final void setStateUnread() {
        this.bitFalse(7);
        this.bitTrue(4);
    }

    private final void setStateOK() {
        this.bitFalse(7);
        this.bitFalse(4);
    }

    boolean stateDead() {
        return this.bitIsTrue(7);
    }

    private final boolean stateOK() {
        return this.bitIsFalse(4) && this.bitIsFalse(7) && this.bitIsFalse(8);
    }

    final boolean stateOKAndAncestors() {
        if (!this.stateOK() || this.i_fields == null) {
            return false;
        }
        if (this.i_ancestor != null) {
            return this.i_ancestor.stateOKAndAncestors();
        }
        return true;
    }

    boolean stateUnread() {
        return this.bitIsTrue(4) && this.bitIsFalse(7) && this.bitIsFalse(8);
    }

    boolean storeField(ReflectField reflectField) {
        if (reflectField.isStatic()) {
            return false;
        }
        if (reflectField.isTransient()) {
            Config4Class config4Class = this.configOrAncestorConfig();
            if (config4Class == null) {
                return false;
            }
            if (!config4Class.storeTransientFields()) {
                return false;
            }
        }
        return Platform4.canSetAccessible() || reflectField.isPublic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredField storedField(String string, Object object) {
        Object object2 = this.i_stream.i_lock;
        synchronized (object2) {
            ClassMetadata classMetadata = this.i_stream.getYapClass(this.i_stream.configImpl().reflectorFor(object));
            if (this.i_fields != null) {
                for (int i = 0; i < this.i_fields.length; ++i) {
                    if (!this.i_fields[i].getName().equals(string) || classMetadata != null && classMetadata != this.i_fields[i].getFieldYapClass(this.i_stream)) continue;
                    return this.i_fields[i];
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeStaticFieldValues(Transaction transaction, boolean bl) {
        if (this.bitIsTrue(5) && !bl) {
            return;
        }
        this.bitTrue(5);
        if (!this.shouldStoreStaticFields(transaction)) {
            return;
        }
        ObjectContainerBase objectContainerBase = transaction.stream();
        objectContainerBase.showInternalClasses(true);
        try {
            StaticClass staticClass = this.queryStaticClass(transaction);
            if (staticClass == null) {
                this.createStaticClass(transaction);
            } else {
                this.updateStaticClass(transaction, staticClass);
            }
        }
        finally {
            objectContainerBase.showInternalClasses(false);
        }
    }

    private boolean shouldStoreStaticFields(Transaction transaction) {
        return this.staticFieldValuesArePersisted() || Platform4.storeStaticFieldValues(transaction.reflector(), this.classReflector());
    }

    private void updateStaticClass(final Transaction transaction, StaticClass staticClass) {
        ObjectContainerBase objectContainerBase = transaction.stream();
        objectContainerBase.activate1(transaction, staticClass, 4);
        final StaticField[] staticFieldArray = staticClass.fields;
        Iterator4 iterator4 = Iterators.map(this.staticReflectFields(), new Function4(){

            public Object apply(Object object) {
                ReflectField reflectField = (ReflectField)object;
                StaticField staticField = ClassMetadata.this.fieldByName(staticFieldArray, reflectField.getName());
                if (staticField != null) {
                    ClassMetadata.this.updateExistingStaticField(transaction, staticField, reflectField);
                    return staticField;
                }
                return ClassMetadata.this.toStaticField(reflectField);
            }
        });
        staticClass.fields = this.toStaticFieldArray(iterator4);
        if (!objectContainerBase.isClient()) {
            this.setStaticClass(transaction, staticClass);
        }
    }

    private void createStaticClass(Transaction transaction) {
        if (transaction.stream().isClient()) {
            return;
        }
        StaticClass staticClass = new StaticClass(this.i_name, this.toStaticFieldArray(this.staticReflectFieldsToStaticFields()));
        this.setStaticClass(transaction, staticClass);
    }

    private Iterator4 staticReflectFieldsToStaticFields() {
        return Iterators.map(this.staticReflectFields(), new Function4(){

            public Object apply(Object object) {
                return ClassMetadata.this.toStaticField((ReflectField)object);
            }
        });
    }

    private StaticField toStaticField(ReflectField reflectField) {
        return new StaticField(reflectField.getName(), this.staticReflectFieldValue(reflectField));
    }

    private Object staticReflectFieldValue(ReflectField reflectField) {
        reflectField.setAccessible();
        return reflectField.get(null);
    }

    private void setStaticClass(Transaction transaction, StaticClass staticClass) {
        transaction.stream().setInternal(transaction, staticClass, true);
    }

    private StaticField[] toStaticFieldArray(Iterator4 iterator4) {
        return this.toStaticFieldArray(new Collection4(iterator4));
    }

    private StaticField[] toStaticFieldArray(Collection4 collection4) {
        return (StaticField[])collection4.toArray(new StaticField[collection4.size()]);
    }

    private Iterator4 staticReflectFields() {
        return Iterators.filter(this.reflectFields(), new Predicate4(){

            public boolean match(Object object) {
                return ((ReflectField)object).isStatic();
            }
        });
    }

    private ReflectField[] reflectFields() {
        return this.classReflector().getDeclaredFields();
    }

    private void updateExistingStaticField(Transaction transaction, StaticField staticField, ReflectField reflectField) {
        long l;
        ObjectContainerBase objectContainerBase = transaction.stream();
        Object object = this.staticReflectFieldValue(reflectField);
        if (staticField.value != null && object != null && staticField.value.getClass() == object.getClass() && (l = (long)objectContainerBase.getID1(staticField.value)) > 0L) {
            if (staticField.value != object) {
                objectContainerBase.bind1(transaction, object, l);
                objectContainerBase.refresh(object, Integer.MAX_VALUE);
                staticField.value = object;
            }
            return;
        }
        if (object == null) {
            try {
                reflectField.set(null, staticField.value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        staticField.value = object;
    }

    private boolean staticFieldValuesArePersisted() {
        return this.i_config != null && this.i_config.staticFieldValuesArePersisted();
    }

    private StaticField fieldByName(StaticField[] staticFieldArray, String string) {
        for (int i = 0; i < staticFieldArray.length; ++i) {
            StaticField staticField = staticFieldArray[i];
            if (!string.equals(staticField.name)) continue;
            return staticField;
        }
        return null;
    }

    private StaticClass queryStaticClass(Transaction transaction) {
        Query query = transaction.stream().query(transaction);
        query.constrain(Const4.CLASS_STATICCLASS);
        query.descend("name").constrain(this.i_name);
        ObjectSet objectSet = query.execute();
        return objectSet.size() > 0 ? (StaticClass)objectSet.next() : null;
    }

    public boolean supportsIndex() {
        return true;
    }

    public String toString() {
        if (this.i_name != null) {
            return this.i_name;
        }
        if (this.i_nameBytes == null) {
            return "*CLASS NAME UNKNOWN*";
        }
        UnicodeStringIO unicodeStringIO = this.i_stream == null ? Const4.stringIO : this.i_stream.stringIO();
        return ((LatinStringIO)unicodeStringIO).read(this.i_nameBytes);
    }

    public boolean writeArray(Object object, Buffer buffer) {
        return false;
    }

    public boolean writeObjectBegin() {
        if (!this.stateOK()) {
            return false;
        }
        return super.writeObjectBegin();
    }

    public void writeIndexEntry(Buffer buffer, Object object) {
        if (object == null) {
            buffer.writeInt(0);
            return;
        }
        buffer.writeInt((Integer)object);
    }

    public Object writeNew(MarshallerFamily marshallerFamily, Object object, boolean bl, StatefulBuffer statefulBuffer, boolean bl2, boolean bl3) {
        if (object == null) {
            statefulBuffer.writeInt(0);
            return new Integer(0);
        }
        int n = statefulBuffer.getStream().setInternal(statefulBuffer.getTransaction(), object, statefulBuffer.getUpdateDepth(), true);
        statefulBuffer.writeInt(n);
        return new Integer(n);
    }

    public final void writeThis(Transaction transaction, Buffer buffer) {
        MarshallerFamily.current()._class.write(transaction, this, buffer);
    }

    public void prepareComparison(Transaction transaction, Object object) {
        this.prepareComparison(object);
    }

    public Comparable4 prepareComparison(Object object) {
        if (object != null) {
            this.i_lastID = object instanceof Integer ? (Integer)object : (int)this.i_stream.getID(object);
            this.i_compareTo = this.reflector().forObject(object);
        } else {
            this.i_lastID = 0;
            this.i_compareTo = null;
        }
        return this;
    }

    public Object current() {
        if (this.i_compareTo == null) {
            return null;
        }
        return new Integer(this.i_lastID);
    }

    public int compareTo(Object object) {
        if (object instanceof Integer) {
            return (Integer)object - this.i_lastID;
        }
        if (object == null && this.i_compareTo == null) {
            return 0;
        }
        return -1;
    }

    public boolean isEqual(Object object) {
        if (object == null) {
            return this.i_compareTo == null;
        }
        return this.i_compareTo.isAssignableFrom(this.reflector().forObject(object));
    }

    public boolean isGreater(Object object) {
        return false;
    }

    public boolean isSmaller(Object object) {
        return false;
    }

    public String toString(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer, ObjectReference objectReference, int n, int n2) {
        int n3 = this.readFieldCount(statefulBuffer);
        String string = "";
        for (int i = 0; i < n3; ++i) {
            string = string + this.i_fields[i].toString(marshallerFamily, statefulBuffer);
        }
        if (this.i_ancestor != null) {
            string = string + this.i_ancestor.toString(marshallerFamily, statefulBuffer, objectReference, n, n2);
        }
        return string;
    }

    public static void defragObject(ReaderPair readerPair) {
        ObjectHeader objectHeader = ObjectHeader.defrag(readerPair);
        objectHeader._marshallerFamily._object.defragFields(objectHeader.yapClass(), objectHeader, readerPair);
    }

    public void defrag(MarshallerFamily marshallerFamily, ReaderPair readerPair, boolean bl) {
        if (this.hasIndex()) {
            readerPair.copyID();
        } else {
            readerPair.copyUnindexedID();
        }
        int n = this.linkLength() - 4;
        readerPair.incrementOffset(n);
    }

    public void defragClass(ReaderPair readerPair, int n) throws CorruptionException {
        MarshallerFamily marshallerFamily = MarshallerFamily.current();
        marshallerFamily._class.defrag(this, this.i_stream.stringIO(), readerPair, n);
    }

    public static ClassMetadata readClass(ObjectContainerBase objectContainerBase, Buffer buffer) {
        ObjectHeader objectHeader = new ObjectHeader(objectContainerBase, buffer);
        return objectHeader.yapClass();
    }

    public boolean isAssignableFrom(ClassMetadata classMetadata) {
        return this.classReflector().isAssignableFrom(classMetadata.classReflector());
    }

    public final void defragIndexEntry(ReaderPair readerPair) {
        readerPair.copyID();
    }

    private static class FieldMetadataIterator
    implements Iterator4 {
        private final ClassMetadata _initialClazz;
        private ClassMetadata _curClazz;
        private int _curIdx;

        public FieldMetadataIterator(ClassMetadata classMetadata) {
            this._initialClazz = classMetadata;
            this.reset();
        }

        public Object current() {
            return this._curClazz.i_fields[this._curIdx];
        }

        public boolean moveNext() {
            if (this._curClazz == null) {
                this._curClazz = this._initialClazz;
                this._curIdx = 0;
            } else {
                ++this._curIdx;
            }
            while (this._curClazz != null && !this.indexInRange()) {
                this._curClazz = this._curClazz.i_ancestor;
                this._curIdx = 0;
            }
            return this._curClazz != null && this.indexInRange();
        }

        public void reset() {
            this._curClazz = null;
            this._curIdx = -1;
        }

        private boolean indexInRange() {
            return this._curIdx < this._curClazz.i_fields.length;
        }
    }
}

