/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.services;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;

public class ContextService
implements FocusListener {
    private static final String RSSOWL_NAVIGATION_CONTEXT = "org.rssowl.ui.NavigationContext";
    private IContextActivation fActivateContext;
    private IContextService fContextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
    private boolean fNavigationContextActive;

    public ContextService() {
        this.activateNavigationContext();
    }

    public void registerInputField(Control control) {
        control.addFocusListener((FocusListener)this);
    }

    public void focusGained(FocusEvent e) {
        this.deactivateNavigationContext();
    }

    public void focusLost(FocusEvent e) {
        this.activateNavigationContext();
    }

    private void activateNavigationContext() {
        if (this.fNavigationContextActive) {
            return;
        }
        this.fActivateContext = this.fContextService.activateContext(RSSOWL_NAVIGATION_CONTEXT);
        this.fNavigationContextActive = true;
    }

    private void deactivateNavigationContext() {
        if (!this.fNavigationContextActive) {
            return;
        }
        this.fContextService.deactivateContext(this.fActivateContext);
        this.fNavigationContextActive = false;
    }
}

