/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.notifier;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.event.BookMarkAdapter;
import org.rssowl.core.persist.event.BookMarkEvent;
import org.rssowl.core.persist.event.BookMarkListener;
import org.rssowl.core.persist.event.EntityListener;
import org.rssowl.core.persist.event.FolderAdapter;
import org.rssowl.core.persist.event.FolderEvent;
import org.rssowl.core.persist.event.FolderListener;
import org.rssowl.core.persist.event.NewsAdapter;
import org.rssowl.core.persist.event.NewsEvent;
import org.rssowl.core.persist.event.NewsListener;
import org.rssowl.core.persist.event.SearchMarkAdapter;
import org.rssowl.core.persist.event.SearchMarkEvent;
import org.rssowl.core.persist.event.SearchMarkListener;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.BatchedBuffer;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.ui.internal.ApplicationWorkbenchAdvisor;
import org.rssowl.ui.internal.ApplicationWorkbenchWindowAdvisor;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.notifier.NewsNotificationItem;
import org.rssowl.ui.internal.notifier.NotificationItem;
import org.rssowl.ui.internal.notifier.NotificationPopup;
import org.rssowl.ui.internal.notifier.SearchNotificationItem;
import org.rssowl.ui.internal.util.JobRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationService {
    private static final int BATCH_INTERVAL = 5000;
    private final NewsListener fNewsListener;
    private final SearchMarkListener fSearchMarkListener;
    private final BookMarkListener fBookMarkListener;
    private final FolderListener fFolderListener;
    private final IPreferenceScope fGlobalPreferences;
    private final BatchedBuffer<NotificationItem> fBatchedBuffer;
    private final Map<String, Boolean> fNotifierEnablementCache = new ConcurrentHashMap<String, Boolean>();
    private static NotificationPopup fgNotificationPopup;
    private static long fgLastNotificationPopupCloseTime;

    public NotificationService() {
        BatchedBuffer.Receiver<NotificationItem> receiver = new BatchedBuffer.Receiver<NotificationItem>(){

            public IStatus receive(Collection<NotificationItem> items, Job job, IProgressMonitor monitor) {
                if (!monitor.isCanceled()) {
                    NotificationService.this.showItems(items, Mode.INCOMING_AUTOMATIC, monitor);
                }
                return Status.OK_STATUS;
            }
        };
        this.fBatchedBuffer = new BatchedBuffer((BatchedBuffer.Receiver)receiver, 5000);
        this.fGlobalPreferences = Owl.getPreferenceService().getGlobalScope();
        this.fNewsListener = this.registerNewsListener();
        this.fSearchMarkListener = this.registerSearchMarkListener();
        this.fBookMarkListener = this.registerBookMarkListener();
        this.fFolderListener = this.registerFolderListener();
    }

    public void stopService() {
        this.fBatchedBuffer.cancel(false);
        DynamicDAO.removeEntityListener(INews.class, (EntityListener)this.fNewsListener);
        DynamicDAO.removeEntityListener(ISearchMark.class, (EntityListener)this.fSearchMarkListener);
        DynamicDAO.removeEntityListener(IBookMark.class, (EntityListener)this.fBookMarkListener);
        DynamicDAO.removeEntityListener(IFolder.class, (EntityListener)this.fFolderListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySettingsChanged() {
        Map<String, Boolean> map = this.fNotifierEnablementCache;
        synchronized (map) {
            this.fNotifierEnablementCache.clear();
        }
    }

    public void show(List<INews> news, RGB color, Mode mode) {
        this.show(news, color, mode, false);
    }

    public void show(List<INews> news, RGB color, Mode mode, boolean direct) {
        TreeSet<NotificationItem> items = new TreeSet<NotificationItem>();
        for (INews newsitem : news) {
            items.add(new NewsNotificationItem(newsitem, color));
        }
        if (!direct && !this.isPopupVisible() && mode == Mode.INCOMING_AUTOMATIC) {
            this.fBatchedBuffer.addAll(items);
        } else {
            this.showItems(items, mode, null);
        }
    }

    public synchronized boolean isPopupVisible() {
        return fgNotificationPopup != null;
    }

    public boolean wasPopupRecentlyClosed() {
        return System.currentTimeMillis() - fgLastNotificationPopupCloseTime < 300L;
    }

    public synchronized void closePopup() {
        NotificationPopup popup = fgNotificationPopup;
        if (popup != null) {
            popup.doClose();
        }
    }

    private NewsListener registerNewsListener() {
        NewsAdapter listener = new NewsAdapter(){

            public void entitiesAdded(Set<NewsEvent> events) {
                if (!Controller.getDefault().isShuttingDown()) {
                    NotificationService.this.onNewsAdded(events);
                }
            }
        };
        DynamicDAO.addEntityListener(INews.class, (EntityListener)listener);
        return listener;
    }

    private BookMarkListener registerBookMarkListener() {
        BookMarkAdapter listener = new BookMarkAdapter(){

            public void entitiesUpdated(Set<BookMarkEvent> events) {
                for (BookMarkEvent event : events) {
                    if (!event.isRoot() || event.getOldParent() == null) continue;
                    NotificationService.this.notifySettingsChanged();
                    break;
                }
            }
        };
        DynamicDAO.addEntityListener(IBookMark.class, (EntityListener)listener);
        return listener;
    }

    private FolderListener registerFolderListener() {
        FolderAdapter listener = new FolderAdapter(){

            public void entitiesUpdated(Set<FolderEvent> events) {
                for (FolderEvent event : events) {
                    if (!event.isRoot() || event.getOldParent() == null) continue;
                    NotificationService.this.notifySettingsChanged();
                    break;
                }
            }
        };
        DynamicDAO.addEntityListener(IFolder.class, (EntityListener)listener);
        return listener;
    }

    private SearchMarkListener registerSearchMarkListener() {
        SearchMarkAdapter listener = new SearchMarkAdapter(){

            public void newsChanged(Set<SearchMarkEvent> events) {
                if (!Controller.getDefault().isShuttingDown()) {
                    NotificationService.this.onNewsChanged(events);
                }
            }
        };
        DynamicDAO.addEntityListener(ISearchMark.class, (EntityListener)listener);
        return listener;
    }

    private void onNewsChanged(Set<SearchMarkEvent> events) {
        if (!this.fGlobalPreferences.getBoolean(DefaultPreferences.SHOW_NOTIFICATION_POPUP)) {
            return;
        }
        HashSet<SearchMarkEvent> filteredEvents = new HashSet<SearchMarkEvent>(events.size());
        if (this.fGlobalPreferences.getBoolean(DefaultPreferences.LIMIT_NOTIFIER_TO_SELECTION)) {
            for (SearchMarkEvent event : events) {
                IPreferenceScope prefs;
                if (!event.isAddedNewNews() || !(prefs = Owl.getPreferenceService().getEntityScope((IEntity)event.getEntity())).getBoolean(DefaultPreferences.ENABLE_NOTIFIER)) continue;
                filteredEvents.add(event);
            }
        } else {
            block1: for (SearchMarkEvent event : events) {
                ISearchMark searchmark = event.getEntity();
                List conditions = searchmark.getSearchConditions();
                if (!event.isAddedNewNews()) continue;
                for (ISearchCondition condition : conditions) {
                    if (!(condition.getValue() instanceof String) || condition.getField().getId() == 15) continue;
                    filteredEvents.add(event);
                    continue block1;
                }
            }
        }
        TreeSet<NotificationItem> items = new TreeSet<NotificationItem>();
        for (SearchMarkEvent event : filteredEvents) {
            items.add(new SearchNotificationItem(event.getEntity(), event.getEntity().getNewsCount(EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED))));
        }
        if (!this.isPopupVisible()) {
            this.fBatchedBuffer.addAll(items);
        } else {
            this.showItems(items, Mode.INCOMING_AUTOMATIC, null);
        }
    }

    private void onNewsAdded(final Set<NewsEvent> events) {
        if (!this.fGlobalPreferences.getBoolean(DefaultPreferences.SHOW_NOTIFICATION_POPUP)) {
            return;
        }
        if (!CoreUtils.containsState(events, (INews.State)INews.State.NEW)) {
            return;
        }
        final Runnable runnable = new Runnable(){

            public void run() {
                Set eventsToShow = events;
                if (NotificationService.this.fGlobalPreferences.getBoolean(DefaultPreferences.LIMIT_NOTIFIER_TO_SELECTION)) {
                    eventsToShow = NotificationService.this.filterEvents(eventsToShow);
                }
                TreeSet<NewsNotificationItem> items = new TreeSet<NewsNotificationItem>();
                for (NewsEvent event : eventsToShow) {
                    INews news = event.getEntity();
                    if (!news.getState().equals((Object)INews.State.NEW)) continue;
                    items.add(new NewsNotificationItem(news));
                }
                if (items.isEmpty()) {
                    return;
                }
                if (!NotificationService.this.isPopupVisible()) {
                    NotificationService.this.fBatchedBuffer.addAll(items);
                } else {
                    NotificationService.this.showItems(items, Mode.INCOMING_AUTOMATIC, null);
                }
            }
        };
        if (this.fGlobalPreferences.getBoolean(DefaultPreferences.SHOW_NOTIFICATION_POPUP_ONLY_WHEN_MINIMIZED)) {
            Shell primaryShell = OwlUI.getPrimaryShell();
            if (primaryShell != null) {
                JobRunner.runInUIThread((Widget)primaryShell, new Runnable(){

                    public void run() {
                        if (Controller.getDefault().isShuttingDown()) {
                            return;
                        }
                        ApplicationWorkbenchWindowAdvisor advisor = ApplicationWorkbenchAdvisor.fgPrimaryApplicationWorkbenchWindowAdvisor;
                        if (advisor != null && !advisor.isMinimizedToTray() && !advisor.isMinimized()) {
                            return;
                        }
                        JobRunner.runInBackgroundThread(runnable);
                    }
                });
            }
        } else {
            runnable.run();
        }
    }

    public boolean shouldShow(INews news) {
        if (!this.fGlobalPreferences.getBoolean(DefaultPreferences.LIMIT_NOTIFIER_TO_SELECTION)) {
            return true;
        }
        return this.shouldShow(news.getFeedLinkAsText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldShow(String feedLink) {
        Map<String, Boolean> map = this.fNotifierEnablementCache;
        synchronized (map) {
            Boolean notifierEnabled;
            if (!this.fNotifierEnablementCache.containsKey(feedLink)) {
                this.updateEnabledFeedCache();
            }
            if ((notifierEnabled = this.fNotifierEnablementCache.get(feedLink)) == null) {
                notifierEnabled = false;
                this.fNotifierEnablementCache.put(feedLink, notifierEnabled);
            }
            return notifierEnabled;
        }
    }

    private Set<NewsEvent> filterEvents(Set<NewsEvent> events) {
        HashSet<NewsEvent> filteredEvents = new HashSet<NewsEvent>();
        for (NewsEvent event : events) {
            if (!event.getEntity().isVisible() || !this.shouldShow(event.getEntity().getFeedLinkAsText())) continue;
            filteredEvents.add(event);
        }
        return filteredEvents;
    }

    private void updateEnabledFeedCache() {
        Collection bookMarks = DynamicDAO.loadAll(IBookMark.class);
        for (IBookMark bookMark : bookMarks) {
            IPreferenceScope prefs = Owl.getPreferenceService().getEntityScope((IEntity)bookMark);
            this.fNotifierEnablementCache.put(bookMark.getFeedLinkReference().getLinkAsText(), prefs.getBoolean(DefaultPreferences.ENABLE_NOTIFIER));
        }
    }

    private void showItems(final Collection<NotificationItem> items, final Mode mode, final IProgressMonitor monitor) {
        if (items.isEmpty()) {
            return;
        }
        JobRunner.runInUIThread((Widget)OwlUI.getPrimaryShell(), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean minimized;
                if (Controller.getDefault().isShuttingDown() || monitor != null && monitor.isCanceled()) {
                    return;
                }
                ApplicationWorkbenchWindowAdvisor advisor = ApplicationWorkbenchAdvisor.fgPrimaryApplicationWorkbenchWindowAdvisor;
                boolean bl = minimized = advisor != null && (advisor.isMinimizedToTray() || advisor.isMinimized());
                if (!minimized && NotificationService.this.fGlobalPreferences.getBoolean(DefaultPreferences.SHOW_NOTIFICATION_POPUP_ONLY_WHEN_MINIMIZED)) {
                    return;
                }
                NotificationService notificationService = NotificationService.this;
                synchronized (notificationService) {
                    if (fgNotificationPopup == null) {
                        fgNotificationPopup = new NotificationPopup(items.size(), mode){

                            public boolean doClose() {
                                fgNotificationPopup = null;
                                fgLastNotificationPopupCloseTime = System.currentTimeMillis();
                                return super.doClose();
                            }
                        };
                        try {
                            fgNotificationPopup.open(items);
                        }
                        catch (Exception exception) {
                            fgNotificationPopup = null;
                        }
                    } else if (mode == Mode.INCOMING_AUTOMATIC) {
                        fgNotificationPopup.makeVisible(items);
                    }
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        INCOMING_AUTOMATIC,
        INCOMING_MANUAL,
        RECENT;

    }
}

