/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.filter;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.rssowl.core.INewsAction;
import org.rssowl.core.persist.IAttachment;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.INews;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.filter.Messages;
import org.rssowl.ui.internal.services.DownloadService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadAttachmentsNewsAction
implements INewsAction {
    public static final String ID = "org.rssowl.ui.DownloadAttachmentsNewsAction";

    public List<IEntity> run(List<INews> news, Map<INews, INews> replacements, Object data) {
        File folder;
        news = CoreUtils.replace(news, replacements);
        if (data != null && data instanceof String && (folder = new File((String)data)).exists()) {
            for (INews newsitem : news) {
                String newslink;
                List attachments = newsitem.getAttachments();
                for (IAttachment attachment : attachments) {
                    URI link = attachment.getLink();
                    if (link != null && !link.isAbsolute()) {
                        try {
                            link = URIUtils.resolve((URI)URIUtils.toHTTP((URI)newsitem.getFeedReference().getLink()), (URI)link);
                        }
                        catch (URISyntaxException e) {
                            Activator.safeLogError(e.getMessage(), e);
                            continue;
                        }
                    }
                    if (link == null) continue;
                    Controller.getDefault().getDownloadService().download(DownloadService.DownloadRequest.createAttachmentDownloadRequest(attachment, link, folder, false, null));
                }
                if (!attachments.isEmpty() || !StringUtils.isSet((String)(newslink = CoreUtils.getLink((INews)newsitem))) || newslink.endsWith(".html")) continue;
                try {
                    Controller.getDefault().getDownloadService().download(DownloadService.DownloadRequest.createNewsDownloadRequest(newsitem, new URI(newslink), folder));
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }
        return Collections.emptyList();
    }

    public boolean conflictsWith(INewsAction otherAction) {
        return false;
    }

    public String getLabel(Object data) {
        if (data != null && data instanceof String) {
            return NLS.bind((String)Messages.DownloadAttachmentsNewsAction_DOWNLOAD_TO_N, (Object)data);
        }
        return null;
    }
}

