/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.keys.IBindingService;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.ApplicationActionBarAdvisor;
import org.rssowl.ui.internal.ContextMenuCreator;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.Messages;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.ArchiveNewsAction;
import org.rssowl.ui.internal.actions.AutomateFilterAction;
import org.rssowl.ui.internal.actions.CreateFilterAction;
import org.rssowl.ui.internal.actions.DeleteTypesAction;
import org.rssowl.ui.internal.actions.ExportAction;
import org.rssowl.ui.internal.actions.ImportAction;
import org.rssowl.ui.internal.actions.MakeNewsStickyAction;
import org.rssowl.ui.internal.actions.MarkAllNewsReadAction;
import org.rssowl.ui.internal.actions.MoveCopyNewsToBinAction;
import org.rssowl.ui.internal.actions.NavigationActionFactory;
import org.rssowl.ui.internal.actions.NewBookMarkAction;
import org.rssowl.ui.internal.actions.NewFolderAction;
import org.rssowl.ui.internal.actions.NewNewsBinAction;
import org.rssowl.ui.internal.actions.NewSearchMarkAction;
import org.rssowl.ui.internal.actions.NewTypeDropdownAction;
import org.rssowl.ui.internal.actions.OpenInBrowserAction;
import org.rssowl.ui.internal.actions.RedoAction;
import org.rssowl.ui.internal.actions.ReloadAllAction;
import org.rssowl.ui.internal.actions.ReloadTypesAction;
import org.rssowl.ui.internal.actions.SearchFeedsAction;
import org.rssowl.ui.internal.actions.SearchNewsAction;
import org.rssowl.ui.internal.actions.ShowActivityAction;
import org.rssowl.ui.internal.actions.ToggleReadStateAction;
import org.rssowl.ui.internal.actions.UndoAction;
import org.rssowl.ui.internal.editors.browser.WebBrowserContext;
import org.rssowl.ui.internal.editors.feed.FeedView;
import org.rssowl.ui.internal.editors.feed.FeedViewInput;
import org.rssowl.ui.internal.undo.IUndoRedoListener;
import org.rssowl.ui.internal.undo.UndoStack;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.ModelUtils;
import org.rssowl.ui.internal.views.explorer.BookMarkExplorer;

public class CoolBarAdvisor {
    private static final String SEPARATOR_ID = "org.rssowl.ui.CoolBarSeparator";
    private static final String SPACER_ID = "org.rssowl.ui.CoolBarSpacer";
    private final IWorkbenchWindow fWindow;
    private final ICoolBarManager fManager;
    private final IPreferenceScope fPreferences;
    private final AtomicInteger fLoadCounter = new AtomicInteger();
    private final IBindingService fBindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);

    public CoolBarAdvisor(ICoolBarManager manager, IWorkbenchWindow window) {
        this.fManager = manager;
        this.fWindow = window;
        this.fPreferences = Owl.getPreferenceService().getGlobalScope();
        this.registerListeners();
    }

    private void registerListeners() {
        UndoStack.getInstance().addListener(new IUndoRedoListener(){

            public void undoPerformed() {
                CoolBarAdvisor.this.update(CoolBarItem.UNDO, null, null, true);
                CoolBarAdvisor.this.update(CoolBarItem.REDO, null, null, true);
            }

            public void redoPerformed() {
                CoolBarAdvisor.this.update(CoolBarItem.UNDO, null, null, true);
                CoolBarAdvisor.this.update(CoolBarItem.REDO, null, null, true);
            }

            public void operationAdded() {
                CoolBarAdvisor.this.update(CoolBarItem.UNDO, null, null, true);
                CoolBarAdvisor.this.update(CoolBarItem.REDO, null, null, true);
            }
        });
        Controller.getDefault().addBookMarkLoadListener(new Controller.BookMarkLoadListener(){

            public void bookMarkAboutToLoad(IBookMark bookmark) {
                if (CoolBarAdvisor.this.fLoadCounter.incrementAndGet() > 0) {
                    CoolBarAdvisor.this.update(CoolBarItem.STOP, null, null, true);
                }
            }

            public void bookMarkDoneLoading(IBookMark bookmark) {
                if (CoolBarAdvisor.this.fLoadCounter.decrementAndGet() == 0) {
                    CoolBarAdvisor.this.update(CoolBarItem.STOP, null, null, true);
                }
            }
        });
        final ISelectionListener selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                CoolBarAdvisor.this.update(CoolBarItem.MARK_READ, selection, part, false);
                CoolBarAdvisor.this.update(CoolBarItem.MOVE, selection, part, false);
                CoolBarAdvisor.this.update(CoolBarItem.COPY, selection, part, false);
                CoolBarAdvisor.this.update(CoolBarItem.STICKY, selection, part, false);
                CoolBarAdvisor.this.update(CoolBarItem.DELETE, selection, part, false);
                CoolBarAdvisor.this.update(CoolBarItem.OPEN, selection, part, false);
                CoolBarAdvisor.this.update(CoolBarItem.UPDATE, selection, part, false);
                CoolBarAdvisor.this.update(CoolBarItem.ATTACHMENTS, selection, part, false);
                CoolBarAdvisor.this.update(CoolBarItem.ARCHIVE, selection, part, false);
            }
        };
        final IPartListener partListener = new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
                if (part instanceof IEditorPart) {
                    CoolBarAdvisor.this.update(CoolBarItem.CLOSE, null, part, false);
                    CoolBarAdvisor.this.update(CoolBarItem.CLOSE_OTHERS, null, part, false);
                    CoolBarAdvisor.this.update(CoolBarItem.CLOSE_ALL, null, part, false);
                }
                if (part instanceof FeedView) {
                    CoolBarAdvisor.this.update(CoolBarItem.SAVE_AS, null, part, false);
                    CoolBarAdvisor.this.update(CoolBarItem.PRINT, null, part, false);
                    CoolBarAdvisor.this.update(CoolBarItem.MARK_ALL_READ, null, part, false);
                }
                if (part instanceof BookMarkExplorer) {
                    CoolBarAdvisor.this.update(CoolBarItem.BOOKMARK_VIEW, null, part, false);
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part instanceof IEditorPart) {
                    CoolBarAdvisor.this.update(CoolBarItem.CLOSE, null, part, false);
                    CoolBarAdvisor.this.update(CoolBarItem.CLOSE_OTHERS, null, part, false);
                    CoolBarAdvisor.this.update(CoolBarItem.CLOSE_ALL, null, part, false);
                }
                if (OwlUI.getEditorReferences().isEmpty()) {
                    CoolBarAdvisor.this.update(CoolBarItem.SAVE_AS, null, null, false);
                    CoolBarAdvisor.this.update(CoolBarItem.PRINT, null, null, false);
                    CoolBarAdvisor.this.update(CoolBarItem.MARK_ALL_READ, null, null, false);
                }
                if (part instanceof BookMarkExplorer) {
                    CoolBarAdvisor.this.update(CoolBarItem.BOOKMARK_VIEW, null, null, false);
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
                CoolBarAdvisor.this.update(CoolBarItem.CLOSE, null, part, false);
                CoolBarAdvisor.this.update(CoolBarItem.CLOSE_OTHERS, null, part, false);
                CoolBarAdvisor.this.update(CoolBarItem.CLOSE_ALL, null, part, false);
                CoolBarAdvisor.this.update(CoolBarItem.SAVE_AS, null, part, false);
                CoolBarAdvisor.this.update(CoolBarItem.PRINT, null, part, false);
                CoolBarAdvisor.this.update(CoolBarItem.MARK_ALL_READ, null, part, false);
            }

            public void partActivated(IWorkbenchPart part) {
                CoolBarAdvisor.this.update(CoolBarItem.SAVE_AS, null, part, false);
                CoolBarAdvisor.this.update(CoolBarItem.PRINT, null, part, false);
                CoolBarAdvisor.this.update(CoolBarItem.MARK_ALL_READ, null, part, false);
                CoolBarAdvisor.this.update(CoolBarItem.CLOSE, null, part, false);
                CoolBarAdvisor.this.update(CoolBarItem.CLOSE_OTHERS, null, part, false);
                CoolBarAdvisor.this.update(CoolBarItem.CLOSE_ALL, null, part, false);
            }
        };
        this.fWindow.addPageListener(new IPageListener(){

            public void pageOpened(IWorkbenchPage page) {
                page.addSelectionListener(selectionListener);
                page.addPartListener(partListener);
                IWorkbenchPart activePart = page.getActivePart();
                CoolBarAdvisor.this.updateActions(activePart);
                JobRunner.runDelayedInUIThread((Widget)CoolBarAdvisor.this.fWindow.getShell(), new Runnable(){

                    public void run() {
                        CoolBarAdvisor.this.update(CoolBarItem.NEXT, null, null, false);
                        CoolBarAdvisor.this.update(CoolBarItem.PREVIOUS, null, null, false);
                    }
                });
            }

            public void pageClosed(IWorkbenchPage page) {
                page.removeSelectionListener(selectionListener);
                page.removePartListener(partListener);
            }

            public void pageActivated(IWorkbenchPage page) {
            }
        });
    }

    public void advise() {
        this.advise(false);
    }

    public void advise(boolean fromUpdate) {
        CoolBar barControl = null;
        if (this.fManager instanceof CoolBarManager) {
            barControl = ((CoolBarManager)this.fManager).getControl();
        }
        if (barControl != null && fromUpdate) {
            barControl.getShell().setRedraw(false);
        }
        try {
            this.fManager.removeAll();
            CoolBarMode mode = CoolBarMode.values()[this.fPreferences.getInteger(DefaultPreferences.TOOLBAR_MODE)];
            int[] items = this.fPreferences.getIntegers(DefaultPreferences.TOOLBAR_ITEMS);
            if (items == null || items.length == 0) {
                items = new int[]{CoolBarItem.SPACER.ordinal()};
            }
            ToolBarManager currentToolBar = new ToolBarManager(mode == CoolBarMode.IMAGE_TEXT_HORIZONTAL ? 0x820000 : 0x800000);
            int[] nArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                CoolBarItem item = CoolBarItem.values()[id];
                if (item != null) {
                    ActionContributionItem contribItem;
                    if (item == CoolBarItem.SEPARATOR) {
                        this.fManager.add((IToolBarManager)currentToolBar);
                        currentToolBar = new ToolBarManager(mode == CoolBarMode.IMAGE_TEXT_HORIZONTAL ? 0x820000 : 0x800000);
                    } else if (item == CoolBarItem.SPACER) {
                        contribItem = new ActionContributionItem((IAction)new Action(""){

                            public boolean isEnabled() {
                                return false;
                            }
                        });
                        currentToolBar.add((IContributionItem)contribItem);
                    } else {
                        contribItem = new CoolBarActionContributionitem(item, (IAction)this.getAction(item, mode, currentToolBar));
                        contribItem.setId(item.getId());
                        if (mode == CoolBarMode.IMAGE_TEXT_HORIZONTAL || mode == CoolBarMode.IMAGE_TEXT_VERTICAL) {
                            contribItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
                        }
                        currentToolBar.add((IContributionItem)contribItem);
                    }
                }
                ++n2;
            }
            this.fManager.add((IToolBarManager)currentToolBar);
            if (fromUpdate) {
                this.fManager.update(true);
                if (barControl != null) {
                    boolean isLocked = barControl.getLocked();
                    barControl.setLocked(!isLocked);
                    barControl.setLocked(isLocked);
                }
                this.updateActions(OwlUI.getActivePart(this.fWindow));
            }
        }
        finally {
            if (barControl != null && fromUpdate) {
                barControl.getShell().setRedraw(true);
            }
        }
    }

    private Action getAction(final CoolBarItem item, final CoolBarMode mode, final ToolBarManager manager) {
        Action action = new Action(item.getName(), item.getStyle()){

            public String getId() {
                return item.getId();
            }

            public String getActionDefinitionId() {
                return item.hasCommand() ? item.getId() : null;
            }

            public ImageDescriptor getImageDescriptor() {
                return mode == CoolBarMode.TEXT ? null : item.getImg();
            }

            public ImageDescriptor getDisabledImageDescriptor() {
                return mode == CoolBarMode.TEXT ? null : item.getDisabledImg();
            }

            public void run() {
                CoolBarAdvisor.this.run(this, item, manager);
            }
        };
        action.setToolTipText(item.getTooltip());
        action.setMenuCreator((IMenuCreator)this.getMenu(item));
        return action;
    }

    private void updateActions(IWorkbenchPart activePart) {
        CoolBarItem[] items;
        ISelection selection = null;
        if (activePart != null && activePart.getSite() != null && activePart.getSite().getSelectionProvider() != null) {
            selection = activePart.getSite().getSelectionProvider().getSelection();
        }
        CoolBarItem[] coolBarItemArray = items = CoolBarItem.values();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CoolBarItem item = coolBarItemArray[n2];
            this.update(item, (ISelection)(selection != null ? selection : StructuredSelection.EMPTY), activePart, false);
            ++n2;
        }
    }

    private void update(IAction action, CoolBarItem item, ISelection selection, IWorkbenchPart part) {
        switch (item) {
            case UNDO: {
                action.setEnabled(UndoStack.getInstance().isUndoSupported());
                action.setToolTipText(UndoStack.getInstance().getUndoName());
                break;
            }
            case REDO: {
                action.setEnabled(UndoStack.getInstance().isRedoSupported());
                action.setToolTipText(UndoStack.getInstance().getRedoName());
                break;
            }
            case STOP: {
                action.setEnabled(this.fLoadCounter.get() != 0);
                break;
            }
            case MARK_READ: {
                action.setEnabled(part instanceof FeedView && !selection.isEmpty());
                break;
            }
            case MOVE: {
                action.setEnabled(part instanceof FeedView && !selection.isEmpty());
                break;
            }
            case COPY: {
                action.setEnabled(part instanceof FeedView && !selection.isEmpty());
                break;
            }
            case STICKY: {
                action.setEnabled(part instanceof FeedView && !selection.isEmpty());
                break;
            }
            case OPEN: {
                action.setEnabled(part instanceof FeedView && !selection.isEmpty() && !ModelUtils.isEntityGroupSelected(selection));
                break;
            }
            case UPDATE: {
                action.setEnabled(!selection.isEmpty() || OwlUI.getActiveFeedView() != null);
                break;
            }
            case SAVE_AS: {
                action.setEnabled(part instanceof FeedView || OwlUI.getActiveFeedView() != null);
                break;
            }
            case PRINT: {
                if (!Application.IS_MAC) {
                    action.setEnabled(part instanceof FeedView || OwlUI.getActiveFeedView() != null);
                    break;
                }
                action.setEnabled(false);
                break;
            }
            case MARK_ALL_READ: {
                action.setEnabled(part instanceof FeedView || OwlUI.getActiveFeedView() != null);
                break;
            }
            case CLOSE: {
                action.setEnabled(!OwlUI.getEditorReferences().isEmpty());
                break;
            }
            case CLOSE_OTHERS: {
                action.setEnabled(OwlUI.getEditorReferences().size() > 1);
                break;
            }
            case CLOSE_ALL: {
                action.setEnabled(!OwlUI.getEditorReferences().isEmpty());
                break;
            }
            case BOOKMARK_VIEW: {
                action.setChecked(part instanceof BookMarkExplorer || OwlUI.getOpenedBookMarkExplorer() != null);
                break;
            }
            case NEXT: {
                NavigationActionFactory.NavigationActionType type = NavigationActionFactory.NavigationActionType.values()[this.fPreferences.getInteger(DefaultPreferences.DEFAULT_NEXT_ACTION)];
                action.setToolTipText(this.getLabelWithBinding(type.getCommandId(), type.getName(), true));
                break;
            }
            case PREVIOUS: {
                NavigationActionFactory.NavigationActionType type = NavigationActionFactory.NavigationActionType.values()[this.fPreferences.getInteger(DefaultPreferences.DEFAULT_PREVIOUS_ACTION)];
                action.setToolTipText(this.getLabelWithBinding(type.getCommandId(), type.getName(), true));
                break;
            }
            case DELETE: {
                action.setEnabled(part instanceof FeedView && !selection.isEmpty());
                break;
            }
            case ATTACHMENTS: {
                boolean enabled = false;
                if (part instanceof FeedView && !selection.isEmpty()) {
                    Collection<INews> selectedNews = ModelUtils.normalize(((IStructuredSelection)selection).toList());
                    for (INews news : selectedNews) {
                        if (news.getAttachments().isEmpty()) continue;
                        enabled = true;
                        break;
                    }
                }
                action.setEnabled(enabled);
                break;
            }
            case ARCHIVE: {
                action.setEnabled(part instanceof FeedView && !selection.isEmpty());
            }
        }
    }

    private void update(final CoolBarItem coolBarItem, final ISelection selection, final IWorkbenchPart part, boolean ensureUIThread) {
        if (Controller.getDefault().isShuttingDown()) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                CoolBarActionContributionitem item = CoolBarAdvisor.this.find(coolBarItem.getId());
                if (item != null) {
                    item.update((ISelection)(selection != null ? selection : StructuredSelection.EMPTY), part);
                }
            }
        };
        if (ensureUIThread) {
            JobRunner.runInUIThread((Widget)this.fWindow.getShell(), runnable);
        } else {
            runnable.run();
        }
    }

    private CoolBarActionContributionitem find(String id) {
        IContributionItem[] items;
        IContributionItem[] iContributionItemArray = items = this.fManager.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem result;
            IToolBarManager toolBarManager;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ToolBarContributionItem && (toolBarManager = ((ToolBarContributionItem)item).getToolBarManager()) != null && (result = toolBarManager.find(id)) != null && result instanceof CoolBarActionContributionitem) {
                return (CoolBarActionContributionitem)result;
            }
            ++n2;
        }
        return null;
    }

    private void run(Action wrappingAction, CoolBarItem item, ToolBarManager manager) {
        switch (item) {
            case NEW: {
                NewTypeDropdownAction action = new NewTypeDropdownAction();
                this.initWithExplorerSelectionAndRunAction((IWorkbenchWindowActionDelegate)action);
                break;
            }
            case IMPORT: {
                ImportAction action = new ImportAction();
                action.init(this.fWindow);
                action.run(null);
                break;
            }
            case EXPORT: {
                ExportAction action = new ExportAction();
                action.init(this.fWindow);
                action.run(null);
                break;
            }
            case UNDO: {
                UndoAction action = new UndoAction();
                action.run();
                break;
            }
            case REDO: {
                RedoAction action = new RedoAction();
                action.run();
                break;
            }
            case SEARCH: {
                SearchNewsAction action = new SearchNewsAction();
                action.init(this.fWindow);
                action.run(null);
                break;
            }
            case UPDATE_ALL: {
                ReloadAllAction action = new ReloadAllAction();
                action.init(this.fWindow);
                action.run(null);
                break;
            }
            case UPDATE: {
                IStructuredSelection activeSelection = OwlUI.getActiveSelection();
                ReloadTypesAction action = new ReloadTypesAction(activeSelection, this.fWindow.getShell());
                action.run(null);
                break;
            }
            case STOP: {
                Controller.getDefault().stopUpdate();
                wrappingAction.setEnabled(false);
                break;
            }
            case MARK_READ: {
                IStructuredSelection selection = OwlUI.getActiveFeedViewSelection();
                if (selection == null || selection.isEmpty()) break;
                ToggleReadStateAction action = new ToggleReadStateAction(selection);
                action.init(this.fWindow);
                action.run();
                break;
            }
            case MARK_ALL_READ: {
                MarkAllNewsReadAction action = new MarkAllNewsReadAction();
                action.init(this.fWindow);
                action.run(null);
                break;
            }
            case NEXT: {
                NavigationActionFactory.NavigationActionType defaultAction = NavigationActionFactory.NavigationActionType.values()[this.fPreferences.getInteger(DefaultPreferences.DEFAULT_NEXT_ACTION)];
                NavigationActionFactory.NavigationAction action = new NavigationActionFactory.NavigationAction(defaultAction);
                action.init(this.fWindow);
                action.run(null);
                break;
            }
            case PREVIOUS: {
                NavigationActionFactory.NavigationActionType defaultAction = NavigationActionFactory.NavigationActionType.values()[this.fPreferences.getInteger(DefaultPreferences.DEFAULT_PREVIOUS_ACTION)];
                NavigationActionFactory.NavigationAction action = new NavigationActionFactory.NavigationAction(defaultAction);
                action.init(this.fWindow);
                action.run(null);
                break;
            }
            case NEW_BOOKMARK: {
                NewBookMarkAction action = new NewBookMarkAction();
                this.initWithExplorerSelectionAndRunAction(action);
                break;
            }
            case NEW_BIN: {
                NewNewsBinAction action = new NewNewsBinAction();
                this.initWithExplorerSelectionAndRunAction(action);
                break;
            }
            case NEW_SAVED_SEARCH: {
                NewSearchMarkAction action = new NewSearchMarkAction();
                this.initWithExplorerSelectionAndRunAction(action);
                break;
            }
            case NEW_FOLDER: {
                NewFolderAction action = new NewFolderAction();
                this.initWithExplorerSelectionAndRunAction(action);
                break;
            }
            case CLOSE: {
                ActionFactory.IWorkbenchAction action = ActionFactory.CLOSE.create(this.fWindow);
                action.run();
                break;
            }
            case CLOSE_OTHERS: {
                IEditorReference[] refArray;
                IWorkbenchPage page = this.fWindow.getActivePage();
                if (page == null || (refArray = page.getEditorReferences()) == null || refArray.length <= 1) break;
                IEditorReference[] otherEditors = new IEditorReference[refArray.length - 1];
                IEditorReference activeEditor = (IEditorReference)page.getReference((IWorkbenchPart)page.getActiveEditor());
                int i = 0;
                while (i < refArray.length) {
                    if (refArray[i] == activeEditor) {
                        System.arraycopy(refArray, 0, otherEditors, 0, i);
                        System.arraycopy(refArray, i + 1, otherEditors, i, refArray.length - 1 - i);
                        break;
                    }
                    ++i;
                }
                page.closeEditors(otherEditors, true);
                break;
            }
            case CLOSE_ALL: {
                ActionFactory.IWorkbenchAction action = ActionFactory.CLOSE_ALL.create(this.fWindow);
                action.run();
                break;
            }
            case OPEN: {
                IStructuredSelection selection = OwlUI.getActiveFeedViewSelection();
                FeedView feedView = OwlUI.getActiveFeedView();
                if (selection == null || selection.isEmpty() || feedView == null) break;
                OpenInBrowserAction action = new OpenInBrowserAction(selection, WebBrowserContext.createFrom((ISelection)selection, feedView));
                action.run();
                break;
            }
            case SAVE_AS: {
                FeedView activeFeedView = OwlUI.getActiveFeedView();
                if (activeFeedView == null) break;
                activeFeedView.doSaveAs();
                break;
            }
            case PRINT: {
                FeedView activeFeedView = OwlUI.getActiveFeedView();
                if (activeFeedView == null) break;
                activeFeedView.print();
                break;
            }
            case FULLSCREEN: {
                OwlUI.toggleFullScreen();
                wrappingAction.setChecked(this.fWindow.getShell().getFullScreen());
                break;
            }
            case BOOKMARK_VIEW: {
                OwlUI.toggleBookmarks();
                break;
            }
            case STICKY: {
                IStructuredSelection selection = OwlUI.getActiveFeedViewSelection();
                if (selection == null || selection.isEmpty()) break;
                new MakeNewsStickyAction(selection).run();
                break;
            }
            case FIND_MORE_FEEDS: {
                SearchFeedsAction action = new SearchFeedsAction();
                action.init(this.fWindow);
                action.run(null);
                break;
            }
            case ACTIVITIES: {
                ShowActivityAction action = new ShowActivityAction();
                action.init(this.fWindow);
                action.run(null);
                break;
            }
            case PREFERENCES: {
                ActionFactory.IWorkbenchAction action = ActionFactory.PREFERENCES.create(this.fWindow);
                action.run();
                break;
            }
            case HISTORY: {
                OwlUI.positionDropDownMenu(wrappingAction, manager);
                break;
            }
            case LABEL: {
                OwlUI.positionDropDownMenu(wrappingAction, manager);
                break;
            }
            case MOVE: {
                OwlUI.positionDropDownMenu(wrappingAction, manager);
                break;
            }
            case COPY: {
                OwlUI.positionDropDownMenu(wrappingAction, manager);
                break;
            }
            case SHARE: {
                OwlUI.positionDropDownMenu(wrappingAction, manager);
                break;
            }
            case BOOKMARKS: {
                OwlUI.positionDropDownMenu(wrappingAction, manager);
                break;
            }
            case DELETE: {
                IStructuredSelection selection = OwlUI.getActiveFeedViewSelection();
                if (selection == null || selection.isEmpty()) break;
                new DeleteTypesAction(this.fWindow.getShell(), selection).run();
                break;
            }
            case ATTACHMENTS: {
                OwlUI.positionDropDownMenu(wrappingAction, manager);
                break;
            }
            case ARCHIVE: {
                IStructuredSelection selection = OwlUI.getActiveFeedViewSelection();
                if (selection == null || selection.isEmpty()) break;
                new ArchiveNewsAction(selection).run();
            }
        }
    }

    private void initWithExplorerSelectionAndRunAction(IWorkbenchWindowActionDelegate action) {
        action.init(this.fWindow);
        IFolder folder = OwlUI.getBookMarkExplorerSelection();
        if (folder != null) {
            action.selectionChanged(null, (ISelection)new StructuredSelection((Object)folder));
        }
        action.run(null);
    }

    private ContextMenuCreator getMenu(CoolBarItem item) {
        if (!item.withDropDownMenu()) {
            return null;
        }
        switch (item) {
            case NEW: {
                return new ContextMenuCreator(){

                    public Menu createMenu(Control parent) {
                        NewTypeDropdownAction action = new NewTypeDropdownAction();
                        action.init(CoolBarAdvisor.this.fWindow);
                        IFolder folder = OwlUI.getBookMarkExplorerSelection();
                        if (folder != null) {
                            action.selectionChanged(null, (ISelection)new StructuredSelection((Object)folder));
                        }
                        return action.getMenu(parent);
                    }
                };
            }
            case NEXT: {
                return new ContextMenuCreator(){

                    public Menu createMenu(Control parent) {
                        Menu menu = new Menu(parent);
                        NavigationActionFactory.NavigationActionType defaultAction = NavigationActionFactory.NavigationActionType.values()[CoolBarAdvisor.this.fPreferences.getInteger(DefaultPreferences.DEFAULT_NEXT_ACTION)];
                        MenuItem item = new MenuItem(menu, 16);
                        item.setText(CoolBarAdvisor.this.getLabelWithBinding(NavigationActionFactory.NavigationActionType.NEXT_NEWS.getCommandId(), NavigationActionFactory.NavigationActionType.NEXT_NEWS.getName()));
                        item.setData((Object)NavigationActionFactory.NavigationActionType.NEXT_NEWS);
                        item.addSelectionListener((SelectionListener)new NavigationSelectionListener(true));
                        if (item.getData().equals((Object)defaultAction)) {
                            item.setSelection(true);
                        }
                        item = new MenuItem(menu, 16);
                        item.setText(CoolBarAdvisor.this.getLabelWithBinding(NavigationActionFactory.NavigationActionType.NEXT_UNREAD_NEWS.getCommandId(), NavigationActionFactory.NavigationActionType.NEXT_UNREAD_NEWS.getName()));
                        item.setData((Object)NavigationActionFactory.NavigationActionType.NEXT_UNREAD_NEWS);
                        item.addSelectionListener((SelectionListener)new NavigationSelectionListener(true));
                        if (item.getData().equals((Object)defaultAction)) {
                            item.setSelection(true);
                        }
                        new MenuItem(menu, 2);
                        item = new MenuItem(menu, 16);
                        item.setText(CoolBarAdvisor.this.getLabelWithBinding(NavigationActionFactory.NavigationActionType.NEXT_FEED.getCommandId(), NavigationActionFactory.NavigationActionType.NEXT_FEED.getName()));
                        item.setData((Object)NavigationActionFactory.NavigationActionType.NEXT_FEED);
                        item.addSelectionListener((SelectionListener)new NavigationSelectionListener(true));
                        if (item.getData().equals((Object)defaultAction)) {
                            item.setSelection(true);
                        }
                        item = new MenuItem(menu, 16);
                        item.setText(CoolBarAdvisor.this.getLabelWithBinding(NavigationActionFactory.NavigationActionType.NEXT_UNREAD_FEED.getCommandId(), NavigationActionFactory.NavigationActionType.NEXT_UNREAD_FEED.getName()));
                        item.setData((Object)NavigationActionFactory.NavigationActionType.NEXT_UNREAD_FEED);
                        item.addSelectionListener((SelectionListener)new NavigationSelectionListener(true));
                        if (item.getData().equals((Object)defaultAction)) {
                            item.setSelection(true);
                        }
                        new MenuItem(menu, 2);
                        item = new MenuItem(menu, 16);
                        item.setText(CoolBarAdvisor.this.getLabelWithBinding(NavigationActionFactory.NavigationActionType.NEXT_TAB.getCommandId(), NavigationActionFactory.NavigationActionType.NEXT_TAB.getName()));
                        item.setData((Object)NavigationActionFactory.NavigationActionType.NEXT_TAB);
                        item.addSelectionListener((SelectionListener)new NavigationSelectionListener(true));
                        if (item.getData().equals((Object)defaultAction)) {
                            item.setSelection(true);
                        }
                        return menu;
                    }
                };
            }
            case PREVIOUS: {
                return new ContextMenuCreator(){

                    public Menu createMenu(Control parent) {
                        Menu menu = new Menu(parent);
                        NavigationActionFactory.NavigationActionType defaultAction = NavigationActionFactory.NavigationActionType.values()[CoolBarAdvisor.this.fPreferences.getInteger(DefaultPreferences.DEFAULT_PREVIOUS_ACTION)];
                        MenuItem item = new MenuItem(menu, 16);
                        item.setText(CoolBarAdvisor.this.getLabelWithBinding(NavigationActionFactory.NavigationActionType.PREVIOUS_NEWS.getCommandId(), NavigationActionFactory.NavigationActionType.PREVIOUS_NEWS.getName()));
                        item.setData((Object)NavigationActionFactory.NavigationActionType.PREVIOUS_NEWS);
                        item.addSelectionListener((SelectionListener)new NavigationSelectionListener(false));
                        if (item.getData().equals((Object)defaultAction)) {
                            item.setSelection(true);
                        }
                        item = new MenuItem(menu, 16);
                        item.setText(CoolBarAdvisor.this.getLabelWithBinding(NavigationActionFactory.NavigationActionType.PREVIOUS_UNREAD_NEWS.getCommandId(), NavigationActionFactory.NavigationActionType.PREVIOUS_UNREAD_NEWS.getName()));
                        item.setData((Object)NavigationActionFactory.NavigationActionType.PREVIOUS_UNREAD_NEWS);
                        item.addSelectionListener((SelectionListener)new NavigationSelectionListener(false));
                        if (item.getData().equals((Object)defaultAction)) {
                            item.setSelection(true);
                        }
                        new MenuItem(menu, 2);
                        item = new MenuItem(menu, 16);
                        item.setText(CoolBarAdvisor.this.getLabelWithBinding(NavigationActionFactory.NavigationActionType.PREVIOUS_FEED.getCommandId(), NavigationActionFactory.NavigationActionType.PREVIOUS_FEED.getName()));
                        item.setData((Object)NavigationActionFactory.NavigationActionType.PREVIOUS_FEED);
                        item.addSelectionListener((SelectionListener)new NavigationSelectionListener(false));
                        if (item.getData().equals((Object)defaultAction)) {
                            item.setSelection(true);
                        }
                        item = new MenuItem(menu, 16);
                        item.setText(CoolBarAdvisor.this.getLabelWithBinding(NavigationActionFactory.NavigationActionType.PREVIOUS_UNREAD_FEED.getCommandId(), NavigationActionFactory.NavigationActionType.PREVIOUS_UNREAD_FEED.getName()));
                        item.setData((Object)NavigationActionFactory.NavigationActionType.PREVIOUS_UNREAD_FEED);
                        item.addSelectionListener((SelectionListener)new NavigationSelectionListener(false));
                        if (item.getData().equals((Object)defaultAction)) {
                            item.setSelection(true);
                        }
                        new MenuItem(menu, 2);
                        item = new MenuItem(menu, 16);
                        item.setText(CoolBarAdvisor.this.getLabelWithBinding(NavigationActionFactory.NavigationActionType.PREVIOUS_TAB.getCommandId(), NavigationActionFactory.NavigationActionType.PREVIOUS_TAB.getName()));
                        item.setData((Object)NavigationActionFactory.NavigationActionType.PREVIOUS_TAB);
                        item.addSelectionListener((SelectionListener)new NavigationSelectionListener(false));
                        if (item.getData().equals((Object)defaultAction)) {
                            item.setSelection(true);
                        }
                        return menu;
                    }
                };
            }
            case HISTORY: {
                return new ContextMenuCreator(){

                    public Menu createMenu(Control parent) {
                        Menu menu = new Menu(parent);
                        ContributionItemFactory.REOPEN_EDITORS.create(CoolBarAdvisor.this.fWindow).fill(menu, 0);
                        MenuItem[] items = menu.getItems();
                        if (items.length > 0 && (items[0].getStyle() & 2) != 0) {
                            items[0].dispose();
                        }
                        return menu;
                    }
                };
            }
            case LABEL: {
                return new ContextMenuCreator(){

                    public Menu createMenu(Control parent) {
                        MenuManager manager = new MenuManager();
                        IStructuredSelection activeFeedViewSelection = OwlUI.getActiveFeedViewSelection();
                        ApplicationActionBarAdvisor.fillLabelMenu((IMenuManager)manager, activeFeedViewSelection, (IShellProvider)CoolBarAdvisor.this.fWindow, true);
                        return manager.createContextMenu(parent);
                    }
                };
            }
            case MOVE: {
                return this.getMoveCopyMenu(true);
            }
            case COPY: {
                return this.getMoveCopyMenu(false);
            }
            case SHARE: {
                return new ContextMenuCreator(){

                    public Menu createMenu(Control parent) {
                        MenuManager manager = new MenuManager();
                        IStructuredSelection activeFeedViewSelection = OwlUI.getActiveFeedViewSelection();
                        ApplicationActionBarAdvisor.fillShareMenu((IMenuManager)manager, activeFeedViewSelection, (IShellProvider)CoolBarAdvisor.this.fWindow, true);
                        return manager.createContextMenu(parent);
                    }
                };
            }
            case BOOKMARKS: {
                return new ContextMenuCreator(){

                    public Menu createMenu(Control parent) {
                        MenuManager manager = new MenuManager();
                        ApplicationActionBarAdvisor.fillBookMarksMenu((IMenuManager)manager, CoolBarAdvisor.this.fWindow);
                        return manager.createContextMenu(parent);
                    }
                };
            }
            case ATTACHMENTS: {
                return new ContextMenuCreator(){

                    public Menu createMenu(Control parent) {
                        MenuManager manager = new MenuManager();
                        IStructuredSelection activeFeedViewSelection = OwlUI.getActiveFeedViewSelection();
                        ApplicationActionBarAdvisor.fillAttachmentsMenu((IMenuManager)manager, activeFeedViewSelection, (IShellProvider)CoolBarAdvisor.this.fWindow, true);
                        return manager.createContextMenu(parent);
                    }
                };
            }
        }
        return null;
    }

    private ContextMenuCreator getMoveCopyMenu(final boolean isMove) {
        return new ContextMenuCreator(){

            public Menu createMenu(Control parent) {
                IStructuredSelection selection = OwlUI.getActiveFeedViewSelection();
                if (selection == null || selection.isEmpty()) {
                    return null;
                }
                MenuManager manager = new MenuManager();
                ArrayList newsbins = new ArrayList(DynamicDAO.loadAll(INewsBin.class));
                Comparator<INewsBin> comparator = new Comparator<INewsBin>(){

                    @Override
                    public int compare(INewsBin o1, INewsBin o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                };
                Collections.sort(newsbins, comparator);
                IEditorPart activeEditor = OwlUI.getActiveEditor();
                IEditorInput activeInput = activeEditor != null ? activeEditor.getEditorInput() : null;
                for (INewsBin bin : newsbins) {
                    if (activeInput != null && activeInput instanceof FeedViewInput && ((FeedViewInput)activeInput).getMark().equals(bin)) continue;
                    manager.add((IAction)new MoveCopyNewsToBinAction(selection, bin, isMove));
                }
                manager.add((IAction)new MoveCopyNewsToBinAction(selection, null, isMove));
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new AutomateFilterAction(isMove ? CreateFilterAction.PresetAction.MOVE : CreateFilterAction.PresetAction.COPY, (ISelection)selection));
                return manager.createContextMenu(parent);
            }
        };
    }

    private String getLabelWithBinding(String id, String label) {
        return this.getLabelWithBinding(id, label, false);
    }

    private String getLabelWithBinding(String id, String label, boolean forToolTip) {
        TriggerSequence binding = this.fBindingService.getBestActiveBindingFor(id);
        if (binding != null) {
            return forToolTip ? NLS.bind((String)Messages.CoolBarAdvisor_LABEL_KEY, (Object)label, (Object)binding.format()) : NLS.bind((String)Messages.CoolBarAdvisor_LABEL_TAB_KEY, (Object)label, (Object)binding.format());
        }
        return label;
    }

    private class CoolBarActionContributionitem
    extends ActionContributionItem {
        private final CoolBarItem fItem;

        CoolBarActionContributionitem(CoolBarItem item, IAction action) {
            super(action);
            this.fItem = item;
        }

        public void update(ISelection selection, IWorkbenchPart part) {
            CoolBarAdvisor.this.update(this.getAction(), this.fItem, selection, part);
            Widget widget = this.getWidget();
            if (Application.IS_WINDOWS && widget != null && !widget.isDisposed() && widget instanceof ToolItem && !((ToolItem)widget).isEnabled()) {
                ToolItem item = (ToolItem)widget;
                String text = item.getText();
                item.setText("");
                item.setText(text);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CoolBarItem {
        SEPARATOR("org.rssowl.ui.CoolBarSeparator", Messages.CoolBarAdvisor_SEPARATOR, null, OwlUI.getImageDescriptor("icons/obj16/separator.gif"), null, 0),
        SPACER("org.rssowl.ui.CoolBarSpacer", Messages.CoolBarAdvisor_BLANK, null, OwlUI.getImageDescriptor("icons/etool16/spacer.gif"), null, 0),
        NEW("org.rssowl.ui.NewDropDown", Messages.CoolBarAdvisor_NEW, null, OwlUI.getImageDescriptor("icons/etool16/add.gif"), null, 4, false, 1),
        IMPORT("org.rssowl.ui.actions.ImportFeeds", Messages.CoolBarAdvisor_IMPORT, null, OwlUI.getImageDescriptor("icons/etool16/import.gif"), null, 1),
        EXPORT("org.rssowl.ui.actions.ExportFeeds", Messages.CoolBarAdvisor_EXPORT, null, OwlUI.getImageDescriptor("icons/etool16/export.gif"), null, 1),
        UNDO("org.rssowl.ui.UndoAction", Messages.CoolBarAdvisor_UNDO, null, OwlUI.getImageDescriptor("icons/elcl16/undo_edit.gif"), OwlUI.getImageDescriptor("icons/dlcl16/undo_edit.gif"), 2),
        REDO("org.rssowl.ui.RedoAction", Messages.CoolBarAdvisor_REDO, null, OwlUI.getImageDescriptor("icons/elcl16/redo_edit.gif"), OwlUI.getImageDescriptor("icons/dlcl16/redo_edit.gif"), 2),
        UPDATE("org.rssowl.ui.actions.Reload", Messages.CoolBarAdvisor_UPDATE, null, OwlUI.getImageDescriptor("icons/elcl16/reload.gif"), OwlUI.getImageDescriptor("icons/dlcl16/reload.gif"), 3),
        UPDATE_ALL("org.rssowl.ui.actions.ReloadAll", Messages.CoolBarAdvisor_UPDATE_ALL, null, OwlUI.getImageDescriptor("icons/elcl16/reload_all.gif"), null, 3),
        STOP("org.rssowl.ui.StopUpdate", Messages.CoolBarAdvisor_STOP, Messages.CoolBarAdvisor_STOP_UPDATES, OwlUI.getImageDescriptor("icons/etool16/stop.gif"), OwlUI.getImageDescriptor("icons/dtool16/stop.gif"), 1, false, 3),
        SEARCH("org.rssowl.ui.SearchNewsAction", Messages.CoolBarAdvisor_SEARCH, null, OwlUI.SEARCHMARK, null, 4),
        MARK_READ("org.rssowl.ui.ToggleReadState", Messages.CoolBarAdvisor_MARK_READ, null, OwlUI.getImageDescriptor("icons/elcl16/mark_read.gif"), OwlUI.getImageDescriptor("icons/dlcl16/mark_read.gif"), 5),
        MARK_ALL_READ("org.rssowl.ui.MarkAllRead", Messages.CoolBarAdvisor_MARK_ALL_READ, null, OwlUI.getImageDescriptor("icons/elcl16/mark_all_read.gif"), OwlUI.getImageDescriptor("icons/dlcl16/mark_all_read.gif"), 5),
        LABEL("org.rssowl.ui.Label", Messages.CoolBarAdvisor_LABEL, Messages.CoolBarAdvisor_LABEL_NEWS, OwlUI.getImageDescriptor("icons/elcl16/labels.gif"), null, 4, false, 6),
        STICKY("org.rssowl.ui.actions.MarkSticky", Messages.CoolBarAdvisor_STICKY, Messages.CoolBarAdvisor_MARK_STICKY, OwlUI.NEWS_PINNED, OwlUI.getImageDescriptor("icons/obj16/news_pinned_disabled.gif"), 6),
        NEXT("org.rssowl.ui.Next", Messages.CoolBarAdvisor_NEXT, null, OwlUI.getImageDescriptor("icons/etool16/next.gif"), null, 4, false, 7),
        PREVIOUS("org.rssowl.ui.Previous", Messages.CoolBarAdvisor_PREVIOUS, null, OwlUI.getImageDescriptor("icons/etool16/previous.gif"), null, 4, false, 7),
        OPEN("org.rssowl.ui.OpenInBrowserAction", Messages.CoolBarAdvisor_OPEN, Messages.CoolBarAdvisor_OPEN_NEWS, OwlUI.getImageDescriptor("icons/elcl16/browser.gif"), OwlUI.getImageDescriptor("icons/dlcl16/browser.gif"), 8),
        MOVE("org.rssowl.ui.Move", Messages.CoolBarAdvisor_MOVE, Messages.CoolBarAdvisor_MOVE_NEWS, OwlUI.getImageDescriptor("icons/etool16/move_to.gif"), OwlUI.getImageDescriptor("icons/dtool16/move_to.gif"), 4, false, 8),
        COPY("org.rssowl.ui.Copy", Messages.CoolBarAdvisor_COPY, Messages.CoolBarAdvisor_COPY_NEWS, OwlUI.getImageDescriptor("icons/etool16/copy_to.gif"), OwlUI.getImageDescriptor("icons/dtool16/copy_to.gif"), 4, false, 8),
        SHARE("org.rssowl.ui.Share", Messages.CoolBarAdvisor_SHARE, Messages.CoolBarAdvisor_SHARE_NEWS, OwlUI.getImageDescriptor("icons/elcl16/share.gif"), null, 4, false, 8),
        SAVE_AS("org.eclipse.ui.file.saveAs", Messages.CoolBarAdvisor_SAVE, Messages.CoolBarAdvisor_SAVE_NEWS, OwlUI.getImageDescriptor("icons/etool16/save_as.gif"), OwlUI.getImageDescriptor("icons/dtool16/save_as.gif"), 8),
        PRINT("org.eclipse.ui.file.print", Messages.CoolBarAdvisor_PRINT, Messages.CoolBarAdvisor_PRINT_NEWS, OwlUI.getImageDescriptor("icons/etool16/print.gif"), OwlUI.getImageDescriptor("icons/dtool16/print.gif"), 8),
        FIND_MORE_FEEDS("org.rssowl.ui.SearchFeedsAction", Messages.CoolBarAdvisor_FIND_FEEDS, null, OwlUI.getImageDescriptor("icons/etool16/new_bkmrk.gif"), null, 9),
        NEW_BOOKMARK("org.rssowl.ui.actions.NewBookMark", Messages.CoolBarAdvisor_BOOKMARK, Messages.CoolBarAdvisor_NEW_BOOKMARK, OwlUI.BOOKMARK, null, 9),
        NEW_BIN("org.rssowl.ui.actions.NewNewsBin", Messages.CoolBarAdvisor_NEWS_BIN, Messages.CoolBarAdvisor_NEW_NEWSBIN, OwlUI.NEWSBIN, null, 9),
        NEW_SAVED_SEARCH("org.rssowl.ui.actions.NewSearchMark", Messages.CoolBarAdvisor_SAVED_SEARCH, Messages.CoolBarAdvisor_NEW_SAVED_SEARCH, OwlUI.SEARCHMARK, null, 9),
        NEW_FOLDER("org.rssowl.ui.actions.NewFolder", Messages.CoolBarAdvisor_FOLDER, Messages.CoolBarAdvisor_NEW_FOLDER, OwlUI.FOLDER, null, 9),
        CLOSE("org.eclipse.ui.file.close", Messages.CoolBarAdvisor_CLOSE, null, OwlUI.getImageDescriptor("icons/etool16/close_tab.gif"), OwlUI.getImageDescriptor("icons/dtool16/close_tab.gif"), 10),
        CLOSE_OTHERS("org.eclipse.ui.file.closeOthers", Messages.CoolBarAdvisor_CLOSE_OTHERS, null, OwlUI.getImageDescriptor("icons/etool16/close_other_tabs.gif"), OwlUI.getImageDescriptor("icons/dtool16/close_other_tabs.gif"), 10),
        CLOSE_ALL("org.eclipse.ui.file.closeAll", Messages.CoolBarAdvisor_CLOSE_ALL, null, OwlUI.getImageDescriptor("icons/etool16/close_all_tabs.gif"), OwlUI.getImageDescriptor("icons/dtool16/close_all_tabs.gif"), 10),
        BOOKMARKS("org.rssowl.ui.Bookmarks", Messages.CoolBarAdvisor_BOOKMARKS, null, OwlUI.getImageDescriptor("icons/etool16/subscriptions.gif"), null, 4, false, 11),
        HISTORY("org.rssowl.ui.History", Messages.CoolBarAdvisor_HISTORY, Messages.CoolBarAdvisor_RECENTLY_VISITED_FEEDS, OwlUI.getImageDescriptor("icons/etool16/history.gif"), null, 4, false, 11),
        BOOKMARK_VIEW("org.rssowl.ui.ToggleBookmarksCommand", Messages.CoolBarAdvisor_BOOKMARK_VIEW, null, OwlUI.getImageDescriptor("icons/eview16/bkmrk_explorer.gif"), null, 2, true, 11),
        ACTIVITIES("org.rssowl.ui.ShowActivityAction", Messages.CoolBarAdvisor_ACTIVITY, Messages.CoolBarAdvisor_DOWNLOADS_ACTIVITY, OwlUI.getImageDescriptor("icons/elcl16/activity.gif"), null, 12),
        PREFERENCES("org.rssowl.ui.ShowPreferences", Messages.CoolBarAdvisor_PREFERENCES, null, OwlUI.getImageDescriptor("icons/elcl16/preferences.gif"), null, 1, false, 12),
        FULLSCREEN("org.rssowl.ui.FullScreenCommand", Messages.CoolBarAdvisor_FULL_SCREEN, Messages.CoolBarAdvisor_TOGGLE_FULL_SCREEN, OwlUI.getImageDescriptor("icons/etool16/fullscreen.gif"), null, 2, true, 12),
        DELETE("org.eclipse.ui.edit.delete", Messages.CoolBarAdvisor_DELETE, Messages.CoolBarAdvisor_DELETE_NEWS, OwlUI.getImageDescriptor("icons/etool16/cancel.gif"), OwlUI.getImageDescriptor("icons/dtool16/cancel.gif"), 8),
        ATTACHMENTS("org.rssowl.ui.Attachments", Messages.CoolBarAdvisor_ATTACHMENTS, null, OwlUI.getImageDescriptor("icons/obj16/attachment.gif"), OwlUI.getImageDescriptor("icons/dtool16/attachment.gif"), 4, false, 8),
        ARCHIVE("org.rssowl.ui.ArchiveCommand", Messages.CoolBarAdvisor_ARCHIVE, Messages.CoolBarAdvisor_ARCHIVE_NEWS, OwlUI.getImageDescriptor("icons/etool16/archive.gif"), OwlUI.getImageDescriptor("icons/dtool16/archive.gif"), 8);

        private final String fId;
        private final String fName;
        private final String fTooltip;
        private final ImageDescriptor fImg;
        private final ImageDescriptor fDisabledImg;
        private final int fStyle;
        private final boolean fHasCommand;
        private final int fGroup;

        private CoolBarItem(String id, String name, String tooltip, ImageDescriptor img, ImageDescriptor disabledImg, int group) {
            this(id, name, tooltip, img, disabledImg, 1, true, group);
        }

        private CoolBarItem(String id, String name, String tooltip, ImageDescriptor img, ImageDescriptor disabledImg, int style, boolean hasCommand, int group) {
            this.fId = id;
            this.fName = name;
            this.fTooltip = tooltip;
            this.fImg = img;
            this.fDisabledImg = disabledImg;
            this.fStyle = style;
            this.fHasCommand = hasCommand;
            this.fGroup = group;
        }

        public String getId() {
            return this.fId;
        }

        public String getName() {
            return this.fName;
        }

        public String getTooltip() {
            return this.fTooltip;
        }

        public int getGroup() {
            return this.fGroup;
        }

        public ImageDescriptor getImg() {
            return this.fImg;
        }

        ImageDescriptor getDisabledImg() {
            return this.fDisabledImg;
        }

        int getStyle() {
            return this.fStyle;
        }

        boolean withDropDownMenu() {
            return this.fStyle == 4;
        }

        boolean hasCommand() {
            return this.fHasCommand;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CoolBarMode {
        IMAGE_TEXT_VERTICAL,
        IMAGE_TEXT_HORIZONTAL,
        IMAGE,
        TEXT;

    }

    private class NavigationSelectionListener
    extends SelectionAdapter {
        private boolean fIsNext;

        NavigationSelectionListener(boolean isNext) {
            this.fIsNext = isNext;
        }

        public void widgetSelected(SelectionEvent e) {
            Object data;
            if (((MenuItem)e.widget).getSelection() && (data = e.widget.getData()) instanceof NavigationActionFactory.NavigationActionType) {
                NavigationActionFactory.NavigationActionType actionType = (NavigationActionFactory.NavigationActionType)((Object)data);
                NavigationActionFactory.NavigationAction action = new NavigationActionFactory.NavigationAction(actionType);
                action.init(CoolBarAdvisor.this.fWindow);
                action.run(null);
                CoolBarAdvisor.this.fPreferences.putInteger(this.fIsNext ? DefaultPreferences.DEFAULT_NEXT_ACTION : DefaultPreferences.DEFAULT_PREVIOUS_ACTION, actionType.ordinal());
                CoolBarAdvisor.this.update(this.fIsNext ? CoolBarItem.NEXT : CoolBarItem.PREVIOUS, null, null, false);
            }
        }
    }
}

