/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.res.GetIcon;
import mediathek.tool.MVColor;
import mediathek.tool.MVFont;
import mediathek.tool.MVSenderIconCache;
import mediathek.tool.MVTable;

public class CellRendererAbo
extends DefaultTableCellRenderer {
    private final MVSenderIconCache senderIconCache = new MVSenderIconCache();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setBackground(null);
        this.setForeground(null);
        this.setFont(null);
        this.setIcon(null);
        this.setHorizontalAlignment(10);
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        try {
            if (isSelected) {
                this.setFont(new Font("Dialog", 1, MVFont.fontSize));
            } else {
                this.setFont(new Font("Dialog", 0, MVFont.fontSize));
            }
            int r = table.convertRowIndexToModel(row);
            int c = table.convertColumnIndexToModel(column);
            DatenAbo abo = Daten.listeAbo.getAboNr(r);
            boolean eingeschaltet = abo.aboIstEingeschaltet();
            if (c == 0) {
                this.setHorizontalAlignment(0);
            }
            if (c == 8) {
                this.setHorizontalAlignment(0);
            }
            if (!eingeschaltet) {
                this.setFont(new Font("Dialog", 2, this.getFont().getSize()));
                if (isSelected) {
                    this.setBackground(MVColor.ABO_AUSGESCHALTET_SEL.color);
                } else {
                    this.setBackground(MVColor.ABO_AUSGESCHALTET.color);
                }
            }
            switch (c) {
                case 1: {
                    this.setHorizontalAlignment(0);
                    if (eingeschaltet) {
                        this.setIcon(GetIcon.getProgramIcon("ja_16.png"));
                        break;
                    }
                    this.setIcon(GetIcon.getProgramIcon("nein_12.png"));
                    break;
                }
                case 3: {
                    if (!((MVTable)table).iconAnzeigen) break;
                    this.handleSenderColumn((String)value, ((MVTable)table).iconKlein);
                }
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(630365892, ex);
        }
        return this;
    }

    private void handleSenderColumn(String sender, boolean small) {
        this.setHorizontalAlignment(0);
        ImageIcon icon = this.senderIconCache.get(sender, small);
        if (icon != null) {
            this.setText("");
            this.setIcon(icon);
        }
    }
}

