/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.gui.PanelVorlage;
import mediathek.res.GetIcon;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVColor;

public class PanelFilmlisteLaden
extends PanelVorlage {
    private JButton jButtonDateiAuswaehlen;
    private JButton jButtonFilmeLaden;
    private JButton jButtonLoad;
    private JButton jButtonUrl;
    private JCheckBox jCheckBoxUpdate;
    private JPanel jPanelAuto;
    private JPanel jPanelManuel;
    private JRadioButton jRadioButtonAuto;
    private JRadioButton jRadioButtonManuell;
    private JTextArea jTextAreaAuto;
    private JTextArea jTextAreaManuell;
    private JTextField jTextFieldUrl;

    public PanelFilmlisteLaden(Daten d, JFrame parentComponent) {
        super(d, parentComponent);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.jButtonDateiAuswaehlen.setIcon(GetIcon.getProgramIcon("fileopen_16.png"));
        this.jButtonUrl.setIcon(GetIcon.getProgramIcon("view-refresh_16.png"));
        this.initRadio();
        this.jButtonUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelFilmlisteLaden.this.jTextFieldUrl.setText(Daten.filmeLaden.getDownloadUrl_akt());
            }
        });
        this.jButtonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Daten.filmeLaden.importFilmliste("");
            }
        });
        this.jButtonDateiAuswaehlen.addActionListener(new BeobPfad());
        this.jButtonFilmeLaden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PanelFilmlisteLaden.this.jCheckBoxUpdate.isSelected()) {
                    Daten.filmeLaden.updateFilmliste(PanelFilmlisteLaden.this.jTextFieldUrl.getText());
                } else {
                    Daten.filmeLaden.importFilmliste(PanelFilmlisteLaden.this.jTextFieldUrl.getText());
                }
            }
        });
        this.jRadioButtonManuell.addActionListener(new BeobOption());
        this.jRadioButtonAuto.addActionListener(new BeobOption());
        this.jTextFieldUrl.getDocument().addDocumentListener(new BeobDateiUrl());
        ListenerMediathekView.addListener(new ListenerMediathekView(12, PanelFilmlisteLaden.class.getSimpleName()){

            @Override
            public void ping() {
                PanelFilmlisteLaden.this.initRadio();
            }
        });
    }

    private void initRadio() {
        if (GuiFunktionen.getImportArtFilme() == 0) {
            this.jRadioButtonManuell.setSelected(true);
        } else {
            this.jRadioButtonAuto.setSelected(true);
        }
        this.jTextFieldUrl.setText(Daten.mVConfig.get("system-import-url-manuell"));
        this.setPanelTabelle(this.jRadioButtonManuell.isSelected());
    }

    private void setPanelTabelle(boolean manuell) {
        if (manuell) {
            this.jTextAreaManuell.setBackground(MVColor.FILMLISTE_LADEN_AKTIV.color);
            this.jTextAreaAuto.setBackground(null);
        } else {
            this.jTextAreaManuell.setBackground(null);
            this.jTextAreaAuto.setBackground(MVColor.FILMLISTE_LADEN_AKTIV.color);
        }
    }

    private void initComponents() {
        ButtonGroup buttonGroup1 = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.jPanelAuto = new JPanel();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.jTextAreaAuto = new JTextArea();
        this.jButtonLoad = new JButton();
        this.jPanelManuel = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.jTextFieldUrl = new JTextField();
        this.jButtonDateiAuswaehlen = new JButton();
        this.jButtonFilmeLaden = new JButton();
        JScrollPane jScrollPane3 = new JScrollPane();
        this.jTextAreaManuell = new JTextArea();
        this.jCheckBoxUpdate = new JCheckBox();
        this.jButtonUrl = new JButton();
        this.jRadioButtonAuto = new JRadioButton();
        this.jRadioButtonManuell = new JRadioButton();
        this.jPanelAuto.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0, 0, 255)), "Die Filmliste automatisch laden"));
        this.jTextAreaAuto.setEditable(false);
        this.jTextAreaAuto.setColumns(20);
        this.jTextAreaAuto.setRows(4);
        this.jTextAreaAuto.setText("Die Filmliste wird beim Programmstart automatisch geladen (wenn sie\n\u00e4lter als 3h ist). Zus\u00e4tzlich kann sie \u00fcber den Button \"Neue Filmliste laden\"\naktualisiert werden. Zum Update werden dann nur noch die Differenzlisten geladen (enthalten\nnur die neuen Filme).");
        this.jTextAreaAuto.setMargin(new Insets(4, 4, 4, 4));
        jScrollPane2.setViewportView(this.jTextAreaAuto);
        this.jButtonLoad.setText("Filme jetzt laden");
        GroupLayout jPanelAutoLayout = new GroupLayout(this.jPanelAuto);
        this.jPanelAuto.setLayout(jPanelAutoLayout);
        jPanelAutoLayout.setHorizontalGroup(jPanelAutoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelAutoLayout.createSequentialGroup().addContainerGap().addGroup(jPanelAutoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane2).addGroup(GroupLayout.Alignment.TRAILING, jPanelAutoLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonLoad))).addContainerGap()));
        jPanelAutoLayout.setVerticalGroup(jPanelAutoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelAutoLayout.createSequentialGroup().addComponent(jScrollPane2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonLoad).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelManuel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0, 0, 255)), "Filmliste nur manuell laden"));
        jLabel1.setText("URL/Datei:");
        this.jButtonDateiAuswaehlen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/fileopen_16.png")));
        this.jButtonDateiAuswaehlen.setToolTipText("Lokale Filmliste ausw\u00e4hlen");
        this.jButtonFilmeLaden.setText("Filme jetzt laden");
        this.jTextAreaManuell.setEditable(false);
        this.jTextAreaManuell.setColumns(20);
        this.jTextAreaManuell.setRows(4);
        this.jTextAreaManuell.setText("Die Filmliste wird nur manuell \u00fcber den Button \"Neue Filmliste laden\"\ngeladen. Es wird dann dieser Dialog angezeigt und es kann eine URL/Datei zum\nLaden angegeben werden.");
        this.jTextAreaManuell.setMargin(new Insets(4, 4, 4, 4));
        jScrollPane3.setViewportView(this.jTextAreaManuell);
        this.jCheckBoxUpdate.setText("alte Filmliste nicht l\u00f6schen, nur erweitern");
        this.jButtonUrl.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/icons_refresh_16.png")));
        this.jButtonUrl.setToolTipText("Neue URL suchen");
        GroupLayout jPanelManuelLayout = new GroupLayout(this.jPanelManuel);
        this.jPanelManuel.setLayout(jPanelManuelLayout);
        jPanelManuelLayout.setHorizontalGroup(jPanelManuelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelManuelLayout.createSequentialGroup().addContainerGap().addGroup(jPanelManuelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelManuelLayout.createSequentialGroup().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldUrl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonUrl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDateiAuswaehlen)).addComponent(jScrollPane3).addGroup(GroupLayout.Alignment.TRAILING, jPanelManuelLayout.createSequentialGroup().addComponent(this.jCheckBoxUpdate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 263, Short.MAX_VALUE).addComponent(this.jButtonFilmeLaden))).addContainerGap()));
        jPanelManuelLayout.setVerticalGroup(jPanelManuelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelManuelLayout.createSequentialGroup().addComponent(jScrollPane3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelManuelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldUrl, -2, -1, -2).addComponent(jLabel1).addComponent(this.jButtonDateiAuswaehlen).addComponent(this.jButtonUrl)).addGap(18, 18, 18).addGroup(jPanelManuelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonFilmeLaden).addComponent(this.jCheckBoxUpdate)).addContainerGap()));
        jPanelManuelLayout.linkSize(1, this.jButtonDateiAuswaehlen, jLabel1, this.jTextFieldUrl);
        buttonGroup1.add(this.jRadioButtonAuto);
        buttonGroup1.add(this.jRadioButtonManuell);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonAuto).addComponent(this.jRadioButtonManuell)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelAuto, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelManuel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonAuto).addComponent(this.jPanelAuto, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonManuell).addComponent(this.jPanelManuel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private class BeobDateiUrl
    implements DocumentListener {
        private BeobDateiUrl() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.tus();
        }

        private void tus() {
            Daten.mVConfig.add("system-import-url-manuell", PanelFilmlisteLaden.this.jTextFieldUrl.getText());
        }
    }

    private class BeobPfad
    implements ActionListener {
        private BeobPfad() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemInfo.isMacOSX()) {
                FileDialog chooser = new FileDialog((Frame)PanelFilmlisteLaden.this.daten.mediathekGui, "Filmliste laden");
                chooser.setMode(0);
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        File destination = new File(chooser.getDirectory() + chooser.getFile());
                        PanelFilmlisteLaden.this.jTextFieldUrl.setText(destination.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(102036579, ex);
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                if (!PanelFilmlisteLaden.this.jTextFieldUrl.getText().equals("")) {
                    chooser.setCurrentDirectory(new File(PanelFilmlisteLaden.this.jTextFieldUrl.getText()));
                }
                chooser.setFileSelectionMode(0);
                chooser.setFileHidingEnabled(false);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        PanelFilmlisteLaden.this.jTextFieldUrl.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(733025319, ex);
                    }
                }
            }
        }
    }

    private class BeobOption
    implements ActionListener {
        private BeobOption() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PanelFilmlisteLaden.this.stopBeob) {
                if (PanelFilmlisteLaden.this.jRadioButtonManuell.isSelected()) {
                    Daten.mVConfig.add("update-filme", String.valueOf(0));
                } else {
                    Daten.mVConfig.add("update-filme", String.valueOf(2));
                }
                ListenerMediathekView.notify(12, this.getClass().getSimpleName());
            }
        }
    }
}

