/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.gui.dialog.DialogEditAbo;
import mediathek.tool.FilenameUtils;
import mediathek.tool.Filter;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.TModelAbo;
import msearch.daten.DatenFilm;
import msearch.daten.ListeFilme;
import msearch.tool.Datum;
import msearch.tool.GermanStringSorter;

public class ListeAbo
extends LinkedList<DatenAbo> {
    Daten daten;
    final String[] LEER = new String[]{""};
    String[] titel;
    String[] thema;
    String[] irgendwo;
    private int nr = 0;

    public ListeAbo(Daten ddaten) {
        this.daten = ddaten;
    }

    public boolean addAbo(String aboName) {
        return this.addAbo(aboName, "", "", "");
    }

    public boolean addAbo(String aboname, String filmSender, String filmThema, String filmTitel) {
        int min;
        try {
            min = Integer.parseInt(Daten.mVConfig.get("Abo-Mindestdauer-Minuten"));
        }
        catch (Exception ex) {
            min = 0;
            Daten.mVConfig.add("Abo-Mindestdauer-Minuten", "0");
        }
        return this.addAbo(filmSender, filmThema, filmTitel, "", "", min, aboname);
    }

    public boolean addAbo(String filmSender, String filmThema, String filmTitel, String filmThemaTitel, String irgendwo, int mindestdauer, String namePfad) {
        boolean ret = false;
        namePfad = FilenameUtils.replaceLeerDateiname(namePfad, false);
        DatenAbo datenAbo = new DatenAbo(namePfad, filmSender, filmThema, filmTitel, filmThemaTitel, irgendwo, mindestdauer, namePfad, "");
        DialogEditAbo dialogEditAbo = new DialogEditAbo(this.daten.mediathekGui, true, this.daten, datenAbo);
        dialogEditAbo.setVisible(true);
        if (dialogEditAbo.ok) {
            if (!this.aboExistiertBereits(datenAbo)) {
                Daten.mVConfig.add("Abo-Mindestdauer-Minuten", datenAbo.arr[8]);
                this.addAbo(datenAbo);
                this.aenderungMelden();
                ret = true;
            } else {
                MVMessageDialog.showMessageDialog(null, "Abo existiert bereits", "Abo anlegen", 1);
            }
        }
        return ret;
    }

    public void addAbo(DatenAbo datenAbo) {
        ++this.nr;
        datenAbo.nr = this.nr;
        if (datenAbo.arr[2].isEmpty()) {
            datenAbo.arr[2] = "Abo_" + this.nr;
        }
        datenAbo.setMindestDauerMinuten();
        super.add(datenAbo);
        this.sort();
    }

    public void aboLoeschen(DatenAbo abo) {
        if (abo != null) {
            this.remove(abo);
            this.aenderungMelden();
        }
    }

    public void aenderungMelden() {
        this.setAboFuerFilm(Daten.listeFilme, true);
        ListenerMediathekView.notify(10, ListeAbo.class.getSimpleName());
    }

    public DatenAbo getAboNr(int i) {
        return (DatenAbo)this.get(i);
    }

    public void sort() {
        Collections.sort(this);
    }

    public void addObjectData(TModelAbo model) {
        model.setRowCount(0);
        ListIterator iterator = this.listIterator();
        Object[] object = new Object[12];
        while (iterator.hasNext()) {
            DatenAbo datenAbo = (DatenAbo)iterator.next();
            for (int m = 0; m < 12; ++m) {
                object[m] = m == 0 ? Integer.valueOf(datenAbo.nr) : (m == 8 ? Integer.valueOf(datenAbo.mindestdauerMinuten) : (m == 10 ? this.getDatumForObject(datenAbo.arr[10]) : (m == 1 ? "" : (m != 2 && !DatenAbo.anzeigen(m) ? "" : datenAbo.arr[m]))));
            }
            model.addRow(object);
        }
    }

    public Datum getDatumForObject(String datum) {
        Datum tmp = new Datum(0L);
        if (!datum.equals("")) {
            try {
                tmp.setTime(new SimpleDateFormat("dd.MM.yyyy").parse(datum).getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return tmp;
    }

    public ArrayList<String> getPfade() {
        ArrayList<String> pfade = new ArrayList<String>();
        for (DatenAbo abo : this) {
            String s = abo.arr[9];
            if (pfade.contains(s)) continue;
            pfade.add(abo.arr[9]);
        }
        GermanStringSorter sorter = GermanStringSorter.getInstance();
        Collections.sort(pfade, sorter);
        return pfade;
    }

    private boolean aboExistiertBereits(DatenAbo abo) {
        for (DatenAbo datenAbo : this) {
            if (!Filter.aboExistiertBereits(datenAbo, abo)) continue;
            return true;
        }
        return false;
    }

    public DatenAbo getAboFuerFilm_schnell(DatenFilm film, boolean laengePruefen) {
        if (film.abo == null) {
            return null;
        }
        if (laengePruefen && !Filter.laengePruefen(((DatenAbo)film.abo).mindestdauerMinuten, film.dauerL)) {
            return null;
        }
        return (DatenAbo)film.abo;
    }

    public void setAboFuerFilm(ListeFilme listeFilme, boolean aboLoeschen) {
        ListIterator iteratorFilm = listeFilme.listIterator();
        if (this.size() == 0 && aboLoeschen) {
            while (iteratorFilm.hasNext()) {
                DatenFilm datenFilm = (DatenFilm)iteratorFilm.next();
                datenFilm.arr[14] = "";
                datenFilm.abo = null;
            }
        } else {
            block1: while (iteratorFilm.hasNext()) {
                DatenFilm datenFilm = (DatenFilm)iteratorFilm.next();
                datenFilm.arr[14] = "";
                datenFilm.abo = null;
                ListIterator iteratorAbo = this.listIterator();
                while (iteratorAbo.hasNext()) {
                    String[] stringArray;
                    String[] stringArray2;
                    String[] stringArray3;
                    DatenAbo datenAbo = (DatenAbo)iteratorAbo.next();
                    if (datenAbo.isEmpty()) continue;
                    if (datenAbo.arr[5].isEmpty()) {
                        this.titel = this.LEER;
                    } else if (Filter.isPattern(datenAbo.arr[5])) {
                        String[] stringArray4 = new String[1];
                        stringArray3 = stringArray4;
                        stringArray4[0] = datenAbo.arr[5];
                    } else {
                        stringArray3 = this.titel = datenAbo.arr[5].toLowerCase().split(",");
                    }
                    if (datenAbo.arr[6].isEmpty()) {
                        this.thema = this.LEER;
                    } else if (Filter.isPattern(datenAbo.arr[6])) {
                        String[] stringArray5 = new String[1];
                        stringArray2 = stringArray5;
                        stringArray5[0] = datenAbo.arr[6];
                    } else {
                        stringArray2 = this.thema = datenAbo.arr[6].toLowerCase().split(",");
                    }
                    if (datenAbo.arr[7].isEmpty()) {
                        this.irgendwo = this.LEER;
                    } else if (Filter.isPattern(datenAbo.arr[7])) {
                        String[] stringArray6 = new String[1];
                        stringArray = stringArray6;
                        stringArray6[0] = datenAbo.arr[7];
                    } else {
                        stringArray = this.irgendwo = datenAbo.arr[7].toLowerCase().split(",");
                    }
                    if (!Filter.filterAufFilmPruefen(datenAbo.arr[3], datenAbo.arr[4], this.titel, this.thema, this.irgendwo, datenAbo.mindestdauerMinuten, datenFilm, false)) continue;
                    if (!Filter.laengePruefen(datenAbo.mindestdauerMinuten, datenFilm.dauerL)) {
                        datenFilm.arr[14] = datenAbo.arr[2] + " [zu kurz]";
                        datenFilm.abo = datenAbo;
                        continue block1;
                    }
                    datenFilm.arr[14] = datenAbo.arr[2];
                    datenFilm.abo = datenAbo;
                    continue block1;
                }
            }
        }
    }
}

