/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web;

import com.pugh.sockso.Utils;
import com.pugh.sockso.web.BadRequestException;
import com.pugh.sockso.web.EmptyRequestException;
import com.pugh.sockso.web.InputBuffer;
import com.pugh.sockso.web.MultipartSection;
import com.pugh.sockso.web.Request;
import com.pugh.sockso.web.Server;
import com.pugh.sockso.web.UploadFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpRequest
implements Request {
    public static final int MAX_HEADERS = 100;
    private final Server server;
    protected final Hashtable<String, String> cookies;
    private final Hashtable<String, String> arguments;
    private final Hashtable<String, String> headers;
    private final Hashtable<String, UploadFile> files;
    private String[] params = null;
    private String host = null;
    private String statusLine = null;

    public HttpRequest(Server server) {
        this.server = server;
        this.cookies = new Hashtable();
        this.arguments = new Hashtable();
        this.headers = new Hashtable();
        this.files = new Hashtable();
    }

    public void process(InputStream stream) throws IOException, BadRequestException, EmptyRequestException {
        InputBuffer buffer = new InputBuffer(stream, 100);
        this.readStatusLine(buffer);
        this.readHeaders(buffer);
        this.readBody(buffer);
    }

    private void readStatusLine(InputBuffer buffer) throws IOException, BadRequestException, EmptyRequestException {
        this.statusLine = buffer.readLine();
        if (this.statusLine.equals("")) {
            throw new EmptyRequestException();
        }
        Pattern p = Pattern.compile("(GET|POST) (.+?) HTTP/\\d\\.\\d");
        Matcher m = p.matcher(this.statusLine);
        log.debug((Object)("Status Line: '" + this.statusLine + "'"));
        if (!m.matches()) {
            throw new BadRequestException("Invalid HTTP status line", 400);
        }
        String resource = m.group(2);
        int queryStringIndex = resource.indexOf("?");
        if (queryStringIndex != -1) {
            this.processUrlEncodedData(resource.substring(queryStringIndex + 1));
            resource = resource.substring(0, queryStringIndex);
        }
        this.params = resource.substring(1).split("/");
    }

    private void readHeaders(InputBuffer buffer) throws IOException {
        String line;
        int headerCount = 0;
        while (headerCount++ < 100 && (line = buffer.readLine()) != null && !line.equals("")) {
            log.debug((Object)("HTTP Header: " + line));
            Pattern p2 = Pattern.compile("(.*?): (.*)");
            Matcher m2 = p2.matcher(line);
            if (!m2.matches()) continue;
            String name = m2.group(1).toLowerCase();
            String value = m2.group(2);
            this.headers.put(name.toLowerCase(), value);
            if (name.equals("host")) {
                this.host = value;
                continue;
            }
            if (!name.equals("cookie")) continue;
            this.addCookies(value);
        }
    }

    private void readBody(InputBuffer buffer) throws IOException {
        int contentLength = this.getContentLength();
        if (this.getHeader("content-type").contains("multipart/form-data")) {
            log.debug((Object)("Multipart Form Data: ~" + contentLength + " bytes"));
            this.processMultipartData(buffer);
        } else {
            String postData = buffer.readString(contentLength);
            log.debug((Object)("URL Encoded Post Data: '" + postData + "'"));
            this.processUrlEncodedData(postData);
        }
    }

    private int getContentLength() {
        try {
            return Integer.parseInt(this.getHeader("content-length"));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private void processMultipartData(InputBuffer buffer) throws IOException {
        String boundary = this.getMultipartBoundary();
        String startMarker = "--" + boundary;
        String endMarker = startMarker + "--";
        while (true) {
            String marker;
            if ((marker = buffer.readLine()).equals(endMarker)) {
                return;
            }
            if (marker.equals(startMarker)) {
                MultipartSection ms = new MultipartSection();
                ms.process(buffer, boundary);
                if (!ms.getFilename().equals("")) {
                    log.debug((Object)("Multipart File: " + ms.getFilename()));
                    this.files.put(ms.getName(), new UploadFile(ms.getFilename(), ms.getContentType(), ms.getData(), ms.getFilename(), ms.getTemporaryFile()));
                    continue;
                }
                log.debug((Object)("Multipart Arg: " + ms.getName() + " = " + ms.getData()));
                this.arguments.put(ms.getName(), ms.getData());
                continue;
            }
            if (marker.equals("")) break;
        }
    }

    protected String getMultipartBoundary() {
        String contentType = this.getHeader("content-type");
        Pattern pattern = Pattern.compile(".*boundary=(.*)");
        Matcher matcher = pattern.matcher(contentType);
        return matcher.matches() ? matcher.group(1) : null;
    }

    private void processUrlEncodedData(String data) {
        String[] pairs;
        for (String pairData : pairs = data.split("&")) {
            String[] pair = pairData.split("=");
            if (pair.length != 2) continue;
            String name = Utils.URLDecode(pair[0]);
            String value = Utils.URLDecode(pair[1]);
            log.debug((Object)("URL Encoded Argument: " + name + "=" + value));
            this.arguments.put(name, value);
        }
    }

    public String getResource() {
        return this.statusLine;
    }

    public String getHeader(String name) {
        String value = this.headers.get(name.toLowerCase());
        return value == null ? "" : value;
    }

    public String getArgument(String name) {
        String value = this.arguments.get(name);
        return value == null ? "" : value;
    }

    public boolean hasArgument(String name) {
        return !this.getArgument(name).equals("");
    }

    public UploadFile getFile(String name) {
        return this.files.get(name);
    }

    protected void addCookies(String cookieData) {
        String[] pairs;
        for (String pairData : pairs = cookieData.split(";")) {
            String[] pair = pairData.split("=");
            if (pair.length != 2) continue;
            String name = Utils.URLDecode(pair[0]).trim();
            String value = Utils.URLDecode(pair[1]).trim();
            this.cookies.put(name, value);
            log.debug((Object)("HttpRequestCookie: " + name + "=" + value));
        }
    }

    public String getCookie(String name) {
        String value = this.cookies.get(name);
        return value == null ? "" : value;
    }

    public String getHost() {
        return this.host != null ? this.host : this.server.getHost();
    }

    public String getUrlParam(int index) {
        return index < this.params.length ? Utils.URLDecode(this.params[index]) : "";
    }

    public int getParamCount() {
        return this.params.length;
    }

    public String[] getPlayParams(boolean skipFirstArg) {
        return this.getPlayParams(skipFirstArg ? 1 : 0);
    }

    public String[] getPlayParams(int skipNumArgs) {
        int offset = 1 + skipNumArgs;
        String[] custArgs = new String[this.params.length - offset];
        System.arraycopy(this.params, offset, custArgs, 0, this.params.length - offset);
        return custArgs;
    }

    public String getPreferredLangCode() {
        String[] langPair;
        String[] weightingPair;
        String langs = this.getHeader("Accept-Language");
        String[] locales = langs.split(",");
        String lang = "";
        if (locales.length > 0 && (weightingPair = locales[0].split(";")).length > 0 && (langPair = weightingPair[0].split("-")).length > 0) {
            lang = langPair[0];
        }
        return lang;
    }

    protected void finalize() throws Throwable {
        for (String key : this.files.keySet()) {
            UploadFile file = this.getFile(key);
            File tempFile = file.getTemporaryFile();
            if (tempFile == null) continue;
            tempFile.delete();
        }
    }
}

