/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso;

import com.pugh.sockso.Main;
import com.pugh.sockso.Manager;
import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.Validater;
import com.pugh.sockso.ValidationException;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.resources.Resources;
import com.pugh.sockso.web.User;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class Console
implements Manager {
    private static final Logger log = Logger.getLogger(Console.class);
    protected static final String CMD_COLADD = "coladd";
    protected static final String CMD_COLDEL = "coldel";
    protected static final String CMD_COLLIST = "collist";
    protected static final String CMD_COLSCAN = "colscan";
    protected static final String CMD_EXIT = "exit";
    protected static final String CMD_PROPSET = "propset";
    protected static final String CMD_PROPLIST = "proplist";
    protected static final String CMD_PROPDEL = "propdel";
    protected static final String CMD_USERLIST = "userlist";
    protected static final String CMD_USERADD = "useradd";
    protected static final String CMD_USERDEL = "userdel";
    protected static final String CMD_VERSION = "version";
    private final Database db;
    private final Properties p;
    private final CollectionManager cm;
    private final Locale locale;
    private final PrintStream out;
    private final InputStream is;
    private static final String PROMPT = "#SoCkSo#> ";

    public Console(Database db, Properties p, CollectionManager cm, Resources r) {
        this(db, p, cm, System.out, System.in, r.getCurrentLocale());
    }

    public Console(Database db, Properties p, CollectionManager cm, PrintStream out, InputStream is, Locale locale) {
        this.db = db;
        this.p = p;
        this.cm = cm;
        this.out = out;
        this.is = is;
        this.locale = locale;
    }

    private void checkForUpdate() {
        String latestVersion = Utils.getLatestVersion();
        if (latestVersion != null && !latestVersion.equals("1.2")) {
            this.out.println(this.locale.getString("misc.msg.updateAvailable", new String[]{latestVersion}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open() {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(this.is));
            this.checkForUpdate();
            while (true) {
                this.out.print(PROMPT);
                String command = in.readLine();
                if (command == null) {
                    Utils.close(in);
                    return;
                }
                this.dispatchCommand(command);
                continue;
                break;
            }
        }
        catch (IOException e) {
            log.error((Object)e);
            Utils.close(in);
            return;
        }
        catch (SQLException e) {
            log.error((Object)e);
            return;
        }
        finally {
            Utils.close(in);
        }
    }

    protected String[] getArgs(String command) {
        return command.split(" ");
    }

    public void dispatchCommand(String command) throws SQLException {
        String name;
        String[] args = this.getArgs(command);
        String string = name = args.length > 0 ? args[0] : "";
        if (!name.equals("")) {
            if (name.equals(CMD_EXIT)) {
                this.cmdExit();
            } else if (name.equals(CMD_COLADD)) {
                this.cmdColAdd(args);
            } else if (name.equals(CMD_COLDEL)) {
                this.cmdColDel(args);
            } else if (name.equals(CMD_COLLIST)) {
                this.cmdColList();
            } else if (name.equals(CMD_COLSCAN)) {
                this.cmdColScan();
            } else if (name.equals(CMD_PROPLIST)) {
                this.cmdPropList(args);
            } else if (name.equals(CMD_PROPSET)) {
                this.cmdPropSet(args);
            } else if (name.equals(CMD_PROPDEL)) {
                this.cmdPropDel(args);
            } else if (name.equals(CMD_USERLIST)) {
                this.cmdUserList(args);
            } else if (name.equals(CMD_USERADD)) {
                this.cmdUserAdd(args);
            } else if (name.equals(CMD_USERDEL)) {
                this.cmdUserDel(args);
            } else if (name.equals(CMD_VERSION)) {
                this.cmdVersion();
            } else {
                this.printCommands();
            }
        }
    }

    protected void cmdVersion() {
        this.out.println("Sockso 1.2");
    }

    protected void cmdExit() {
        Main.exit();
    }

    protected void printCommands() {
        this.out.println(this.locale.getString("con.desc.commands"));
        this.out.println("coladd PATH                " + this.locale.getString("con.desc.addDirectory"));
        this.out.println("coldel PATH                " + this.locale.getString("con.desc.removeDirectory"));
        this.out.println("collist                    " + this.locale.getString("con.desc.listDirectories"));
        this.out.println("colscan                    " + this.locale.getString("con.desc.rescanCollection"));
        this.out.println("exit                       " + this.locale.getString("con.desc.exit"));
        this.out.println("proplist FILTER            " + this.locale.getString("con.desc.listProperties"));
        this.out.println("propset NAME VALUE         " + this.locale.getString("con.desc.setProperty"));
        this.out.println("propdel NAME               " + this.locale.getString("con.desc.delProperty"));
        this.out.println("userlist                   " + this.locale.getString("con.desc.listUsers"));
        this.out.println("useradd NAME PASS EMAIL    " + this.locale.getString("con.desc.addUser"));
        this.out.println("userdel ID                 " + this.locale.getString("con.desc.deleteUser"));
        this.out.println("version                    " + this.locale.getString("con.desc.version"));
        this.out.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cmdUserList(String[] args) throws SQLException {
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            String sql = " select id, name, email  from users  order by name asc ";
            st = this.db.prepare(" select id, name, email  from users  order by name asc ");
            rs = st.executeQuery();
            while (rs.next()) {
                this.out.println(rs.getString("id") + "\t" + rs.getString("name") + "\t" + rs.getString("email"));
            }
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
    }

    protected void cmdUserAdd(String[] args) throws SQLException {
        if (args.length < 4) {
            this.printCommands();
        } else {
            try {
                Validater v = new Validater(this.db);
                String name = args[1];
                String pass = args[2];
                String email = args[3];
                if (v.usernameExists(name)) {
                    throw new ValidationException(this.locale.getString("con.err.usernameExists"));
                }
                if (v.emailExists(email)) {
                    throw new ValidationException(this.locale.getString("con.err.emailExists"));
                }
                User newUser = new User(name, pass, email);
                newUser.save(this.db);
                this.out.println(newUser.getId() == -1 ? this.locale.getString("con.msg.userCreated") : this.locale.getString("con.err.errorCreatingUser"));
            }
            catch (ValidationException e) {
                this.out.println(e.getMessage());
            }
        }
    }

    protected void cmdUserDel(String[] args) {
        if (args.length < 2) {
            this.printCommands();
        } else {
            try {
                String sql = " delete from users  where id = " + this.db.escape(args[1]);
                this.db.update(sql);
                this.out.println(this.locale.getString("con.msg.userDeleted"));
            }
            catch (SQLException e) {
                this.out.println(this.locale.getString("con.err.errorDeletingUser"));
            }
        }
    }

    protected void cmdColDel(String[] args) {
        if (args.length < 2) {
            this.printCommands();
        } else {
            String path = args[1];
            this.out.println(this.cm.removeDirectory(path) ? this.locale.getString("con.msg.directoryDeleted") : this.locale.getString("con.err.directoryNotInColl"));
        }
    }

    protected void cmdColAdd(String[] args) {
        if (args.length < 2) {
            this.printCommands();
        } else {
            String path = args[1];
            File file = new File(path);
            if (file.exists()) {
                this.cm.addDirectory(file);
                this.out.println(this.locale.getString("con.msg.directoryAdded"));
            } else {
                this.out.println(this.locale.getString("con.err.pathNotExist", new String[]{path}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cmdColList() throws SQLException {
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            String sql = " select c.id, c.path  from collection c  order by c.path asc ";
            st = this.db.prepare(" select c.id, c.path  from collection c  order by c.path asc ");
            rs = st.executeQuery();
            this.out.println(" ID  PATH");
            this.out.println("----------");
            while (rs.next()) {
                this.out.println(" [" + rs.getString("id") + "] " + rs.getString("path"));
            }
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
    }

    protected void cmdColScan() {
        this.out.println("Scanning collection...");
        this.cm.checkCollection();
    }

    protected void cmdPropSet(String[] args) {
        if (args.length < 3) {
            this.printCommands();
        } else {
            String name = args[1];
            String value = Utils.joinArray(args, " ", 2, args.length - 1);
            this.p.set(name, value);
            this.p.save();
            this.out.println(this.locale.getString("con.msg.propertySaved"));
        }
    }

    protected void cmdPropList(String[] args) {
        String pattern = args.length > 1 ? args[1] : null;
        Object[] props = this.p.getProperties();
        int longest = this.getLongestStringLength((String[])props);
        Arrays.sort(props);
        this.out.println(" NAME" + this.getPadding(4, longest) + "  VALUE");
        if (pattern != null) {
            this.out.println("\n (containing '" + pattern + "')");
        }
        this.out.println();
        for (Object prop : props) {
            if (pattern != null && !((String)prop).contains(pattern)) continue;
            this.out.println(" " + (String)prop + this.getPadding(((String)prop).length(), longest) + "  " + this.p.get((String)prop));
        }
    }

    protected String getPadding(int length, int longest) {
        String padding = "";
        for (int i = length; i < longest; ++i) {
            padding = padding + " ";
        }
        return padding;
    }

    protected int getLongestStringLength(String[] strings) {
        int longest = 0;
        for (String string : strings) {
            int length = string.length();
            if (length <= longest) continue;
            longest = length;
        }
        return longest;
    }

    protected void cmdPropDel(String[] args) {
        if (args.length < 2) {
            this.printCommands();
        } else {
            String propName = args[1];
            if (this.p.exists(propName)) {
                this.p.delete(propName);
                this.p.save();
                this.out.println(this.locale.getString("con.msg.propertyDeleted"));
            } else {
                this.out.println(this.locale.getString("con.err.propertyDoesntExist"));
            }
        }
    }

    public void close() {
    }
}

