/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.controller.Controller;
import freemind.controller.MenuBar;
import freemind.main.HtmlTools;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public abstract class MainView
extends JLabel {
    static Dimension minimumSize = new Dimension(0, 0);
    static Dimension maximumSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private static Logger logger = null;
    private static final int MIN_HOR_NODE_SIZE = 10;
    private boolean isPainting;
    protected int isDraggedOver = 0;
    static final float ZOOM_CORRECTION_FACTOR = 0.97f;

    int getZoomedFoldingSymbolHalfWidth() {
        return this.getNodeView().getZoomedFoldingSymbolHalfWidth();
    }

    MainView() {
        if (logger == null) {
            logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
        this.isPainting = false;
        this.setAlignmentX(0.5f);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
    }

    public Dimension getMinimumSize() {
        return minimumSize;
    }

    public Dimension getMaximumSize() {
        return maximumSize;
    }

    public NodeView getNodeView() {
        return (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, this);
    }

    public Dimension getPreferredSize() {
        boolean isEmpty;
        String text = this.getText();
        boolean bl = isEmpty = text.length() == 0 || HtmlTools.isHtmlNode(text) && text.indexOf("<img") < 0 && HtmlTools.htmlToPlain(text).length() == 0;
        if (isEmpty) {
            this.setText("!");
        }
        Dimension prefSize = super.getPreferredSize();
        float zoom = this.getNodeView().getMap().getZoom();
        if (zoom != 1.0f) {
            prefSize.width = (int)(0.99 + (double)((float)prefSize.width * zoom));
            prefSize.height = (int)(0.99 + (double)((float)prefSize.height * zoom));
        }
        if (this.isCurrentlyPrinting() && MapView.NEED_PREF_SIZE_BUG_FIX) {
            prefSize.width += this.getNodeView().getMap().getZoomed(10);
        }
        prefSize.width = Math.max(this.getNodeView().getMap().getZoomed(10), prefSize.width);
        if (isEmpty) {
            this.setText("");
        }
        prefSize.width += this.getNodeView().getMap().getZoomed(12);
        prefSize.height += this.getNodeView().getMap().getZoomed(4);
        return prefSize;
    }

    public void paint(Graphics g) {
        float zoom = this.getZoom();
        if (zoom != 1.0f) {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform transform = g2.getTransform();
            g2.scale(zoom *= 0.97f, zoom);
            this.isPainting = true;
            super.paint(g);
            this.isPainting = false;
            g2.setTransform(transform);
        } else {
            super.paint(g);
        }
    }

    Controller getController() {
        return this.getNodeView().getMap().getController();
    }

    protected boolean isCurrentlyPrinting() {
        return this.getNodeView().getMap().isCurrentlyPrinting();
    }

    private float getZoom() {
        float zoom = this.getNodeView().getMap().getZoom();
        return zoom;
    }

    protected void printComponent(Graphics g) {
        super.paintComponent(g);
    }

    public void paintSelected(Graphics2D graphics) {
        if (this.getNodeView().useSelectionColors()) {
            this.paintBackground(graphics, this.getNodeView().getSelectedColor());
        } else {
            Color backgroundColor = this.getNodeView().getModel().getBackgroundColor();
            if (backgroundColor != null) {
                this.paintBackground(graphics, backgroundColor);
            }
        }
    }

    protected void paintBackground(Graphics2D graphics, Color color) {
        graphics.setColor(color);
        graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    public void paintDragOver(Graphics2D graphics) {
        if (this.isDraggedOver == 1) {
            if (this.getNodeView().isLeft()) {
                graphics.setPaint(new GradientPaint(this.getWidth() * 3 / 4, 0.0f, this.getNodeView().getMap().getBackground(), this.getWidth() / 4, 0.0f, NodeView.dragColor));
                graphics.fillRect(0, 0, this.getWidth() * 3 / 4, this.getHeight() - 1);
            } else {
                graphics.setPaint(new GradientPaint(this.getWidth() / 4, 0.0f, this.getNodeView().getMap().getBackground(), this.getWidth() * 3 / 4, 0.0f, NodeView.dragColor));
                graphics.fillRect(this.getWidth() / 4, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
        if (this.isDraggedOver == 2) {
            graphics.setPaint(new GradientPaint(0.0f, this.getHeight() * 3 / 5, this.getNodeView().getMap().getBackground(), 0.0f, this.getHeight() / 5, NodeView.dragColor));
            graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    public int getHeight() {
        float zoom;
        if (this.isPainting && (zoom = this.getZoom()) != 1.0f) {
            return (int)((float)super.getHeight() / zoom);
        }
        return super.getHeight();
    }

    public int getWidth() {
        float zoom;
        if (this.isPainting && (zoom = this.getZoom()) != 1.0f) {
            return (int)(0.99f + (float)super.getWidth() / zoom);
        }
        return super.getWidth();
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (super.processKeyBinding(ks, e, condition, pressed)) {
            return true;
        }
        MenuBar freeMindMenuBar = this.getController().getFrame().getFreeMindMenuBar();
        return !freeMindMenuBar.isVisible() && freeMindMenuBar.processKeyBinding(ks, e, 2, pressed);
    }

    abstract Point getCenterPoint();

    abstract Point getLeftPoint();

    abstract Point getRightPoint();

    public int getDeltaX() {
        return 0;
    }

    public int getDeltaY() {
        return 0;
    }

    protected int getMainViewHeightWithFoldingMark() {
        return this.getHeight();
    }

    protected int getMainViewWidthWithFoldingMark() {
        return this.getWidth();
    }

    protected void convertPointToMap(Point p) {
        Tools.convertPointToAncestor((Component)this, p, this.getNodeView().getMap());
    }

    protected void convertPointFromMap(Point p) {
        Tools.convertPointFromAncestor(this.getNodeView().getMap(), p, this);
    }

    public void setDraggedOver(int draggedOver) {
        this.isDraggedOver = draggedOver;
    }

    public void setDraggedOver(Point p) {
        this.setDraggedOver(this.dropAsSibling(p.getX()) ? 2 : 1);
    }

    public int getDraggedOver() {
        return this.isDraggedOver;
    }

    public boolean dropAsSibling(double xCoord) {
        return this.isInVerticalRegion(xCoord, 0.3333333333333333);
    }

    public boolean dropPosition(double xCoord) {
        return this.getNodeView().isLeft();
    }

    public boolean isInVerticalRegion(double xCoord, double p) {
        return this.getNodeView().isLeft() ? xCoord > (double)this.getSize().width * (1.0 - p) : xCoord < (double)this.getSize().width * p;
    }

    abstract String getStyle();

    abstract int getAlignment();

    public int getTextWidth() {
        return this.getWidth() - this.getIconWidth();
    }

    public int getTextX() {
        int gap = (this.getWidth() - this.getPreferredSize().width) / 2;
        boolean isLeft = this.getNodeView().isLeft();
        if (isLeft) {
            gap = -gap;
        }
        return gap + (isLeft && !this.getNodeView().isRoot() ? 0 : this.getIconWidth());
    }

    protected int getIconWidth() {
        Icon icon = this.getIcon();
        if (icon == null) {
            return 0;
        }
        return this.getNodeView().getMap().getZoomed(icon.getIconWidth());
    }

    void paintFoldingMark(NodeView nodeView, Graphics2D g, Point p) {
        int zoomedFoldingSymbolHalfWidth = this.getZoomedFoldingSymbolHalfWidth();
        p.translate(-zoomedFoldingSymbolHalfWidth, -zoomedFoldingSymbolHalfWidth);
        Color color = g.getColor();
        g.setColor(Color.WHITE);
        g.fillOval(p.x, p.y, zoomedFoldingSymbolHalfWidth * 2, zoomedFoldingSymbolHalfWidth * 2);
        g.setColor(this.getNodeView().getModel().getEdge().getColor());
        g.drawOval(p.x, p.y, zoomedFoldingSymbolHalfWidth * 2, zoomedFoldingSymbolHalfWidth * 2);
        g.setColor(color);
    }

    public boolean isInFollowLinkRegion(double xCoord) {
        MindMapNode model = this.getNodeView().getModel();
        return model.getLink() != null && (model.isRoot() || !model.hasChildren() || this.isInVerticalRegion(xCoord, 0.5));
    }

    public boolean updateCursor(double xCoord) {
        int requiredCursor;
        boolean followLink = this.isInFollowLinkRegion(xCoord);
        int n = requiredCursor = followLink ? 12 : 0;
        if (this.getCursor().getType() != requiredCursor) {
            this.setCursor(requiredCursor != 0 ? new Cursor(requiredCursor) : null);
        }
        return followLink;
    }
}

