/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.xmpp.client.impl.messages.address;

import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.jivesoftware.smack.packet.IQ;
import org.limewire.io.Address;
import org.limewire.net.address.AddressFactory;
import org.limewire.net.address.AddressSerializer;
import org.limewire.util.StringUtils;
import org.limewire.xmpp.client.impl.messages.InvalidIQException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AddressIQ
extends IQ {
    private final Address address;
    private final AddressFactory factory;

    public AddressIQ(XmlPullParser parser, AddressFactory factory) throws IOException, XmlPullParserException, InvalidIQException {
        int eventType;
        this.factory = factory;
        Address parsedAddress = null;
        do {
            if ((eventType = parser.getEventType()) != 2 || !parser.getName().equals("address") || parser.isEmptyElementTag() || (eventType = parser.next()) != 2) continue;
            String type = parser.getName();
            String value = parser.getAttributeValue(null, "value");
            if (value == null) {
                throw new InvalidIQException("no value attribute");
            }
            try {
                parsedAddress = factory.deserialize(type, Base64.decodeBase64(StringUtils.toUTF8Bytes(value)));
            }
            catch (IOException ie) {
                throw new InvalidIQException("invalid address: " + value, ie);
            }
        } while ((eventType != 3 || !parser.getName().equals("address")) && parser.nextTag() != 1);
        if (parsedAddress == null) {
            throw new InvalidIQException("no address to be parsed");
        }
        this.address = parsedAddress;
    }

    public AddressIQ(Address address, AddressFactory factory) {
        this.address = address;
        this.factory = factory;
    }

    public Address getAddress() {
        return this.address;
    }

    @Override
    public String getChildElementXML() {
        StringBuilder pushEndpoint = new StringBuilder("<address xmlns=\"jabber:iq:lw-address\">");
        if (this.address != null) {
            try {
                AddressSerializer addressSerializer = this.factory.getSerializer(this.address);
                pushEndpoint.append("<" + addressSerializer.getAddressType());
                pushEndpoint.append(" value=\"").append(StringUtils.toUTF8String(Base64.encodeBase64(addressSerializer.serialize(this.address)))).append("\"/>");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        pushEndpoint.append("</address>");
        return pushEndpoint.toString();
    }
}

