/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.warnings;

import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import org.limewire.core.api.Category;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.core.api.library.SharedFileListManager;
import org.limewire.core.settings.SharingSettings;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.warnings.DocumentWarningPanel;

@Singleton
public class DocumentWarningController
implements ComponentListener {
    private boolean showing = false;
    private final Provider<DocumentWarningPanel> documentWarningPanel;
    private final CategoryManager categoryManager;

    @Inject
    public DocumentWarningController(Provider<DocumentWarningPanel> documentWarningPanel, CategoryManager categoryManager) {
        this.documentWarningPanel = documentWarningPanel;
        this.categoryManager = categoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    public void register(SharedFileListManager sharedFileListManager) {
        if (((Boolean)SharingSettings.WARN_SHARING_DOCUMENTS_WITH_WORLD.get()).booleanValue()) {
            ListEventListener<LocalFileItem> listener = new ListEventListener<LocalFileItem>(){

                @Override
                public void listChanged(ListEvent<LocalFileItem> listChanges) {
                    while (listChanges.next()) {
                        if (listChanges.getType() != 2 && listChanges.getType() != 1) continue;
                        LocalFileItem localFileItem = (LocalFileItem)listChanges.getSourceList().get(listChanges.getIndex());
                        if (DocumentWarningController.this.categoryManager.getCategoryForFile(localFileItem.getFile()) != Category.DOCUMENT || !SharingSettings.WARN_SHARING_DOCUMENTS_WITH_WORLD.getValue()) continue;
                        DocumentWarningController.this.showDocumentSharingWarning();
                    }
                }
            };
            sharedFileListManager.getModel().getReadWriteLock().readLock().lock();
            try {
                for (SharedFileList shareList : sharedFileListManager.getModel()) {
                    if (!shareList.isPublic()) continue;
                    shareList.getSwingModel().addListEventListener(listener);
                }
            }
            finally {
                sharedFileListManager.getModel().getReadWriteLock().readLock().unlock();
            }
        }
    }

    private void showDocumentSharingWarning() {
        if (!this.showing) {
            this.showing = true;
            DocumentWarningPanel panel = this.documentWarningPanel.get();
            panel.addComponentListener(this);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        Component panel = e.getComponent();
        if (panel instanceof Disposable) {
            this.showing = false;
            ((Disposable)((Object)panel)).dispose();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

