/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search;

import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.Collection;
import java.util.List;
import org.limewire.core.api.search.Search;
import org.limewire.core.api.search.SearchListener;
import org.limewire.core.api.search.SearchResult;
import org.limewire.core.api.search.sponsored.SponsoredResult;
import org.limewire.ui.swing.search.SearchNavItem;
import org.limewire.ui.swing.search.SponsoredResultsView;
import org.limewire.ui.swing.search.model.SearchResultsModel;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.util.SwingUtils;

class SwingSearchListener
implements SearchListener {
    private final SearchResultsModel searchResultsModel;
    private final SponsoredResultsView sponsoredView;
    private final SearchNavItem searchNavItem;

    public SwingSearchListener(SearchResultsModel searchResultsModel, SponsoredResultsView searchView, SearchNavItem searchNavItem) {
        this.searchResultsModel = searchResultsModel;
        this.sponsoredView = searchView;
        this.searchNavItem = searchNavItem;
        searchResultsModel.getUnfilteredList().addListEventListener(new ListEventListener<VisualSearchResult>(){

            @Override
            public void listChanged(ListEvent<VisualSearchResult> listChanges) {
                SwingSearchListener.this.searchNavItem.sourceCountUpdated(SwingSearchListener.this.searchResultsModel.getResultCount());
            }
        });
    }

    @Override
    public void handleSearchResult(Search search, SearchResult searchResult) {
        this.searchResultsModel.addSearchResult(searchResult);
    }

    @Override
    public void handleSearchResults(Search search, Collection<? extends SearchResult> searchResults) {
        this.searchResultsModel.addSearchResults(searchResults);
    }

    @Override
    public void handleSponsoredResults(Search search, final List<SponsoredResult> sponsoredResults) {
        SwingUtils.invokeNowOrLater(new Runnable(){

            @Override
            public void run() {
                SwingSearchListener.this.sponsoredView.addSponsoredResults(sponsoredResults);
            }
        });
    }

    @Override
    public void searchStarted(Search search) {
    }

    @Override
    public void searchStopped(Search search) {
    }
}

