/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.menu;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.limewire.ui.swing.components.LimeJDialog;
import org.limewire.ui.swing.components.TextFieldClipboardControl;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.URIUtils;

class LocationDialog
extends LimeJDialog {
    private JButton openButton = null;
    private JTextField urlField = null;

    public LocationDialog() {
        this(GuiUtils.getMainFrame());
    }

    public LocationDialog(Frame owner) {
        super(owner);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        JPanel urlPanel = new JPanel();
        this.urlField = new JTextField(30);
        this.urlField.setText("");
        TextFieldClipboardControl.install(this.urlField);
        final JLabel errorLabel = new JLabel(I18n.tr("Invalid Link"));
        errorLabel.setForeground(Color.RED);
        errorLabel.setVisible(false);
        this.urlField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                URI uri = LocationDialog.this.getURI();
                if (uri == null || uri.getScheme() == null) {
                    errorLabel.setVisible(true);
                    LocationDialog.this.openButton.setEnabled(false);
                } else {
                    errorLabel.setVisible(false);
                    LocationDialog.this.openButton.setEnabled(true);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (LocationDialog.this.openButton.isEnabled() && e.getKeyCode() == 10) {
                    LocationDialog.this.openButton.doClick();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.openButton = new JButton(I18n.tr("Open"));
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LocationDialog.this.dispose();
            }
        });
        this.openButton.setEnabled(false);
        JButton cancelButton = new JButton(I18n.tr("Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationDialog.this.dispose();
            }
        });
        urlPanel.setLayout(new MigLayout("", "", ""));
        urlPanel.add((Component)new JLabel(I18n.tr("Enter a magnet or torrent link below:")), "wrap");
        urlPanel.add((Component)this.urlField, "wrap");
        urlPanel.add((Component)errorLabel, "split 3");
        urlPanel.add((Component)this.openButton, "gapleft push");
        urlPanel.add((Component)cancelButton, "alignx right");
        this.setContentPane(urlPanel);
        this.pack();
    }

    void addActionListener(ActionListener actionListener) {
        this.openButton.addActionListener(actionListener);
    }

    void removeActionListener(ActionListener actionListener) {
        this.openButton.removeActionListener(actionListener);
    }

    public synchronized URI getURI() {
        try {
            return URIUtils.toURI(this.urlField.getText());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

