/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.chat;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.application.Resource;
import org.limewire.collection.Periodic;
import org.limewire.friend.api.ChatState;
import org.limewire.friend.api.FriendException;
import org.limewire.friend.api.MessageWriter;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.ui.swing.action.CopyAction;
import org.limewire.ui.swing.action.CutAction;
import org.limewire.ui.swing.action.DeleteAction;
import org.limewire.ui.swing.action.PasteAction;
import org.limewire.ui.swing.action.PopupUtil;
import org.limewire.ui.swing.action.SelectAllAction;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.friends.chat.Displayable;
import org.limewire.ui.swing.util.GuiUtils;

class ResizingInputPanel
extends JPanel
implements Displayable,
Disposable {
    private static final Log LOG = LogFactory.getLog(ResizingInputPanel.class);
    private static final int DELAY_IN_MILLIS_FOR_CHAT_PAUSED = 3000;
    private final JTextArea text;
    private final MessageWriter writer;
    private final ChatStateManager chatStateManager;
    @Resource(key="ChatInputPanel.textFont")
    private Font inputTextFont;

    public ResizingInputPanel(MessageWriter writer, ScheduledExecutorService schedExecService) {
        super(new BorderLayout());
        this.writer = writer;
        GuiUtils.assignResources(this);
        this.chatStateManager = new ChatStateManager(schedExecService);
        this.text = new JTextArea();
        this.text.setFont(this.inputTextFont);
        this.text.setRows(2);
        this.text.setWrapStyleWord(true);
        this.text.setLineWrap(true);
        this.text.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "sendMessage");
        this.text.getActionMap().put("sendMessage", new SendMessage());
        this.text.getDocument().addDocumentListener(this.chatStateManager);
        this.text.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        JPopupMenu popup = PopupUtil.addPopupMenus((JComponent)this.text, new CutAction(this.text), new CopyAction(this.text), new PasteAction(), new DeleteAction(this.text));
        popup.addSeparator();
        popup.add(new SelectAllAction());
        final JScrollPane scrollPane = new JScrollPane(this.text, 20, 31);
        scrollPane.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ResizingInputPanel.this.text.getText().length() > 0 && scrollPane.getVerticalScrollBar().isVisible()) {
                    ResizingInputPanel.this.resizeTextBox(3);
                }
            }
        });
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.add(scrollPane);
    }

    private void resizeTextBox(int rowCount) {
        if (this.text.getRows() != rowCount) {
            this.text.setRows(rowCount);
            this.revalidate();
        }
    }

    @Override
    public void dispose() {
        this.chatStateManager.cancelPendingChatStateUpdates();
    }

    @Override
    public void handleDisplay() {
        this.text.requestFocusInWindow();
    }

    public JTextComponent getInputComponent() {
        return this.text;
    }

    private class ChatStateManager
    implements DocumentListener {
        private final Periodic chatPausedTimer;
        private volatile ChatState currentInputChatState = ChatState.active;

        ChatStateManager(ScheduledExecutorService schedExecService) {
            this.chatPausedTimer = new Periodic(new Runnable(){

                @Override
                public void run() {
                    if (ChatStateManager.this.currentInputChatState == ChatState.composing) {
                        ChatStateManager.this.updateChatState(ChatState.paused);
                    }
                }
            }, schedExecService);
        }

        void updateChatState(ChatState state) {
            if (this.currentInputChatState != state) {
                this.currentInputChatState = state;
                try {
                    ResizingInputPanel.this.writer.setChatState(this.currentInputChatState);
                }
                catch (FriendException e) {
                    LOG.error("Unable to set chat state", e);
                }
            }
        }

        void cancelPendingChatStateUpdates() {
            this.chatPausedTimer.unschedule();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateChatStateComposing();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateChatStateComposing();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (e.getDocument().getLength() == 0) {
                this.updateChatState(ChatState.active);
            } else {
                this.updateChatStateComposing();
            }
        }

        private void updateChatStateComposing() {
            this.updateChatState(ChatState.composing);
            this.chatPausedTimer.rescheduleIfLater(3000L);
        }
    }

    private class SendMessage
    extends AbstractAction {
        private SendMessage() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String message = ResizingInputPanel.this.text.getText();
                if (message.trim().length() > 0) {
                    ResizingInputPanel.this.writer.writeMessage(message);
                    ResizingInputPanel.this.text.setText("");
                    ResizingInputPanel.this.resizeTextBox(2);
                    ResizingInputPanel.this.chatStateManager.updateChatState(ChatState.active);
                }
            }
            catch (FriendException e1) {
                LOG.error("Unable to write message", e1);
            }
        }
    }
}

