/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.filter;

import ca.odell.glazedlists.matchers.Matcher;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.ui.swing.filter.FilterableItem;
import org.limewire.ui.swing.filter.RangeFilterFormat;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

class QualityFilterFormat<E extends FilterableItem>
implements RangeFilterFormat<E> {
    private static final long[] QUALITIES = new long[]{0L, 1L, 2L, 3L};

    QualityFilterFormat() {
    }

    @Override
    public String getHeaderText() {
        return I18n.tr("Quality");
    }

    @Override
    public Matcher<E> getMatcher(long minValue, long maxValue) {
        return new QualityMatcher(minValue);
    }

    @Override
    public String getValueText(int valueIndex) {
        return GuiUtils.toQualityStringShort(QUALITIES[valueIndex]);
    }

    @Override
    public long[] getValues() {
        return QUALITIES;
    }

    @Override
    public boolean isMaximumAbsolute() {
        return true;
    }

    @Override
    public boolean isUpperLimitEnabled() {
        return false;
    }

    @Override
    public boolean updateValues(SearchCategory filterCategory, long lowerValue, long upperValue) {
        return false;
    }

    private static class QualityMatcher<E extends FilterableItem>
    implements Matcher<E> {
        private final long quality;

        public QualityMatcher(long quality) {
            this.quality = quality;
        }

        @Override
        public boolean matches(E item) {
            if (this.quality == 0L) {
                return true;
            }
            if (item.isSpam()) {
                return false;
            }
            Object value = item.getProperty(FilePropertyKey.QUALITY);
            if (value instanceof Long) {
                return (Long)value >= this.quality;
            }
            return false;
        }
    }
}

