/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.downloads.table;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.core.api.Application;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.setting.BooleanSetting;
import org.limewire.ui.swing.components.HTMLLabel;
import org.limewire.ui.swing.components.LimeJDialog;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.NativeLaunchUtils;

public class AVInfoPanel
extends JPanel {
    private static final String AVHOME = "#antivirus";
    private static final String AVHOME_URL = "http://www.limewire.com/client_redirect/?page=antivirus";
    @Resource
    private Font doNotShowFont;
    @Resource
    private Color doNotShowForeground;
    @Resource
    private Font headingFont;
    @Resource
    private Color headingForeground;
    @Resource
    private Font messageFont;
    @Resource
    private Color messageForeground;
    @Resource
    private Font threatHeadingFont;
    @Resource
    private Color threatHeadingForeground;
    @Resource
    private Icon threatIcon;
    @Resource
    private Icon vendorIcon;
    private final Application application;
    private JLabel headingLabel;
    private HTMLLabel messageLabel;
    private JButton okButton;
    private JCheckBox doNotShowCheckBox;
    private JLabel vendorLabel;

    @Inject
    public AVInfoPanel(Application application) {
        this.application = application;
        GuiUtils.assignResources(this);
        this.headingLabel = new JLabel();
        this.messageLabel = new HTMLLabel();
        this.messageLabel.setHtmlFont(this.messageFont);
        this.messageLabel.setHtmlForeground(this.messageForeground);
        this.messageLabel.setMargin(new Insets(0, 0, 0, 0));
        this.messageLabel.setOpaque(false);
        this.messageLabel.setOpenUrlsNatively(false);
        this.messageLabel.addHyperlinkListener(new MessageListener());
        this.okButton = new JButton();
        this.doNotShowCheckBox = new JCheckBox();
        this.doNotShowCheckBox.setFont(this.doNotShowFont);
        this.doNotShowCheckBox.setForeground(this.doNotShowForeground);
        this.doNotShowCheckBox.setOpaque(false);
        this.doNotShowCheckBox.setText(I18n.tr("Do not show message again"));
        this.vendorLabel = new JLabel(this.vendorIcon);
    }

    public void showVendorMessage() {
        this.setLayout(new MigLayout("insets 25 15 15 15, gap 0 0"));
        this.headingLabel.setFont(this.headingFont);
        this.headingLabel.setForeground(this.headingForeground);
        this.headingLabel.setText(I18n.tr("Anti-Virus Protection"));
        String message = I18n.tr("LimeWire PRO Anti-Virus protection is powered by AVG.  AVG scans, detects and deletes files that are suspected to contain viruses or spyware.  <a href=\"{0}\">Learn more</a>", AVHOME);
        this.messageLabel.setText(message);
        this.messageLabel.setPreferredSize(new Dimension(300, this.messageLabel.getPreferredSize().height));
        this.okButton.setAction(new AbstractAction(I18n.tr("OK")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AVInfoPanel.this.disposeWindow();
            }
        });
        this.doNotShowCheckBox.setVisible(false);
        this.add((Component)this.headingLabel, "span, align left, wrap");
        this.add((Component)this.messageLabel, "span, align left, wrap 15");
        this.add((Component)this.okButton, "alignx left, aligny bottom");
        this.add((Component)this.vendorLabel, "alignx right, aligny bottom, push");
        this.showDialog(I18n.tr("About AVG Anti-Virus"));
    }

    public void showDangerMessage(DownloadItem item, boolean showOption) {
        String heading = I18n.tr("Dangerous File");
        String message = I18n.tr("{0} is considered a dangerous file and has automatically been deleted for your protection.", item.getFileName());
        this.showWarningMessage(heading, message, showOption, false, SwingUiSettings.WARN_DOWNLOAD_DANGEROUS, SwingUiSettings.HIDE_DOWNLOAD_DANGEROUS);
    }

    public void showThreatMessage(DownloadItem item, boolean showOption) {
        String heading = I18n.tr("Threat Detected");
        String message = I18n.tr("{0} is suspected to contain a virus or spyware and has automatically been deleted for your protection.  LimeWire PRO Anti-Virus protection is powered by AVG.", item.getFileName());
        this.showWarningMessage(heading, message, showOption, true, SwingUiSettings.WARN_DOWNLOAD_THREAT_FOUND, SwingUiSettings.HIDE_DOWNLOAD_THREAT_FOUND);
    }

    public void showFailureMessage(DownloadItem item, boolean showOption) {
        String heading = I18n.tr("Unable to Scan");
        String message = I18n.tr("{0} could not be inspected due to a problem with the virus scanner.  LimeWire PRO Anti-Virus protection is powered by AVG.", item.getFileName());
        this.showWarningMessage(heading, message, showOption, true, SwingUiSettings.WARN_DOWNLOAD_SCAN_FAILED, SwingUiSettings.HIDE_DOWNLOAD_SCAN_FAILED);
    }

    public void showFailureMessageDefsDownloading(DownloadItem item, boolean autoNotify) {
        String heading = I18n.tr("Can't Scan Yet");
        String message = I18n.tr("{0} could not be inspected because the virus scanner is still downloading its first set of virus definitions.  LimeWire PRO Anti-Virus protection is powered by AVG.", item.getFileName());
        this.showWarningMessage(heading, message, autoNotify, true, SwingUiSettings.WARN_DOWNLOAD_SCAN_FAILED, SwingUiSettings.HIDE_DOWNLOAD_SCAN_FAILED);
    }

    private void showWarningMessage(String heading, String message, boolean showOption, boolean showVendor, BooleanSetting warningSetting, BooleanSetting hideSetting) {
        if (showOption && !warningSetting.getValue()) {
            return;
        }
        this.setLayout(new MigLayout("insets 25 15 15 15, gap 0 0, hidemode 3"));
        JLabel iconLabel = new JLabel(this.threatIcon);
        this.headingLabel.setFont(this.threatHeadingFont);
        this.headingLabel.setForeground(this.threatHeadingForeground);
        this.headingLabel.setText(heading);
        this.messageLabel.setText(message);
        this.messageLabel.setPreferredSize(new Dimension(330, this.messageLabel.getPreferredSize().height));
        this.okButton.setAction(new CloseAction(warningSetting, hideSetting));
        this.doNotShowCheckBox.setSelected(hideSetting.getValue());
        this.doNotShowCheckBox.setVisible(showOption);
        this.add((Component)iconLabel, "spany, alignx left, aligny top, gaptop 6, gapright 15");
        this.add((Component)this.headingLabel, "span, align left, wrap");
        this.add((Component)this.messageLabel, "span, align left, wrap 15");
        this.add((Component)this.okButton, "alignx left, aligny bottom");
        this.add((Component)this.doNotShowCheckBox, "alignx left, aligny bottom, gapleft 5");
        if (showVendor) {
            this.add((Component)this.vendorLabel, "alignx right, aligny bottom, push");
        }
        this.showDialog(I18n.tr("Warning"));
    }

    private void showDialog(String title) {
        final JFrame owner = GuiUtils.getMainFrame();
        final LimeJDialog dialog = new LimeJDialog(owner, title, true);
        dialog.setLayout(new BorderLayout());
        dialog.setDefaultCloseOperation(2);
        dialog.setResizable(false);
        this.setBackground(owner.getBackground());
        dialog.add((Component)this, "Center");
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                dialog.pack();
                dialog.setLocationRelativeTo(owner);
            }
        });
        dialog.pack();
        dialog.setLocationRelativeTo(owner);
        dialog.setVisible(true);
    }

    private void disposeWindow() {
        Container ancestor = this.getTopLevelAncestor();
        if (ancestor instanceof Window) {
            ((Window)ancestor).dispose();
        }
    }

    private class MessageListener
    implements HyperlinkListener {
        private MessageListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && AVInfoPanel.AVHOME.equals(e.getDescription())) {
                NativeLaunchUtils.openURL(AVInfoPanel.this.application.addClientInfoToUrl(AVInfoPanel.AVHOME_URL));
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        private final BooleanSetting warningSetting;
        private final BooleanSetting hideSetting;

        public CloseAction(BooleanSetting warningSetting, BooleanSetting hideSetting) {
            super(I18n.tr("OK"));
            this.warningSetting = warningSetting;
            this.hideSetting = hideSetting;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AVInfoPanel.this.doNotShowCheckBox.isVisible()) {
                this.warningSetting.setValue(!AVInfoPanel.this.doNotShowCheckBox.isSelected());
                this.hideSetting.setValue(AVInfoPanel.this.doNotShowCheckBox.isSelected());
            }
            AVInfoPanel.this.disposeWindow();
        }
    }
}

