/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.concurrent.ListeningExecutorService;
import org.limewire.concurrent.ListeningFuture;
import org.limewire.ui.swing.util.SwingUtils;
import org.limewire.util.ExceptionUtils;

public class HTMLPane
extends JEditorPane {
    private static final ListeningExecutorService QUEUE = ExecutorsHelper.newProcessingQueue("HTMLPane Queue");
    private final SynchronousEditorKit kit = new SynchronousEditorKit();
    private HashMap<Object, Object> pageProperties;
    private volatile boolean pageLoaded;
    private ListeningFuture<LoadResult> currentLoad;

    public HTMLPane() {
        this.setEditorKit(this.kit);
        this.setEditorKitForContentType(this.kit.getContentType(), this.kit);
        this.setContentType("text/html");
        this.setEditable(false);
        this.kit.setAutoFormSubmission(false);
        this.setMargin(new Insets(0, 0, 0, 0));
    }

    public ListeningFuture<LoadResult> setPageAsynchronous(final String url, final String backupPage) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.currentLoad != null) {
            this.currentLoad.cancel(true);
        }
        this.currentLoad = QUEUE.submit(new Callable<LoadResult>(){

            @Override
            public LoadResult call() {
                try {
                    HTMLPane.this.setPageImpl(new URL(url));
                    return LoadResult.SERVER_PAGE;
                }
                catch (IOException iox) {
                    this.setBackup();
                    return LoadResult.OFFLINE_PAGE;
                }
                catch (RuntimeInterruptedException rie) {
                    this.setBackup();
                    return LoadResult.OFFLINE_PAGE;
                }
            }

            private void setBackup() {
                SwingUtils.invokeNowOrLater(new Runnable(){

                    @Override
                    public void run() {
                        HTMLPane.this.setContentType("text/html");
                        HTMLPane.this.setText(backupPage);
                        HTMLPane.this.setCaretPosition(0);
                    }
                });
            }
        });
        return this.currentLoad;
    }

    public boolean isLastRequestSuccessful() {
        return this.pageLoaded;
    }

    public boolean isRequestInProgress() {
        return this.currentLoad != null && !this.currentLoad.isDone();
    }

    @Override
    public void setPage(URL page) throws IOException {
        this.setPageImpl(page);
    }

    private void setPageImpl(final URL page) throws IOException {
        if (page == null) {
            throw new IOException("invalid url");
        }
        this.pageLoaded = false;
        final AtomicReference loaded = new AtomicReference();
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                loaded.set(HTMLPane.this.getPage());
                if (!page.equals(loaded.get()) && page.getRef() == null) {
                    HTMLPane.this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                }
            }
        });
        final AtomicBoolean reloaded = new AtomicBoolean(false);
        InterruptableStream in = new InterruptableStream(this.getStream(page));
        if (this.kit != null) {
            final AtomicReference doc = new AtomicReference();
            this.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    doc.set(HTMLPane.this.initializeModel(HTMLPane.this.kit, page));
                    HTMLPane.this.setDocument((Document)doc.get());
                }
            });
            this.read(in, doc.get());
            reloaded.set(true);
        }
        SwingUtils.invokeNowOrLater(new Runnable(){

            @Override
            public void run() {
                HTMLPane.this.setCaretPosition(0);
                final String reference = page.getRef();
                if (reference != null) {
                    if (!reloaded.get()) {
                        HTMLPane.this.scrollToReference(reference);
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HTMLPane.this.scrollToReference(reference);
                            }
                        });
                    }
                }
                HTMLPane.this.getDocument().putProperty("stream", page);
                HTMLPane.this.firePropertyChange("page", loaded.get(), page);
            }
        });
        this.pageLoaded = true;
    }

    @Override
    public void setDocument(final Document doc) {
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                HTMLPane.super.setDocument(doc);
            }
        });
    }

    @Override
    protected InputStream getStream(URL page) throws IOException {
        final URLConnection conn = page.openConnection();
        if (conn instanceof HttpURLConnection) {
            boolean redirect;
            HttpURLConnection hconn = (HttpURLConnection)conn;
            hconn.setInstanceFollowRedirects(false);
            int response = hconn.getResponseCode();
            boolean bl = redirect = response >= 300 && response <= 399;
            if (redirect) {
                String loc = conn.getHeaderField("Location");
                page = loc.startsWith("http", 0) ? new URL(loc) : new URL(page, loc);
                return this.getStream(page);
            }
        }
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                HTMLPane.this.handleConnectionProperties(conn);
            }
        });
        return conn.getInputStream();
    }

    private void invokeAndWait(final Runnable runnable) throws RuntimeInterruptedException {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        runnable.run();
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeInterruptedException(e);
            }
            catch (InvocationTargetException e) {
                ExceptionUtils.rethrow(e);
            }
        }
    }

    private void handleConnectionProperties(URLConnection conn) {
        String type;
        if (this.pageProperties == null) {
            this.pageProperties = new HashMap();
        }
        if ((type = conn.getContentType()) != null) {
            this.setContentType(type);
            this.pageProperties.put("content-type", type);
        }
        this.pageProperties.put("stream", conn.getURL());
        String enc = conn.getContentEncoding();
        if (enc != null) {
            this.pageProperties.put("content-encoding", enc);
        }
    }

    private Document initializeModel(EditorKit kit, URL page) {
        Document doc = kit.createDefaultDocument();
        if (this.pageProperties != null) {
            for (Object key : this.pageProperties.keySet()) {
                doc.putProperty(key, this.pageProperties.get(key));
            }
            this.pageProperties.clear();
        }
        if (doc.getProperty("stream") == null) {
            doc.putProperty("stream", page);
        }
        return doc;
    }

    private static class InterruptableStream
    extends FilterInputStream {
        public InterruptableStream(InputStream i) {
            super(i);
        }

        protected void checkInterrupted() throws IOException {
            if (Thread.interrupted()) {
                throw new IOException("read interrupted");
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.checkInterrupted();
            return super.read(b, off, len);
        }

        @Override
        public int read() throws IOException {
            this.checkInterrupted();
            return super.read();
        }

        @Override
        public long skip(long n) throws IOException {
            this.checkInterrupted();
            return super.skip(n);
        }

        @Override
        public int available() throws IOException {
            this.checkInterrupted();
            return super.available();
        }

        @Override
        public void reset() throws IOException {
            this.checkInterrupted();
            super.reset();
        }
    }

    private static class SynchronousEditorKit
    extends HTMLEditorKit {
        private SynchronousEditorKit() {
        }

        @Override
        public Document createDefaultDocument() {
            Document doc = super.createDefaultDocument();
            ((HTMLDocument)doc).setAsynchronousLoadPriority(-1);
            return doc;
        }
    }

    private static class RuntimeInterruptedException
    extends RuntimeException {
        public RuntimeInterruptedException(Throwable t) {
            super(t);
        }
    }

    public static enum LoadResult {
        SERVER_PAGE,
        OFFLINE_PAGE;

    }
}

