/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.browser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXPanel;
import org.limewire.ui.swing.browser.BrowserUtils;
import org.limewire.ui.swing.browser.MozillaKeyListener;
import org.limewire.ui.swing.components.ColoredBusyLabel;
import org.limewire.ui.swing.painter.GenericBarPainter;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.PainterUtils;
import org.limewire.ui.swing.util.SwingUtils;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaPanel;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.browser.impl.ChromeAdapter;
import org.mozilla.interfaces.nsIBaseWindow;
import org.mozilla.interfaces.nsIRequest;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIURI;
import org.mozilla.interfaces.nsIWebProgress;
import org.mozilla.interfaces.nsIWebProgressListener;
import org.mozilla.xpcom.Mozilla;

public class Browser
extends MozillaPanel {
    private final Listener listener = new Listener();
    private volatile boolean lastRequestFailed = true;
    private volatile boolean requestInProgress;
    private final MozillaPanel.VisibilityMode loadStatus;
    private JXCollapsiblePane loadingPane;

    public Browser() {
        this.loadStatus = MozillaPanel.VisibilityMode.FORCED_HIDDEN;
    }

    public Browser(boolean attachNewBrowserOnCreation, MozillaPanel.VisibilityMode toolbarVisMode, MozillaPanel.VisibilityMode statusbarVisMode) {
        super(null, attachNewBrowserOnCreation, toolbarVisMode, statusbarVisMode);
        this.loadStatus = MozillaPanel.VisibilityMode.FORCED_HIDDEN;
    }

    public Browser(MozillaPanel.VisibilityMode toolbarVisMode, MozillaPanel.VisibilityMode statusbarVisMode) {
        super(toolbarVisMode, statusbarVisMode);
        this.loadStatus = MozillaPanel.VisibilityMode.FORCED_HIDDEN;
    }

    public Browser(MozillaPanel.VisibilityMode toolbarVisMode, MozillaPanel.VisibilityMode statusbarVisMode, MozillaPanel.VisibilityMode loadingMode) {
        super(toolbarVisMode, statusbarVisMode);
        this.loadStatus = loadingMode;
    }

    @Override
    protected void createChrome() {
        super.createChrome();
        this.loadingPane = new JXCollapsiblePane();
        if (this.loadStatus != MozillaPanel.VisibilityMode.FORCED_HIDDEN) {
            this.loadingPane.setLayout(new BorderLayout());
            ColoredBusyLabel busySpinner = new ColoredBusyLabel(new Dimension(12, 12));
            busySpinner.setBusy(true);
            busySpinner.setOpaque(false);
            JLabel busyLabel = new JLabel(I18n.tr("Loading..."));
            busyLabel.setFont(new Font("DIALOG", 0, 12));
            busyLabel.setForeground(new Color(0x313131));
            busyLabel.setOpaque(false);
            JXPanel loadingPaneInner = new JXPanel(new MigLayout("insets 6, gap 4, aligny center"));
            loadingPaneInner.setBackgroundPainter(new GenericBarPainter(new GradientPaint(0.0f, 0.0f, new Color(0xC8C8C8), 0.0f, 1.0f, new Color(0xF9F9F9)), new Color(0x696969), new Color(0xEBEBEB), PainterUtils.TRASPARENT, PainterUtils.TRASPARENT));
            this.loadingPane.setOpaque(false);
            loadingPaneInner.setOpaque(true);
            loadingPaneInner.add((Component)busySpinner, "gaptop 1");
            loadingPaneInner.add(busyLabel);
            this.loadingPane.add((Component)loadingPaneInner, "Center");
            this.add((Component)this.loadingPane, "South");
        }
    }

    public boolean isRequestInProgress() {
        return this.requestInProgress;
    }

    public boolean isLastRequestSuccessful() {
        return !this.lastRequestFailed;
    }

    @Override
    public void onSetTitle(String title) {
    }

    @Override
    public void onDetachBrowser() {
        if (this.getChromeAdapter() != null) {
            BrowserUtils.removeDomListener(this.getChromeAdapter());
            this.getChromeAdapter().getWebBrowser().removeWebBrowserListener(this.listener, "{570f39d1-efd0-11d3-b093-00a024ffc08c}");
        }
        super.onDetachBrowser();
    }

    @Override
    public void onAttachBrowser(final ChromeAdapter chromeAdapter, ChromeAdapter parentChromeAdapter) {
        super.onAttachBrowser(chromeAdapter, parentChromeAdapter);
        BrowserUtils.addDomListener(chromeAdapter);
        chromeAdapter.getWebBrowser().addWebBrowserListener(this.listener, "{570f39d1-efd0-11d3-b093-00a024ffc08c}");
        SwingUtils.invokeNowOrLater(new Runnable(){

            @Override
            public void run() {
                Browser.this.addKeyListener(new MozillaKeyListener(chromeAdapter));
                Browser.this.addComponentListener(new VisibilityListener());
            }
        });
    }

    public void showLoadingPanel() {
        this.loadingPane.setCollapsed(false);
    }

    public void pageLoadStarted() {
        this.lastRequestFailed = false;
        this.requestInProgress = true;
        if (this.loadStatus == MozillaPanel.VisibilityMode.DEFAULT) {
            SwingUtils.invokeNowOrLater(new Runnable(){

                @Override
                public void run() {
                    Browser.this.loadingPane.setCollapsed(false);
                }
            });
        }
    }

    public void pageLoadStopped(boolean failed) {
        this.lastRequestFailed = failed;
        this.requestInProgress = false;
        if (this.loadStatus == MozillaPanel.VisibilityMode.DEFAULT) {
            SwingUtils.invokeNowOrLater(new Runnable(){

                @Override
                public void run() {
                    Browser.this.loadingPane.setCollapsed(true);
                }
            });
        }
    }

    private void setBrowserVisibility(final boolean isVisible) {
        MozillaExecutor.mozAsyncExec(new Runnable(){

            @Override
            public void run() {
                ChromeAdapter chromeAdapter = Browser.this.getChromeAdapter();
                if (chromeAdapter != null) {
                    nsIBaseWindow baseWindow = XPCOMUtils.qi(chromeAdapter.getWebBrowser(), nsIBaseWindow.class);
                    baseWindow.setVisibility(isVisible);
                }
            }
        });
    }

    private class Listener
    implements nsIWebProgressListener {
        private Listener() {
        }

        @Override
        public void onLocationChange(nsIWebProgress webProgress, nsIRequest request, nsIURI location) {
        }

        @Override
        public void onProgressChange(nsIWebProgress webProgress, nsIRequest request, int curSelfProgress, int maxSelfProgress, int curTotalProgress, int maxTotalProgress) {
        }

        @Override
        public void onSecurityChange(nsIWebProgress webProgress, nsIRequest request, long state) {
        }

        @Override
        public void onStateChange(nsIWebProgress webProgress, nsIRequest request, long stateFlags, long status) {
            if ((stateFlags & 0x40000L) != 0L && (stateFlags & 1L) != 0L) {
                Browser.this.pageLoadStarted();
            }
            if ((stateFlags & 0x40000L) != 0L && (stateFlags & 0x10L) != 0L) {
                Browser.this.pageLoadStopped(status != 0L);
            }
        }

        @Override
        public void onStatusChange(nsIWebProgress webProgress, nsIRequest request, long status, String message) {
        }

        @Override
        public nsISupports queryInterface(String iid) {
            return Mozilla.queryInterface(this, iid);
        }
    }

    private class VisibilityListener
    extends ComponentAdapter {
        private VisibilityListener() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            Browser.this.setBrowserVisibility(false);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            Browser.this.setBrowserVisibility(true);
        }
    }
}

