/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.advanced;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.limewire.listener.EventListener;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.advanced.AbstractTabItem;
import org.limewire.ui.swing.advanced.ConnectionsPanel;
import org.limewire.ui.swing.advanced.ConsolePanel;
import org.limewire.ui.swing.advanced.MojitoPanel;
import org.limewire.ui.swing.advanced.TabButton;
import org.limewire.ui.swing.advanced.TabPanel;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.components.LimeJFrame;
import org.limewire.ui.swing.options.TabItemListener;
import org.limewire.ui.swing.painter.factories.BarPainterFactory;
import org.limewire.ui.swing.util.EnabledType;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class AdvancedToolsPanel
extends JPanel
implements Disposable {
    private static final String WINDOW_TITLE = I18n.tr("Advanced Tools");
    @Resource
    private Color backgroundColor;
    @Resource
    private Icon connectionsIcon;
    @Resource
    private Icon consoleIcon;
    @Resource
    private Icon mojitoIcon;
    @Resource
    private Color tabTopColor;
    @Resource
    private Color tabBottomColor;
    @Resource
    private Color tabFontColor;
    @Resource
    private Font tabFont;
    private Action nextTabAction = new NextTabAction();
    private Action prevTabAction = new PrevTabAction();
    private WindowListener mainFrameListener = new MainFrameListener();
    private AdvancedTabItem selectedItem;
    private Map<TabId, AdvancedTabItem> tabItemMap = new EnumMap<TabId, AdvancedTabItem>(TabId.class);
    private Map<TabId, TabPanel> tabPanelMap = new EnumMap<TabId, TabPanel>(TabId.class);
    private JXPanel headerPanel;
    private JPanel cardPanel;
    private CardLayout cardLayout;

    @Inject
    public AdvancedToolsPanel(BarPainterFactory barPainterFactory, Provider<ConnectionsPanel> connectionsPanel, Provider<ConsolePanel> consolePanel, Provider<MojitoPanel> mojitoPanel) {
        GuiUtils.assignResources(this);
        this.initComponents(barPainterFactory);
        this.addTab(TabId.CONNECTIONS, this.connectionsIcon, connectionsPanel);
        this.addTab(TabId.CONSOLE, this.consoleIcon, consolePanel);
        this.addTab(TabId.MOJITO, this.mojitoIcon, mojitoPanel);
    }

    private void initComponents(BarPainterFactory barPainterFactory) {
        this.setLayout(new BorderLayout());
        this.headerPanel = new JXPanel();
        this.headerPanel.setBackgroundPainter(barPainterFactory.createTopBarPainter());
        this.headerPanel.setLayout(new MigLayout("insets 0 0 0 0, gap 0 0", "", "align top,fill"));
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel();
        this.cardPanel.setBackground(this.backgroundColor);
        this.cardPanel.setLayout(this.cardLayout);
        this.add((Component)this.headerPanel, "North");
        this.add((Component)this.cardPanel, "Center");
    }

    private void addTab(TabId tabId, Icon icon, Provider<? extends TabPanel> provider) {
        AdvancedTabItem tabItem = new AdvancedTabItem(tabId, icon, provider);
        this.tabItemMap.put(tabId, tabItem);
        this.headerPanel.add(this.createButton(tabItem));
    }

    private JButton createButton(AdvancedTabItem tabItem) {
        TabButton button = new TabButton(new TabAction(tabItem, tabItem.getIcon()));
        button.setGradients(this.tabTopColor, this.tabBottomColor);
        button.setForeground(this.tabFontColor);
        button.setFont(this.tabFont);
        button.getActionMap().put("PREV", this.prevTabAction);
        button.getInputMap(0).put(KeyStroke.getKeyStroke(38, 0), "PREV");
        button.getInputMap(0).put(KeyStroke.getKeyStroke(37, 0), "PREV");
        button.getActionMap().put("NEXT", this.nextTabAction);
        button.getInputMap(0).put(KeyStroke.getKeyStroke(40, 0), "NEXT");
        button.getInputMap(0).put(KeyStroke.getKeyStroke(39, 0), "NEXT");
        return button;
    }

    private JFrame getFrame() {
        Container ancestor = this.getTopLevelAncestor();
        return ancestor instanceof JFrame ? (JFrame)ancestor : null;
    }

    public void display(WindowListener windowListener) {
        JFrame frame = this.getFrame();
        if (frame == null) {
            frame = new LimeJFrame(WINDOW_TITLE);
            frame.setDefaultCloseOperation(0);
            frame.setResizable(true);
            Dimension mainSize = GuiUtils.getMainFrame().getSize();
            Dimension prefSize = new Dimension(Math.max(mainSize.width - 60, 800), Math.max(mainSize.height - 60, 600));
            frame.setPreferredSize(prefSize);
            frame.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "escapeAction");
            frame.getRootPane().getActionMap().put("escapeAction", new CloseFrameAction(frame));
            frame.addWindowListener(windowListener);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    AdvancedToolsPanel.this.dispose();
                }
            });
            GuiUtils.getMainFrame().addWindowListener(this.mainFrameListener);
            frame.getContentPane().add((Component)this, "Center");
            frame.pack();
            frame.setLocationRelativeTo(GuiUtils.getMainFrame());
            this.select(this.findNextEnabledTab(-1, true));
            for (TabId tabId : TabId.values()) {
                TabPanel tabPanel = this.tabItemMap.get((Object)tabId).getTabPanel();
                if (tabPanel == null) continue;
                tabPanel.initData();
            }
        }
        frame.setVisible(true);
        frame.toFront();
    }

    @Override
    public void dispose() {
        JFrame frame = this.getFrame();
        if (frame != null) {
            for (TabId tabId : TabId.values()) {
                TabPanel tabPanel = this.tabItemMap.get((Object)tabId).getTabPanel();
                if (tabPanel == null) continue;
                tabPanel.dispose();
            }
            GuiUtils.getMainFrame().removeWindowListener(this.mainFrameListener);
            frame.getContentPane().remove(this);
            frame.dispose();
        }
    }

    public void minimizeWindow(boolean visible) {
        JFrame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(1);
            frame.setVisible(visible);
        }
    }

    public void restoreWindow() {
        JFrame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(0);
            frame.setVisible(true);
        }
    }

    private TabId findNextEnabledTab(int startIndex, boolean forward) {
        TabId[] tabIds = TabId.values();
        startIndex = (startIndex + tabIds.length) % tabIds.length;
        int nextTab = (startIndex + (forward ? 1 : -1) + tabIds.length) % tabIds.length;
        boolean enabled = this.tabItemMap.get((Object)tabIds[nextTab]).isEnabled();
        while (!enabled && nextTab != startIndex) {
            nextTab = (nextTab + (forward ? 1 : -1) + tabIds.length) % tabIds.length;
            enabled = this.tabItemMap.get((Object)tabIds[nextTab]).isEnabled();
        }
        return nextTab != startIndex ? tabIds[nextTab] : null;
    }

    private void select(TabId tabId) {
        if (tabId == null) {
            return;
        }
        if (this.selectedItem != null) {
            this.selectedItem.fireSelected(false);
        }
        this.selectedItem = this.tabItemMap.get((Object)tabId);
        TabPanel tabPanel = this.tabPanelMap.get((Object)tabId);
        if (tabPanel == null) {
            tabPanel = this.selectedItem.getTabPanel();
            tabPanel.setBackground(this.backgroundColor);
            this.tabPanelMap.put(tabId, tabPanel);
            this.cardPanel.add((Component)tabPanel, tabId.toString());
        }
        this.selectedItem.fireSelected(true);
        this.cardLayout.show(this.cardPanel, tabId.toString());
    }

    private void selectNext() {
        int index = this.selectedItem.getTabId().ordinal();
        this.select(this.findNextEnabledTab(index, true));
    }

    private void selectPrev() {
        int index = this.selectedItem.getTabId().ordinal();
        this.select(this.findNextEnabledTab(index, false));
    }

    private static class CloseFrameAction
    extends AbstractAction {
        private JFrame frame;

        public CloseFrameAction(JFrame frame) {
            this.frame = frame;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.frame.setVisible(false);
        }
    }

    private class MainFrameListener
    extends WindowAdapter {
        private MainFrameListener() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            AdvancedToolsPanel.this.dispose();
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            AdvancedToolsPanel.this.restoreWindow();
        }

        @Override
        public void windowIconified(WindowEvent e) {
            AdvancedToolsPanel.this.minimizeWindow(e.getWindow().isVisible());
        }
    }

    private class PrevTabAction
    extends AbstractAction {
        static final String KEY = "PREV";

        private PrevTabAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdvancedToolsPanel.this.selectPrev();
        }
    }

    private class NextTabAction
    extends AbstractAction {
        static final String KEY = "NEXT";

        private NextTabAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdvancedToolsPanel.this.selectNext();
        }
    }

    private class TabAction
    extends AbstractAction {
        private final TabId tabId;

        public TabAction(AdvancedTabItem tabItem, Icon icon) {
            super(tabItem.getTabId().toString(), icon);
            this.tabId = tabItem.getTabId();
            this.putValue("ActionCommandKey", this.tabId.toString());
            this.putValue("ShortDescription", this.tabId.tooltip());
            tabItem.addTabItemListener(new TabItemListener(){

                @Override
                public void itemSelected(boolean selected) {
                    TabAction.this.putValue("SwingSelectedKey", selected);
                }
            });
            TabPanel tabPanel = tabItem.getTabPanel();
            tabPanel.addEnabledListener(new EventListener<EnabledType>(){

                @Override
                public void handleEvent(EnabledType enabledType) {
                    TabAction.this.setEnabled(enabledType.isEnabled());
                }
            });
            this.setEnabled(tabPanel.isTabEnabled());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdvancedToolsPanel.this.select(this.tabId);
        }
    }

    private class AdvancedTabItem
    extends AbstractTabItem {
        private final TabId tabId;
        private final Icon icon;
        private final Provider<? extends TabPanel> provider;
        private TabPanel tabPanel;

        public AdvancedTabItem(TabId tabId, Icon icon, Provider<? extends TabPanel> provider) {
            this.tabId = tabId;
            this.icon = icon;
            this.provider = provider;
        }

        @Override
        public String getId() {
            return this.tabId.toString();
        }

        @Override
        public void select() {
            AdvancedToolsPanel.this.select(this.tabId);
        }

        public boolean isEnabled() {
            return this.getTabPanel().isTabEnabled();
        }

        public Icon getIcon() {
            return this.icon;
        }

        public TabId getTabId() {
            return this.tabId;
        }

        public TabPanel getTabPanel() {
            if (this.tabPanel == null) {
                this.tabPanel = this.provider.get();
            }
            return this.tabPanel;
        }
    }

    public static enum TabId {
        CONNECTIONS(I18n.tr("Connections"), I18n.tr("View connections to other P2P clients")),
        CONSOLE(I18n.tr("Console"), I18n.tr("View console messages")),
        MOJITO(I18n.tr("Mojito"), I18n.tr("View incoming and outgoing DHT messages"));

        private final String name;
        private final String tooltip;

        private TabId(String name, String tooltip) {
            this.name = name;
            this.tooltip = tooltip;
        }

        public String tooltip() {
            return this.tooltip;
        }

        public String toString() {
            return this.name;
        }
    }
}

