/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.limewire.inspection.Inspectable;
import org.limewire.setting.Setting;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;

public abstract class AbstractSetting<T>
implements Setting<T>,
Inspectable {
    protected final Properties DEFAULT_PROPS;
    protected final Properties PROPS;
    protected final String KEY;
    protected final String DEFAULT_VALUE;
    private boolean alwaysSave = false;
    private boolean isPrivate = false;
    private Collection<SettingListener> listeners = null;

    protected AbstractSetting(Properties defaultProps, Properties props, String key, String defaultValue) {
        this.DEFAULT_PROPS = defaultProps;
        this.PROPS = props;
        this.KEY = key;
        this.DEFAULT_VALUE = defaultValue;
        if (this.DEFAULT_PROPS.containsKey(key)) {
            throw new IllegalArgumentException("duplicate setting key: " + key);
        }
        this.DEFAULT_PROPS.put(this.KEY, defaultValue);
        this.loadValue(defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSettingListener(SettingListener l) {
        if (l == null) {
            throw new NullPointerException("SettingListener is null");
        }
        AbstractSetting abstractSetting = this;
        synchronized (abstractSetting) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<SettingListener>();
            }
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSettingListener(SettingListener l) {
        if (l == null) {
            throw new NullPointerException("SettingListener is null");
        }
        AbstractSetting abstractSetting = this;
        synchronized (abstractSetting) {
            if (this.listeners != null) {
                this.listeners.remove(l);
                if (this.listeners.isEmpty()) {
                    this.listeners = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SettingListener[] getSettingListeners() {
        AbstractSetting abstractSetting = this;
        synchronized (abstractSetting) {
            if (this.listeners == null) {
                return null;
            }
            return this.listeners.toArray(new SettingListener[this.listeners.size()]);
        }
    }

    @Override
    public void reload() {
        String value = this.PROPS.getProperty(this.KEY);
        if (value == null) {
            value = this.DEFAULT_VALUE;
        }
        if (this.isDefault()) {
            this.PROPS.setProperty(this.KEY, this.DEFAULT_VALUE);
        }
        this.loadValue(value);
        this.fireSettingEvent(SettingEvent.EventType.RELOAD);
    }

    @Override
    public boolean revertToDefault() {
        if (!this.isDefault()) {
            this.setValueInternal(this.DEFAULT_VALUE);
            this.fireSettingEvent(SettingEvent.EventType.REVERT_TO_DEFAULT);
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldAlwaysSave() {
        return this.alwaysSave;
    }

    @Override
    public AbstractSetting<T> setAlwaysSave(boolean alwaysSave) {
        if (this.alwaysSave != alwaysSave) {
            this.alwaysSave = alwaysSave;
            this.fireSettingEvent(SettingEvent.EventType.ALWAYS_SAVE_CHANGED);
        }
        return this;
    }

    @Override
    public Setting<T> setPrivate(boolean isPrivate) {
        if (this.isPrivate != isPrivate) {
            this.isPrivate = isPrivate;
            this.fireSettingEvent(SettingEvent.EventType.PRIVACY_CHANGED);
        }
        return this;
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public boolean isDefault() {
        String value = this.PROPS.getProperty(this.KEY);
        if (value == null) {
            return true;
        }
        return value.equals(this.DEFAULT_PROPS.getProperty(this.KEY));
    }

    @Override
    public String getKey() {
        return this.KEY;
    }

    @Override
    public String getValueAsString() {
        String prop = this.PROPS.getProperty(this.KEY);
        return prop == null ? this.DEFAULT_VALUE : prop;
    }

    @Override
    public Object inspect() {
        return this.getValueAsString();
    }

    protected void setValueInternal(String value) {
        String old = this.PROPS.getProperty(this.KEY);
        if (old == null || !old.equals(value)) {
            this.PROPS.setProperty(this.KEY, value);
            this.loadValue(value);
            this.fireSettingEvent(SettingEvent.EventType.VALUE_CHANGED);
        }
    }

    protected abstract void loadValue(String var1);

    public String toString() {
        return this.KEY + "=" + this.getValueAsString();
    }

    protected void fireSettingEvent(SettingEvent.EventType type) {
        this.fireSettingEvent(new SettingEvent(type, this));
    }

    protected void fireSettingEvent(final SettingEvent evt) {
        if (evt == null) {
            throw new NullPointerException("SettingEvent is null");
        }
        final SettingListener[] listeners = this.getSettingListeners();
        if (listeners != null) {
            Runnable command = new Runnable(){

                @Override
                public void run() {
                    for (SettingListener l : listeners) {
                        l.settingChanged(evt);
                    }
                }
            };
            SettingsGroupManager.instance().execute(command);
        }
    }
}

