/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import org.limewire.listener.EventBroadcaster;
import org.limewire.listener.EventMulticaster;
import org.limewire.listener.EventMulticasterImpl;
import org.limewire.listener.ListenerSupport;
import org.limewire.net.ConnectBackRequestedEvent;
import org.limewire.net.ConnectivityChangeEvent;
import org.limewire.net.FirewallService;
import org.limewire.net.FirewallServiceImpl;
import org.limewire.net.LimitedSocketController;
import org.limewire.net.ProxyManager;
import org.limewire.net.ProxyManagerImpl;
import org.limewire.net.ProxySettings;
import org.limewire.net.SimpleSocketController;
import org.limewire.net.SocketBindingSettings;
import org.limewire.net.SocketController;
import org.limewire.net.SocketsManager;
import org.limewire.net.SocketsManagerImpl;
import org.limewire.net.WhoIsRequestFactory;
import org.limewire.net.WhoIsRequestFactoryImpl;
import org.limewire.net.address.AddressFactory;
import org.limewire.net.address.AddressFactoryImpl;
import org.limewire.net.address.ConnectableSerializer;
import org.limewire.util.OSUtils;

public class LimeWireNetModule
extends AbstractModule {
    private final Class<? extends ProxySettings> proxySettings;
    private final Class<? extends SocketBindingSettings> socketBindingSettings;

    public LimeWireNetModule() {
        this(null, null);
    }

    public LimeWireNetModule(Class<? extends ProxySettings> proxySettings, Class<? extends SocketBindingSettings> socketBindingSettings) {
        this.proxySettings = proxySettings;
        this.socketBindingSettings = socketBindingSettings;
    }

    @Override
    protected void configure() {
        this.bind(SocketsManager.class).to(SocketsManagerImpl.class);
        this.bind(ProxyManager.class).to(ProxyManagerImpl.class);
        this.bind(WhoIsRequestFactory.class).to(WhoIsRequestFactoryImpl.class);
        this.bind(FirewallService.class).to(FirewallServiceImpl.class);
        this.bind(AddressFactory.class).to(AddressFactoryImpl.class);
        this.bind(ConnectableSerializer.class).asEagerSingleton();
        this.bind(new TypeLiteral<ListenerSupport<ConnectivityChangeEvent>>(){}).to(SocketsManager.class);
        this.bind(new TypeLiteral<EventBroadcaster<ConnectivityChangeEvent>>(){}).to(SocketsManagerImpl.class);
        EventMulticasterImpl connectRequestEventMulticaster = new EventMulticasterImpl();
        this.bind(new TypeLiteral<EventMulticaster<ConnectBackRequestedEvent>>(){}).toInstance(connectRequestEventMulticaster);
        this.bind(new TypeLiteral<EventBroadcaster<ConnectBackRequestedEvent>>(){}).toInstance(connectRequestEventMulticaster);
        this.bind(new TypeLiteral<ListenerSupport<ConnectBackRequestedEvent>>(){}).toInstance(connectRequestEventMulticaster);
        if (OSUtils.isSocketChallengedWindows()) {
            this.bind(SocketController.class).to(LimitedSocketController.class);
        } else {
            this.bind(SocketController.class).to(SimpleSocketController.class);
        }
        if (this.proxySettings != null) {
            this.bind(ProxySettings.class).to(this.proxySettings);
        }
        if (this.socketBindingSettings != null) {
            this.bind(SocketBindingSettings.class).to(this.socketBindingSettings);
        }
    }
}

