/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.limewire.concurrent.OnewayExchanger;
import org.limewire.nio.observer.ConnectObserver;

public class BlockingConnectObserver
implements ConnectObserver {
    private final OnewayExchanger<Socket, IOException> exchanger = new OnewayExchanger();

    @Override
    public void handleConnect(Socket socket) throws IOException {
        this.exchanger.setValue(socket);
    }

    @Override
    public void handleIOException(IOException iox) {
        this.exchanger.setException(iox);
    }

    @Override
    public void shutdown() {
        this.exchanger.setException(new IOException("shut down"));
    }

    public Socket getSocket() throws IOException {
        try {
            return this.exchanger.get();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public Socket getSocket(long timeout, TimeUnit timeUnit) throws IOException, TimeoutException {
        try {
            return this.exchanger.get(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

