/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.inject;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Scope;
import com.google.inject.spi.BindingScopingVisitor;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.limewire.inject.MoreScopes;

public class GuiceUtils {
    private static BindingScopingVisitor<Boolean> eagerScopingVisitor = new BindingScopingVisitor<Boolean>(){

        @Override
        public Boolean visitEagerSingleton() {
            return true;
        }

        @Override
        public Boolean visitNoScoping() {
            return false;
        }

        @Override
        public Boolean visitScope(Scope scope) {
            return scope == MoreScopes.EAGER_SINGLETON;
        }

        @Override
        public Boolean visitScopeAnnotation(Class<? extends Annotation> scopeAnnotation) {
            return false;
        }
    };

    public static void loadEagerSingletons(Injector injector) {
        Map<Key<?>, Binding<?>> map = injector.getAllBindings();
        for (Binding<?> binding : map.values()) {
            if (!binding.acceptScopingVisitor(eagerScopingVisitor).booleanValue()) continue;
            binding.getProvider().get();
        }
    }
}

