/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.friend.impl.address;

import com.google.inject.Inject;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendConnection;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.feature.AddressFeature;
import org.limewire.friend.api.feature.AuthTokenFeature;
import org.limewire.friend.api.feature.ConnectBackRequestFeature;
import org.limewire.friend.api.feature.Feature;
import org.limewire.friend.api.feature.FeatureEvent;
import org.limewire.friend.impl.address.FriendAddress;
import org.limewire.friend.impl.address.FriendAddressRegistry;
import org.limewire.friend.impl.address.FriendFirewalledAddress;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.Address;
import org.limewire.listener.EventBean;
import org.limewire.listener.EventBroadcaster;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.net.ConnectivityChangeEvent;
import org.limewire.net.SocketsManager;
import org.limewire.net.address.AddressResolutionObserver;
import org.limewire.net.address.AddressResolver;
import org.limewire.net.address.FirewalledAddress;

@EagerSingleton
public class FriendAddressResolver
implements AddressResolver {
    private static final Log LOG = LogFactory.getLog(FriendAddressResolver.class, "address-connecting");
    private final EventBean<FriendConnectionEvent> connectionEventBean;
    private final EventBroadcaster<ConnectivityChangeEvent> connectivityEventBroadcaster;
    private final ConnectivyFeatureListener connectivyFeatureListener = new ConnectivyFeatureListener();
    private final SocketsManager socketsManager;
    private final FriendAddressRegistry addressRegistry;

    @Inject
    public FriendAddressResolver(EventBean<FriendConnectionEvent> connectionEventBean, EventBroadcaster<ConnectivityChangeEvent> connectivityEventBroadcaster, SocketsManager socketsManager, FriendAddressRegistry addressRegistry) {
        this.connectionEventBean = connectionEventBean;
        this.connectivityEventBroadcaster = connectivityEventBroadcaster;
        this.socketsManager = socketsManager;
        this.addressRegistry = addressRegistry;
    }

    @Inject
    void register(SocketsManager socketsManager, ListenerSupport<FeatureEvent> featureSupport) {
        socketsManager.registerResolver(this);
        featureSupport.addListener(this.connectivyFeatureListener);
    }

    @Override
    public boolean canResolve(Address address) {
        if (address instanceof FriendAddress) {
            FriendAddress friendIdAddress = (FriendAddress)address;
            FriendPresence presence = this.getPresence(friendIdAddress);
            if (presence == null) {
                LOG.debugf("can not resolve remote address {0} because no presence was found}", (Object)friendIdAddress);
                return false;
            }
            LOG.debugf("can resolve remote address {0}", (Object)address);
            return true;
        }
        LOG.debugf("can not resolve remote address {0}", (Object)address);
        return false;
    }

    public FriendPresence getPresence(FriendAddress address) {
        String id = address.getId();
        FriendConnectionEvent connection = this.connectionEventBean.getLastEvent();
        if (connection == null || connection.getType() != FriendConnectionEvent.Type.CONNECTED) {
            return null;
        }
        Friend friend = ((FriendConnection)connection.getSource()).getFriend(id);
        if (friend != null) {
            for (Map.Entry<String, FriendPresence> entry : friend.getPresences().entrySet()) {
                FriendPresence resolvedPresence = this.getMatchingPresence(address, entry.getKey(), entry.getValue());
                if (resolvedPresence == null) continue;
                return resolvedPresence;
            }
        }
        return null;
    }

    private FriendPresence getMatchingPresence(FriendAddress friendAddress, String resourceId, FriendPresence presence) {
        if (friendAddress.equals(new FriendAddress(resourceId))) {
            Address address = this.addressRegistry.get(friendAddress);
            Feature authTokenFeature = presence.getFeature(AuthTokenFeature.ID);
            if (address != null && authTokenFeature != null) {
                return presence;
            }
            LOG.debugf("address is {0}, token features is {1}", (Object)address, (Object)authTokenFeature);
        }
        return null;
    }

    @Override
    public <T extends AddressResolutionObserver> T resolve(Address address, T observer) {
        LOG.debugf("resolving: {0}", (Object)address);
        FriendAddress friendAddress = (FriendAddress)address;
        FriendPresence resolvedPresence = this.getPresence(friendAddress);
        if (resolvedPresence == null) {
            LOG.debugf("{0} could not be resolved", (Object)address);
            observer.handleIOException(new IOException("Could not be resolved"));
        } else {
            Address resolvedAddress = this.addressRegistry.get(friendAddress);
            if (resolvedAddress == null) {
                LOG.debugf("could not resolve {0}, not in registry {1}", (Object)address, (Object)this.addressRegistry);
                observer.handleIOException(new IOException("could not be resolved, no address"));
            } else if (resolvedAddress instanceof FirewalledAddress) {
                if (this.socketsManager.canResolve(resolvedAddress)) {
                    LOG.debugf("can be same nat resolved {0}", (Object)address);
                    this.socketsManager.resolve(resolvedAddress, observer);
                } else if (resolvedPresence.hasFeatures(ConnectBackRequestFeature.ID)) {
                    resolvedAddress = new FriendFirewalledAddress(friendAddress, (FirewalledAddress)resolvedAddress);
                    LOG.debugf("resolved {0} as xmpp firewalled address {1}", (Object)address, (Object)resolvedAddress);
                    observer.resolved(resolvedAddress);
                } else {
                    LOG.debugf("resolved {0} as firewalled address {1}", (Object)address, (Object)resolvedAddress);
                    observer.resolved(resolvedAddress);
                }
            } else {
                LOG.debugf("resolved {0} as non-firewalled address {1}", (Object)address, (Object)resolvedAddress);
                observer.resolved(resolvedAddress);
            }
        }
        return observer;
    }

    private class ConnectivyFeatureListener
    implements EventListener<FeatureEvent> {
        private ConnectivyFeatureListener() {
        }

        @Override
        public void handleEvent(FeatureEvent event) {
            FriendPresence presence;
            if (event.getType() != FeatureEvent.Type.ADDED) {
                return;
            }
            URI id = ((Feature)event.getData()).getID();
            if ((id.equals(AuthTokenFeature.ID) || id.equals(AddressFeature.ID)) && (presence = (FriendPresence)event.getSource()).hasFeatures(AuthTokenFeature.ID, AddressFeature.ID)) {
                LOG.debugf("presence with address and auth-token became available: {0}", (Object)presence.getPresenceId());
                FriendAddressResolver.this.connectivityEventBroadcaster.broadcast(new ConnectivityChangeEvent());
            }
        }
    }
}

