/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> List<T> listOf(Iterator<T> iterator) {
        ArrayList<T> list = new ArrayList<T>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static <T> List<T> listOf(Iterable<T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : iterable) {
            list.add(t);
        }
        return list;
    }

    public static <T> Set<T> toSet(Collection<T> c) {
        if (c instanceof Set) {
            return (Set)c;
        }
        return new LinkedHashSet<T>(c);
    }

    public static <T> List<T> toList(Collection<T> c) {
        if (c instanceof List) {
            return (List)c;
        }
        return new ArrayList<T>(c);
    }

    public static <T> Iterator<T> readOnlyIterator(final Iterator<T> iterator) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("read only iterator");
            }
        };
    }

    public static <T> Collection<T> flatten(Collection<? extends Collection<? extends T>> values) {
        ArrayList<T> list = new ArrayList<T>();
        for (Collection<T> collection : values) {
            list.addAll(collection);
        }
        return list;
    }
}

