/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkModifier;
import org.jaudiotagger.audio.asf.io.ModificationResult;
import org.jaudiotagger.audio.asf.util.Utils;

public class ChunkRemover
implements ChunkModifier {
    private final Set<GUID> toRemove = new HashSet<GUID>();

    public ChunkRemover(GUID ... guids) {
        for (GUID current : guids) {
            this.toRemove.add(current);
        }
    }

    @Override
    public boolean isApplicable(GUID guid) {
        return this.toRemove.contains(guid);
    }

    @Override
    public ModificationResult modify(GUID guid, InputStream source, OutputStream destination) throws IOException {
        ModificationResult result = null;
        if (guid != null) {
            assert (this.isApplicable(guid));
            long chunkLen = Utils.readUINT64(source);
            source.skip(chunkLen - 24L);
            result = new ModificationResult(-1, -1L * chunkLen, guid);
        } else {
            result = new ModificationResult(0, 0L, new GUID[0]);
        }
        return result;
    }
}

