/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event;

import java.util.HashMap;
import java.util.Map;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventServiceExistsException;
import org.bushe.swing.event.SwingEventService;

public class EventServiceLocator {
    public static final String SERVICE_NAME_EVENT_BUS = "EventBus";
    public static final String SWING_EVENT_SERVICE_CLASS = "org.bushe.swing.event.swingEventServiceClass";
    private static EventService SWING_EVENT_SERVICE;
    private static final Map EVENT_SERVICES;

    public static synchronized EventService getSwingEventService() {
        if (SWING_EVENT_SERVICE == null) {
            String string = System.getProperty(SWING_EVENT_SERVICE_CLASS);
            if (string != null) {
                Object obj;
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException("Could not find class specified in the property org.bushe.swing.event.swingEventServiceClass.  Class=" + string, classNotFoundException);
                }
                try {
                    obj = clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new RuntimeException("InstantiationException creating instance of class set from Java propertyorg.bushe.swing.event.swingEventServiceClass.  Class=" + string, instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException("IllegalAccessException creating instance of class set from Java propertyorg.bushe.swing.event.swingEventServiceClass.  Class=" + string, illegalAccessException);
                }
                try {
                    SWING_EVENT_SERVICE = (EventService)obj;
                }
                catch (ClassCastException classCastException) {
                    throw new RuntimeException("ClassCastException casting to " + EventService.class + " from instance of class set from Java property" + SWING_EVENT_SERVICE_CLASS + ".  Class=" + string, classCastException);
                }
            }
            SWING_EVENT_SERVICE = new SwingEventService();
            EVENT_SERVICES.put(SERVICE_NAME_EVENT_BUS, SWING_EVENT_SERVICE);
        }
        return SWING_EVENT_SERVICE;
    }

    public static synchronized EventService getEventService(String string) {
        EventService eventService = (EventService)EVENT_SERVICES.get(string);
        if (eventService == null && SERVICE_NAME_EVENT_BUS.equals(string)) {
            eventService = EventServiceLocator.getSwingEventService();
        }
        return eventService;
    }

    public static synchronized void setEventService(String string, EventService eventService) throws EventServiceExistsException {
        if (EVENT_SERVICES.get(string) != null && eventService != null) {
            throw new EventServiceExistsException("An event service by the name " + string + "already exists.  Perhaps multiple threads tried to create a service about the same time?");
        }
        if (SERVICE_NAME_EVENT_BUS.equals(string)) {
            throw new EventServiceExistsException("You cannot use this method to set the EventBus implementation.  Set the Java property org.bushe.swing.event.swingEventServiceClass to the implementation class instead.");
        }
        EVENT_SERVICES.put(string, eventService);
    }

    static {
        EVENT_SERVICES = new HashMap();
    }
}

