/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.format.AudioFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AudioFormatPanel
extends JPanel {
    private ButtonGroup buttonGroupAudioBitsPerSample;
    private ButtonGroup buttonGroupAudioChannels;
    private ButtonGroup buttonGroupAudioEndian;
    private JCheckBox checkBoxAudioSigned;
    private JComboBox comboAudioEncoding;
    private JComboBox comboAudioSampleRate;
    private JLabel labelAudioBitsPerSample;
    private JLabel labelAudioEncoding;
    private JLabel labelAudioEndian;
    private JLabel labelAudioSampleRate;
    private JLabel labelChannels;
    private JRadioButton radioAudioBitsPerSample16;
    private JRadioButton radioAudioBitsPerSample8;
    private JRadioButton radioAudioChannelsMono;
    private JRadioButton radioAudioChannelsStereo;
    private JRadioButton radioAudioEndianBig;
    private JRadioButton radioAudioEndianLittle;

    public AudioFormatPanel() {
        this.initComponents();
    }

    public JComboBox getComboAudioEncoding() {
        return this.comboAudioEncoding;
    }

    public JComboBox getComboAudioSampleRate() {
        return this.comboAudioSampleRate;
    }

    public void setAudioFormat(AudioFormat f) {
        this.comboAudioEncoding.setSelectedItem(f.getEncoding());
        this.comboAudioSampleRate.setEnabled(false);
        this.radioAudioChannelsMono.setEnabled(false);
        this.radioAudioChannelsStereo.setEnabled(false);
        this.radioAudioEndianLittle.setEnabled(false);
        this.radioAudioEndianBig.setEnabled(false);
        this.radioAudioBitsPerSample8.setEnabled(false);
        this.radioAudioBitsPerSample16.setEnabled(false);
        this.checkBoxAudioSigned.setEnabled(false);
        this.comboAudioSampleRate.setSelectedItem("" + (int)f.getSampleRate());
        if (f.getChannels() == 1) {
            this.radioAudioChannelsMono.setSelected(true);
        } else if (f.getChannels() == 2) {
            this.radioAudioChannelsStereo.setSelected(true);
        } else {
            throw new IllegalArgumentException();
        }
        if (f.getEndian() == 0) {
            this.radioAudioEndianLittle.setSelected(true);
        } else if (f.getEndian() == 1) {
            this.radioAudioEndianBig.setSelected(true);
        } else {
            if (f.getSampleSizeInBits() > 8) {
                throw new IllegalArgumentException("Unknown or unspecified endian: " + f.getEndian() + " format: " + f);
            }
            this.radioAudioEndianLittle.setSelected(false);
            this.radioAudioEndianBig.setSelected(false);
        }
        if (f.getSampleSizeInBits() == 8) {
            this.radioAudioBitsPerSample8.setSelected(true);
        } else if (f.getSampleSizeInBits() == 16) {
            this.radioAudioBitsPerSample16.setSelected(true);
        } else {
            throw new IllegalArgumentException();
        }
        if (f.getSigned() == 1) {
            this.checkBoxAudioSigned.setSelected(true);
        } else if (f.getSigned() == 0) {
            this.checkBoxAudioSigned.setSelected(false);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public AudioFormat getAudioFormat() {
        int endian;
        int channels;
        int sampleSizeInBits;
        String encoding = (String)this.comboAudioEncoding.getSelectedItem();
        double sampleRate = Integer.parseInt((String)this.comboAudioSampleRate.getSelectedItem());
        if (this.radioAudioBitsPerSample8.isSelected()) {
            sampleSizeInBits = 8;
        } else if (this.radioAudioBitsPerSample16.isSelected()) {
            sampleSizeInBits = 16;
        } else {
            throw new RuntimeException();
        }
        if (this.radioAudioChannelsMono.isSelected()) {
            channels = 1;
        } else if (this.radioAudioChannelsStereo.isSelected()) {
            channels = 2;
        } else {
            throw new RuntimeException();
        }
        if (sampleSizeInBits <= 8) {
            endian = -1;
        } else if (this.radioAudioEndianLittle.isSelected()) {
            endian = 0;
        } else if (this.radioAudioEndianBig.isSelected()) {
            endian = 1;
        } else {
            throw new RuntimeException();
        }
        int signed = this.checkBoxAudioSigned.isSelected() ? 1 : 0;
        return new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, endian, signed);
    }

    private void initComponents() {
        this.buttonGroupAudioBitsPerSample = new ButtonGroup();
        this.buttonGroupAudioChannels = new ButtonGroup();
        this.buttonGroupAudioEndian = new ButtonGroup();
        this.labelAudioEncoding = new JLabel();
        this.comboAudioSampleRate = new JComboBox();
        this.comboAudioEncoding = new JComboBox();
        this.labelAudioSampleRate = new JLabel();
        this.labelAudioBitsPerSample = new JLabel();
        this.radioAudioBitsPerSample8 = new JRadioButton();
        this.radioAudioBitsPerSample16 = new JRadioButton();
        this.radioAudioChannelsStereo = new JRadioButton();
        this.radioAudioChannelsMono = new JRadioButton();
        this.labelChannels = new JLabel();
        this.labelAudioEndian = new JLabel();
        this.radioAudioEndianBig = new JRadioButton();
        this.radioAudioEndianLittle = new JRadioButton();
        this.checkBoxAudioSigned = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.labelAudioEncoding.setText("Encoding:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.labelAudioEncoding, gridBagConstraints);
        this.comboAudioSampleRate.setModel(new DefaultComboBoxModel<String>(new String[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.comboAudioSampleRate, gridBagConstraints);
        this.comboAudioEncoding.setModel(new DefaultComboBoxModel<String>(new String[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.comboAudioEncoding, gridBagConstraints);
        this.labelAudioSampleRate.setText("Sample rate (Hz):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.labelAudioSampleRate, gridBagConstraints);
        this.labelAudioBitsPerSample.setText("Bits per sample:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.labelAudioBitsPerSample, gridBagConstraints);
        this.buttonGroupAudioBitsPerSample.add(this.radioAudioBitsPerSample8);
        this.radioAudioBitsPerSample8.setText("8");
        this.radioAudioBitsPerSample8.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioAudioBitsPerSample8.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.radioAudioBitsPerSample8, gridBagConstraints);
        this.buttonGroupAudioBitsPerSample.add(this.radioAudioBitsPerSample16);
        this.radioAudioBitsPerSample16.setText("16");
        this.radioAudioBitsPerSample16.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioAudioBitsPerSample16.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.radioAudioBitsPerSample16, gridBagConstraints);
        this.buttonGroupAudioChannels.add(this.radioAudioChannelsStereo);
        this.radioAudioChannelsStereo.setText("Stereo");
        this.radioAudioChannelsStereo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioAudioChannelsStereo.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.radioAudioChannelsStereo, gridBagConstraints);
        this.buttonGroupAudioChannels.add(this.radioAudioChannelsMono);
        this.radioAudioChannelsMono.setText("Mono");
        this.radioAudioChannelsMono.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioAudioChannelsMono.setMargin(new Insets(0, 0, 0, 0));
        this.radioAudioChannelsMono.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AudioFormatPanel.this.radioAudioChannelsMonoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.radioAudioChannelsMono, gridBagConstraints);
        this.labelChannels.setText("Channels:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.labelChannels, gridBagConstraints);
        this.labelAudioEndian.setText("Endian:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.labelAudioEndian, gridBagConstraints);
        this.buttonGroupAudioEndian.add(this.radioAudioEndianBig);
        this.radioAudioEndianBig.setText("Big");
        this.radioAudioEndianBig.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioAudioEndianBig.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.radioAudioEndianBig, gridBagConstraints);
        this.buttonGroupAudioEndian.add(this.radioAudioEndianLittle);
        this.radioAudioEndianLittle.setText("Little");
        this.radioAudioEndianLittle.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioAudioEndianLittle.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.radioAudioEndianLittle, gridBagConstraints);
        this.checkBoxAudioSigned.setText("Signed");
        this.checkBoxAudioSigned.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkBoxAudioSigned.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.checkBoxAudioSigned, gridBagConstraints);
    }

    private void radioAudioChannelsMonoActionPerformed(ActionEvent evt) {
    }
}

