/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import com.lti.utils.synchronization.ProducerConsumerQueue;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullBufferStream;
import javax.media.protocol.SourceCloneable;
import net.sf.fmj.utility.LoggerSingleton;

public class CloneablePullBufferDataSource
extends PullBufferDataSource
implements SourceCloneable {
    private static final Logger logger = LoggerSingleton.logger;
    private final PullBufferDataSource source;
    private PullBufferStream[] streams;
    private final ClonedDataSource firstClonedDataSource;
    private List<ClonedDataSource> clones = new ArrayList<ClonedDataSource>();
    private boolean sourceConnected = false;
    private boolean sourceStarted = false;

    public CloneablePullBufferDataSource(PullBufferDataSource source) {
        this.source = source;
        this.firstClonedDataSource = (ClonedDataSource)this.createClone();
    }

    public PullBufferStream[] getStreams() {
        return this.firstClonedDataSource.getStreams();
    }

    public void connect() throws IOException {
        this.firstClonedDataSource.connect();
    }

    public void disconnect() {
        this.firstClonedDataSource.disconnect();
    }

    public String getContentType() {
        return this.firstClonedDataSource.getContentType();
    }

    public Object getControl(String controlType) {
        return this.firstClonedDataSource.getControl(controlType);
    }

    public Object[] getControls() {
        return this.firstClonedDataSource.getControls();
    }

    public Time getDuration() {
        return this.firstClonedDataSource.getDuration();
    }

    public void start() throws IOException {
        this.firstClonedDataSource.start();
    }

    public void stop() throws IOException {
        this.firstClonedDataSource.stop();
    }

    public synchronized DataSource createClone() {
        ClonedDataSource result = new ClonedDataSource();
        this.clones.add(result);
        return result;
    }

    static /* synthetic */ PullBufferStream[] access$102(CloneablePullBufferDataSource x0, PullBufferStream[] x1) {
        x0.streams = x1;
        return x1;
    }

    private class ClonedDataSource
    extends PullBufferDataSource {
        private ClonedPullBufferStream[] clonedStreams;
        private boolean cloneConnected;
        private boolean cloneStarted;

        private ClonedDataSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PullBufferStream[] getStreams() {
            CloneablePullBufferDataSource cloneablePullBufferDataSource = CloneablePullBufferDataSource.this;
            synchronized (cloneablePullBufferDataSource) {
                if (this.clonedStreams == null) {
                    this.clonedStreams = new ClonedPullBufferStream[CloneablePullBufferDataSource.this.streams.length];
                    for (int i = 0; i < CloneablePullBufferDataSource.this.streams.length; ++i) {
                        this.clonedStreams[i] = new ClonedPullBufferStream(i, CloneablePullBufferDataSource.this.streams[i]);
                    }
                }
                return this.clonedStreams;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connect() throws IOException {
            CloneablePullBufferDataSource cloneablePullBufferDataSource = CloneablePullBufferDataSource.this;
            synchronized (cloneablePullBufferDataSource) {
                if (this.cloneConnected) {
                    return;
                }
                if (!CloneablePullBufferDataSource.this.sourceConnected) {
                    CloneablePullBufferDataSource.this.source.connect();
                    CloneablePullBufferDataSource.this.sourceConnected = true;
                }
                this.cloneConnected = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect() {
            CloneablePullBufferDataSource cloneablePullBufferDataSource = CloneablePullBufferDataSource.this;
            synchronized (cloneablePullBufferDataSource) {
                if (!this.cloneConnected) {
                    return;
                }
                this.cloneConnected = false;
                if (CloneablePullBufferDataSource.this.sourceConnected) {
                    for (ClonedDataSource clone : CloneablePullBufferDataSource.this.clones) {
                        if (!clone.cloneConnected) continue;
                        return;
                    }
                    CloneablePullBufferDataSource.this.source.disconnect();
                    CloneablePullBufferDataSource.this.sourceConnected = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getContentType() {
            CloneablePullBufferDataSource cloneablePullBufferDataSource = CloneablePullBufferDataSource.this;
            synchronized (cloneablePullBufferDataSource) {
                return CloneablePullBufferDataSource.this.source.getContentType();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getControl(String controlType) {
            CloneablePullBufferDataSource cloneablePullBufferDataSource = CloneablePullBufferDataSource.this;
            synchronized (cloneablePullBufferDataSource) {
                return CloneablePullBufferDataSource.this.source.getControl(controlType);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getControls() {
            CloneablePullBufferDataSource cloneablePullBufferDataSource = CloneablePullBufferDataSource.this;
            synchronized (cloneablePullBufferDataSource) {
                return CloneablePullBufferDataSource.this.source.getControls();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Time getDuration() {
            CloneablePullBufferDataSource cloneablePullBufferDataSource = CloneablePullBufferDataSource.this;
            synchronized (cloneablePullBufferDataSource) {
                return CloneablePullBufferDataSource.this.source.getDuration();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() throws IOException {
            CloneablePullBufferDataSource cloneablePullBufferDataSource = CloneablePullBufferDataSource.this;
            synchronized (cloneablePullBufferDataSource) {
                if (this.cloneStarted) {
                    return;
                }
                if (!CloneablePullBufferDataSource.this.sourceStarted) {
                    CloneablePullBufferDataSource.access$102(CloneablePullBufferDataSource.this, CloneablePullBufferDataSource.this.source.getStreams());
                    CloneablePullBufferDataSource.this.source.start();
                    CloneablePullBufferDataSource.this.sourceStarted = true;
                }
                this.cloneStarted = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() throws IOException {
            CloneablePullBufferDataSource cloneablePullBufferDataSource = CloneablePullBufferDataSource.this;
            synchronized (cloneablePullBufferDataSource) {
                if (!this.cloneStarted) {
                    return;
                }
                this.cloneStarted = false;
                if (CloneablePullBufferDataSource.this.sourceStarted) {
                    for (ClonedDataSource clone : CloneablePullBufferDataSource.this.clones) {
                        if (!clone.cloneStarted) continue;
                        return;
                    }
                    CloneablePullBufferDataSource.this.source.stop();
                    CloneablePullBufferDataSource.this.sourceStarted = false;
                }
            }
        }

        class ClonedPullBufferStream
        implements PullBufferStream {
            private final int streamIndex;
            private final PullBufferStream stream;
            private final ProducerConsumerQueue bufferQueue = new ProducerConsumerQueue();
            private boolean eos = false;

            public ClonedPullBufferStream(int streamIndex, PullBufferStream stream) {
                this.streamIndex = streamIndex;
                this.stream = stream;
            }

            ProducerConsumerQueue getBufferQueue() {
                return this.bufferQueue;
            }

            public boolean endOfStream() {
                return this.eos;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ContentDescriptor getContentDescriptor() {
                CloneablePullBufferDataSource cloneablePullBufferDataSource = CloneablePullBufferDataSource.this;
                synchronized (cloneablePullBufferDataSource) {
                    return this.stream.getContentDescriptor();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long getContentLength() {
                CloneablePullBufferDataSource cloneablePullBufferDataSource = CloneablePullBufferDataSource.this;
                synchronized (cloneablePullBufferDataSource) {
                    return this.stream.getContentLength();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getControl(String controlType) {
                CloneablePullBufferDataSource cloneablePullBufferDataSource = CloneablePullBufferDataSource.this;
                synchronized (cloneablePullBufferDataSource) {
                    return this.stream.getControl(controlType);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object[] getControls() {
                CloneablePullBufferDataSource cloneablePullBufferDataSource = CloneablePullBufferDataSource.this;
                synchronized (cloneablePullBufferDataSource) {
                    return this.stream.getControls();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Format getFormat() {
                CloneablePullBufferDataSource cloneablePullBufferDataSource = CloneablePullBufferDataSource.this;
                synchronized (cloneablePullBufferDataSource) {
                    return this.stream.getFormat();
                }
            }

            public boolean willReadBlock() {
                return this.bufferQueue.isEmpty();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void read(Buffer buffer) throws IOException {
                CloneablePullBufferDataSource cloneablePullBufferDataSource = CloneablePullBufferDataSource.this;
                synchronized (cloneablePullBufferDataSource) {
                    if (this.bufferQueue.isEmpty()) {
                        Buffer originalBuffer = new Buffer();
                        this.stream.read(originalBuffer);
                        try {
                            for (ClonedDataSource clone : CloneablePullBufferDataSource.this.clones) {
                                ClonedPullBufferStream clonedStream = (ClonedPullBufferStream)clone.getStreams()[this.streamIndex];
                                clonedStream.getBufferQueue().put((Buffer)originalBuffer.clone());
                            }
                        }
                        catch (InterruptedException e) {
                            logger.log(Level.WARNING, "" + e, e);
                            throw new InterruptedIOException();
                        }
                    }
                }
                Buffer nextBuffer = null;
                try {
                    nextBuffer = (Buffer)this.bufferQueue.get();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException("" + e);
                }
                if (nextBuffer.isEOM()) {
                    this.eos = true;
                }
                buffer.copy(nextBuffer);
            }
        }
    }
}

