/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.nio;

import de.kapsi.net.daap.DaapChunkResponse;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.nio.DaapConnectionNIO;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DaapChunkResponseNIO
extends DaapChunkResponse {
    private DaapConnectionNIO connection;
    private ByteBuffer headerBuffer;
    private ByteBuffer dataBuffer;

    public DaapChunkResponseNIO(DaapRequest request, byte[] data) {
        super(request, data);
        this.connection = (DaapConnectionNIO)request.getConnection();
        this.headerBuffer = ByteBuffer.wrap(this.header);
        this.dataBuffer = ByteBuffer.wrap(data);
    }

    public boolean hasRemaining() {
        return this.headerBuffer.hasRemaining() || this.dataBuffer.hasRemaining();
    }

    public boolean write() throws IOException {
        if (this.headerBuffer.hasRemaining()) {
            this.connection.getWriteChannel().write(this.headerBuffer);
            if (this.headerBuffer.hasRemaining()) {
                return false;
            }
        }
        if (this.dataBuffer.hasRemaining()) {
            this.connection.getWriteChannel().write(this.dataBuffer);
            return !this.dataBuffer.hasRemaining();
        }
        return true;
    }
}

