/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.rudp.messages;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.messagehandlers.MessageHandler;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.rudp.messages.LimeAckMessageImpl;
import com.limegroup.gnutella.rudp.messages.LimeDataMessageImpl;
import com.limegroup.gnutella.rudp.messages.LimeFinMessageImpl;
import com.limegroup.gnutella.rudp.messages.LimeKeepAliveMessageImpl;
import com.limegroup.gnutella.rudp.messages.LimeSynMessageImpl;
import java.net.InetSocketAddress;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.rudp.UDPMultiplexor;
import org.limewire.rudp.messages.RUDPMessage;

@EagerSingleton
class LimeRUDPMessageHandler
implements MessageHandler,
Service {
    private final Provider<UDPMultiplexor> plexor;
    private final Provider<MessageRouter> router;

    @Inject
    LimeRUDPMessageHandler(Provider<UDPMultiplexor> plexor, Provider<MessageRouter> router) {
        this.plexor = plexor;
        this.router = router;
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public void initialize() {
        this.plexor.get();
        this.router.get().setUDPMessageHandler(LimeAckMessageImpl.class, this);
        this.router.get().setUDPMessageHandler(LimeDataMessageImpl.class, this);
        this.router.get().setUDPMessageHandler(LimeFinMessageImpl.class, this);
        this.router.get().setUDPMessageHandler(LimeKeepAliveMessageImpl.class, this);
        this.router.get().setUDPMessageHandler(LimeSynMessageImpl.class, this);
    }

    @Override
    public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
        this.plexor.get().routeMessage((RUDPMessage)((Object)msg), addr);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("RUDP Message Routing");
    }
}

